/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.EngineEditorHelperKt;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.SubstituteCommandArguments;
import com.maddyhome.idea.vim.api.VimCaret;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimSearchGroup;
import com.maddyhome.idea.vim.api.VimVisualPosition;
import com.maddyhome.idea.vim.common.Direction;
import com.maddyhome.idea.vim.common.TextRange;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ranges.LineRange;
import com.maddyhome.idea.vim.helper.CharacterHelper;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.helper.SearchOptions;
import com.maddyhome.idea.vim.history.HistoryConstants;
import com.maddyhome.idea.vim.regexp.VimRegex;
import com.maddyhome.idea.vim.regexp.VimRegexException;
import com.maddyhome.idea.vim.regexp.VimRegexOptions;
import com.maddyhome.idea.vim.regexp.match.VimMatchResult;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import com.maddyhome.idea.vim.vimscript.model.VimLContext;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import com.maddyhome.idea.vim.vimscript.model.expressions.Expression;
import com.maddyhome.idea.vim.vimscript.model.expressions.SimpleExpression;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 ]2\u00020\u0001:\u0003]^_B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H$J \u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\b\u0010\u001d\u001a\u00020\u0013H&J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0017H$J\u0017\u0010#\u001a\u0004\u0018\u00010\u00172\u0006\u0010$\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010%J\u0018\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u0017H\u0002J\u0018\u0010)\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\u0017H\u0002J\"\u0010*\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\n2\u0006\u0010+\u001a\u00020,2\b\b\u0002\u0010(\u001a\u00020\u0017H\u0002J(\u0010-\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0002J\"\u00101\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0004H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J\u001a\u00103\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u000204H\u0002J\b\u00105\u001a\u000200H\u0016J\n\u00106\u001a\u0004\u0018\u00010\nH\u0014J\"\u00107\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J \u00108\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00109\u001a\u00020\u00172\u0006\u0010:\u001a\u00020\u0017H$J*\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\n2\u0006\u0010@\u001a\u00020\nH\u0002J(\u0010A\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0016J0\u0010B\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010E\u001a\u000200H\u0016J8\u0010F\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\n2\u0006\u0010@\u001a\u00020\n2\u0006\u0010G\u001a\u00020HH\u0016J(\u0010I\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010J\u001a\u00020\nH$J\b\u0010K\u001a\u00020\u0013H$J\b\u0010L\u001a\u00020\u0013H$J\b\u0010M\u001a\u00020\u0013H\u0017J\"\u0010N\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010O\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0017H\u0016J \u0010P\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u0002042\u0006\u0010.\u001a\u00020\u0017H\u0016J(\u0010Q\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u0002042\u0006\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0002J \u0010R\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u0002042\u0006\u0010.\u001a\u00020\u0017H\u0016J0\u0010S\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010!\u001a\u0002042\u0006\u0010.\u001a\u00020\u00172\u0006\u0010T\u001a\u00020\u00042\u0006\u0010/\u001a\u000200H\u0016J \u0010U\u001a\u00020\u00132\u0006\u0010C\u001a\u00020\n2\u0006\u0010D\u001a\u00020\n2\u0006\u0010E\u001a\u000200H\u0007J \u0010V\u001a\u00020\u00132\u0006\u0010C\u001a\u00020\n2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0004H\u0002J\u0010\u0010Z\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\nH$J\u0010\u0010[\u001a\u00020\u00132\u0006\u0010\\\u001a\u00020\u0004H$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006`"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase;", "Lcom/maddyhome/idea/vim/api/VimSearchGroup;", "()V", "doAll", "", "doAsk", "doError", "doIgnorecase", "Ljava/lang/Boolean;", "lastSearchPattern", "", "getLastSearchPattern", "()Ljava/lang/String;", "setLastSearchPattern", "(Ljava/lang/String;)V", "lastSubstitutePattern", "getLastSubstitutePattern", "setLastSubstitutePattern", "addSubstitutionConfirmationHighlight", "", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "startOffset", "", "endOffset", "atEdgeOfGnRange", "nextRange", "Lcom/maddyhome/idea/vim/common/TextRange;", "forwards", "clearSearchHighlight", "confirmChoice", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$ReplaceConfirmationChoice;", "match", "caret", "Lcom/maddyhome/idea/vim/api/VimCaret;", "findDecimalNumber", "line", "(Ljava/lang/String;)Ljava/lang/Integer;", "findEndOfCharacterClass", "command", "startIndex", "findEndOfCollection", "findEndOfPattern", "delimiter", "", "findItOffset", "count", "dir", "Lcom/maddyhome/idea/vim/common/Direction;", "findNextSearchForGn", "findUnderCaret", "findWordUnderCursor", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "getLastSearchDirection", "getLastUsedPattern", "getNextSearchRange", "highlightSearchLines", "startLine", "endLine", "parseSubstituteCommand", "Lcom/maddyhome/idea/vim/api/SubstituteCommandArguments;", "range", "Lcom/maddyhome/idea/vim/ex/ranges/LineRange;", "excmd", "exarg", "processSearchCommand", "processSearchRange", "pattern", "patternOffset", "direction", "processSubstituteCommand", "parent", "Lcom/maddyhome/idea/vim/vimscript/model/VimLContext;", "replaceString", "newString", "resetIncsearchHighlights", "resetSearchHighlight", "resetState", "searchBackward", "offset", "searchNext", "searchNextWithDirection", "searchPrevious", "searchWord", "whole", "setLastSearchState", "setLastUsedPattern", "patternType", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$PatternType;", "isNewPattern", "setLatestMatch", "updateSearchHighlights", "force", "Companion", "PatternType", "ReplaceConfirmationChoice", "vim-engine"})
public abstract class VimSearchGroupBase
implements VimSearchGroup {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    private boolean doAll;
    private boolean doAsk;
    private boolean doError = true;
    @Nullable
    private Boolean doIgnorecase;
    @Nullable
    private String lastSearchPattern;
    @Nullable
    private String lastSubstitutePattern;
    private static boolean lastIgnoreSmartCase;
    @Nullable
    private static String lastPatternTrailing;
    @NotNull
    private static Direction lastDirection;
    @Nullable
    private static PatternType lastPatternType;
    @Nullable
    private static String lastSubstituteString;
    @NotNull
    private static final List<String> CLASS_NAMES;

    protected abstract void highlightSearchLines(@NotNull VimEditor var1, int var2, int var3);

    protected abstract void updateSearchHighlights(boolean var1);

    protected abstract void resetIncsearchHighlights();

    @NotNull
    protected abstract ReplaceConfirmationChoice confirmChoice(@NotNull VimEditor var1, @NotNull String var2, @NotNull VimCaret var3, int var4);

    protected abstract void addSubstitutionConfirmationHighlight(@NotNull VimEditor var1, int var2, int var3);

    protected abstract void setLatestMatch(@NotNull String var1);

    protected abstract void replaceString(@NotNull VimEditor var1, int var2, int var3, @NotNull String var4);

    protected abstract void resetSearchHighlight();

    @Override
    public abstract void clearSearchHighlight();

    @Override
    @Nullable
    public String getLastSearchPattern() {
        return this.lastSearchPattern;
    }

    @Override
    public void setLastSearchPattern(@Nullable String string) {
        this.lastSearchPattern = string;
    }

    @Override
    @Nullable
    public String getLastSubstitutePattern() {
        return this.lastSubstitutePattern;
    }

    @Override
    public void setLastSubstitutePattern(@Nullable String string) {
        this.lastSubstitutePattern = string;
    }

    @Nullable
    protected String getLastUsedPattern() {
        String string;
        PatternType patternType = lastPatternType;
        switch (patternType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[patternType.ordinal()]) {
            case 1: {
                string = this.getLastSearchPattern();
                break;
            }
            case 2: {
                string = this.getLastSubstitutePattern();
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    @Nullable
    protected final TextRange findUnderCaret(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        TextRange textRange = this.searchBackward(editor, editor.primaryCaret().getOffset().getPoint() + 1, 1);
        if (textRange == null) {
            return null;
        }
        TextRange backSearch = textRange;
        return backSearch.contains(editor.primaryCaret().getOffset().getPoint()) ? backSearch : null;
    }

    @Override
    @Nullable
    public TextRange searchBackward(@NotNull VimEditor editor, int offset, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        EnumSet<Enum> searchOptions = EnumSet.of((Enum)SearchOptions.WRAP, (Enum)SearchOptions.WHOLE_FILE, (Enum)SearchOptions.BACKWARDS);
        TextRange textRange = VimInjectorKt.getInjector().getSearchHelper().findPattern(editor, this.getLastUsedPattern(), offset, count, searchOptions);
        if (textRange == null) {
            return null;
        }
        TextRange foundBackward = textRange;
        int startOffset = foundBackward.getStartOffset() - 1;
        if (startOffset < 0) {
            startOffset = (int)editor.fileSize();
        }
        searchOptions.remove((Object)SearchOptions.BACKWARDS);
        return VimInjectorKt.getInjector().getSearchHelper().findPattern(editor, this.getLastUsedPattern(), startOffset, 1, searchOptions);
    }

    @Override
    @Nullable
    public TextRange getNextSearchRange(@NotNull VimEditor editor, int count, boolean forwards) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        editor.removeSecondaryCarets();
        TextRange current = this.findUnderCaret(editor);
        if (current == null || EditorExtensionsKt.getInVisualMode(editor) && this.atEdgeOfGnRange(current, editor, forwards)) {
            current = this.findNextSearchForGn(editor, count, forwards);
        } else if (count > 1) {
            current = this.findNextSearchForGn(editor, count - 1, forwards);
        }
        return current;
    }

    @Override
    public int processSearchRange(@NotNull VimEditor editor, @NotNull String pattern, int patternOffset, int startOffset, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.setLastUsedPattern(pattern, PatternType.SEARCH, true);
        lastIgnoreSmartCase = false;
        lastPatternTrailing = "";
        lastDirection = direction;
        this.resetSearchHighlight();
        this.updateSearchHighlights(true);
        int result = this.findItOffset(editor, startOffset, 1, lastDirection);
        lastPatternTrailing = patternOffset != 0 ? String.valueOf(patternOffset) : "";
        return result;
    }

    @Override
    public int searchNext(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.searchNextWithDirection(editor, caret, count, lastDirection);
    }

    @Override
    public int searchPrevious(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        return this.searchNextWithDirection(editor, caret, count, lastDirection.reverse());
    }

    @Override
    public int processSearchCommand(@NotNull VimEditor editor, @NotNull String command2, int startOffset, @NotNull Direction dir) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)dir), (String)"dir");
        boolean isNewPattern = false;
        String pattern = null;
        String patternOffset = null;
        char type = dir == Direction.FORWARDS ? (char)'/' : '?';
        if (((CharSequence)command2).length() > 0) {
            if (command2.charAt(0) != type) {
                String string;
                int endOfPattern = VimSearchGroupBase.findEndOfPattern$default(this, command2, type, 0, 4, null);
                String string2 = command2.substring(0, endOfPattern);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                pattern = string2;
                isNewPattern = true;
                if (endOfPattern < command2.length()) {
                    String string3 = command2.substring(endOfPattern + 1);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                } else {
                    string = "";
                }
                patternOffset = string;
            } else if (command2.length() == 1) {
                patternOffset = "";
            } else {
                String string = command2.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                patternOffset = string;
            }
        }
        if ((charSequence = (CharSequence)pattern) == null || charSequence.length() == 0) {
            pattern = this.getLastSearchPattern();
            patternOffset = lastPatternTrailing;
            charSequence = pattern;
            if (charSequence == null || charSequence.length() == 0) {
                isNewPattern = true;
                pattern = this.getLastSubstitutePattern();
                charSequence = pattern;
                if (charSequence == null || charSequence.length() == 0) {
                    VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "E35: No previous regular expression");
                    return -1;
                }
            }
        }
        this.setLastUsedPattern(pattern, PatternType.SEARCH, isNewPattern);
        lastIgnoreSmartCase = false;
        lastPatternTrailing = patternOffset;
        lastDirection = dir;
        this.resetSearchHighlight();
        this.updateSearchHighlights(true);
        return this.findItOffset(editor, startOffset, 1, lastDirection);
    }

    @Override
    public int searchWord(@NotNull VimEditor editor, @NotNull ImmutableVimCaret caret, int count, boolean whole, @NotNull Direction dir) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)((Object)dir), (String)"dir");
        TextRange textRange = this.findWordUnderCursor(editor, caret);
        if (textRange == null) {
            return -1;
        }
        TextRange range = textRange;
        int start2 = range.getStartOffset();
        int end = range.getEndOffset();
        Object pattern = whole ? "\\<" + EngineEditorHelperKt.getText(editor, start2, end) + "\\>" : EngineEditorHelperKt.getText(editor, start2, end);
        this.setLastUsedPattern((String)pattern, PatternType.SEARCH, true);
        lastIgnoreSmartCase = true;
        lastPatternTrailing = "";
        lastDirection = dir;
        this.resetSearchHighlight();
        this.updateSearchHighlights(true);
        int offset = this.findItOffset(editor, range.getStartOffset(), count, lastDirection);
        return offset == -1 ? range.getStartOffset() : offset;
    }

    private final TextRange findNextSearchForGn(VimEditor editor, int count, boolean forwards) {
        TextRange textRange;
        if (forwards) {
            EnumSet<Enum> searchOptions = EnumSet.of((Enum)SearchOptions.WRAP, (Enum)SearchOptions.WHOLE_FILE);
            textRange = VimInjectorKt.getInjector().getSearchHelper().findPattern(editor, this.getLastUsedPattern(), editor.primaryCaret().getOffset().getPoint(), count, searchOptions);
        } else {
            textRange = this.searchBackward(editor, editor.primaryCaret().getOffset().getPoint(), count);
        }
        return textRange;
    }

    private final boolean atEdgeOfGnRange(TextRange nextRange, VimEditor editor, boolean forwards) {
        int currentPosition = editor.currentCaret().getOffset().getPoint();
        return forwards ? nextRange.getEndOffset() - VimInjectorKt.getInjector().getVisualMotionGroup().getSelectionAdj() == currentPosition : nextRange.getStartOffset() == currentPosition;
    }

    private final int searchNextWithDirection(VimEditor editor, ImmutableVimCaret caret, int count, Direction dir) {
        this.resetSearchHighlight();
        this.updateSearchHighlights(true);
        int startOffset = caret.getOffset().getPoint();
        int offset = this.findItOffset(editor, startOffset, count, dir);
        if (offset == startOffset) {
            offset = this.findItOffset(editor, startOffset, count + 1, dir);
        }
        return offset;
    }

    private final int findEndOfPattern(String command2, char delimiter, int startIndex) {
        int i;
        boolean magic = true;
        for (i = startIndex; i < command2.length() && command2.charAt(i) != delimiter; ++i) {
            if (magic && command2.charAt(i) == '[' || !magic && command2.charAt(i) == '\\' && i + 1 < command2.length() && command2.charAt(i + 1) == '[') {
                i = this.findEndOfCollection(command2, i);
                continue;
            }
            if (command2.charAt(i) != '\\' || i + 1 >= command2.length()) continue;
            if (command2.charAt(++i) == 'v' || command2.charAt(i) == 'm') {
                magic = true;
            }
            if (command2.charAt(i) != 'V' && command2.charAt(i) != 'M') continue;
            magic = false;
        }
        return i;
    }

    static /* synthetic */ int findEndOfPattern$default(VimSearchGroupBase vimSearchGroupBase, String string, char c, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findEndOfPattern");
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return vimSearchGroupBase.findEndOfPattern(string, c, n);
    }

    private final int findEndOfCollection(String command2, int startIndex) {
        int i;
        for (i = startIndex; i < command2.length() - 1 && command2.charAt(i) != ']'; ++i) {
            if (command2.charAt(i) == '\\' && i + 1 < command2.length()) {
                ++i;
                continue;
            }
            if (i + 1 >= command2.length() || command2.charAt(i) != '[' || Intrinsics.compare((int)command2.charAt(i + 1), (int)58) >= 0) continue;
            i = this.findEndOfCharacterClass(command2, i + 2);
        }
        return i;
    }

    private final int findEndOfCharacterClass(String command2, int startIndex) {
        for (String charClass : CLASS_NAMES) {
            if (startIndex + charClass.length() >= command2.length()) continue;
            String string = command2.substring(startIndex, startIndex + charClass.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            if (!Intrinsics.areEqual((Object)string, (Object)charClass)) continue;
            return startIndex + charClass.length() - 1;
        }
        return startIndex;
    }

    private final TextRange findWordUnderCursor(VimEditor editor, ImmutableVimCaret caret) {
        int stop = EngineEditorHelperKt.getLineEndOffset(editor, caret.getBufferPosition().getLine(), true);
        int pos = caret.getOffset().getPoint();
        if (editor.text().length() == 0 || editor.text().length() <= pos) {
            return null;
        }
        int start2 = pos;
        CharacterHelper.CharacterType[] characterTypeArray = new CharacterHelper.CharacterType[]{CharacterHelper.CharacterType.KEYWORD, CharacterHelper.CharacterType.PUNCTUATION};
        CharacterHelper.CharacterType[] types = characterTypeArray;
        for (int i = 0; i < 2; ++i) {
            CharacterHelper.CharacterType type = CharacterHelper.charType(editor, editor.text().charAt(start2), false);
            if (type == types[i]) {
                for (start2 = pos; start2 > 0 && CharacterHelper.charType(editor, editor.text().charAt(start2 - 1), false) == types[i]; --start2) {
                }
            } else {
                while (start2 < stop && CharacterHelper.charType(editor, editor.text().charAt(start2), false) != types[i]) {
                    ++start2;
                }
            }
            if (start2 != stop) break;
        }
        if (start2 == stop) {
            return null;
        }
        int end = start2 < stop && (start2 >= editor.text().length() - 1 || CharacterHelper.charType(editor, editor.text().charAt(start2 + 1), false) != CharacterHelper.CharacterType.KEYWORD) ? start2 + 1 : VimInjectorKt.getInjector().getSearchHelper().findNextWordEnd(editor, start2, 1, false, false) + 1;
        return new TextRange(start2, end);
    }

    @Override
    public boolean processSubstituteCommand(@NotNull VimEditor editor, @NotNull VimCaret caret, @NotNull LineRange range, @NotNull String excmd, @NotNull String exarg, @NotNull VimLContext parent) {
        VimRegex vimRegex;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)excmd, (String)"excmd");
        Intrinsics.checkNotNullParameter((Object)exarg, (String)"exarg");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        List exceptions = new ArrayList();
        if (EditorExtensionsKt.getInVisualMode(editor)) {
            EngineModeExtensionsKt.exitVisualMode(editor);
        }
        SubstituteCommandArguments substituteCommandArguments = this.parseSubstituteCommand(editor, range, excmd, exarg);
        if (substituteCommandArguments == null) {
            return false;
        }
        SubstituteCommandArguments substituteCommandParse = substituteCommandArguments;
        String pattern = substituteCommandParse.getPattern();
        String substituteString = substituteCommandParse.getSubstituteString();
        int line1 = substituteCommandParse.getRange().startLine;
        int line2 = substituteCommandParse.getRange().endLine;
        List options = new ArrayList();
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getSmartcase()) {
            options.add(VimRegexOptions.SMART_CASE);
        }
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getIgnorecase()) {
            options.add(VimRegexOptions.IGNORE_CASE);
        }
        if (VimInjectorKt.globalOptions(VimInjectorKt.getInjector()).getWrapscan()) {
            options.add(VimRegexOptions.WRAP_SCAN);
        }
        try {
            vimRegex = new VimRegex(pattern);
        }
        catch (VimRegexException e) {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(editor, e.getMessage());
            return false;
        }
        VimRegex regex = vimRegex;
        boolean hasExpression = substituteString.length() >= 2 && substituteString.charAt(0) == '\\' && substituteString.charAt(1) == '=';
        String string = lastSubstituteString;
        if (string == null) {
            string = "";
        }
        String oldLastSubstituteString = string;
        lastSubstituteString = substituteString;
        this.resetSearchHighlight();
        this.updateSearchHighlights(true);
        int lastMatchStartOffset = -1;
        boolean gotQuit = false;
        int column = 0;
        int line = line1;
        while (line <= line2 && !gotQuit) {
            Pair<VimMatchResult.Success, String> substituteResult = regex.substitute(editor, substituteString, oldLastSubstituteString, line, column, hasExpression, options);
            if (substituteResult == null) {
                ++line;
                column = 0;
                continue;
            }
            VimInjectorKt.getInjector().getJumpService().saveJumpLocation(editor);
            TextRange matchRange = ((VimMatchResult.Success)substituteResult.getFirst()).getRange();
            Expression expression = null;
            if (hasExpression) {
                String exprString;
                Intrinsics.checkNotNullExpressionValue((Object)substituteString.substring(2), (String)"substring(...)");
                expression = VimInjectorKt.getInjector().getVimscriptParser().parseExpression(exprString);
                if (expression == null) {
                    exceptions.add(new ExException("E15: Invalid expression: " + exprString));
                    expression = new SimpleExpression(new VimString(""));
                }
            }
            Object match = (String)substituteResult.getSecond();
            lastMatchStartOffset = matchRange.getStartOffset();
            boolean didReplace = false;
            if (this.doAll || line != editor.lineCount()) {
                Object choice;
                boolean doReplace = true;
                if (this.doAsk) {
                    this.addSubstitutionConfirmationHighlight(editor, matchRange.getStartOffset(), matchRange.getEndOffset());
                    choice = this.confirmChoice(editor, (String)match, caret, matchRange.getStartOffset());
                    switch (WhenMappings.$EnumSwitchMapping$1[choice.ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            doReplace = false;
                            break;
                        }
                        case 3: {
                            this.doAsk = false;
                            break;
                        }
                        case 4: {
                            doReplace = false;
                            gotQuit = true;
                            break;
                        }
                        case 5: {
                            this.doAll = false;
                            line2 = line;
                        }
                    }
                }
                if (doReplace) {
                    this.setLatestMatch(EngineEditorHelperKt.getText(editor, new TextRange(matchRange.getStartOffset(), matchRange.getEndOffset())));
                    caret.moveToOffset(matchRange.getStartOffset());
                    if (expression != null) {
                        try {
                            choice = expression.evaluate(editor, VimInjectorKt.getInjector().getExecutionContextManager().onEditor(editor, null), parent).toInsertableString();
                        }
                        catch (Exception e) {
                            Intrinsics.checkNotNull((Object)e, (String)"null cannot be cast to non-null type com.maddyhome.idea.vim.ex.ExException");
                            exceptions.add((ExException)e);
                            choice = "";
                        }
                        match = choice;
                    }
                    BufferPosition endPositionWithoutReplace = editor.offsetToBufferPosition(matchRange.getEndOffset());
                    this.replaceString(editor, matchRange.getStartOffset(), matchRange.getEndOffset(), (String)match);
                    didReplace = true;
                    BufferPosition endPositionWithReplace = editor.offsetToBufferPosition(matchRange.getStartOffset() + ((String)match).length());
                    line += endPositionWithReplace.getLine() - endPositionWithoutReplace.getLine();
                    line2 += endPositionWithReplace.getLine() - endPositionWithoutReplace.getLine();
                }
            }
            if (this.doAll && matchRange.getStartOffset() != matchRange.getEndOffset()) {
                if (didReplace) {
                    BufferPosition endPosition = editor.offsetToBufferPosition(matchRange.getStartOffset() + ((String)match).length());
                    line = endPosition.getLine();
                    column = endPosition.getColumn();
                    continue;
                }
                VimVisualPosition endPosition = editor.offsetToVisualPosition(matchRange.getEndOffset());
                column = endPosition.getColumn();
                continue;
            }
            column = 0;
            ++line;
        }
        if (!gotQuit) {
            if (lastMatchStartOffset != -1) {
                caret.moveToOffset(VimInjectorKt.getInjector().getMotion().moveCaretToLineStartSkipLeading(editor, editor.offsetToBufferPosition(lastMatchStartOffset).getLine()));
            } else {
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "E486: Pattern not found: " + pattern);
            }
        }
        this.setLatestMatch("");
        if (!((Collection)exceptions).isEmpty()) {
            VimInjectorKt.getInjector().getMessages().indicateError();
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, ((ExException)exceptions.get(0)).toString());
        }
        return true;
    }

    private final SubstituteCommandArguments parseSubstituteCommand(VimEditor editor, LineRange range, String excmd, String exarg) {
        Object object;
        int i;
        int n;
        int substituteStringEndIndex;
        PatternType patternType = Intrinsics.areEqual((Object)"~", (Object)excmd) ? lastPatternType : PatternType.SUBSTITUTE;
        Object pattern = "";
        Object sub = null;
        char delimiter = '\u0000';
        int trailingOptionsStartIndex = 0;
        if (excmd.charAt(0) == 's' && ((CharSequence)exarg).length() > 0 && !CharsKt.isWhitespace((char)StringsKt.first((CharSequence)exarg)) && !StringsKt.contains$default((CharSequence)"0123456789cegriIp|\"", (char)StringsKt.first((CharSequence)exarg), (boolean)false, (int)2, null)) {
            if (Character.isLetter(StringsKt.first((CharSequence)exarg))) {
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "E146: Regular expressions can't be delimited by letters");
                return null;
            }
            int substituteStringStartIndex = 0;
            if (StringsKt.first((CharSequence)exarg) == '\\') {
                if (exarg.length() < 2 || !StringsKt.contains$default((CharSequence)"/?&", (char)exarg.charAt(1), (boolean)false, (int)2, null)) {
                    VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "E10: \\ should be followed by /, ? or &");
                    return null;
                }
                if (exarg.charAt(1) != '&') {
                    patternType = PatternType.SEARCH;
                }
                delimiter = exarg.charAt(1);
                substituteStringStartIndex += 2;
            } else {
                patternType = lastPatternType;
                delimiter = StringsKt.first((CharSequence)exarg);
                int endOfPattern = this.findEndOfPattern(exarg, delimiter, 1);
                String string = exarg.substring(1, endOfPattern);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                pattern = string;
                if (((CharSequence)pattern).length() == 0) {
                    pattern = null;
                }
                substituteStringStartIndex = endOfPattern;
                if (endOfPattern < exarg.length() && exarg.charAt(endOfPattern) == delimiter) {
                    ++substituteStringStartIndex;
                }
            }
            String string = exarg.substring(substituteStringStartIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String tmpSub = string;
            substituteStringEndIndex = tmpSub.length();
            trailingOptionsStartIndex = substituteStringStartIndex + substituteStringEndIndex;
            n = tmpSub.length();
            for (i = 0; i < n; ++i) {
                if (tmpSub.charAt(i) != delimiter || i != 0 && tmpSub.charAt(i - 1) == '\\') continue;
                substituteStringEndIndex = i;
                trailingOptionsStartIndex = substituteStringStartIndex + substituteStringEndIndex + 1;
                break;
            }
            String string2 = tmpSub.substring(0, substituteStringEndIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            sub = string2;
        } else {
            if (lastSubstituteString == null) {
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "E33: No previous substitute regular expression");
                return null;
            }
            pattern = null;
            String string = lastSubstituteString;
            Intrinsics.checkNotNull((Object)string);
            sub = string;
        }
        if (trailingOptionsStartIndex < exarg.length() && exarg.charAt(trailingOptionsStartIndex) == '&') {
            ++trailingOptionsStartIndex;
        } else {
            this.doAll = VimInjectorKt.options(VimInjectorKt.getInjector(), editor).getGdefault();
            this.doAsk = false;
            this.doError = true;
            this.doIgnorecase = null;
        }
        int trailingOptionsEndIndex = trailingOptionsStartIndex;
        substituteStringEndIndex = exarg.length();
        for (int i2 = trailingOptionsStartIndex; i2 < substituteStringEndIndex; ++i2) {
            if (exarg.charAt(i2) == 'g') {
                this.doAll = !this.doAll;
            } else if (exarg.charAt(i2) == 'c') {
                this.doAsk = !this.doAsk;
            } else if (exarg.charAt(i2) == 'e') {
                this.doError = !this.doError;
            } else if (exarg.charAt(i2) == 'r') {
                patternType = lastPatternType;
            } else if (exarg.charAt(i2) == 'i') {
                this.doIgnorecase = true;
            } else if (exarg.charAt(i2) == 'I') {
                this.doIgnorecase = false;
            } else if (exarg.charAt(i2) != 'p' && exarg.charAt(i2) != 'l' && exarg.charAt(i2) != '#' && exarg.charAt(i2) != 'n') break;
            ++trailingOptionsEndIndex;
        }
        int line1 = range.startLine;
        int line2 = range.endLine;
        if (line1 < 0 || line2 < 0) {
            return null;
        }
        n = exarg.length();
        for (i = trailingOptionsEndIndex; i < n; ++i) {
            if (!CharsKt.isWhitespace((char)exarg.charAt(i))) continue;
            ++trailingOptionsEndIndex;
        }
        if (trailingOptionsEndIndex < exarg.length() && Character.isDigit(exarg.charAt(trailingOptionsEndIndex))) {
            int count = 0;
            while (trailingOptionsEndIndex < exarg.length() && Character.isDigit(exarg.charAt(trailingOptionsEndIndex))) {
                count = count * 10 + CharsKt.digitToInt((char)exarg.charAt(trailingOptionsEndIndex));
                ++trailingOptionsEndIndex;
            }
            if (count <= 0 && this.doError) {
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "Zero count");
                return null;
            }
            line1 = line2;
            line2 = EngineEditorHelperKt.normalizeLine(editor, line1 + count - 1);
        }
        if (trailingOptionsEndIndex < exarg.length() && exarg.charAt(trailingOptionsEndIndex) != '\"') {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "Trailing characters");
            return null;
        }
        if (trailingOptionsEndIndex < exarg.length() && exarg.charAt(trailingOptionsEndIndex) != '\"') {
            VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, "Trailing characters");
            return null;
        }
        boolean isNewPattern = true;
        if (pattern == null) {
            String errorMessage;
            isNewPattern = false;
            PatternType patternType2 = patternType;
            switch (patternType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[patternType2.ordinal()]) {
                case 1: {
                    pattern = this.getLastSearchPattern();
                    String string = "E33: No previous substitute regular expression";
                    break;
                }
                case 2: {
                    pattern = this.getLastSubstitutePattern();
                    String string = "E35: No previous regular expression";
                    break;
                }
                default: {
                    String string = errorMessage = null;
                }
            }
            if (pattern == null) {
                VimInjectorKt.getInjector().getMessages().showStatusBarMessage(null, errorMessage);
                return null;
            }
        }
        this.setLastUsedPattern((String)pattern, PatternType.SUBSTITUTE, isNewPattern);
        lastIgnoreSmartCase = false;
        Boolean bl = this.doIgnorecase;
        if (Intrinsics.areEqual((Object)bl, (Object)true)) {
            object = "\\c" + (String)pattern;
        } else if (Intrinsics.areEqual((Object)bl, (Object)false)) {
            object = "\\C" + (String)pattern;
        } else if (bl == null) {
            object = pattern;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        pattern = object;
        return new SubstituteCommandArguments((String)pattern, (String)sub, new LineRange(line1, line2));
    }

    private final void setLastUsedPattern(String pattern, PatternType patternType, boolean isNewPattern) {
        if (isNewPattern) {
            switch (WhenMappings.$EnumSwitchMapping$0[patternType.ordinal()]) {
                case 1: {
                    this.setLastSearchPattern(pattern);
                    lastPatternType = PatternType.SEARCH;
                    break;
                }
                case 2: {
                    this.setLastSubstitutePattern(pattern);
                    lastPatternType = PatternType.SUBSTITUTE;
                }
            }
        }
        VimInjectorKt.getInjector().getRegisterGroup().storeTextSpecial('/', pattern);
        VimInjectorKt.getInjector().getHistoryGroup().addEntry(HistoryConstants.SEARCH, pattern);
    }

    @Override
    @Nullable
    public Integer findDecimalNumber(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Regex regex = new Regex("\\d+");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)line, (int)0, (int)2, null);
        if (matchResult == null || (matchResult = matchResult.getRange()) == null) {
            return null;
        }
        MatchResult range = matchResult;
        String string = line.substring(range.getFirst(), range.getLast() + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return Integer.parseInt(string);
    }

    @Override
    @NotNull
    public Direction getLastSearchDirection() {
        return lastDirection;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int findItOffset(VimEditor editor, int startOffset, int count, Direction dir) {
        Direction direction;
        ParsePosition pp;
        boolean hasEndOffset;
        boolean offsetIsLineOffset;
        int offset;
        int startOffsetMutable;
        block20: {
            NumberFormat nf;
            Number num;
            block22: {
                block23: {
                    block21: {
                        startOffsetMutable = startOffset;
                        offset = 0;
                        offsetIsLineOffset = false;
                        hasEndOffset = false;
                        pp = new ParsePosition(0);
                        String string = lastPatternTrailing;
                        Intrinsics.checkNotNull((Object)string);
                        if (!(((CharSequence)string).length() > 0)) break block20;
                        String string2 = lastPatternTrailing;
                        Intrinsics.checkNotNull((Object)string2);
                        if (Character.isDigit(string2.charAt(0))) break block21;
                        String string3 = lastPatternTrailing;
                        Intrinsics.checkNotNull((Object)string3);
                        if (string3.charAt(0) == '+') break block21;
                        String string4 = lastPatternTrailing;
                        Intrinsics.checkNotNull((Object)string4);
                        if (string4.charAt(0) != '-') break block22;
                    }
                    offsetIsLineOffset = true;
                    if (!Intrinsics.areEqual((Object)lastPatternTrailing, (Object)"+")) break block23;
                    offset = 1;
                    break block20;
                }
                if (Intrinsics.areEqual((Object)lastPatternTrailing, (Object)"-")) {
                    offset = -1;
                    break block20;
                } else {
                    String string = lastPatternTrailing;
                    Intrinsics.checkNotNull((Object)string);
                    if (string.charAt(0) == '+') {
                        String string5 = lastPatternTrailing;
                        Intrinsics.checkNotNull((Object)string5);
                        String string6 = string5.substring(1);
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                        lastPatternTrailing = string6;
                    }
                    if ((num = (nf = NumberFormat.getIntegerInstance()).parse(lastPatternTrailing, pp = new ParsePosition(0))) != null) {
                        offset = num.intValue();
                    }
                }
                break block20;
            }
            CharSequence charSequence = "ebs";
            String string = lastPatternTrailing;
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.indexOf$default((CharSequence)charSequence, (char)string.charAt(0), (int)0, (boolean)false, (int)6, null) != -1) {
                String string7 = lastPatternTrailing;
                Intrinsics.checkNotNull((Object)string7);
                if (string7.length() >= 2) {
                    CharSequence charSequence2 = "+-";
                    String string8 = lastPatternTrailing;
                    Intrinsics.checkNotNull((Object)string8);
                    if (StringsKt.indexOf$default((CharSequence)charSequence2, (char)string8.charAt(1), (int)0, (boolean)false, (int)6, null) != -1) {
                        offset = 1;
                    }
                    nf = NumberFormat.getIntegerInstance();
                    String string9 = lastPatternTrailing;
                    Intrinsics.checkNotNull((Object)string9);
                    pp = new ParsePosition(string9.charAt(1) == '+' ? 2 : 1);
                    num = nf.parse(lastPatternTrailing, pp);
                    if (num != null) {
                        offset = num.intValue();
                    }
                }
                String string10 = lastPatternTrailing;
                Intrinsics.checkNotNull((Object)string10);
                boolean bl = hasEndOffset = string10.charAt(0) == 'e';
            }
        }
        if (!offsetIsLineOffset && offset != 0) {
            startOffsetMutable = Math.max(0, Math.min(startOffsetMutable - offset, editor.text().length() - 1));
        }
        EnumSet<Enum> searchOptions = EnumSet.of((Enum)SearchOptions.SHOW_MESSAGES, (Enum)SearchOptions.WHOLE_FILE);
        if (dir == Direction.BACKWARDS) {
            searchOptions.add(SearchOptions.BACKWARDS);
        }
        if (lastIgnoreSmartCase) {
            searchOptions.add(SearchOptions.IGNORE_SMARTCASE);
        }
        if (hasEndOffset) {
            searchOptions.add(SearchOptions.WANT_ENDPOS);
        }
        TextRange textRange = VimInjectorKt.getInjector().getSearchHelper().findPattern(editor, this.getLastUsedPattern(), startOffsetMutable, count, searchOptions);
        if (textRange == null) {
            return -1;
        }
        TextRange range = textRange;
        int res2 = range.getStartOffset();
        if (offsetIsLineOffset) {
            int line = editor.offsetToBufferPosition(range.getStartOffset()).getLine();
            int newLine = EngineEditorHelperKt.normalizeLine(editor, line + offset);
            res2 = VimInjectorKt.getInjector().getMotion().moveCaretToLineStart(editor, newLine);
        } else if (hasEndOffset || offset != 0) {
            int base2 = hasEndOffset ? range.getEndOffset() - 1 : range.getStartOffset();
            res2 = Math.max(0, Math.min(base2 + offset, editor.text().length() - 1));
        }
        int ppos = pp.getIndex();
        String string = lastPatternTrailing;
        Intrinsics.checkNotNull((Object)string);
        if (ppos >= string.length() - 1) return res2;
        String string11 = lastPatternTrailing;
        Intrinsics.checkNotNull((Object)string11);
        if (string11.charAt(ppos) != ';') return res2;
        String string12 = lastPatternTrailing;
        Intrinsics.checkNotNull((Object)string12);
        if (string12.charAt(ppos + 1) == '/') {
            direction = Direction.FORWARDS;
        } else {
            String string13 = lastPatternTrailing;
            Intrinsics.checkNotNull((Object)string13);
            if (string13.charAt(ppos + 1) != '?') {
                return res2;
            }
            direction = Direction.BACKWARDS;
        }
        Direction nextDir = direction;
        String string14 = lastPatternTrailing;
        Intrinsics.checkNotNull((Object)string14);
        if (string14.length() - ppos > 2) {
            ++ppos;
        }
        String string15 = lastPatternTrailing;
        Intrinsics.checkNotNull((Object)string15);
        String string16 = string15.substring(ppos + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"substring(...)");
        return this.processSearchCommand(editor, string16, res2, nextDir);
    }

    @TestOnly
    public final void setLastSearchState(@NotNull String pattern, @NotNull String patternOffset, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)patternOffset, (String)"patternOffset");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        this.setLastUsedPattern(pattern, PatternType.SEARCH, true);
        lastIgnoreSmartCase = false;
        lastPatternTrailing = patternOffset;
        lastDirection = direction;
    }

    @TestOnly
    public void resetState() {
        lastPatternType = PatternType.SEARCH;
        this.setLastSubstitutePattern(null);
        this.setLastSearchPattern(null);
        lastPatternTrailing = "";
        lastIgnoreSmartCase = false;
        lastDirection = Direction.FORWARDS;
    }

    protected static final boolean getLastIgnoreSmartCase() {
        return Companion.getLastIgnoreSmartCase();
    }

    protected static final void setLastIgnoreSmartCase(boolean bl) {
        Companion.setLastIgnoreSmartCase(bl);
    }

    static {
        lastPatternTrailing = "";
        lastDirection = Direction.FORWARDS;
        Object[] objectArray = new String[]{"alnum:]", "alpha:]", "blank:]", "cntrl:]", "digit:]", "graph:]", "lower:]", "print:]", "punct:]", "space:]", "upper:]", "xdigit:]", "tab:]", "return:]", "backspace:]", "escape:]"};
        CLASS_NAMES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0084\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\t8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$Companion;", "", "()V", "CLASS_NAMES", "", "", "lastDirection", "Lcom/maddyhome/idea/vim/common/Direction;", "lastIgnoreSmartCase", "", "getLastIgnoreSmartCase$annotations", "getLastIgnoreSmartCase", "()Z", "setLastIgnoreSmartCase", "(Z)V", "lastPatternTrailing", "lastPatternType", "Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$PatternType;", "lastSubstituteString", "vim-engine"})
    protected static final class Companion {
        private Companion() {
        }

        protected final boolean getLastIgnoreSmartCase() {
            return lastIgnoreSmartCase;
        }

        protected final void setLastIgnoreSmartCase(boolean bl) {
            lastIgnoreSmartCase = bl;
        }

        @JvmStatic
        protected static /* synthetic */ void getLastIgnoreSmartCase$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$PatternType;", "", "(Ljava/lang/String;I)V", "SEARCH", "SUBSTITUTE", "vim-engine"})
    protected static final class PatternType
    extends Enum<PatternType> {
        public static final /* enum */ PatternType SEARCH = new PatternType();
        public static final /* enum */ PatternType SUBSTITUTE = new PatternType();
        private static final /* synthetic */ PatternType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PatternType[] values() {
            return (PatternType[])$VALUES.clone();
        }

        public static PatternType valueOf(String value) {
            return Enum.valueOf(PatternType.class, value);
        }

        @NotNull
        public static EnumEntries<PatternType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = patternTypeArray = new PatternType[]{PatternType.SEARCH, PatternType.SUBSTITUTE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0084\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/maddyhome/idea/vim/api/VimSearchGroupBase$ReplaceConfirmationChoice;", "", "(Ljava/lang/String;I)V", "SUBSTITUTE_THIS", "SKIP", "SUBSTITUTE_ALL", "QUIT", "SUBSTITUTE_LAST", "vim-engine"})
    protected static final class ReplaceConfirmationChoice
    extends Enum<ReplaceConfirmationChoice> {
        public static final /* enum */ ReplaceConfirmationChoice SUBSTITUTE_THIS = new ReplaceConfirmationChoice();
        public static final /* enum */ ReplaceConfirmationChoice SKIP = new ReplaceConfirmationChoice();
        public static final /* enum */ ReplaceConfirmationChoice SUBSTITUTE_ALL = new ReplaceConfirmationChoice();
        public static final /* enum */ ReplaceConfirmationChoice QUIT = new ReplaceConfirmationChoice();
        public static final /* enum */ ReplaceConfirmationChoice SUBSTITUTE_LAST = new ReplaceConfirmationChoice();
        private static final /* synthetic */ ReplaceConfirmationChoice[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ReplaceConfirmationChoice[] values() {
            return (ReplaceConfirmationChoice[])$VALUES.clone();
        }

        public static ReplaceConfirmationChoice valueOf(String value) {
            return Enum.valueOf(ReplaceConfirmationChoice.class, value);
        }

        @NotNull
        public static EnumEntries<ReplaceConfirmationChoice> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = replaceConfirmationChoiceArray = new ReplaceConfirmationChoice[]{ReplaceConfirmationChoice.SUBSTITUTE_THIS, ReplaceConfirmationChoice.SKIP, ReplaceConfirmationChoice.SUBSTITUTE_ALL, ReplaceConfirmationChoice.QUIT, ReplaceConfirmationChoice.SUBSTITUTE_LAST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[PatternType.values().length];
            try {
                nArray[PatternType.SEARCH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PatternType.SUBSTITUTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ReplaceConfirmationChoice.values().length];
            try {
                nArray[ReplaceConfirmationChoice.SUBSTITUTE_THIS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplaceConfirmationChoice.SKIP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplaceConfirmationChoice.SUBSTITUTE_ALL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplaceConfirmationChoice.QUIT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReplaceConfirmationChoice.SUBSTITUTE_LAST.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

