/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.EffectiveOptions;
import com.maddyhome.idea.vim.api.GlobalOptions;
import com.maddyhome.idea.vim.api.LocalOptionInitialisationScenario;
import com.maddyhome.idea.vim.api.OptionInitialisationStrategy;
import com.maddyhome.idea.vim.api.OptionListenersImpl;
import com.maddyhome.idea.vim.api.OptionStorage;
import com.maddyhome.idea.vim.api.Options;
import com.maddyhome.idea.vim.api.ParsedValuesCache;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimOptionGroup;
import com.maddyhome.idea.vim.api.VimOptionGroupKt;
import com.maddyhome.idea.vim.options.EffectiveOptionValueChangeListener;
import com.maddyhome.idea.vim.options.GlobalOptionChangeListener;
import com.maddyhome.idea.vim.options.Option;
import com.maddyhome.idea.vim.options.OptionAccessScope;
import com.maddyhome.idea.vim.options.OptionDeclaredScope;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\t\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\n2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000eH\u0016J\u0014\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000e0\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J-\u0010\u001f\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010 \u001a\u00020!H\u0016\u00a2\u0006\u0002\u0010\"JM\u0010#\u001a\u0002H$\"\b\b\u0000\u0010\u000b*\u00020\f\"\b\b\u0001\u0010$*\u00020%2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H$0'H\u0016\u00a2\u0006\u0002\u0010(J\"\u0010)\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010*\u001a\u0004\u0018\u00010\u00192\u0006\u0010+\u001a\u00020,H\u0016J \u0010-\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000eH\u0002J\b\u0010.\u001a\u00020\nH\u0016J+\u0010/\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u00100\u001a\u0002H\u000b\u00a2\u0006\u0002\u00101J(\u00102\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u00103\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u0010\u00104\u001a\u00020\n2\u0006\u00105\u001a\u00020\u001eH\u0016J\u0010\u00106\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u00107\u001a\u00020\nH\u0016J5\u00108\u001a\u00020\n\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u000e2\u0006\u0010 \u001a\u00020!2\u0006\u00109\u001a\u0002H\u000bH\u0016\u00a2\u0006\u0002\u0010:J\u0018\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u0019H\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/maddyhome/idea/vim/api/VimOptionGroupBase;", "Lcom/maddyhome/idea/vim/api/VimOptionGroup;", "()V", "listeners", "Lcom/maddyhome/idea/vim/api/OptionListenersImpl;", "parsedValuesCache", "Lcom/maddyhome/idea/vim/api/ParsedValuesCache;", "storage", "Lcom/maddyhome/idea/vim/api/OptionStorage;", "addEffectiveOptionValueChangeListener", "", "T", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "option", "Lcom/maddyhome/idea/vim/options/Option;", "listener", "Lcom/maddyhome/idea/vim/options/EffectiveOptionValueChangeListener;", "addGlobalOptionChangeListener", "Lcom/maddyhome/idea/vim/options/GlobalOptionChangeListener;", "addOption", "getAllOptions", "", "getEffectiveOptions", "Lcom/maddyhome/idea/vim/api/EffectiveOptions;", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getGlobalOptions", "Lcom/maddyhome/idea/vim/api/GlobalOptions;", "getOption", "key", "", "getOptionValue", "scope", "Lcom/maddyhome/idea/vim/options/OptionAccessScope;", "(Lcom/maddyhome/idea/vim/options/Option;Lcom/maddyhome/idea/vim/options/OptionAccessScope;)Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "getParsedEffectiveOptionValue", "TData", "", "provider", "Lkotlin/Function1;", "(Lcom/maddyhome/idea/vim/options/Option;Lcom/maddyhome/idea/vim/api/VimEditor;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "initialiseLocalOptions", "sourceEditor", "scenario", "Lcom/maddyhome/idea/vim/api/LocalOptionInitialisationScenario;", "initialiseNewOptionDefaultValues", "initialiseOptions", "overrideDefaultValue", "newDefaultValue", "(Lcom/maddyhome/idea/vim/options/Option;Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;)V", "removeEffectiveOptionValueChangeListener", "removeGlobalOptionChangeListener", "removeOption", "optionName", "resetAllOptions", "resetAllOptionsForTesting", "setOptionValue", "value", "(Lcom/maddyhome/idea/vim/options/Option;Lcom/maddyhome/idea/vim/options/OptionAccessScope;Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;)V", "updateFallbackWindow", "fallbackWindow", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimOptionGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimOptionGroupBase.kt\ncom/maddyhome/idea/vim/api/VimOptionGroupBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,746:1\n1#2:747\n1855#3,2:748\n1855#3,2:750\n1855#3,2:752\n*S KotlinDebug\n*F\n+ 1 VimOptionGroupBase.kt\ncom/maddyhome/idea/vim/api/VimOptionGroupBase\n*L\n119#1:748,2\n138#1:750,2\n195#1:752,2\n*E\n"})
public abstract class VimOptionGroupBase
implements VimOptionGroup {
    @NotNull
    private final OptionStorage storage = new OptionStorage();
    @NotNull
    private final OptionListenersImpl listeners = new OptionListenersImpl(this.storage, VimInjectorKt.getInjector().getEditorGroup());
    @NotNull
    private final ParsedValuesCache parsedValuesCache = new ParsedValuesCache(this.storage, VimInjectorKt.getInjector().getVimStorageService());

    @Override
    public void initialiseOptions() {
        Options.INSTANCE.initialise();
    }

    @Override
    public void initialiseLocalOptions(@NotNull VimEditor editor, @Nullable VimEditor sourceEditor, @NotNull LocalOptionInitialisationScenario scenario) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)scenario), (String)"scenario");
        OptionInitialisationStrategy strategy = new OptionInitialisationStrategy(this.storage);
        if (scenario == LocalOptionInitialisationScenario.DEFAULTS) {
            if (!(sourceEditor == null)) {
                boolean $i$a$-check-VimOptionGroupBase$initialiseLocalOptions$32 = false;
                String $i$a$-check-VimOptionGroupBase$initialiseLocalOptions$32 = "sourceEditor must be null when initialising the default options";
                throw new IllegalStateException($i$a$-check-VimOptionGroupBase$initialiseLocalOptions$32.toString());
            }
            strategy.initialiseToDefaults(editor);
            return;
        }
        if (!(sourceEditor != null)) {
            boolean bl = false;
            String string = "sourceEditor must not be null for scenario: " + scenario;
            throw new IllegalStateException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[scenario.ordinal()]) {
            case 1: 
            case 2: {
                strategy.initialiseCloneCurrentState(sourceEditor, editor);
                break;
            }
            case 3: {
                strategy.initialiseForSplitCurrentWindow(sourceEditor, editor);
                break;
            }
            case 4: {
                strategy.initialiseForEditingNewBuffer(sourceEditor, editor);
                break;
            }
            case 5: {
                strategy.initialiseForNewBufferInNewWindow(sourceEditor, editor);
            }
        }
    }

    protected final void updateFallbackWindow(@NotNull VimEditor fallbackWindow, @NotNull VimEditor sourceEditor) {
        Intrinsics.checkNotNullParameter((Object)fallbackWindow, (String)"fallbackWindow");
        Intrinsics.checkNotNullParameter((Object)sourceEditor, (String)"sourceEditor");
        OptionInitialisationStrategy strategy = new OptionInitialisationStrategy(this.storage);
        strategy.initialiseCloneCurrentState(sourceEditor, fallbackWindow);
    }

    @Override
    @NotNull
    public <T extends VimDataType> T getOptionValue(@NotNull Option<T> option, @NotNull OptionAccessScope scope) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return this.storage.getOptionValue(option, scope);
    }

    @Override
    public <T extends VimDataType> void setOptionValue(@NotNull Option<T> option, @NotNull OptionAccessScope scope, @NotNull T value) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        option.checkIfValueValid(value, value.asString());
        OptionAccessScope optionAccessScope = scope;
        if (optionAccessScope instanceof OptionAccessScope.EFFECTIVE) {
            if (this.storage.setOptionValue(option, scope, value)) {
                this.parsedValuesCache.reset(option, ((OptionAccessScope.EFFECTIVE)scope).getEditor());
                this.listeners.onEffectiveValueChanged(option, ((OptionAccessScope.EFFECTIVE)scope).getEditor());
            }
        } else if (optionAccessScope instanceof OptionAccessScope.LOCAL) {
            if (this.storage.setOptionValue(option, scope, value)) {
                this.parsedValuesCache.reset(option, ((OptionAccessScope.LOCAL)scope).getEditor());
                this.listeners.onLocalValueChanged(option, ((OptionAccessScope.LOCAL)scope).getEditor());
            }
        } else if (optionAccessScope instanceof OptionAccessScope.GLOBAL && this.storage.setOptionValue(option, scope, value)) {
            if (option.getDeclaredScope() == OptionDeclaredScope.GLOBAL) {
                this.parsedValuesCache.reset(option, ((OptionAccessScope.GLOBAL)scope).getEditor());
            }
            this.listeners.onGlobalValueChanged(option);
        }
    }

    @Override
    @NotNull
    public <T extends VimDataType, TData> TData getParsedEffectiveOptionValue(@NotNull Option<T> option, @Nullable VimEditor editor, @NotNull Function1<? super T, ? extends TData> provider) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        return this.parsedValuesCache.getParsedEffectiveOptionValue(option, editor, provider);
    }

    @Override
    @Nullable
    public Option<VimDataType> getOption(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return Options.INSTANCE.getOption(key);
    }

    @Override
    @NotNull
    public Set<Option<VimDataType>> getAllOptions() {
        return Options.INSTANCE.getAllOptions();
    }

    @Override
    public void resetAllOptions(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Iterable $this$forEach$iv = Options.INSTANCE.getAllOptions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Option option = (Option)element$iv;
            boolean bl = false;
            VimOptionGroupKt.resetDefaultValue(this, option, new OptionAccessScope.GLOBAL(editor));
            switch (WhenMappings.$EnumSwitchMapping$1[option.getDeclaredScope().ordinal()]) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    VimOptionGroupKt.resetDefaultValue(this, option, new OptionAccessScope.LOCAL(editor));
                    break;
                }
                case 4: 
                case 5: {
                    this.setOptionValue(option, new OptionAccessScope.LOCAL(editor), option.getUnsetValue());
                }
            }
        }
    }

    @Override
    public void resetAllOptionsForTesting() {
        this.resetAllOptions(VimInjectorKt.getInjector().getFallbackWindow());
        Iterable $this$forEach$iv = VimInjectorKt.getInjector().getEditorGroup().getEditors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VimEditor it = (VimEditor)element$iv;
            boolean bl = false;
            this.resetAllOptions(it);
        }
    }

    @Override
    public void addOption(@NotNull Option<? extends VimDataType> option) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        Options.INSTANCE.addOption(option);
        this.initialiseNewOptionDefaultValues(option);
    }

    @Override
    public void removeOption(@NotNull String optionName) {
        Intrinsics.checkNotNullParameter((Object)optionName, (String)"optionName");
        Options.INSTANCE.removeOption(optionName);
        this.listeners.removeAllListeners(optionName);
    }

    @Override
    public <T extends VimDataType> void addGlobalOptionChangeListener(@NotNull Option<T> option, @NotNull GlobalOptionChangeListener listener) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!(option.getDeclaredScope() == OptionDeclaredScope.GLOBAL)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.listeners.addGlobalOptionChangeListener(option.getName(), listener);
    }

    @Override
    public <T extends VimDataType> void removeGlobalOptionChangeListener(@NotNull Option<T> option, @NotNull GlobalOptionChangeListener listener) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.removeGlobalOptionChangeListener(option.getName(), listener);
    }

    @Override
    public <T extends VimDataType> void addEffectiveOptionValueChangeListener(@NotNull Option<T> option, @NotNull EffectiveOptionValueChangeListener listener) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.addEffectiveOptionValueChangeListener(option.getName(), listener);
    }

    @Override
    public <T extends VimDataType> void removeEffectiveOptionValueChangeListener(@NotNull Option<T> option, @NotNull EffectiveOptionValueChangeListener listener) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.removeEffectiveOptionValueChangeListener(option.getName(), listener);
    }

    @Override
    public final <T extends VimDataType> void overrideDefaultValue(@NotNull Option<T> option, @NotNull T newDefaultValue) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        Intrinsics.checkNotNullParameter(newDefaultValue, (String)"newDefaultValue");
        option.overrideDefaultValue$vim_engine(newDefaultValue);
    }

    @Override
    @NotNull
    public GlobalOptions getGlobalOptions() {
        return new GlobalOptions(new OptionAccessScope.GLOBAL(null));
    }

    @Override
    @NotNull
    public EffectiveOptions getEffectiveOptions(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return new EffectiveOptions(new OptionAccessScope.EFFECTIVE(editor));
    }

    private final <T extends VimDataType> void initialiseNewOptionDefaultValues(Option<T> option) {
        if (option.getDeclaredScope() != OptionDeclaredScope.LOCAL_TO_WINDOW) {
            this.storage.setOptionValue(option, new OptionAccessScope.GLOBAL(null), option.getDefaultValue());
        }
        Iterable $this$forEach$iv = VimInjectorKt.getInjector().getEditorGroup().getEditors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VimEditor editor = (VimEditor)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$1[option.getDeclaredScope().ordinal()]) {
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    this.storage.setOptionValue(option, new OptionAccessScope.LOCAL(editor), option.getDefaultValue());
                    break;
                }
                case 4: 
                case 5: {
                    this.storage.setOptionValue(option, new OptionAccessScope.LOCAL(editor), option.getUnsetValue());
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LocalOptionInitialisationScenario.values().length];
            try {
                nArray[LocalOptionInitialisationScenario.FALLBACK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocalOptionInitialisationScenario.CMD_LINE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocalOptionInitialisationScenario.SPLIT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocalOptionInitialisationScenario.EDIT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LocalOptionInitialisationScenario.NEW.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OptionDeclaredScope.values().length];
            try {
                nArray[OptionDeclaredScope.GLOBAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OptionDeclaredScope.LOCAL_TO_BUFFER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OptionDeclaredScope.LOCAL_TO_WINDOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OptionDeclaredScope.GLOBAL_OR_LOCAL_TO_BUFFER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OptionDeclaredScope.GLOBAL_OR_LOCAL_TO_WINDOW.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

