/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimJumpService;
import com.maddyhome.idea.vim.api.VimJumpServiceKt;
import com.maddyhome.idea.vim.mark.Jump;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0006H\u0016J\u0010\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00182\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0018\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0016J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0016J \u0010!\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0016R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR&\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006#"}, d2={"Lcom/maddyhome/idea/vim/api/VimJumpServiceBase;", "Lcom/maddyhome/idea/vim/api/VimJumpService;", "()V", "projectToJumpSpot", "", "", "", "getProjectToJumpSpot", "()Ljava/util/Map;", "projectToJumps", "", "Lcom/maddyhome/idea/vim/mark/Jump;", "getProjectToJumps", "addJump", "", "projectId", "jump", "reset", "", "dropLastJump", "getJump", "count", "getJumpSpot", "getJumps", "", "removeJump", "resetJumps", "saveJumpLocation", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "updateJumpsFromDelete", "startOffset", "length", "updateJumpsFromInsert", "Companion", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimJumpServiceBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimJumpServiceBase.kt\ncom/maddyhome/idea/vim/api/VimJumpServiceBase\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,78:1\n372#2,7:79\n*S KotlinDebug\n*F\n+ 1 VimJumpServiceBase.kt\ncom/maddyhome/idea/vim/api/VimJumpServiceBase\n*L\n36#1:79,7\n*E\n"})
public abstract class VimJumpServiceBase
implements VimJumpService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, List<Jump>> projectToJumps = new LinkedHashMap();
    @NotNull
    private final Map<String, Integer> projectToJumpSpot = new LinkedHashMap();
    public static final int SAVE_JUMP_COUNT = 100;

    @NotNull
    protected final Map<String, List<Jump>> getProjectToJumps() {
        return this.projectToJumps;
    }

    @NotNull
    protected final Map<String, Integer> getProjectToJumpSpot() {
        return this.projectToJumpSpot;
    }

    @Override
    @Nullable
    public Jump getJump(@NotNull String projectId, int count) {
        Jump jump;
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        List list = this.projectToJumps.get(projectId);
        if (list == null) {
            list = new ArrayList();
        }
        List jumps = list;
        this.projectToJumpSpot.putIfAbsent(projectId, -1);
        int n = jumps.size() - 1;
        Integer n2 = this.projectToJumpSpot.get(projectId);
        Intrinsics.checkNotNull((Object)n2);
        int index = n - (((Number)n2).intValue() - count);
        Jump jump2 = (Jump)CollectionsKt.getOrNull((List)jumps, (int)index);
        if (jump2 != null) {
            Jump jump3;
            Jump it = jump3 = jump2;
            boolean bl = false;
            Integer n3 = this.projectToJumpSpot.get(projectId);
            Intrinsics.checkNotNull((Object)n3);
            this.projectToJumpSpot.put(projectId, ((Number)n3).intValue() - count);
            jump = jump3;
        } else {
            jump = null;
        }
        return jump;
    }

    @Override
    @NotNull
    public List<Jump> getJumps(@NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        List list = this.projectToJumps.get(projectId);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    public int getJumpSpot(@NotNull String projectId) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Integer n = this.projectToJumpSpot.get(projectId);
        return n != null ? n : -1;
    }

    @Override
    public void addJump(@NotNull String projectId, @NotNull Jump jump, boolean reset) {
        int n;
        List list;
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        this.setLastJumpTimeStamp(System.currentTimeMillis());
        Map<String, List<Jump>> $this$getOrPut$iv = this.projectToJumps;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(projectId);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(projectId, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        List jumps = list;
        jumps.removeIf(arg_0 -> VimJumpServiceBase.addJump$lambda$2((Function1)new Function1<Jump, Boolean>(jump){
            final /* synthetic */ Jump $jump;
            {
                this.$jump = $jump;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Jump it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getFilepath(), (Object)this.$jump.getFilepath()) && it.getLine() == this.$jump.getLine();
            }
        }, arg_0));
        jumps.add(jump);
        Map<String, Integer> map = this.projectToJumpSpot;
        if (reset) {
            n = -1;
        } else {
            Integer n2 = this.projectToJumpSpot.get(projectId);
            n = (n2 != null ? n2 : -1) + 1;
        }
        Integer n3 = n;
        map.put(projectId, n3);
        if (jumps.size() > 100) {
            CollectionsKt.removeFirst((List)jumps);
        }
    }

    @Override
    public void saveJumpLocation(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VimJumpServiceKt.addJump(this, editor, true);
        VimInjectorKt.getInjector().getMarkService().setMark(editor, '\'');
        this.includeCurrentCommandAsNavigation(editor);
    }

    @Override
    public void removeJump(@NotNull String projectId, @NotNull Jump jump) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
            Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
            List<Jump> list = this.projectToJumps.get(projectId);
            if (list == null) break block0;
            list.removeIf(arg_0 -> VimJumpServiceBase.removeJump$lambda$3((Function1)new Function1<Jump, Boolean>(jump){
                final /* synthetic */ Jump $jump;
                {
                    this.$jump = $jump;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Jump it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$jump);
                }
            }, arg_0));
        }
    }

    @Override
    public void dropLastJump(@NotNull String projectId) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
            List<Jump> list = this.projectToJumps.get(projectId);
            if (list == null) break block0;
            Jump cfr_ignored_0 = (Jump)CollectionsKt.removeLastOrNull(list);
        }
    }

    @Override
    public void updateJumpsFromInsert(@NotNull String projectId, int startOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void updateJumpsFromDelete(@NotNull String projectId, int startOffset, int length) {
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void resetJumps() {
        this.projectToJumps.clear();
        this.projectToJumpSpot.clear();
    }

    private static final boolean addJump$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean removeJump$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/maddyhome/idea/vim/api/VimJumpServiceBase$Companion;", "", "()V", "SAVE_JUMP_COUNT", "", "vim-engine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

