/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.BufferPosition;
import com.maddyhome.idea.vim.api.ImmutableVimCaret;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimVisualPosition;
import com.maddyhome.idea.vim.common.LiveRange;
import com.maddyhome.idea.vim.common.Offset;
import com.maddyhome.idea.vim.group.visual.EngineVisualGroupKt;
import com.maddyhome.idea.vim.group.visual.VisualChange;
import com.maddyhome.idea.vim.helper.EngineModeExtensionsKt;
import com.maddyhome.idea.vim.helper.StrictMode;
import com.maddyhome.idea.vim.state.mode.EditorExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH&J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\tH&J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\tH\u0016J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\tH&J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020!H&J\b\u0010\"\u001a\u00020\u0018H&J\b\u0010#\u001a\u00020\u0018H&J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&H&J\u0010\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\tH&J\b\u0010*\u001a\u00020\u0018H&R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u000b\"\u0004\b\u0016\u0010\r\u00a8\u0006+\u00c0\u0006\u0003"}, d2={"Lcom/maddyhome/idea/vim/api/VimCaret;", "Lcom/maddyhome/idea/vim/api/ImmutableVimCaret;", "vimInsertStart", "Lcom/maddyhome/idea/vim/common/LiveRange;", "getVimInsertStart", "()Lcom/maddyhome/idea/vim/common/LiveRange;", "setVimInsertStart", "(Lcom/maddyhome/idea/vim/common/LiveRange;)V", "vimLastColumn", "", "getVimLastColumn", "()I", "setVimLastColumn", "(I)V", "vimLastVisualOperatorRange", "Lcom/maddyhome/idea/vim/group/visual/VisualChange;", "getVimLastVisualOperatorRange", "()Lcom/maddyhome/idea/vim/group/visual/VisualChange;", "setVimLastVisualOperatorRange", "(Lcom/maddyhome/idea/vim/group/visual/VisualChange;)V", "vimSelectionStart", "getVimSelectionStart", "setVimSelectionStart", "moveToBufferPosition", "", "position", "Lcom/maddyhome/idea/vim/api/BufferPosition;", "moveToInlayAwareOffset", "newOffset", "moveToOffset", "offset", "moveToOffsetNative", "moveToVisualPosition", "Lcom/maddyhome/idea/vim/api/VimVisualPosition;", "removeSelection", "resetLastColumn", "setSelection", "start", "Lcom/maddyhome/idea/vim/common/Offset;", "end", "setVimLastColumnAndGetCaret", "col", "vimSelectionStartClear", "vim-engine"})
public interface VimCaret
extends ImmutableVimCaret {
    @Override
    public int getVimLastColumn();

    public void setVimLastColumn(int var1);

    public void resetLastColumn();

    @Override
    public int getVimSelectionStart();

    public void setVimSelectionStart(int var1);

    public void vimSelectionStartClear();

    public void setSelection(@NotNull Offset var1, @NotNull Offset var2);

    public void removeSelection();

    @NotNull
    default public VimCaret moveToOffset(int offset) {
        VimCaret vimCaret;
        if (offset < 0 || offset > this.getEditor().text().length() || !this.isValid()) {
            return this;
        }
        if (EditorExtensionsKt.getInBlockSelection(this.getEditor())) {
            StrictMode.INSTANCE.assertTrue(Intrinsics.areEqual((Object)this, (Object)this.getEditor().primaryCaret()), "Block selection can only be moved with primary caret!");
            EngineVisualGroupKt.vimMoveBlockSelectionToOffset(this.getEditor(), offset);
            VimInjectorKt.getInjector().getScroll().scrollCaretIntoView(this.getEditor());
            return this;
        }
        int oldOffset = this.getOffset().getPoint();
        VimCaret caretAfterMove = this.moveToInlayAwareOffset(offset);
        if (Intrinsics.areEqual((Object)this, (Object)this.getEditor().primaryCaret())) {
            VimInjectorKt.getInjector().getScroll().scrollCaretIntoView(this.getEditor());
        }
        if (EditorExtensionsKt.getInVisualMode(this.getEditor()) || EditorExtensionsKt.getInSelectMode(this.getEditor())) {
            EngineVisualGroupKt.vimMoveSelectionToCaret(caretAfterMove, this.getVimSelectionStart());
            vimCaret = (VimCaret)this.getEditor().findLastVersionOfCaret((ImmutableVimCaret)caretAfterMove);
            if (vimCaret == null) {
                vimCaret = caretAfterMove;
            }
        } else {
            EngineModeExtensionsKt.exitVisualMode(this.getEditor());
            vimCaret = caretAfterMove;
        }
        caretAfterMove = vimCaret;
        VimInjectorKt.getInjector().getMotion().onAppCodeMovement(this.getEditor(), this, offset, oldOffset);
        return caretAfterMove;
    }

    public void moveToOffsetNative(int var1);

    @NotNull
    public VimCaret moveToInlayAwareOffset(int var1);

    public void moveToBufferPosition(@NotNull BufferPosition var1);

    public void moveToVisualPosition(@NotNull VimVisualPosition var1);

    @NotNull
    public VimCaret setVimLastColumnAndGetCaret(int var1);

    @NotNull
    public LiveRange getVimInsertStart();

    public void setVimInsertStart(@NotNull LiveRange var1);

    @Nullable
    public VisualChange getVimLastVisualOperatorRange();

    public void setVimLastVisualOperatorRange(@Nullable VisualChange var1);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static VimCaret moveToOffset(@NotNull VimCaret $this, int offset) {
            return $this.moveToOffset(offset);
        }
    }
}

