/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.MultikeyMap;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.ex.ExException;
import com.maddyhome.idea.vim.ex.ExExceptionsKt;
import com.maddyhome.idea.vim.helper.StrictMode;
import com.maddyhome.idea.vim.options.NumberOption;
import com.maddyhome.idea.vim.options.Option;
import com.maddyhome.idea.vim.options.OptionAccessScope;
import com.maddyhome.idea.vim.options.OptionDeclaredScope;
import com.maddyhome.idea.vim.options.StringListOption;
import com.maddyhome.idea.vim.options.StringOption;
import com.maddyhome.idea.vim.options.ToggleOption;
import com.maddyhome.idea.vim.options.UnsignedNumberOption;
import com.maddyhome.idea.vim.options.helpers.GuiCursorOptionHelper;
import com.maddyhome.idea.vim.options.helpers.KeywordOptionHelper;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimInt;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimString;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b1\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010b\u001a\u0002Hc\"\u0010\b\u0000\u0010c*\n\u0012\u0006\b\u0001\u0012\u00020e0d2\u0006\u0010f\u001a\u0002Hc\u00a2\u0006\u0002\u0010gJ\u0012\u0010h\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020e0d0iJ\u0016\u0010j\u001a\n\u0012\u0004\u0012\u00020e\u0018\u00010d2\u0006\u0010k\u001a\u00020lJ\u0006\u0010m\u001a\u00020nJ+\u0010o\u001a\u00020n\"\b\b\u0000\u0010c*\u00020e2\f\u0010f\u001a\b\u0012\u0004\u0012\u0002Hc0d2\u0006\u0010p\u001a\u0002Hc\u00a2\u0006\u0002\u0010qJ\u000e\u0010r\u001a\u00020n2\u0006\u0010s\u001a\u00020lR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\nR\u0011\u0010\u0016\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\nR\u0011\u0010\u0018\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\nR\u0010\u0010\u001a\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\nR\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\nR\u0011\u0010)\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006R\u0011\u0010+\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\nR\u0011\u0010-\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00103\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\nR\u0011\u00105\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010&R\u0011\u00107\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010&R\u0011\u00109\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010&R\u0011\u0010;\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00100R\u0011\u0010=\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010\u0006R\u0011\u0010?\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u00100R\u0011\u0010A\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u00100R\u0011\u0010C\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u00100R\u0011\u0010E\u001a\u00020.\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u00100R\u0011\u0010G\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\nR\u0011\u0010I\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010\nR\u0011\u0010K\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\bL\u0010&R\u0011\u0010M\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010&R\u0010\u0010O\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010P\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010\nR\u0011\u0010R\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010\nR\u0011\u0010T\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010\u0012R\u0011\u0010V\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010&R\u0011\u0010X\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010\u0006R\u0011\u0010Z\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010\u0006R\u0011\u0010\\\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010\nR\u0011\u0010^\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010\u0006R\u0011\u0010`\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010\n\u00a8\u0006t"}, d2={"Lcom/maddyhome/idea/vim/api/Options;", "", "()V", "clipboard", "Lcom/maddyhome/idea/vim/options/StringListOption;", "getClipboard", "()Lcom/maddyhome/idea/vim/options/StringListOption;", "digraph", "Lcom/maddyhome/idea/vim/options/ToggleOption;", "getDigraph", "()Lcom/maddyhome/idea/vim/options/ToggleOption;", "gdefault", "getGdefault", "guicursor", "getGuicursor", "history", "Lcom/maddyhome/idea/vim/options/UnsignedNumberOption;", "getHistory", "()Lcom/maddyhome/idea/vim/options/UnsignedNumberOption;", "hlsearch", "ideaglobalmode", "getIdeaglobalmode", "ideastrictmode", "getIdeastrictmode", "ideatracetime", "getIdeatracetime", "ignorecase", "incsearch", "getIncsearch", "iskeyword", "getIskeyword", "keymodel", "getKeymodel", "matchpairs", "getMatchpairs", "maxmapdepth", "Lcom/maddyhome/idea/vim/options/NumberOption;", "getMaxmapdepth", "()Lcom/maddyhome/idea/vim/options/NumberOption;", "more", "getMore", "nrformats", "getNrformats", "number", "getNumber", "operatorfunc", "Lcom/maddyhome/idea/vim/options/StringOption;", "getOperatorfunc", "()Lcom/maddyhome/idea/vim/options/StringOption;", "options", "Lcom/maddyhome/idea/vim/api/MultikeyMap;", "relativenumber", "getRelativenumber", "scroll", "getScroll", "scrolljump", "getScrolljump", "scrolloff", "getScrolloff", "selection", "getSelection", "selectmode", "getSelectmode", "shell", "getShell", "shellcmdflag", "getShellcmdflag", "shellxescape", "getShellxescape", "shellxquote", "getShellxquote", "showcmd", "getShowcmd", "showmode", "getShowmode", "sidescroll", "getSidescroll", "sidescrolloff", "getSidescrolloff", "smartcase", "startofline", "getStartofline", "timeout", "getTimeout", "timeoutlen", "getTimeoutlen", "undolevels", "getUndolevels", "viminfo", "getViminfo", "virtualedit", "getVirtualedit", "visualbell", "getVisualbell", "whichwrap", "getWhichwrap", "wrapscan", "getWrapscan", "addOption", "T", "Lcom/maddyhome/idea/vim/options/Option;", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "option", "(Lcom/maddyhome/idea/vim/options/Option;)Lcom/maddyhome/idea/vim/options/Option;", "getAllOptions", "", "getOption", "key", "", "initialise", "", "overrideDefaultValue", "newDefaultValue", "(Lcom/maddyhome/idea/vim/options/Option;Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;)V", "removeOption", "optionName", "vim-engine"})
public final class Options {
    @NotNull
    public static final Options INSTANCE;
    @NotNull
    private static final MultikeyMap options;
    @NotNull
    private static final ToggleOption digraph;
    @NotNull
    private static final ToggleOption gdefault;
    @NotNull
    private static final UnsignedNumberOption history;
    @JvmField
    @NotNull
    public static final ToggleOption hlsearch;
    @JvmField
    @NotNull
    public static final ToggleOption ignorecase;
    @NotNull
    private static final ToggleOption incsearch;
    @NotNull
    private static final StringListOption keymodel;
    @NotNull
    private static final NumberOption maxmapdepth;
    @NotNull
    private static final ToggleOption more;
    @NotNull
    private static final StringListOption nrformats;
    @NotNull
    private static final ToggleOption number;
    @NotNull
    private static final ToggleOption relativenumber;
    @NotNull
    private static final NumberOption scroll;
    @NotNull
    private static final NumberOption scrolloff;
    @NotNull
    private static final StringOption selection;
    @NotNull
    private static final StringListOption selectmode;
    @NotNull
    private static final StringOption shell;
    @NotNull
    private static final StringOption shellxescape;
    @NotNull
    private static final ToggleOption showcmd;
    @NotNull
    private static final ToggleOption showmode;
    @NotNull
    private static final NumberOption sidescroll;
    @NotNull
    private static final NumberOption sidescrolloff;
    @JvmField
    @NotNull
    public static final ToggleOption smartcase;
    @NotNull
    private static final ToggleOption startofline;
    @NotNull
    private static final ToggleOption timeout;
    @NotNull
    private static final UnsignedNumberOption timeoutlen;
    @NotNull
    private static final NumberOption undolevels;
    @NotNull
    private static final StringListOption viminfo;
    @NotNull
    private static final StringListOption virtualedit;
    @NotNull
    private static final ToggleOption visualbell;
    @NotNull
    private static final StringListOption whichwrap;
    @NotNull
    private static final ToggleOption wrapscan;
    @NotNull
    private static final StringListOption guicursor;
    @NotNull
    private static final StringListOption iskeyword;
    @NotNull
    private static final StringListOption matchpairs;
    @NotNull
    private static final StringOption operatorfunc;
    @NotNull
    private static final NumberOption scrolljump;
    @NotNull
    private static final StringOption shellcmdflag;
    @NotNull
    private static final StringOption shellxquote;
    @NotNull
    private static final StringListOption clipboard;
    @NotNull
    private static final ToggleOption ideaglobalmode;
    @NotNull
    private static final ToggleOption ideastrictmode;
    @NotNull
    private static final ToggleOption ideatracetime;

    private Options() {
    }

    public final void initialise() {
    }

    @Nullable
    public final Option<VimDataType> getOption(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return options.get(key);
    }

    @NotNull
    public final Set<Option<VimDataType>> getAllOptions() {
        return CollectionsKt.toSet((Iterable)options.getValues());
    }

    @NotNull
    public final <T extends Option<? extends VimDataType>> T addOption(@NotNull T option) {
        T t;
        Intrinsics.checkNotNullParameter(option, (String)"option");
        T it = t = option;
        boolean bl = false;
        options.put(option.getName(), option.getAbbrev(), option);
        return t;
    }

    public final void removeOption(@NotNull String optionName) {
        Intrinsics.checkNotNullParameter((Object)optionName, (String)"optionName");
        options.remove(optionName);
    }

    public final <T extends VimDataType> void overrideDefaultValue(@NotNull Option<T> option, @NotNull T newDefaultValue) {
        Intrinsics.checkNotNullParameter(option, (String)"option");
        Intrinsics.checkNotNullParameter(newDefaultValue, (String)"newDefaultValue");
        option.overrideDefaultValue$vim_engine(newDefaultValue);
    }

    @NotNull
    public final ToggleOption getDigraph() {
        return digraph;
    }

    @NotNull
    public final ToggleOption getGdefault() {
        return gdefault;
    }

    @NotNull
    public final UnsignedNumberOption getHistory() {
        return history;
    }

    @NotNull
    public final ToggleOption getIncsearch() {
        return incsearch;
    }

    @NotNull
    public final StringListOption getKeymodel() {
        return keymodel;
    }

    @NotNull
    public final NumberOption getMaxmapdepth() {
        return maxmapdepth;
    }

    @NotNull
    public final ToggleOption getMore() {
        return more;
    }

    @NotNull
    public final StringListOption getNrformats() {
        return nrformats;
    }

    @NotNull
    public final ToggleOption getNumber() {
        return number;
    }

    @NotNull
    public final ToggleOption getRelativenumber() {
        return relativenumber;
    }

    @NotNull
    public final NumberOption getScroll() {
        return scroll;
    }

    @NotNull
    public final NumberOption getScrolloff() {
        return scrolloff;
    }

    @NotNull
    public final StringOption getSelection() {
        return selection;
    }

    @NotNull
    public final StringListOption getSelectmode() {
        return selectmode;
    }

    @NotNull
    public final StringOption getShell() {
        return shell;
    }

    @NotNull
    public final StringOption getShellxescape() {
        return shellxescape;
    }

    @NotNull
    public final ToggleOption getShowcmd() {
        return showcmd;
    }

    @NotNull
    public final ToggleOption getShowmode() {
        return showmode;
    }

    @NotNull
    public final NumberOption getSidescroll() {
        return sidescroll;
    }

    @NotNull
    public final NumberOption getSidescrolloff() {
        return sidescrolloff;
    }

    @NotNull
    public final ToggleOption getStartofline() {
        return startofline;
    }

    @NotNull
    public final ToggleOption getTimeout() {
        return timeout;
    }

    @NotNull
    public final UnsignedNumberOption getTimeoutlen() {
        return timeoutlen;
    }

    @NotNull
    public final NumberOption getUndolevels() {
        return undolevels;
    }

    @NotNull
    public final StringListOption getViminfo() {
        return viminfo;
    }

    @NotNull
    public final StringListOption getVirtualedit() {
        return virtualedit;
    }

    @NotNull
    public final ToggleOption getVisualbell() {
        return visualbell;
    }

    @NotNull
    public final StringListOption getWhichwrap() {
        return whichwrap;
    }

    @NotNull
    public final ToggleOption getWrapscan() {
        return wrapscan;
    }

    @NotNull
    public final StringListOption getGuicursor() {
        return guicursor;
    }

    @NotNull
    public final StringListOption getIskeyword() {
        return iskeyword;
    }

    @NotNull
    public final StringListOption getMatchpairs() {
        return matchpairs;
    }

    @NotNull
    public final StringOption getOperatorfunc() {
        return operatorfunc;
    }

    @NotNull
    public final NumberOption getScrolljump() {
        return scrolljump;
    }

    @NotNull
    public final StringOption getShellcmdflag() {
        return shellcmdflag;
    }

    @NotNull
    public final StringOption getShellxquote() {
        return shellxquote;
    }

    @NotNull
    public final StringListOption getClipboard() {
        return clipboard;
    }

    @NotNull
    public final ToggleOption getIdeaglobalmode() {
        return ideaglobalmode;
    }

    @NotNull
    public final ToggleOption getIdeastrictmode() {
        return ideastrictmode;
    }

    @NotNull
    public final ToggleOption getIdeatracetime() {
        return ideatracetime;
    }

    static {
        String string;
        INSTANCE = new Options();
        options = new MultikeyMap(new Option[0]);
        digraph = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("digraph", OptionDeclaredScope.GLOBAL, "dg", false, false, 16, null));
        gdefault = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("gdefault", OptionDeclaredScope.GLOBAL, "gd", false, false, 16, null));
        history = (UnsignedNumberOption)INSTANCE.addOption((Option)new UnsignedNumberOption("history", OptionDeclaredScope.GLOBAL, "hi", 50));
        hlsearch = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("hlsearch", OptionDeclaredScope.GLOBAL, "hls", false, false, 16, null));
        ignorecase = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("ignorecase", OptionDeclaredScope.GLOBAL, "ic", false, false, 16, null));
        incsearch = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("incsearch", OptionDeclaredScope.GLOBAL, "is", false, false, 16, null));
        Object object = new String[]{"startsel", "stopsel", "stopselect", "stopvisual", "continueselect", "continuevisual"};
        keymodel = (StringListOption)INSTANCE.addOption((Option)new StringListOption("keymodel", OptionDeclaredScope.GLOBAL, "km", "continueselect,stopselect", (Collection<String>)SetsKt.setOf((Object[])object)));
        maxmapdepth = (NumberOption)INSTANCE.addOption((Option)new NumberOption("maxmapdepth", OptionDeclaredScope.GLOBAL, "mmd", 20, 0, 16, null));
        more = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("more", OptionDeclaredScope.GLOBAL, "more", true, false, 16, null));
        object = new String[]{"octal", "hex", "alpha"};
        nrformats = (StringListOption)INSTANCE.addOption((Option)new StringListOption("nrformats", OptionDeclaredScope.LOCAL_TO_BUFFER, "nf", "hex", (Collection<String>)SetsKt.setOf((Object[])object)));
        number = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("number", OptionDeclaredScope.LOCAL_TO_WINDOW, "nu", false, false, 16, null));
        relativenumber = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("relativenumber", OptionDeclaredScope.LOCAL_TO_WINDOW, "rnu", false, false, 16, null));
        scroll = (NumberOption)INSTANCE.addOption((Option)new NumberOption("scroll", OptionDeclaredScope.LOCAL_TO_WINDOW, "scr", 0, 0, 16, null));
        scrolloff = (NumberOption)INSTANCE.addOption((Option)new NumberOption("scrolloff", OptionDeclaredScope.GLOBAL_OR_LOCAL_TO_WINDOW, "so", 0, 0, 16, null));
        object = new String[]{"old", "inclusive", "exclusive"};
        selection = (StringOption)INSTANCE.addOption((Option)new StringOption("selection", OptionDeclaredScope.GLOBAL, "sel", "inclusive", SetsKt.setOf((Object[])object)));
        object = new String[]{"mouse", "key", "cmd", "ideaselection"};
        selectmode = (StringListOption)INSTANCE.addOption((Option)new StringListOption("selectmode", OptionDeclaredScope.GLOBAL, "slm", "", (Collection<String>)SetsKt.setOf((Object[])object)));
        if (VimInjectorKt.getInjector().getSystemInfoService().isWindows()) {
            string = "cmd.exe";
        } else {
            string = System.getenv("SHELL");
            if (string == null) {
                string = "sh";
            }
        }
        shell = (StringOption)INSTANCE.addOption((Option)new StringOption("shell", OptionDeclaredScope.GLOBAL, "sh", string, null, 16, null));
        shellxescape = (StringOption)INSTANCE.addOption((Option)new StringOption("shellxescape", OptionDeclaredScope.GLOBAL, "sxe", VimInjectorKt.getInjector().getSystemInfoService().isWindows() ? "\"&|<>()@^" : "", null, 16, null));
        showcmd = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("showcmd", OptionDeclaredScope.GLOBAL, "sc", true, false, 16, null));
        showmode = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("showmode", OptionDeclaredScope.GLOBAL, "smd", true, false, 16, null));
        sidescroll = (NumberOption)INSTANCE.addOption((Option)new NumberOption("sidescroll", OptionDeclaredScope.GLOBAL, "ss", 0, 0, 16, null));
        sidescrolloff = (NumberOption)INSTANCE.addOption((Option)new NumberOption("sidescrolloff", OptionDeclaredScope.GLOBAL_OR_LOCAL_TO_WINDOW, "siso", 0, 0, 16, null));
        smartcase = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("smartcase", OptionDeclaredScope.GLOBAL, "scs", false, false, 16, null));
        startofline = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("startofline", OptionDeclaredScope.GLOBAL, "sol", true, false, 16, null));
        timeout = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("timeout", OptionDeclaredScope.GLOBAL, "to", true, false, 16, null));
        timeoutlen = (UnsignedNumberOption)INSTANCE.addOption((Option)new UnsignedNumberOption("timeoutlen", OptionDeclaredScope.GLOBAL, "tm", 1000));
        undolevels = (NumberOption)INSTANCE.addOption((Option)new NumberOption("undolevels", OptionDeclaredScope.GLOBAL_OR_LOCAL_TO_BUFFER, "ul", 1000, -123456));
        viminfo = (StringListOption)INSTANCE.addOption((Option)new StringListOption("viminfo", OptionDeclaredScope.GLOBAL, "vi", "'100,<50,s10,h", null, 16, null));
        object = new String[]{"onemore", "block", "insert", "all"};
        virtualedit = (StringListOption)INSTANCE.addOption((Option)new StringListOption("virtualedit", OptionDeclaredScope.GLOBAL_OR_LOCAL_TO_WINDOW, "ve", "", (Collection<String>)SetsKt.setOf((Object[])object)));
        visualbell = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("visualbell", OptionDeclaredScope.GLOBAL, "vb", false, false, 16, null));
        object = new String[]{"b", "s", "h", "l", "<", ">", "~", "[", "]"};
        whichwrap = (StringListOption)INSTANCE.addOption((Option)new StringListOption("whichwrap", OptionDeclaredScope.GLOBAL, "ww", "b,s", (Collection<String>)SetsKt.setOf((Object[])object)));
        wrapscan = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("wrapscan", OptionDeclaredScope.GLOBAL, "ws", true, false, 16, null));
        object = OptionDeclaredScope.GLOBAL;
        guicursor = (StringListOption)INSTANCE.addOption((Option)new StringListOption((OptionDeclaredScope)((Object)object)){

            public void checkIfValueValid(@NotNull VimDataType value, @NotNull String token) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                super.checkIfValueValid(value, token);
                String valueAsString = ((VimString)value).getValue();
                String[] stringArray = new String[]{","};
                Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)valueAsString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    GuiCursorOptionHelper.INSTANCE.convertToken(it);
                }
            }
        });
        object = OptionDeclaredScope.LOCAL_TO_BUFFER;
        iskeyword = (StringListOption)INSTANCE.addOption((Option)new StringListOption((OptionDeclaredScope)((Object)object)){

            public void checkIfValueValid(@NotNull VimDataType value, @NotNull String token) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                super.checkIfValueValid(value, token);
                if (KeywordOptionHelper.INSTANCE.isValueInvalid(((VimString)value).getValue())) {
                    Object[] objectArray = new Object[]{token};
                    throw ExExceptionsKt.exExceptionMessage("E474", objectArray);
                }
            }

            @NotNull
            public List<String> split(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                List<String> result = KeywordOptionHelper.INSTANCE.parseValues(value);
                StrictMode.INSTANCE.assertTrue(result != null, "Cannot split iskeyword value: $ value");
                List<String> list = result;
                if (list == null) {
                    list = this.split(((VimString)this.getDefaultValue()).getValue());
                }
                return list;
            }
        });
        object = OptionDeclaredScope.LOCAL_TO_BUFFER;
        matchpairs = (StringListOption)INSTANCE.addOption((Option)new StringListOption((OptionDeclaredScope)((Object)object)){

            public void checkIfValueValid(@NotNull VimDataType value, @NotNull String token) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                super.checkIfValueValid(value, token);
                for (String v : this.split(((VimString)value).getValue())) {
                    Object[] objectArray = (Object[])v;
                    if (new Regex(".:.").matches((CharSequence)objectArray)) continue;
                    objectArray = new Object[]{token};
                    throw ExExceptionsKt.exExceptionMessage("E474", objectArray);
                }
            }
        });
        object = OptionDeclaredScope.GLOBAL;
        VimString vimString = VimString.Companion.getEMPTY();
        operatorfunc = (StringOption)INSTANCE.addOption((Option)new StringOption((OptionDeclaredScope)((Object)object), vimString){

            @NotNull
            public VimString parseValue(@NotNull String value, @NotNull String token) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                return super.parseValue(value, token);
            }
        });
        object = OptionDeclaredScope.GLOBAL;
        scrolljump = (NumberOption)INSTANCE.addOption((Option)new NumberOption((OptionDeclaredScope)((Object)object)){

            public void checkIfValueValid(@NotNull VimDataType value, @NotNull String token) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                super.checkIfValueValid(value, token);
                if (((VimInt)value).getValue() < -100) {
                    throw new ExException("E49: Invalid scroll size: " + token);
                }
            }
        });
        object = OptionDeclaredScope.GLOBAL;
        shellcmdflag = (StringOption)INSTANCE.addOption((Option)new StringOption((OptionDeclaredScope)((Object)object)){

            @NotNull
            public VimString getDefaultValue() {
                String shell = ((VimString)VimInjectorKt.getInjector().getOptionGroup().getOptionValue(Options.INSTANCE.getShell(), new OptionAccessScope.GLOBAL(null))).asString();
                return new VimString(VimInjectorKt.getInjector().getSystemInfoService().isWindows() && StringsKt.contains$default((CharSequence)shell, (CharSequence)"powershell", (boolean)false, (int)2, null) ? "-Command" : (VimInjectorKt.getInjector().getSystemInfoService().isWindows() && !StringsKt.contains$default((CharSequence)shell, (CharSequence)"sh", (boolean)false, (int)2, null) ? "/c" : "-c"));
            }
        });
        object = OptionDeclaredScope.GLOBAL;
        shellxquote = (StringOption)INSTANCE.addOption((Option)new StringOption((OptionDeclaredScope)((Object)object)){

            @NotNull
            public VimString getDefaultValue() {
                String shell = ((VimString)VimInjectorKt.getInjector().getOptionGroup().getOptionValue(Options.INSTANCE.getShell(), new OptionAccessScope.GLOBAL(null))).asString();
                return new VimString(VimInjectorKt.getInjector().getSystemInfoService().isWindows() && Intrinsics.areEqual((Object)shell, (Object)"cmd.exe") ? "(" : (VimInjectorKt.getInjector().getSystemInfoService().isWindows() && StringsKt.contains$default((CharSequence)shell, (CharSequence)"sh", (boolean)false, (int)2, null) ? "\"" : ""));
            }
        });
        clipboard = (StringListOption)INSTANCE.addOption((Option)new StringListOption("clipboard", OptionDeclaredScope.GLOBAL, "cb", "autoselect,exclude:cons\\|linux", null, 16, null));
        ideaglobalmode = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("ideaglobalmode", OptionDeclaredScope.GLOBAL, "ideaglobalmode", false, false, 16, null));
        ideastrictmode = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("ideastrictmode", OptionDeclaredScope.GLOBAL, "ideastrictmode", false, true));
        ideatracetime = (ToggleOption)INSTANCE.addOption((Option)new ToggleOption("ideatracetime", OptionDeclaredScope.GLOBAL, "ideatracetime", false, true));
    }
}

