/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.vim.api;

import com.maddyhome.idea.vim.api.Key;
import com.maddyhome.idea.vim.api.OptionStorage;
import com.maddyhome.idea.vim.api.Options;
import com.maddyhome.idea.vim.api.VimEditor;
import com.maddyhome.idea.vim.api.VimInjectorKt;
import com.maddyhome.idea.vim.api.VimStorageServiceKt;
import com.maddyhome.idea.vim.options.NumberOption;
import com.maddyhome.idea.vim.options.Option;
import com.maddyhome.idea.vim.options.OptionAccessScope;
import com.maddyhome.idea.vim.options.OptionDeclaredScope;
import com.maddyhome.idea.vim.options.ToggleOption;
import com.maddyhome.idea.vim.vimscript.model.datatypes.VimDataType;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J-\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0012\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0011J/\u0010\u0013\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u0011J/\u0010\u0014\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0015\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0011J+\u0010\u0016\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J;\u0010\u001b\u001a\u0004\u0018\u0001H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00062\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0010H\u0002\u00a2\u0006\u0002\u0010\u001dJ\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J-\u0010\u001f\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\fJ5\u0010\"\u001a\u00020!\"\b\b\u0000\u0010\u000e*\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010$J5\u0010%\u001a\u00020!\"\b\b\u0000\u0010\u000e*\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010$J7\u0010&\u001a\u00020!\"\b\b\u0000\u0010\u000e*\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010#\u001a\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010$J5\u0010'\u001a\u00020!\"\b\b\u0000\u0010\u000e*\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010$J3\u0010(\u001a\u00020!\"\b\b\u0000\u0010\u000e*\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010#\u001a\u0002H\u000e\u00a2\u0006\u0002\u0010)J;\u0010*\u001a\u00020!\"\b\b\u0000\u0010\u000e*\u00020\u00062\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010+\u001a\u00020\u00052\u0006\u0010#\u001a\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010,J5\u0010-\u001a\u00020!\"\b\b\u0000\u0010\u000e*\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010#\u001a\u0002H\u000eH\u0002\u00a2\u0006\u0002\u0010$J\u001f\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020!2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000502H\u0082\bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/maddyhome/idea/vim/api/OptionStorage;", "", "()V", "globalValues", "", "", "Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "localOptionsKey", "Lcom/maddyhome/idea/vim/api/Key;", "perWindowGlobalOptionsKey", "getBufferLocalOptionStorage", "editor", "Lcom/maddyhome/idea/vim/api/VimEditor;", "getBufferLocalValue", "T", "option", "Lcom/maddyhome/idea/vim/options/Option;", "(Lcom/maddyhome/idea/vim/options/Option;Lcom/maddyhome/idea/vim/api/VimEditor;)Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "getEffectiveValue", "getEmergencyFallbackLocalValue", "getGlobalValue", "getLocalValue", "getOptionValue", "scope", "Lcom/maddyhome/idea/vim/options/OptionAccessScope;", "(Lcom/maddyhome/idea/vim/options/Option;Lcom/maddyhome/idea/vim/options/OptionAccessScope;)Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "getPerWindowGlobalOptionStorage", "getValue", "values", "(Ljava/util/Map;Lcom/maddyhome/idea/vim/options/Option;)Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;", "getWindowLocalOptionStorage", "getWindowLocalValue", "isLocalToBufferOptionStorageInitialised", "", "setBufferLocalValue", "value", "(Lcom/maddyhome/idea/vim/options/Option;Lcom/maddyhome/idea/vim/api/VimEditor;Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;)Z", "setEffectiveValue", "setGlobalValue", "setLocalValue", "setOptionValue", "(Lcom/maddyhome/idea/vim/options/Option;Lcom/maddyhome/idea/vim/options/OptionAccessScope;Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;)Z", "setValue", "key", "(Ljava/util/Map;Ljava/lang/String;Lcom/maddyhome/idea/vim/vimscript/model/datatypes/VimDataType;)Z", "setWindowLocalValue", "strictModeAssert", "", "condition", "lazyMessage", "Lkotlin/Function0;", "vim-engine"})
@SourceDebugExtension(value={"SMAP\nVimOptionGroupBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VimOptionGroupBase.kt\ncom/maddyhome/idea/vim/api/OptionStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,746:1\n372#1,4:748\n372#1,4:752\n1#2:747\n*S KotlinDebug\n*F\n+ 1 VimOptionGroupBase.kt\ncom/maddyhome/idea/vim/api/OptionStorage\n*L\n273#1:748,4\n280#1:752,4\n*E\n"})
final class OptionStorage {
    @NotNull
    private final Map<String, VimDataType> globalValues = new LinkedHashMap();
    @NotNull
    private final Key<Map<String, VimDataType>> perWindowGlobalOptionsKey = new Key("vimPerWindowGlobalOptions");
    @NotNull
    private final Key<Map<String, VimDataType>> localOptionsKey = new Key("vimLocalOptions");

    @NotNull
    public final <T extends VimDataType> T getOptionValue(@NotNull Option<T> option, @NotNull OptionAccessScope scope) {
        T t;
        Intrinsics.checkNotNullParameter(option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        OptionAccessScope optionAccessScope = scope;
        if (optionAccessScope instanceof OptionAccessScope.EFFECTIVE) {
            t = this.getEffectiveValue(option, ((OptionAccessScope.EFFECTIVE)scope).getEditor());
        } else if (optionAccessScope instanceof OptionAccessScope.GLOBAL) {
            t = this.getGlobalValue(option, ((OptionAccessScope.GLOBAL)scope).getEditor());
        } else if (optionAccessScope instanceof OptionAccessScope.LOCAL) {
            t = this.getLocalValue(option, ((OptionAccessScope.LOCAL)scope).getEditor());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return t;
    }

    public final <T extends VimDataType> boolean setOptionValue(@NotNull Option<T> option, @NotNull OptionAccessScope scope, @NotNull T value) {
        boolean bl;
        Intrinsics.checkNotNullParameter(option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        OptionAccessScope optionAccessScope = scope;
        if (optionAccessScope instanceof OptionAccessScope.EFFECTIVE) {
            bl = this.setEffectiveValue(option, ((OptionAccessScope.EFFECTIVE)scope).getEditor(), value);
        } else if (optionAccessScope instanceof OptionAccessScope.GLOBAL) {
            bl = this.setGlobalValue(option, ((OptionAccessScope.GLOBAL)scope).getEditor(), value);
        } else if (optionAccessScope instanceof OptionAccessScope.LOCAL) {
            bl = this.setLocalValue(option, ((OptionAccessScope.LOCAL)scope).getEditor(), value);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public final boolean isLocalToBufferOptionStorageInitialised(@NotNull VimEditor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return VimInjectorKt.getInjector().getVimStorageService().getDataFromBuffer(editor, this.localOptionsKey) != null;
    }

    private final <T extends VimDataType> T getEffectiveValue(Option<T> option, VimEditor editor) {
        Object object;
        switch (WhenMappings.$EnumSwitchMapping$0[option.getDeclaredScope().ordinal()]) {
            case 1: {
                object = this.getGlobalValue(option, editor);
                break;
            }
            case 2: {
                object = this.getLocalValue(option, editor);
                break;
            }
            case 3: {
                object = this.getLocalValue(option, editor);
                break;
            }
            case 4: {
                T t;
                T it = t = this.getLocalValue(option, editor);
                boolean bl = false;
                object = !Intrinsics.areEqual(it, option.getUnsetValue()) ? t : null;
                if (object != null) break;
                object = this.getGlobalValue(option, editor);
                break;
            }
            case 5: {
                T t;
                T it = t = this.getLocalValue(option, editor);
                boolean bl = false;
                object = !Intrinsics.areEqual(it, option.getUnsetValue()) ? t : null;
                if (object != null) break;
                object = this.getGlobalValue(option, editor);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    private final <T extends VimDataType> T getGlobalValue(Option<T> option, VimEditor editor) {
        T t;
        Map<String, VimDataType> values;
        Map<String, VimDataType> map;
        if (option.getDeclaredScope() == OptionDeclaredScope.LOCAL_TO_WINDOW) {
            if (!(editor != null)) {
                boolean bl = false;
                String string = "Editor must be provided for local options";
                throw new IllegalStateException(string.toString());
            }
            map = this.getPerWindowGlobalOptionStorage(editor);
        } else {
            map = values = this.globalValues;
        }
        if ((t = this.getValue(values, option)) == null) {
            t = option.getDefaultValue();
        }
        return t;
    }

    private final <T extends VimDataType> T getLocalValue(Option<T> option, VimEditor editor) {
        T t;
        switch (WhenMappings.$EnumSwitchMapping$0[option.getDeclaredScope().ordinal()]) {
            case 1: {
                t = this.getGlobalValue(option, editor);
                break;
            }
            case 2: 
            case 4: {
                t = this.getBufferLocalValue(option, editor);
                break;
            }
            case 3: 
            case 5: {
                t = this.getWindowLocalValue(option, editor);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends VimDataType> T getBufferLocalValue(Option<T> option, VimEditor editor) {
        void this_$iv;
        Map<String, VimDataType> values = this.getBufferLocalOptionStorage(editor);
        T value = this.getValue(values, option);
        OptionStorage optionStorage = this;
        boolean condition$iv = value != null;
        boolean $i$f$strictModeAssert = false;
        VimDataType vimDataType = this_$iv.globalValues.get(Options.INSTANCE.getIdeastrictmode().getName());
        boolean bl = vimDataType != null ? vimDataType.asBoolean() : false;
        if (bl && !condition$iv) {
            boolean bl2 = false;
            String string = ("Unexpected uninitialised buffer local value: " + option.getName()).toString();
            throw new IllegalStateException(string);
        }
        T t = value;
        if (t == null) {
            t = this.getEmergencyFallbackLocalValue(option, editor);
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    private final <T extends VimDataType> T getWindowLocalValue(Option<T> option, VimEditor editor) {
        void this_$iv;
        Map<String, VimDataType> values = this.getWindowLocalOptionStorage(editor);
        T value = this.getValue(values, option);
        OptionStorage optionStorage = this;
        boolean condition$iv = value != null;
        boolean $i$f$strictModeAssert = false;
        VimDataType vimDataType = this_$iv.globalValues.get(Options.INSTANCE.getIdeastrictmode().getName());
        boolean bl = vimDataType != null ? vimDataType.asBoolean() : false;
        if (bl && !condition$iv) {
            boolean bl2 = false;
            String string = ("Unexpected uninitialised window local value: " + option.getName()).toString();
            throw new IllegalStateException(string);
        }
        T t = value;
        if (t == null) {
            t = this.getEmergencyFallbackLocalValue(option, editor);
        }
        return t;
    }

    private final <T extends VimDataType> boolean setEffectiveValue(Option<T> option, VimEditor editor, T value) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[option.getDeclaredScope().ordinal()]) {
            case 1: {
                bl = this.setGlobalValue(option, editor, value);
                break;
            }
            case 2: 
            case 3: {
                boolean bl2;
                boolean it = bl2 = this.setLocalValue(option, editor, value);
                boolean bl3 = false;
                this.setGlobalValue(option, editor, value);
                bl = bl2;
                break;
            }
            case 4: 
            case 5: {
                boolean changed = false;
                if (!Intrinsics.areEqual(this.getLocalValue(option, editor), option.getUnsetValue())) {
                    changed = this.setLocalValue(option, editor, option instanceof NumberOption || option instanceof ToggleOption ? value : option.getUnsetValue());
                }
                if (this.setGlobalValue(option, editor, value) || changed) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final <T extends VimDataType> boolean setGlobalValue(Option<T> option, VimEditor editor, T value) {
        Map<String, VimDataType> map;
        if (option.getDeclaredScope() == OptionDeclaredScope.LOCAL_TO_WINDOW) {
            if (!(editor != null)) {
                boolean bl = false;
                String string = "Editor must be provided for local options";
                throw new IllegalStateException(string.toString());
            }
            map = this.getPerWindowGlobalOptionStorage(editor);
        } else {
            map = this.globalValues;
        }
        Map<String, VimDataType> values = map;
        return this.setValue(values, option.getName(), value);
    }

    private final <T extends VimDataType> boolean setLocalValue(Option<T> option, VimEditor editor, T value) {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[option.getDeclaredScope().ordinal()]) {
            case 1: {
                bl = this.setGlobalValue(option, editor, value);
                break;
            }
            case 2: 
            case 4: {
                bl = this.setBufferLocalValue(option, editor, value);
                break;
            }
            case 3: 
            case 5: {
                bl = this.setWindowLocalValue(option, editor, value);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final <T extends VimDataType> boolean setBufferLocalValue(Option<T> option, VimEditor editor, T value) {
        Map<String, VimDataType> values = this.getBufferLocalOptionStorage(editor);
        return this.setValue(values, option.getName(), value);
    }

    private final <T extends VimDataType> boolean setWindowLocalValue(Option<T> option, VimEditor editor, T value) {
        Map<String, VimDataType> values = this.getWindowLocalOptionStorage(editor);
        return this.setValue(values, option.getName(), value);
    }

    private final <T extends VimDataType> T getValue(Map<String, VimDataType> values, Option<T> option) {
        VimDataType vimDataType = values.get(option.getName());
        return (T)(vimDataType instanceof VimDataType ? vimDataType : null);
    }

    private final <T extends VimDataType> boolean setValue(Map<String, VimDataType> values, String key, T value) {
        VimDataType oldValue = values.get(key);
        if (!Intrinsics.areEqual((Object)oldValue, value)) {
            values.put(key, value);
            return true;
        }
        return false;
    }

    private final Map<String, VimDataType> getPerWindowGlobalOptionStorage(VimEditor editor) {
        return VimStorageServiceKt.getOrPutWindowData(VimInjectorKt.getInjector().getVimStorageService(), editor, this.perWindowGlobalOptionsKey, getPerWindowGlobalOptionStorage.1.INSTANCE);
    }

    private final Map<String, VimDataType> getBufferLocalOptionStorage(VimEditor editor) {
        return VimStorageServiceKt.getOrPutBufferData(VimInjectorKt.getInjector().getVimStorageService(), editor, this.localOptionsKey, getBufferLocalOptionStorage.1.INSTANCE);
    }

    private final Map<String, VimDataType> getWindowLocalOptionStorage(VimEditor editor) {
        return VimStorageServiceKt.getOrPutWindowData(VimInjectorKt.getInjector().getVimStorageService(), editor, this.localOptionsKey, getWindowLocalOptionStorage.1.INSTANCE);
    }

    private final <T extends VimDataType> T getEmergencyFallbackLocalValue(Option<T> option, VimEditor editor) {
        return option.getDeclaredScope() == OptionDeclaredScope.GLOBAL_OR_LOCAL_TO_BUFFER || option.getDeclaredScope() == OptionDeclaredScope.GLOBAL_OR_LOCAL_TO_WINDOW ? option.getUnsetValue() : this.getGlobalValue(option, editor);
    }

    private final void strictModeAssert(boolean condition, Function0<String> lazyMessage) {
        boolean $i$f$strictModeAssert = false;
        VimDataType vimDataType = this.globalValues.get(Options.INSTANCE.getIdeastrictmode().getName());
        boolean bl = vimDataType != null ? vimDataType.asBoolean() : false;
        if (bl && !condition) {
            throw new IllegalStateException(lazyMessage.invoke().toString());
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OptionDeclaredScope.values().length];
            try {
                nArray[OptionDeclaredScope.GLOBAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OptionDeclaredScope.LOCAL_TO_BUFFER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OptionDeclaredScope.LOCAL_TO_WINDOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OptionDeclaredScope.GLOBAL_OR_LOCAL_TO_BUFFER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OptionDeclaredScope.GLOBAL_OR_LOCAL_TO_WINDOW.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

