/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.OSTargetInfo;
import org.clang.basic.target.impl.TargetInfo;
import org.clang.basic.target.impl.TargetsStatics;
import org.clank.support.Native;
import org.llvm.adt.APFloat;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.support.fltSemantics;

public class NaClTargetInfo<Target extends TargetInfo>
extends OSTargetInfo<Target> {
    @Override
    protected void getOSDefines(LangOptions Opts, Triple Triple2, MacroBuilder Builder2) {
        if (Opts.POSIXThreads) {
            Builder2.defineMacro(new Twine("_REENTRANT"));
        }
        if (Opts.CPlusPlus) {
            Builder2.defineMacro(new Twine("_GNU_SOURCE"));
        }
        TargetsStatics.DefineStd(Builder2, new StringRef("unix"), Opts);
        Builder2.defineMacro(new Twine("__ELF__"));
        Builder2.defineMacro(new Twine("__native_client__"));
    }

    public NaClTargetInfo(Target T2, Triple Triple2, TargetOptions Opts) {
        super(T2, Triple2, Opts);
        this.tgt.LongAlign = (byte)32;
        this.tgt.LongWidth = (byte)32;
        this.tgt.PointerAlign = (byte)32;
        this.tgt.PointerWidth = (byte)32;
        this.tgt.IntMaxType = TargetInfo.IntType.SignedLongLong;
        this.tgt.Int64Type = TargetInfo.IntType.SignedLongLong;
        this.tgt.DoubleAlign = (byte)64;
        this.tgt.LongDoubleWidth = (byte)64;
        this.tgt.LongDoubleAlign = (byte)64;
        this.tgt.LongLongWidth = (byte)64;
        this.tgt.LongLongAlign = (byte)64;
        this.tgt.SizeType = TargetInfo.IntType.UnsignedInt;
        this.tgt.PtrDiffType = TargetInfo.IntType.SignedInt;
        this.tgt.IntPtrType = TargetInfo.IntType.SignedInt;
        this.tgt.LongDoubleFormat = (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEdouble);
        if (Triple2.getArch() != Triple.ArchType.arm) {
            if (Triple2.getArch() == Triple.ArchType.x86) {
                this.tgt.resetDataLayout(new StringRef("e-m:e-p:32:32-i64:64-n8:16:32-S128"));
            } else if (Triple2.getArch() == Triple.ArchType.x86_64) {
                this.tgt.resetDataLayout(new StringRef("e-m:e-p:32:32-i64:64-n8:16:32:64-S128"));
            } else if (Triple2.getArch() != Triple.ArchType.mipsel) {
                assert (Triple2.getArch() == Triple.ArchType.le32);
                this.tgt.resetDataLayout(new StringRef("e-p:32:32-i64:64"));
            }
        }
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

