/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import java.util.logging.Level;
import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileEntry;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.impl.SourceManagerStatics;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeTrace;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitchCharPtr;
import org.llvm.adt.Twine;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.raw_ostream;

public final class SrcMgr {

    public static class SLocEntry
    implements Native.NativePOD<SLocEntry>,
    NativeType.SizeofCapable {
        protected int Offset;
        static final int ExpansionBit = Integer.MIN_VALUE;
        private static final int ExpansionBitMask = Integer.MAX_VALUE;
        protected int Union_IncludeLoc_or_SpellingLoc;
        protected int Union_NumCreatedFIDs_or_ExpansionLocStart;
        protected int Union_Data_or_ExpansionLocEnd;
        private static long instances = 0L;

        static void copyTo(int[] arrayUIntFields, int i, SLocEntry value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        static int toOffset(int rawOffset) {
            return rawOffset & Integer.MAX_VALUE;
        }

        static boolean isExpansion(int rawOffset) {
            return (rawOffset & Integer.MIN_VALUE) != 0;
        }

        static boolean isNotExpansion(int rawOffset) {
            return (rawOffset & Integer.MIN_VALUE) == 0;
        }

        public final int $sizeof() {
            return SLocEntry.$sizeof_SLocEntry();
        }

        static int $sizeof_SLocEntry() {
            return NativeType.BYTES_IN_JAVA_OBJECT_HEADER + 4 + 4 + 4 + 4;
        }

        final void setFile_NumCreatedFIDs(int NumFIDs) {
            throw new IllegalStateException("Entry is not updated this way, use SourceManager methods instead");
        }

        final void setFile_HasLineDirectives() {
            throw new IllegalStateException("Entry is not updated this way, use SourceManager methods instead");
        }

        final int getFile_ContentCacheIndex() {
            assert (this.isFile()) : "Not a file SLocEntry!";
            return FileInfo.getContentCacheIndex(this.Union_Data_or_ExpansionLocEnd);
        }

        final int getRawOffset() {
            return this.Offset;
        }

        SLocEntry(int rawOffset) {
            this.Offset = rawOffset;
            SLocEntry.trackInstance();
        }

        SLocEntry(int RawOffset, int Union_IncludeLoc_or_SpellingLoc, int Union_NumCreatedFIDs_or_ExpansionLocStart, int Union_Data_or_ExpansionLocEnd) {
            this.Offset = RawOffset;
            this.Union_IncludeLoc_or_SpellingLoc = Union_IncludeLoc_or_SpellingLoc;
            this.Union_NumCreatedFIDs_or_ExpansionLocStart = Union_NumCreatedFIDs_or_ExpansionLocStart;
            this.Union_Data_or_ExpansionLocEnd = Union_Data_or_ExpansionLocEnd;
            SLocEntry.trackInstance();
        }

        SLocEntry(int[] array2, int index) {
            SLocEntry.trackInstance();
            throw new UnsupportedOperationException();
        }

        public final int getOffset() {
            return SLocEntry.toOffset(this.Offset);
        }

        public final boolean isExpansion() {
            return SLocEntry.isExpansion(this.Offset);
        }

        public final boolean isFile() {
            return !this.isExpansion();
        }

        public final FileInfo getFile() {
            assert (this.isFile()) : "Not a file SLocEntry!";
            return (FileInfo)this;
        }

        public final ExpansionInfo getExpansion() {
            assert (this.isExpansion()) : "Not a macro expansion SLocEntry!";
            return (ExpansionInfo)this;
        }

        public static SLocEntry get(int Offset, FileInfo FI) {
            assert ((Offset & Integer.MIN_VALUE) == 0) : "Offset is too large";
            FI.Offset = Offset;
            assert (FI.isFile());
            return FI;
        }

        public static SLocEntry get(int Offset, ExpansionInfo Expansion) {
            assert ((Offset & Integer.MIN_VALUE) == 0) : "Offset is too large";
            Expansion.Offset = Offset | Integer.MIN_VALUE;
            assert (Expansion.isExpansion());
            return Expansion;
        }

        public static SLocEntry get(int RawOffset, int Union_IncludeLoc_or_SpellingLoc, int Union_NumCreatedFIDs_or_ExpansionLocStart, int Union_Data_or_ExpansionLocEnd) {
            SLocEntry out = SLocEntry.isExpansion(RawOffset) ? new ExpansionInfo(RawOffset, Union_IncludeLoc_or_SpellingLoc, Union_NumCreatedFIDs_or_ExpansionLocStart, Union_Data_or_ExpansionLocEnd) : new FileInfo(RawOffset, Union_IncludeLoc_or_SpellingLoc, Union_NumCreatedFIDs_or_ExpansionLocStart, Union_Data_or_ExpansionLocEnd);
            return out;
        }

        private SLocEntry() {
            SLocEntry.trackInstance();
        }

        public SLocEntry(SLocEntry $Prm0) {
            throw new UnsupportedOperationException("no-copy or get must be used");
        }

        public SLocEntry(JavaDifferentiators.JD.Move _dparam, SLocEntry $Prm0) {
            throw new UnsupportedOperationException("no-move or get must be used");
        }

        public final SLocEntry $assign(SLocEntry $Prm0) {
            throw new IllegalStateException("Entry is not updated this way, use SourceManager methods instead");
        }

        public final SLocEntry $assignMove(SLocEntry $Prm0) {
            return (SLocEntry)Native.$Deref((Object)this.$assign($Prm0));
        }

        public String toString() {
            return "SLocEntry{" + (this.isExpansion() ? "M:" : "F:") + this.getOffset() + "[" + (this.isExpansion() ? this.getExpansion() : this.getFile()) + "]}";
        }

        public SLocEntry clone() {
            throw new UnsupportedOperationException("Why is it used?");
        }

        public final boolean $noteq(SLocEntry other) {
            return !this.$eq(other);
        }

        public final boolean $eq(SLocEntry other) {
            return this.Offset == other.Offset && this.Union_IncludeLoc_or_SpellingLoc == other.Union_IncludeLoc_or_SpellingLoc && this.Union_NumCreatedFIDs_or_ExpansionLocStart == other.Union_NumCreatedFIDs_or_ExpansionLocStart && this.Union_Data_or_ExpansionLocEnd == other.Union_Data_or_ExpansionLocEnd;
        }

        private static void trackInstance() {
            if (NativeTrace.STATISTICS) {
                ++instances;
            }
        }

        public static void clearStatistics() {
            instances = 0L;
        }

        public static long PrintStats(raw_ostream out) {
            out.$out(String.format("%22s created:\t", SLocEntry.class.getSimpleName())).$out(NativeTrace.formatNumber((long)instances)).$out(".\n");
            NativeTrace.dumpStatisticValue((String)SLocEntry.class.getSimpleName(), (long)instances);
            return instances;
        }
    }

    public static final class ExpansionInfo
    extends SLocEntry {
        private static long instances = 0L;

        private ExpansionInfo() {
            throw new UnsupportedOperationException("Java Deleted");
        }

        public ExpansionInfo(JavaDifferentiators.JD.Move _dparam, ExpansionInfo $Prm0) {
            throw new UnsupportedOperationException("Java Deleted");
        }

        private ExpansionInfo(int RawOffset, int SpellingLoc, int ExpansionLocStart, int ExpansionLocEnd) {
            super(RawOffset, SpellingLoc, ExpansionLocStart, ExpansionLocEnd);
            ExpansionInfo.trackInstance();
        }

        public SourceLocation getSpellingLoc() {
            return SourceLocation.getFromRawEncoding(this.Union_IncludeLoc_or_SpellingLoc);
        }

        public int $getSpellingLoc() {
            return this.Union_IncludeLoc_or_SpellingLoc;
        }

        public SourceLocation getExpansionLocStart() {
            return SourceLocation.getFromRawEncoding(this.Union_NumCreatedFIDs_or_ExpansionLocStart);
        }

        public int $getExpansionLocStart() {
            return this.Union_NumCreatedFIDs_or_ExpansionLocStart;
        }

        public SourceLocation getExpansionLocEnd() {
            SourceLocation EndLoc = SourceLocation.getFromRawEncoding(this.Union_Data_or_ExpansionLocEnd);
            return EndLoc.isInvalid() ? this.getExpansionLocStart() : EndLoc;
        }

        public int $getExpansionLocEnd() {
            return SourceLocation.isInvalid(this.Union_Data_or_ExpansionLocEnd) ? this.$getExpansionLocStart() : this.Union_Data_or_ExpansionLocEnd;
        }

        public std_pair.pair<SourceLocation, SourceLocation> getExpansionLocRange() {
            return std.make_pair((Object)this.getExpansionLocStart(), (Object)this.getExpansionLocEnd());
        }

        public long $getExpansionLocRange() {
            return BasicClangGlobals.wrap_SourceLocation_SourceLocation(this.$getExpansionLocStart(), this.$getExpansionLocEnd());
        }

        public boolean isMacroArgExpansion() {
            return SourceLocation.isValid(this.$getExpansionLocStart()) && SourceLocation.isInvalid(this.Union_Data_or_ExpansionLocEnd);
        }

        public boolean isMacroBodyExpansion() {
            return SourceLocation.isValid(this.$getExpansionLocStart()) && SourceLocation.isValid(this.Union_Data_or_ExpansionLocEnd);
        }

        public boolean isFunctionMacroExpansion() {
            return SourceLocation.isValid(this.$getExpansionLocStart()) && this.$getExpansionLocStart() != this.$getExpansionLocEnd();
        }

        public static ExpansionInfo create(SourceLocation SpellingLoc, SourceLocation Start, SourceLocation End) {
            return ExpansionInfo.create(SpellingLoc.getRawEncoding(), Start.getRawEncoding(), End.getRawEncoding());
        }

        static ExpansionInfo create(int Raw_SpellingLoc, int Raw_Start, int Raw_End) {
            ExpansionInfo X = new ExpansionInfo(0, Raw_SpellingLoc, Raw_Start, Raw_End);
            return X;
        }

        public static ExpansionInfo createForMacroArg(int SpellingLoc, int ExpansionLoc) {
            return ExpansionInfo.create(SpellingLoc, ExpansionLoc, SourceLocation.getInvalid());
        }

        public ExpansionInfo $assign(ExpansionInfo $Prm0) {
            throw new UnsupportedOperationException("We don't have real instances of this, they are decomposed in collection");
        }

        public ExpansionInfo $assignMove(ExpansionInfo $Prm0) {
            throw new UnsupportedOperationException("We don't have real instances of this, they are decomposed in collection");
        }

        @Override
        public String toString() {
            return "EInfo{SLoc=" + this.getSpellingLoc() + ", Exp=[" + SourceLocation.getFromRawEncoding(this.Union_NumCreatedFIDs_or_ExpansionLocStart) + "-" + SourceLocation.getFromRawEncoding(this.Union_Data_or_ExpansionLocEnd) + ")}";
        }

        @Override
        public ExpansionInfo clone() {
            throw new UnsupportedOperationException("We don't have real instances of this, they are decomposed in collection");
        }

        private static void trackInstance() {
            if (NativeTrace.STATISTICS) {
                ++instances;
            }
        }

        public static void clearStatistics() {
            instances = 0L;
        }

        public static long PrintStats(raw_ostream out) {
            out.$out(String.format("%22s created:\t", ExpansionInfo.class.getSimpleName())).$out(NativeTrace.formatNumber((long)instances)).$out(".\n");
            NativeTrace.dumpStatisticValue((String)ExpansionInfo.class.getSimpleName(), (long)instances);
            return instances;
        }
    }

    public static final class FileInfo
    extends SLocEntry {
        static final int LineDirectivesBit = Integer.MIN_VALUE;
        static final int CharacteristicKindShift = 29;
        private static final int CharacteristicKindUser = 0;
        private static final int CharacteristicKindSystem = 0x20000000;
        private static final int CharacteristicKindExtSystem = 0x40000000;
        private static final int CharacteristicKindMask = 0x60000000;
        private static final int ContentCacheMask = 0x1FFFFFFF;
        private static long instances = 0L;
        private static long callGetContentCache = 0L;
        private static long callGetFileCharacteristic = 0L;

        public static FileInfo get(int IL, ContentCache Con, CharacteristicKind FileCharacter) {
            int Data = Con.$index();
            Data |= FileCharacter.getValue() << 29;
            assert (FileCharacter.getValue() < 4) : "invalid file character";
            FileInfo X = new FileInfo(0, IL, 0, Data);
            assert (FileCharacter == X.getFileCharacteristic());
            assert (X.getContentCacheIndex() == Con.$index()) : "ContentCache pointer insufficiently aligned: " + X.getContentCacheIndex() + " vs " + Con.$index();
            return X;
        }

        public SourceLocation getIncludeLoc() {
            return SourceLocation.getFromRawEncoding(this.Union_IncludeLoc_or_SpellingLoc);
        }

        public int $getIncludeLoc() {
            return this.Union_IncludeLoc_or_SpellingLoc;
        }

        public ContentCache getContentCache() {
            throw new UnsupportedOperationException("Use SourceManager.getContentCache instead");
        }

        public int getContentCacheIndex() {
            return FileInfo.getContentCacheIndex(this.Union_Data_or_ExpansionLocEnd);
        }

        public static int getContentCacheIndex(int Data) {
            FileInfo.trackGetContentCache();
            return Data & 0x1FFFFFFF;
        }

        public CharacteristicKind getFileCharacteristic() {
            return FileInfo.getFileCharacteristic(this.Union_Data_or_ExpansionLocEnd);
        }

        public static CharacteristicKind getFileCharacteristic(int Data) {
            FileInfo.trackGetFileCharacteristic();
            int val = Data & 0x60000000;
            if (val == 0) {
                return CharacteristicKind.C_User;
            }
            if (val == 0x20000000) {
                return CharacteristicKind.C_System;
            }
            assert (val == 0x40000000);
            return CharacteristicKind.C_ExternCSystem;
        }

        public int getNumCreatedFIDs() {
            return this.Union_NumCreatedFIDs_or_ExpansionLocStart;
        }

        public boolean hasLineDirectives() {
            return (this.Union_Data_or_ExpansionLocEnd & Integer.MIN_VALUE) != 0;
        }

        public static int setHasLineDirectives(int Data) {
            return Data | Integer.MIN_VALUE;
        }

        public FileInfo() {
            throw new UnsupportedOperationException("Java Deleted");
        }

        public FileInfo(JavaDifferentiators.JD.Move _dparam, FileInfo $Prm0) {
            throw new UnsupportedOperationException("Java Deleted");
        }

        private FileInfo(int RawOffset, int IncludeLoc, int NumCreatedFIDs, int Data) {
            super(RawOffset, IncludeLoc, NumCreatedFIDs, Data);
            FileInfo.trackInstance();
        }

        @Override
        public FileInfo clone() {
            throw new UnsupportedOperationException("We don't have real instances of this, they are decomposed in collection");
        }

        public FileInfo $assign(FileInfo $Prm0) {
            throw new UnsupportedOperationException("We don't have real instances of this, they are decomposed in collection");
        }

        public FileInfo $assignMove(FileInfo $Prm0) {
            throw new UnsupportedOperationException("We don't have real instances of this, they are decomposed in collection");
        }

        @Override
        public String toString() {
            return "FileInfo{IncludeLoc=" + this.getIncludeLoc() + ", FileCharacteristic=" + (Object)((Object)this.getFileCharacteristic()) + ", hasLineDirectives=" + this.hasLineDirectives() + ", NumCreatedFIDs=" + this.getNumCreatedFIDs() + ", Data=" + this.getContentCacheIndex() + '}';
        }

        private static void trackInstance() {
            if (NativeTrace.STATISTICS) {
                ++instances;
            }
        }

        private static void trackGetContentCache() {
            if (NativeTrace.STATISTICS) {
                ++callGetContentCache;
            }
        }

        private static void trackGetFileCharacteristic() {
            if (NativeTrace.STATISTICS) {
                ++callGetFileCharacteristic;
            }
        }

        public static void clearStatistics() {
            instances = 0L;
            callGetContentCache = 0L;
            callGetFileCharacteristic = 0L;
        }

        public static long PrintStats(raw_ostream out) {
            if (!NativeTrace.STATISTICS) {
                return instances;
            }
            out.$out(String.format("%22s created:\t", FileInfo.class.getSimpleName())).$out(NativeTrace.formatNumber((long)instances)).$out(".\n");
            out.$out(String.format("%22s  called:\t", "GetContentCache")).$out(NativeTrace.formatNumber((long)callGetContentCache)).$out(".\n");
            out.$out(String.format("%22s  called:\t", "GetFileCharacteristic")).$out(NativeTrace.formatNumber((long)callGetFileCharacteristic)).$out(".\n");
            NativeTrace.dumpStatisticValue((String)FileInfo.class.getSimpleName(), (long)instances);
            return instances;
        }
    }

    public static class ContentCache
    implements Destructors.ClassWithDestructor {
        private final int Index;
        private final ADTAliases.PointerInt2Pair<MemoryBuffer> Buffer = new ADTAliases.PointerInt2Pair(null, 0);
        public final FileEntry OrigEntry;
        public FileEntry ContentsEntry;
        public int[] SourceLineCache;
        public int NumLines;
        public boolean BufferOverridden;
        public boolean IsSystemFile;
        public boolean IsTransient;
        private static final StringRef getBuffer$FillStr = new StringRef("<<<MISSING SOURCE FILE>>>\n");
        private static long instances = 0L;

        public ContentCache(int index) {
            this(index, null, null);
        }

        public ContentCache(int index, FileEntry Ent) {
            this(index, Ent, Ent);
        }

        public ContentCache(int index, FileEntry Ent, FileEntry contentEnt) {
            this.OrigEntry = Ent;
            this.ContentsEntry = contentEnt;
            this.SourceLineCache = null;
            this.NumLines = 0;
            this.BufferOverridden = false;
            this.IsSystemFile = false;
            this.IsTransient = false;
            this.Index = index;
            ContentCache.trackInstance();
        }

        public ContentCache(ContentCache RHS) {
            this.SourceLineCache = null;
            this.BufferOverridden = false;
            this.IsSystemFile = false;
            this.IsTransient = false;
            this.OrigEntry = RHS.OrigEntry;
            this.ContentsEntry = RHS.ContentsEntry;
            assert (RHS.Buffer.getPointer() == null && RHS.SourceLineCache == null) : "Passed ContentCache object cannot own a buffer.";
            this.NumLines = RHS.NumLines;
            this.Index = RHS.Index;
        }

        public void $destroy() {
            if (SourceManagerStatics.CACHE_LINES_OFFSETS) {
                // empty if block
            }
            if (this.shouldFreeBuffer() && this.Buffer.getPointer() != null) {
                ((MemoryBuffer)this.Buffer.getPointer()).$destroy();
            }
        }

        public MemoryBuffer getBuffer(DiagnosticsEngine Diag, SourceManager SM) {
            return this.getBuffer(Diag, SM, SourceLocation.getInvalid(), null);
        }

        public MemoryBuffer getBuffer(DiagnosticsEngine Diag, SourceManager SM, int Loc) {
            return this.getBuffer(Diag, SM, Loc, null);
        }

        public MemoryBuffer getBuffer(DiagnosticsEngine Diag, SourceManager SM, int Loc, bool.ptr Invalid) {
            StringRef BufStr;
            char.ptr InvalidBOM;
            if (this.Buffer.getPointer() != null || this.ContentsEntry == null) {
                if (Invalid != null) {
                    Invalid.$set(this.isBufferInvalid());
                }
                return (MemoryBuffer)this.Buffer.getPointer();
            }
            boolean isVolatile = SM.userFilesAreVolatile() && !this.IsSystemFile;
            ErrorOr<std_ptr.unique_ptr<MemoryBuffer>> BufferOrError = SM.getFileManager().getBufferForFile(this.ContentsEntry, isVolatile);
            if (!BufferOrError.$bool()) {
                StringRef FillStr = getBuffer$FillStr;
                this.Buffer.setPointer((Object)((MemoryBuffer)MemoryBuffer.getNewUninitMemBuffer((int)Unsigned.$long2uint((long)this.ContentsEntry.getSize()), (Twine)Twine.T$invalid_marker).release()));
                char.ptr Ptr2 = Native.$tryClone((char.ptr)((MemoryBuffer)this.Buffer.getPointer()).getBufferStart());
                long e = this.ContentsEntry.getSize();
                for (long i = 0L; i != e; ++i) {
                    Ptr2.$set(Unsigned.$long2uint((long)i), FillStr.$at(Unsigned.$long2uint((long)(i % (long)FillStr.size()))));
                }
                if (Diag.isDiagnosticInFlight()) {
                    Diag.SetDelayedDiagnostic(3, new StringRef(this.ContentsEntry.getName()), new StringRef(BufferOrError.getError().message()));
                } else {
                    BasicClangGlobals.$out_DiagnosticBuilder$C_StringRef(BasicClangGlobals.$out_DiagnosticBuilder$C_char$ptr$C(Diag.Report(new SourceLocation(Loc), 3), this.ContentsEntry.getName()), new StringRef(BufferOrError.getError().message())).$destroy();
                }
                this.setInvalidBufferFlag(this.Buffer);
                if (Invalid != null) {
                    Invalid.$set(true);
                }
                return (MemoryBuffer)this.Buffer.getPointer();
            }
            this.Buffer.setPointer((Object)((MemoryBuffer)((std_ptr.unique_ptr)BufferOrError.$arrow()).release()));
            if ((long)this.getRawBuffer().getBufferSize() != this.ContentsEntry.getSize()) {
                boolean repaired = false;
                int BufferSize = this.getRawBuffer().getBufferSize();
                long FileSize = this.ContentsEntry.getSize();
                NativeTrace.getLogger().log(Level.FINE, "Found inconsistence for {0}:\n\tBufSize={1} vs. FileEntry.Size={2} {3}", new Object[]{Casts.toJavaString((char.ptr)this.ContentsEntry.Name), BufferSize, FileSize, (long)BufferSize > FileSize ? "- need to repair" : ""});
                repaired = SM.repairVolatileContentCache(this);
                if (!repaired) {
                    NativeTrace.assertTrueInConsole((boolean)false, (String)("Couldn't repair " + Casts.toJavaString((char.ptr)this.ContentsEntry.Name) + " SM.getBuffer: BufSize=" + BufferSize + " vs. FileEntry.Size=" + FileSize));
                    if (Diag.isDiagnosticInFlight()) {
                        Diag.SetDelayedDiagnostic(13, new StringRef(this.ContentsEntry.getName()));
                    } else {
                        BasicClangGlobals.$out_DiagnosticBuilder$C_char$ptr$C(Diag.Report(new SourceLocation(Loc), 13), this.ContentsEntry.getName()).$destroy();
                    }
                    this.setInvalidBufferFlag(this.Buffer);
                    if (Invalid != null) {
                        Invalid.$set(true);
                    }
                    return (MemoryBuffer)this.Buffer.getPointer();
                }
            }
            if ((InvalidBOM = new StringSwitchCharPtr(BufStr = ((MemoryBuffer)this.Buffer.getPointer()).getBuffer()).StartsWith("\u00fe\u00ff", NativePointer.$UTF_16__BE_).StartsWith("\u00ff\u00fe", NativePointer.$UTF_16__LE_).StartsWith("\u0000\u0000\u00fe\u00ff", NativePointer.$UTF_32__BE_).StartsWith("\u00ff\u00fe\u0000\u0000", NativePointer.$UTF_32__LE_).StartsWith("+/v", NativePointer.$UTF_7).StartsWith("\u00f7dL", NativePointer.$UTF_1).StartsWith("\u00ddsfs", NativePointer.$UTF_EBCDIC).StartsWith("\u000e\u00fe\u00ff", NativePointer.$SDSU).StartsWith("\u00fb\u00ee(", NativePointer.$BOCU_1).StartsWith("\u00841\u00953", NativePointer.$GB_18030).Default((char.ptr)null)) != null) {
                BasicClangGlobals.$out_DiagnosticBuilder$C_char$ptr$C(BasicClangGlobals.$out_DiagnosticBuilder$C_char$ptr$C(Diag.Report(new SourceLocation(Loc), 47), InvalidBOM), this.ContentsEntry.getName()).$destroy();
                this.setInvalidBufferFlag(this.Buffer);
            }
            if (Invalid != null) {
                Invalid.$set(this.isBufferInvalid());
            }
            return (MemoryBuffer)this.Buffer.getPointer();
        }

        public void setInvalidBufferFlag() {
            this.setInvalidBufferFlag(this.Buffer);
        }

        private void setInvalidBufferFlag(ADTAliases.PointerInt2Pair<MemoryBuffer> Buffer2) {
            Buffer2.setInt(Buffer2.getInt() | 1);
            assert (Buffer2.getPointer() != null);
            ((MemoryBuffer)Buffer2.getPointer()).setInvalid();
        }

        public int getSize() {
            return this.Buffer.getPointer() != null ? ((MemoryBuffer)this.Buffer.getPointer()).getBufferSize() : Unsigned.$long2uint((long)this.ContentsEntry.getSize());
        }

        int $index() {
            return this.Index;
        }

        public int getSizeBytesMapped() {
            return this.Buffer.getPointer() != null ? ((MemoryBuffer)this.Buffer.getPointer()).getBufferSize() : 0;
        }

        public MemoryBuffer.BufferKind getMemoryBufferKind() {
            assert (this.Buffer.getPointer() != null);
            if (this.Buffer.getPointer() == null) {
                return MemoryBuffer.BufferKind.MemoryBuffer_Malloc;
            }
            MemoryBuffer buf = (MemoryBuffer)this.Buffer.getPointer();
            return buf.getBufferKind();
        }

        public void setBuffer(std_ptr.unique_ptr<MemoryBuffer> B2) {
            assert (this.Buffer.getPointer() == null) : "MemoryBuffer already set.";
            this.Buffer.setPointer((Object)((MemoryBuffer)B2.release()));
            this.Buffer.setInt(0);
        }

        public MemoryBuffer getRawBuffer() {
            return (MemoryBuffer)this.Buffer.getPointer();
        }

        public void replaceBuffer(MemoryBuffer B2) {
            this.replaceBuffer(B2, false);
        }

        public void replaceBuffer(MemoryBuffer B2, boolean DoNotFree) {
            if (B2 != null && B2 == this.Buffer.getPointer()) {
                assert (false) : "Replacing with the same buffer";
                this.Buffer.setInt(DoNotFree ? 2 : 0);
                return;
            }
            if (this.shouldFreeBuffer() && this.Buffer.getPointer() != null) {
                ((MemoryBuffer)this.Buffer.getPointer()).$destroy();
            }
            this.Buffer.setPointer((Object)B2);
            this.Buffer.setInt(DoNotFree ? 2 : 0);
        }

        public boolean isBufferInvalid() {
            return (this.Buffer.getInt() & 1) != 0;
        }

        public boolean shouldFreeBuffer() {
            return (this.Buffer.getInt() & 2) == 0;
        }

        public String toString() {
            return "ContentCache{Index=" + this.Index + ";Buffer=" + this.Buffer + "\n, OrigEntry=" + this.OrigEntry + (this.ContentsEntry == this.OrigEntry ? "" : "\n, ContentsEntry=" + this.ContentsEntry) + "\n, SourceLineCache=" + this.SourceLineCache + "\n, NumLines=" + this.NumLines + ", BufferOverridden=" + this.BufferOverridden + ", IsSystemFile=" + this.IsSystemFile + ", IsTransient=" + this.IsTransient + '}';
        }

        private static void trackInstance() {
            if (NativeTrace.STATISTICS) {
                ++instances;
            }
        }

        public static void clearStatistics() {
            instances = 0L;
        }

        public static long PrintStats(raw_ostream out) {
            out.$out(String.format("%22s created:\t", ContentCache.class.getSimpleName())).$out(NativeTrace.formatNumber((long)instances)).$out(".\n");
            NativeTrace.dumpStatisticValue((String)ContentCache.class.getSimpleName(), (long)instances);
            return instances;
        }

        private static final class CCFlags {
            public static final int InvalidFlag = 1;
            public static final int DoNotFreeFlag = 2;

            private CCFlags() {
            }
        }
    }

    public static final class CharacteristicKind
    extends Enum<CharacteristicKind> {
        public static final /* enum */ CharacteristicKind C_User = new CharacteristicKind(0);
        public static final /* enum */ CharacteristicKind C_System = new CharacteristicKind(1);
        public static final /* enum */ CharacteristicKind C_ExternCSystem = new CharacteristicKind(2);
        public static final byte C_User_Raw = 0;
        public static final byte C_System_Raw = 1;
        public static final byte C_ExternCSystem_Raw = 2;
        private final byte value;
        private static final /* synthetic */ CharacteristicKind[] $VALUES;

        public static CharacteristicKind[] values() {
            return (CharacteristicKind[])$VALUES.clone();
        }

        public static CharacteristicKind valueOf(String name) {
            return Enum.valueOf(CharacteristicKind.class, name);
        }

        public static CharacteristicKind valueOf(int val) {
            CharacteristicKind out;
            CharacteristicKind characteristicKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private CharacteristicKind(int val) {
            this.value = (byte)val;
        }

        public byte getValue() {
            return this.value;
        }

        static {
            $VALUES = new CharacteristicKind[]{C_User, C_System, C_ExternCSystem};
        }

        private static final class Values {
            private static final CharacteristicKind[] VALUES;
            private static final CharacteristicKind[] _VALUES;

            private Values() {
            }

            static {
                byte max = 0;
                byte min = 0;
                for (CharacteristicKind kind : CharacteristicKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new CharacteristicKind[min < 0 ? 1 - min : 0];
                VALUES = new CharacteristicKind[max >= 0 ? 1 + max : 0];
                for (CharacteristicKind kind : CharacteristicKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((CharacteristicKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((CharacteristicKind)kind).value] = kind;
                }
            }
        }
    }
}

