/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import java.util.Objects;
import org.clang.basic.BasicClangGlobals;
import org.clang.basic.CharSourceRange;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.format.FormatStyle;
import org.clang.format.impl.FormatDecision;
import org.clang.format.impl.FormatStatics;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.TokenType;
import org.clang.tooling.core.Replacement;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.support.llvm;

public class WhitespaceManager
implements Destructors.ClassWithDestructor {
    private SmallVector<Change> Changes = new SmallVector(16, (Object)new Change());
    private final SourceManager SourceMgr;
    private std.setType<Replacement> Replaces;
    private final FormatStyle Style;
    private boolean UseCRLF;

    public WhitespaceManager(SourceManager SourceMgr, FormatStyle Style, boolean UseCRLF) {
        this.SourceMgr = SourceMgr;
        this.Replaces = new std.setType();
        this.Style = Style;
        this.UseCRLF = UseCRLF;
    }

    public void reset() {
        this.Changes.clear();
        this.Replaces.clear();
    }

    public void replaceWhitespace(FormatToken Tok, int Newlines, int IndentLevel, int Spaces, int StartOfTokenColumn) {
        this.replaceWhitespace(Tok, Newlines, IndentLevel, Spaces, StartOfTokenColumn, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceWhitespace(FormatToken Tok, int Newlines, int IndentLevel, int Spaces, int StartOfTokenColumn, boolean InPPDirective) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if (Tok.Finalized) {
                return;
            }
            Tok.Decision = Unsigned.$greater_uint((int)Newlines, (int)0) ? FormatDecision.FD_Break : FormatDecision.FD_Continue;
            this.Changes.push_back_T$RR($c$.track((Object)new Change(true, new SourceRange(Tok.WhitespaceRange), IndentLevel, Spaces, StartOfTokenColumn, Newlines, new StringRef(NativePointer.$EMPTY), new StringRef(NativePointer.$EMPTY), Tok.Tok.getKind(), InPPDirective && !Tok.IsFirst, Tok.is_TokenType(TokenType.TT_StartOfName) || Tok.is_TokenType(TokenType.TT_FunctionDeclarationName), false)));
            $c$.clean();
        }
        finally {
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUntouchableToken(FormatToken Tok, boolean InPPDirective) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if (Tok.Finalized) {
                return;
            }
            this.Changes.push_back_T$RR($c$.track((Object)new Change(false, new SourceRange(Tok.WhitespaceRange), 0, 0, Tok.OriginalColumn, Tok.NewlinesBefore, new StringRef(NativePointer.$EMPTY), new StringRef(NativePointer.$EMPTY), Tok.Tok.getKind(), InPPDirective && !Tok.IsFirst, Tok.is_TokenType(TokenType.TT_StartOfName) || Tok.is_TokenType(TokenType.TT_FunctionDeclarationName), false)));
            $c$.clean();
        }
        finally {
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceWhitespaceInToken(FormatToken Tok, int Offset, int ReplaceChars, StringRef PreviousPostfix, StringRef CurrentPrefix, boolean InPPDirective, int Newlines, int IndentLevel, int Spaces) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if (Tok.Finalized) {
                return;
            }
            SourceLocation Start = Tok.getStartOfNonWhitespace().getLocWithOffset(Offset);
            this.Changes.push_back_T$RR($c$.track((Object)new Change(true, new SourceRange(Start, Start.getLocWithOffset(ReplaceChars)), IndentLevel, Spaces, std.max((int)0, (int)Spaces), Newlines, new StringRef(PreviousPostfix), new StringRef(CurrentPrefix), Tok.is_TokenType(TokenType.TT_LineComment) ? (char)'\u0004' : '\u0000', InPPDirective && !Tok.IsFirst, Tok.is_TokenType(TokenType.TT_StartOfName) || Tok.is_TokenType(TokenType.TT_FunctionDeclarationName), Newlines == 0)));
            $c$.clean();
        }
        finally {
            $c$.$destroy();
        }
    }

    public std.setType<Replacement> generateReplacements() {
        if (this.Changes.empty()) {
            return this.Replaces;
        }
        std.sort((type.iterator)this.Changes.begin(), (type.iterator)this.Changes.end(), (std.Compare)new Change.IsBeforeInFile(this.SourceMgr));
        this.calculateLineBreakInformation();
        this.alignConsecutiveDeclarations();
        this.alignConsecutiveAssignments();
        this.alignTrailingComments();
        this.alignEscapedNewlines();
        this.generateChanges();
        return this.Replaces;
    }

    private void calculateLineBreakInformation() {
        ((Change)this.Changes.$at((int)0)).PreviousEndOfTokenColumn = 0;
        Change LastOutsideTokenChange = (Change)this.Changes.$at(0);
        int e = this.Changes.size();
        for (int i = 1; i != e; ++i) {
            int OriginalWhitespaceStart = this.SourceMgr.getFileOffset(((Change)this.Changes.$at((int)i)).OriginalWhitespaceRange.getBegin());
            int PreviousOriginalWhitespaceEnd = this.SourceMgr.getFileOffset(((Change)this.Changes.$at((int)(i - 1))).OriginalWhitespaceRange.getEnd());
            ((Change)this.Changes.$at((int)(i - 1))).TokenLength = OriginalWhitespaceStart - PreviousOriginalWhitespaceEnd + ((Change)this.Changes.$at((int)i)).PreviousLinePostfix.size() + ((Change)this.Changes.$at((int)(i - 1))).CurrentLinePrefix.size();
            if (((Change)this.Changes.$at((int)(i - 1))).IsInsideToken) {
                LastOutsideTokenChange.TokenLength += ((Change)this.Changes.$at((int)(i - 1))).TokenLength + ((Change)this.Changes.$at((int)(i - 1))).Spaces;
            } else {
                LastOutsideTokenChange = (Change)this.Changes.$at(i - 1);
            }
            ((Change)this.Changes.$at((int)i)).PreviousEndOfTokenColumn = ((Change)this.Changes.$at((int)(i - 1))).StartOfTokenColumn + ((Change)this.Changes.$at((int)(i - 1))).TokenLength;
            ((Change)this.Changes.$at((int)(i - 1))).IsTrailingComment = (Unsigned.$greater_uint((int)((Change)this.Changes.$at((int)i)).NewlinesBefore, (int)0) || ((Change)this.Changes.$at((int)i)).Kind == '\u0001' || ((Change)this.Changes.$at((int)i)).IsInsideToken && ((Change)this.Changes.$at((int)i)).Kind == '\u0004') && ((Change)this.Changes.$at((int)(i - 1))).Kind == '\u0004';
        }
        ((Change)this.Changes.back()).TokenLength = 0;
        ((Change)this.Changes.back()).IsTrailingComment = ((Change)this.Changes.back()).Kind == '\u0004';
        Change LastBlockComment = null;
        for (Change $Change : this.Changes) {
            if ($Change.IsInsideToken) {
                $Change.IsTrailingComment = false;
            }
            $Change.StartOfBlockComment = null;
            $Change.IndentationOffset = 0;
            if ($Change.Kind == '\u0004') {
                LastBlockComment = $Change;
                continue;
            }
            if ($Change.Kind == '\u0000') {
                $Change.StartOfBlockComment = LastBlockComment;
                if ($Change.StartOfBlockComment == null) continue;
                $Change.IndentationOffset = $Change.StartOfTokenColumn - $Change.StartOfBlockComment.StartOfTokenColumn;
                continue;
            }
            LastBlockComment = null;
        }
    }

    private void alignConsecutiveAssignments() {
        if (!this.Style.AlignConsecutiveAssignments) {
            return;
        }
        FormatStatics.AlignTokens(this.Style, C -> {
            if (Unsigned.$greater_uint((int)C.NewlinesBefore, (int)0)) {
                return false;
            }
            if (C != this.Changes.back() && Unsigned.$greater_uint((int)((Change)this.Changes.$at((int)(this.Changes.find((Object)C) + 1))).NewlinesBefore, (int)0)) {
                return false;
            }
            return C.Kind == '>';
        }, this.Changes);
    }

    private void alignConsecutiveDeclarations() {
        if (!this.Style.AlignConsecutiveDeclarations) {
            return;
        }
        FormatStatics.AlignTokens(this.Style, C -> C.IsStartOfDeclName, this.Changes);
    }

    private void alignTrailingComments() {
        int MinColumn = 0;
        int MaxColumn = -1;
        int StartOfSequence = 0;
        boolean BreakBeforeNext = false;
        int Newlines = 0;
        int e = this.Changes.size();
        for (int i = 0; i != e; ++i) {
            if (((Change)this.Changes.$at((int)i)).StartOfBlockComment != null) continue;
            Newlines += ((Change)this.Changes.$at((int)i)).NewlinesBefore;
            if (!((Change)this.Changes.$at((int)i)).IsTrailingComment) continue;
            int ChangeMinColumn = ((Change)this.Changes.$at((int)i)).StartOfTokenColumn;
            int ChangeMaxColumn = this.Style.ColumnLimit - ((Change)this.Changes.$at((int)i)).TokenLength;
            if (!((Change)this.Changes.$at((int)i)).CreateReplacement) {
                ChangeMaxColumn = ChangeMinColumn;
            }
            if (i + 1 != e && ((Change)this.Changes.$at((int)(i + 1))).ContinuesPPDirective) {
                ChangeMaxColumn -= 2;
            }
            boolean FollowsRBraceInColumn0 = Unsigned.$greater_uint((int)i, (int)0) && ((Change)this.Changes.$at((int)i)).NewlinesBefore == 0 && ((Change)this.Changes.$at((int)(i - 1))).Kind == '\u0018' && ((Change)this.Changes.$at((int)(i - 1))).StartOfTokenColumn == 0;
            boolean WasAlignedWithStartOfNextLine = false;
            if (((Change)this.Changes.$at((int)i)).NewlinesBefore == 1) {
                int CommentColumn = this.SourceMgr.getSpellingColumnNumber(((Change)this.Changes.$at((int)i)).OriginalWhitespaceRange.getEnd());
                for (int j = i + 1; j != e; ++j) {
                    if (((Change)this.Changes.$at((int)j)).Kind == '\u0004' || ((Change)this.Changes.$at((int)j)).Kind == '\u0000') continue;
                    int NextColumn = this.SourceMgr.getSpellingColumnNumber(((Change)this.Changes.$at((int)j)).OriginalWhitespaceRange.getEnd());
                    WasAlignedWithStartOfNextLine = CommentColumn == NextColumn || CommentColumn == NextColumn + this.Style.IndentWidth;
                    break;
                }
            }
            if (!this.Style.AlignTrailingComments || FollowsRBraceInColumn0) {
                this.alignTrailingComments(StartOfSequence, i, MinColumn);
                MinColumn = ChangeMinColumn;
                MaxColumn = ChangeMinColumn;
                StartOfSequence = i;
            } else if (BreakBeforeNext || Unsigned.$greater_uint((int)Newlines, (int)1) || Unsigned.$greater_uint((int)ChangeMinColumn, (int)MaxColumn) || Unsigned.$less_uint((int)ChangeMaxColumn, (int)MinColumn) || ((Change)this.Changes.$at((int)i)).NewlinesBefore == 1 && Unsigned.$greater_uint((int)i, (int)0) && !((Change)this.Changes.$at((int)(i - 1))).IsTrailingComment || WasAlignedWithStartOfNextLine) {
                this.alignTrailingComments(StartOfSequence, i, MinColumn);
                MinColumn = ChangeMinColumn;
                MaxColumn = ChangeMaxColumn;
                StartOfSequence = i;
            } else {
                MinColumn = std.max((int)MinColumn, (int)ChangeMinColumn);
                MaxColumn = std.min_uint((int)MaxColumn, (int)ChangeMaxColumn);
            }
            BreakBeforeNext = i == 0 || Unsigned.$greater_uint((int)((Change)this.Changes.$at((int)i)).NewlinesBefore, (int)1) || ((Change)this.Changes.$at((int)i)).NewlinesBefore == 1 && StartOfSequence == i;
            Newlines = 0;
        }
        this.alignTrailingComments(StartOfSequence, this.Changes.size(), MinColumn);
    }

    private void alignTrailingComments(int Start, int End, int Column) {
        for (int i = Start; i != End; ++i) {
            int Shift = 0;
            if (((Change)this.Changes.$at((int)i)).IsTrailingComment) {
                Shift = Column - ((Change)this.Changes.$at((int)i)).StartOfTokenColumn;
            }
            if (((Change)this.Changes.$at((int)i)).StartOfBlockComment != null) {
                Shift = ((Change)this.Changes.$at((int)i)).IndentationOffset + ((Change)this.Changes.$at((int)i)).StartOfBlockComment.StartOfTokenColumn - ((Change)this.Changes.$at((int)i)).StartOfTokenColumn;
            }
            assert (Shift >= 0);
            ((Change)this.Changes.$at((int)i)).Spaces += Shift;
            if (i + 1 != End) {
                ((Change)this.Changes.$at((int)(i + 1))).PreviousEndOfTokenColumn += Shift;
            }
            ((Change)this.Changes.$at((int)i)).StartOfTokenColumn += Shift;
        }
    }

    private void alignEscapedNewlines() {
        int MaxEndOfLine = this.Style.AlignEscapedNewlinesLeft ? 0 : this.Style.ColumnLimit;
        int StartOfMacro = 0;
        int i = 1;
        int e = this.Changes.size();
        while (Unsigned.$less_uint((int)i, (int)e)) {
            Change C = (Change)this.Changes.$at(i);
            if (Unsigned.$greater_uint((int)C.NewlinesBefore, (int)0)) {
                if (C.ContinuesPPDirective) {
                    MaxEndOfLine = std.max((int)(C.PreviousEndOfTokenColumn + 2), (int)MaxEndOfLine);
                } else {
                    this.alignEscapedNewlines(StartOfMacro + 1, i, MaxEndOfLine);
                    MaxEndOfLine = this.Style.AlignEscapedNewlinesLeft ? 0 : this.Style.ColumnLimit;
                    StartOfMacro = i;
                }
            }
            ++i;
        }
        this.alignEscapedNewlines(StartOfMacro + 1, this.Changes.size(), MaxEndOfLine);
    }

    private void alignEscapedNewlines(int Start, int End, int Column) {
        int i = Start;
        while (Unsigned.$less_uint((int)i, (int)End)) {
            Change C = (Change)this.Changes.$at(i);
            if (Unsigned.$greater_uint((int)C.NewlinesBefore, (int)0)) {
                assert (C.ContinuesPPDirective);
                C.EscapedNewlineColumn = Unsigned.$greater_uint((int)(C.PreviousEndOfTokenColumn + 1), (int)Column) ? 0 : Column;
            }
            ++i;
        }
    }

    private void generateChanges() {
        int e = this.Changes.size();
        for (int i = 0; i != e; ++i) {
            Change C = (Change)this.Changes.$at(i);
            if (Unsigned.$greater_uint((int)i, (int)0)) assert (BasicClangGlobals.$noteq_SourceLocation$C((SourceLocation)((Change)this.Changes.$at((int)(i - 1))).OriginalWhitespaceRange.getBegin(), (SourceLocation)C.OriginalWhitespaceRange.getBegin())) : "Generating two replacements for the same location";
            if (!C.CreateReplacement) continue;
            std.string ReplacementText = new std.string(C.PreviousLinePostfix);
            if (C.ContinuesPPDirective) {
                this.appendNewlineText(ReplacementText, C.NewlinesBefore, C.PreviousEndOfTokenColumn, C.EscapedNewlineColumn);
            } else {
                this.appendNewlineText(ReplacementText, C.NewlinesBefore);
            }
            this.appendIndentText(ReplacementText, C.IndentLevel, std.max((int)0, (int)C.Spaces), C.StartOfTokenColumn - std.max((int)0, (int)C.Spaces));
            ReplacementText.append(C.CurrentLinePrefix);
            this.storeReplacement(new SourceRange(C.OriginalWhitespaceRange), new StringRef(ReplacementText));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeReplacement(SourceRange Range2, StringRef Text) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if (llvm.$eq_StringRef((StringRef)this.SourceMgr.getCharacterDataStringRef_ValidOnly(Range2.getBegin().getRawEncoding(), Range2.getEnd().getRawEncoding()), (StringRef)Text)) {
                return;
            }
            $c$.clean((Object)this.Replaces.insert_T$RR($c$.track((Object)new Replacement(this.SourceMgr, CharSourceRange.getCharRange((SourceRange)Range2), new StringRef(Text)))));
        }
        finally {
            $c$.$destroy();
        }
    }

    private void appendNewlineText(std.string Text, int Newlines) {
        int i = 0;
        while (Unsigned.$less_uint((int)i, (int)Newlines)) {
            Text.append(this.UseCRLF ? NativePointer.$((String)"\r\n") : NativePointer.$LF);
            ++i;
        }
    }

    private void appendNewlineText(std.string Text, int Newlines, int PreviousEndOfTokenColumn, int EscapedNewlineColumn) {
        if (Unsigned.$greater_uint((int)Newlines, (int)0)) {
            int Offset = std.min((int)(EscapedNewlineColumn - 1), (int)PreviousEndOfTokenColumn);
            int i = 0;
            while (Unsigned.$less_uint((int)i, (int)Newlines)) {
                Text.append(EscapedNewlineColumn - Offset - 1, (byte)32);
                Text.append(this.UseCRLF ? NativePointer.$((String)"\\\r\n") : NativePointer.$((String)"\\\n"));
                Offset = 0;
                ++i;
            }
        }
    }

    private void appendIndentText(std.string Text, int IndentLevel, int Spaces, int WhitespaceStartColumn) {
        switch (this.Style.UseTab) {
            case UT_Never: {
                Text.append(Spaces, (byte)32);
                break;
            }
            case UT_Always: {
                int FirstTabWidth = this.Style.TabWidth - Unsigned.$rem_uint((int)WhitespaceStartColumn, (int)this.Style.TabWidth);
                if (Unsigned.$lesseq_uint((int)(FirstTabWidth + this.Style.TabWidth), (int)Spaces)) {
                    Spaces -= FirstTabWidth;
                    Text.append(NativePointer.$TAB);
                }
                Text.append(Unsigned.$div_uint((int)Spaces, (int)this.Style.TabWidth), (byte)9);
                Text.append(Unsigned.$rem_uint((int)Spaces, (int)this.Style.TabWidth), (byte)32);
                break;
            }
            case UT_ForIndentation: {
                if (WhitespaceStartColumn == 0) {
                    int Indentation = IndentLevel * this.Style.IndentWidth;
                    if (Unsigned.$greater_uint((int)Indentation, (int)Spaces)) {
                        Indentation = Spaces;
                    }
                    int Tabs = Unsigned.$div_uint((int)Indentation, (int)this.Style.TabWidth);
                    Text.append(Tabs, (byte)9);
                    Spaces -= Tabs * this.Style.TabWidth;
                }
                Text.append(Spaces, (byte)32);
                break;
            }
            case UT_ForContinuationAndIndentation: {
                if (WhitespaceStartColumn == 0) {
                    int Tabs = Unsigned.$div_uint((int)Spaces, (int)this.Style.TabWidth);
                    Text.append(Tabs, (byte)9);
                    Spaces -= Tabs * this.Style.TabWidth;
                }
                Text.append(Spaces, (byte)32);
            }
        }
    }

    public void $destroy() {
        this.Replaces.$destroy();
        this.Changes.$destroy();
    }

    public String toString() {
        return "Changes=" + this.Changes + ", SourceMgr=[SourceManager], Replaces=" + this.Replaces + ", Style=" + this.Style + ", UseCRLF=" + this.UseCRLF;
    }

    public static class Change
    implements Destructors.ClassWithDestructor,
    Native.NativePOD<Change>,
    Native.NativeComparable<Change> {
        public boolean CreateReplacement;
        public SourceRange OriginalWhitespaceRange;
        public int StartOfTokenColumn;
        public int NewlinesBefore;
        public std.string PreviousLinePostfix;
        public std.string CurrentLinePrefix;
        public char Kind;
        public boolean ContinuesPPDirective;
        public boolean IsStartOfDeclName;
        public int IndentLevel;
        public int Spaces;
        public boolean IsInsideToken;
        public boolean IsTrailingComment;
        public int TokenLength;
        public int PreviousEndOfTokenColumn;
        public int EscapedNewlineColumn;
        public Change StartOfBlockComment;
        public int IndentationOffset;

        public Change() {
            this.OriginalWhitespaceRange = new SourceRange();
            this.PreviousLinePostfix = new std.string();
            this.CurrentLinePrefix = new std.string();
        }

        public Change(boolean CreateReplacement, SourceRange OriginalWhitespaceRange, int IndentLevel, int Spaces, int StartOfTokenColumn, int NewlinesBefore, StringRef PreviousLinePostfix, StringRef CurrentLinePrefix, char Kind, boolean ContinuesPPDirective, boolean IsStartOfDeclName, boolean IsInsideToken) {
            this.CreateReplacement = CreateReplacement;
            this.OriginalWhitespaceRange = new SourceRange(OriginalWhitespaceRange);
            this.StartOfTokenColumn = StartOfTokenColumn;
            this.NewlinesBefore = NewlinesBefore;
            this.PreviousLinePostfix = PreviousLinePostfix.$string();
            this.CurrentLinePrefix = CurrentLinePrefix.$string();
            this.Kind = Kind;
            this.ContinuesPPDirective = ContinuesPPDirective;
            this.IsStartOfDeclName = IsStartOfDeclName;
            this.IndentLevel = IndentLevel;
            this.Spaces = Spaces;
            this.IsInsideToken = IsInsideToken;
            this.IsTrailingComment = false;
            this.TokenLength = 0;
            this.PreviousEndOfTokenColumn = 0;
            this.EscapedNewlineColumn = 0;
            this.StartOfBlockComment = null;
            this.IndentationOffset = 0;
        }

        public void $destroy() {
            this.CurrentLinePrefix.$destroy();
            this.PreviousLinePostfix.$destroy();
        }

        public Change(JavaDifferentiators.JD$Move _dparam, Change $Prm0) {
            this.CreateReplacement = $Prm0.CreateReplacement;
            this.OriginalWhitespaceRange = new SourceRange(JavaDifferentiators.JD$Move.INSTANCE, $Prm0.OriginalWhitespaceRange);
            this.StartOfTokenColumn = $Prm0.StartOfTokenColumn;
            this.NewlinesBefore = $Prm0.NewlinesBefore;
            this.PreviousLinePostfix = new std.string(JavaDifferentiators.JD$Move.INSTANCE, $Prm0.PreviousLinePostfix);
            this.CurrentLinePrefix = new std.string(JavaDifferentiators.JD$Move.INSTANCE, $Prm0.CurrentLinePrefix);
            this.Kind = $Prm0.Kind;
            this.ContinuesPPDirective = $Prm0.ContinuesPPDirective;
            this.IsStartOfDeclName = $Prm0.IsStartOfDeclName;
            this.IndentLevel = $Prm0.IndentLevel;
            this.Spaces = $Prm0.Spaces;
            this.IsInsideToken = $Prm0.IsInsideToken;
            this.IsTrailingComment = $Prm0.IsTrailingComment;
            this.TokenLength = $Prm0.TokenLength;
            this.PreviousEndOfTokenColumn = $Prm0.PreviousEndOfTokenColumn;
            this.EscapedNewlineColumn = $Prm0.EscapedNewlineColumn;
            this.StartOfBlockComment = $Prm0.StartOfBlockComment;
            this.IndentationOffset = $Prm0.IndentationOffset;
        }

        public Change $assignMove(Change $Prm0) {
            this.CreateReplacement = $Prm0.CreateReplacement;
            this.OriginalWhitespaceRange.$assignMove($Prm0.OriginalWhitespaceRange);
            this.StartOfTokenColumn = $Prm0.StartOfTokenColumn;
            this.NewlinesBefore = $Prm0.NewlinesBefore;
            this.PreviousLinePostfix.$assignMove($Prm0.PreviousLinePostfix);
            this.CurrentLinePrefix.$assignMove($Prm0.CurrentLinePrefix);
            this.Kind = $Prm0.Kind;
            this.ContinuesPPDirective = $Prm0.ContinuesPPDirective;
            this.IsStartOfDeclName = $Prm0.IsStartOfDeclName;
            this.IndentLevel = $Prm0.IndentLevel;
            this.Spaces = $Prm0.Spaces;
            this.IsInsideToken = $Prm0.IsInsideToken;
            this.IsTrailingComment = $Prm0.IsTrailingComment;
            this.TokenLength = $Prm0.TokenLength;
            this.PreviousEndOfTokenColumn = $Prm0.PreviousEndOfTokenColumn;
            this.EscapedNewlineColumn = $Prm0.EscapedNewlineColumn;
            this.StartOfBlockComment = $Prm0.StartOfBlockComment;
            this.IndentationOffset = $Prm0.IndentationOffset;
            return this;
        }

        public Change $assign(Change $Prm0) {
            this.CreateReplacement = $Prm0.CreateReplacement;
            this.OriginalWhitespaceRange.$assign($Prm0.OriginalWhitespaceRange);
            this.StartOfTokenColumn = $Prm0.StartOfTokenColumn;
            this.NewlinesBefore = $Prm0.NewlinesBefore;
            this.PreviousLinePostfix.$assign($Prm0.PreviousLinePostfix);
            this.CurrentLinePrefix.$assign($Prm0.CurrentLinePrefix);
            this.Kind = $Prm0.Kind;
            this.ContinuesPPDirective = $Prm0.ContinuesPPDirective;
            this.IsStartOfDeclName = $Prm0.IsStartOfDeclName;
            this.IndentLevel = $Prm0.IndentLevel;
            this.Spaces = $Prm0.Spaces;
            this.IsInsideToken = $Prm0.IsInsideToken;
            this.IsTrailingComment = $Prm0.IsTrailingComment;
            this.TokenLength = $Prm0.TokenLength;
            this.PreviousEndOfTokenColumn = $Prm0.PreviousEndOfTokenColumn;
            this.EscapedNewlineColumn = $Prm0.EscapedNewlineColumn;
            this.StartOfBlockComment = $Prm0.StartOfBlockComment;
            this.IndentationOffset = $Prm0.IndentationOffset;
            return this;
        }

        public Change clone() {
            Change res = new Change();
            res.$assign(this);
            return res;
        }

        public boolean $eq(Change other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            if (this.CreateReplacement != other.CreateReplacement) {
                return false;
            }
            if (this.StartOfTokenColumn != other.StartOfTokenColumn) {
                return false;
            }
            if (this.NewlinesBefore != other.NewlinesBefore) {
                return false;
            }
            if (this.Kind != other.Kind) {
                return false;
            }
            if (this.ContinuesPPDirective != other.ContinuesPPDirective) {
                return false;
            }
            if (this.IsStartOfDeclName != other.IsStartOfDeclName) {
                return false;
            }
            if (this.IndentLevel != other.IndentLevel) {
                return false;
            }
            if (this.Spaces != other.Spaces) {
                return false;
            }
            if (this.IsInsideToken != other.IsInsideToken) {
                return false;
            }
            if (this.IsTrailingComment != other.IsTrailingComment) {
                return false;
            }
            if (this.TokenLength != other.TokenLength) {
                return false;
            }
            if (this.PreviousEndOfTokenColumn != other.PreviousEndOfTokenColumn) {
                return false;
            }
            if (this.EscapedNewlineColumn != other.EscapedNewlineColumn) {
                return false;
            }
            if (this.IndentationOffset != other.IndentationOffset) {
                return false;
            }
            if (!Objects.equals(this.OriginalWhitespaceRange, other.OriginalWhitespaceRange)) {
                return false;
            }
            if (!Objects.equals(this.PreviousLinePostfix, other.PreviousLinePostfix)) {
                return false;
            }
            if (!Objects.equals(this.CurrentLinePrefix, other.CurrentLinePrefix)) {
                return false;
            }
            return Objects.equals(this.StartOfBlockComment, other.StartOfBlockComment);
        }

        public String toString() {
            return "CreateReplacement=" + this.CreateReplacement + ", OriginalWhitespaceRange=" + this.OriginalWhitespaceRange + ", StartOfTokenColumn=" + this.StartOfTokenColumn + ", NewlinesBefore=" + this.NewlinesBefore + ", PreviousLinePostfix=" + this.PreviousLinePostfix + ", CurrentLinePrefix=" + this.CurrentLinePrefix + ", Kind=" + Unsigned.$ushort2uint((char)this.Kind) + ", ContinuesPPDirective=" + this.ContinuesPPDirective + ", IsStartOfDeclName=" + this.IsStartOfDeclName + ", IndentLevel=" + this.IndentLevel + ", Spaces=" + this.Spaces + ", IsInsideToken=" + this.IsInsideToken + ", IsTrailingComment=" + this.IsTrailingComment + ", TokenLength=" + this.TokenLength + ", PreviousEndOfTokenColumn=" + this.PreviousEndOfTokenColumn + ", EscapedNewlineColumn=" + this.EscapedNewlineColumn + ", StartOfBlockComment=" + this.StartOfBlockComment + ", IndentationOffset=" + this.IndentationOffset;
        }

        public static class IsBeforeInFile
        implements std.Compare<Change> {
            private final SourceManager SourceMgr;

            public IsBeforeInFile(SourceManager SourceMgr) {
                this.SourceMgr = SourceMgr;
            }

            public boolean $call(Change C1, Change C2) {
                return this.SourceMgr.isBeforeInTranslationUnit(C1.OriginalWhitespaceRange.getBegin(), C2.OriginalWhitespaceRange.getBegin());
            }

            public IsBeforeInFile(IsBeforeInFile $Prm0) {
                this.SourceMgr = $Prm0.SourceMgr;
            }

            public IsBeforeInFile(JavaDifferentiators.JD$Move _dparam, IsBeforeInFile $Prm0) {
                this.SourceMgr = $Prm0.SourceMgr;
            }

            public boolean compare(Change a, Change b) {
                return this.$call(a, b);
            }

            public String toString() {
                return "SourceMgr=[SourceManager]";
            }
        }
    }
}

