/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clang.format.FormatStyle;
import org.clang.format.impl.AdditionalKeywords;
import org.clang.format.impl.AnnotatedLine;
import org.clang.format.impl.FormatToken;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Unsigned;
import org.llvm.adt.aliases.ArrayRefInt;

public class LevelIndentTracker
implements Destructors.ClassWithDestructor {
    private final FormatStyle Style;
    private final AdditionalKeywords Keywords;
    private int AdditionalIndent;
    private std.vectorInt IndentForLevel;
    private int Offset;
    private int Indent;

    public LevelIndentTracker(FormatStyle Style, AdditionalKeywords Keywords, int StartLevel, int AdditionalIndent) {
        this.Style = Style;
        this.Keywords = Keywords;
        this.AdditionalIndent = AdditionalIndent;
        this.IndentForLevel = new std.vectorInt();
        this.Offset = 0;
        this.Indent = 0;
        for (int i = 0; i != StartLevel; ++i) {
            this.IndentForLevel.push_back_T$RR(Style.IndentWidth * i + AdditionalIndent);
        }
    }

    public int getIndent() {
        return this.Indent;
    }

    public void nextLine(AnnotatedLine Line) {
        this.Offset = this.getIndentOffset(Line.First);
        while (Unsigned.$lesseq_uint((int)this.IndentForLevel.size(), (int)Line.Level)) {
            this.IndentForLevel.push_back_T$RR(-1);
        }
        if (Line.InPPDirective) {
            this.Indent = Line.Level * this.Style.IndentWidth + this.AdditionalIndent;
        } else {
            this.IndentForLevel.resize(Line.Level + 1);
            this.Indent = this.getIndent(new ArrayRefInt(this.IndentForLevel), Line.Level);
        }
        if (this.Indent + this.Offset >= 0) {
            this.Indent += this.Offset;
        }
    }

    public void adjustToUnmodifiedLine(AnnotatedLine Line) {
        int LevelIndent = Line.First.OriginalColumn;
        if (LevelIndent - this.Offset >= 0) {
            LevelIndent -= this.Offset;
        }
        if (!(Line.First.is_TokenKind('\u0004') && this.IndentForLevel.$at(Line.Level) != -1 || Line.InPPDirective)) {
            this.IndentForLevel.$set(Line.Level, LevelIndent);
        }
    }

    private int getIndentOffset(FormatToken RootToken) {
        if (this.Style.Language == FormatStyle.LanguageKind.LK_Java || this.Style.Language == FormatStyle.LanguageKind.LK_JavaScript) {
            return 0;
        }
        if (RootToken.isAccessSpecifier(false) || RootToken.isObjCAccessSpecifier() || RootToken.isOneOf(this.Keywords.kw_signals, this.Keywords.kw_qsignals) && RootToken.Next != null && RootToken.Next.is_TokenKind('<')) {
            return this.Style.AccessModifierOffset;
        }
        return 0;
    }

    private int getIndent(ArrayRefInt IndentForLevel, int Level2) {
        if (IndentForLevel.$at(Level2) != -1) {
            return IndentForLevel.$at(Level2);
        }
        if (Level2 == 0) {
            return 0;
        }
        return this.getIndent(new ArrayRefInt(IndentForLevel), Level2 - 1) + this.Style.IndentWidth;
    }

    public void $destroy() {
        this.IndentForLevel.$destroy();
    }

    public String toString() {
        return "Style=" + this.Style + ", Keywords=" + this.Keywords + ", AdditionalIndent=" + this.AdditionalIndent + ", IndentForLevel=" + this.IndentForLevel + ", Offset=" + this.Offset + ", Indent=" + this.Indent;
    }
}

