/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import java.util.Iterator;
import org.clang.basic.CharSourceRange;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.format.FormatStyle;
import org.clang.format.impl.AdditionalKeywords;
import org.clang.format.impl.AnnotatedLine;
import org.clang.format.impl.Environment;
import org.clang.format.impl.FormatStatics;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.FormatTokenLexer;
import org.clang.format.impl.JsImportedSymbol;
import org.clang.format.impl.JsModuleReference;
import org.clang.format.impl.TokenAnalyzer;
import org.clang.format.impl.TokenAnnotator;
import org.clang.tooling.core.Replacement;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.void;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorUInt;
import org.llvm.support.llvm;

public class JavaScriptImportSorter
extends TokenAnalyzer
implements Destructors.ClassWithDestructor {
    private FormatToken Current;
    private FormatToken LineEnd;
    private FormatToken invalidToken = new FormatToken();
    private StringRef FileContents;

    public JavaScriptImportSorter(Environment Env, FormatStyle Style) {
        super(Env, Style);
        this.FileContents = Env.getSourceManager().getBufferData(Env.getFileID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public std.setType<Replacement> analyze(TokenAnnotator Annotator, SmallVectorImpl<AnnotatedLine> AnnotatedLines, FormatTokenLexer Tokens, std.setType<Replacement> Result) {
        SmallVector References = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            this.AffectedRangeMgr.computeAffectedLines((type.ptr<AnnotatedLine>)AnnotatedLines.begin(), (type.ptr<AnnotatedLine>)AnnotatedLines.end());
            AdditionalKeywords Keywords = Tokens.getKeywords();
            std_pair.pair<SmallVector<JsModuleReference>, AnnotatedLine> tmp = this.parseModuleReferences(Keywords, AnnotatedLines);
            References = (SmallVector)tmp.first;
            AnnotatedLine FirstNonImportLine = (AnnotatedLine)tmp.second;
            if (References.empty()) {
                std.setType setType2 = new std.setType(Result);
                return setType2;
            }
            SmallVectorUInt Indices = new SmallVectorUInt(16, 0);
            int e = References.size();
            for (int i = 0; i != e; ++i) {
                Indices.push_back(i);
            }
            final SmallVector References_final = References;
            std.Compare<Integer> comparator = new std.Compare<Integer>(){

                public boolean compare(Integer LHSI, Integer RHSI) {
                    return FormatStatics.$less_JsModuleReference$C((JsModuleReference)References_final.$at(LHSI.intValue()), (JsModuleReference)References_final.$at(RHSI.intValue()));
                }
            };
            std.stable_sort((uint.ptr)Indices.begin(), (uint.ptr)Indices.end(), (std.Compare)comparator);
            boolean ReferencesInOrder = std.is_sorted((uint.ptr)Indices.begin(), (uint.ptr)Indices.end());
            std.string ReferencesText = new std.string();
            boolean SymbolsInOrder = true;
            int e2 = Indices.size();
            for (int i = 0; i != e2; ++i) {
                JsModuleReference Reference = new JsModuleReference((JsModuleReference)References.$at(Indices.$at(i)));
                if (this.appendReference(ReferencesText, Reference)) {
                    SymbolsInOrder = false;
                }
                if (!Unsigned.$less_uint((int)(i + 1), (int)e2)) continue;
                ReferencesText.$addassign_T$C$P((CharSequence)"\n");
                if (Reference.IsExport || Reference.IsExport == ((JsModuleReference)References.$at((int)Indices.$at((int)(i + 1)))).IsExport && Reference.Category == ((JsModuleReference)References.$at((int)Indices.$at((int)(i + 1)))).Category) continue;
                ReferencesText.$addassign_T$C$P((CharSequence)"\n");
            }
            if (ReferencesInOrder && SymbolsInOrder) {
                std.setType i = new std.setType(Result);
                return i;
            }
            SourceRange InsertionPoint = new SourceRange(((JsModuleReference)References.$at((int)0)).Range);
            InsertionPoint.setEnd(((JsModuleReference)References.$at((int)(References.size() - 1))).Range.getEnd());
            int PreviousSize = this.getSourceText(new SourceRange(InsertionPoint)).size();
            while (Unsigned.$less_uint((int)ReferencesText.size(), (int)PreviousSize)) {
                ReferencesText.$addassign_T$C$P((CharSequence)" ");
            }
            if (FirstNonImportLine != null && Unsigned.$less_uint((int)FirstNonImportLine.First.NewlinesBefore, (int)2)) {
                ReferencesText.$addassign_T$C$P((CharSequence)"\n");
            }
            $c$.clean((Object)Result.insert_T$RR($c$.track((Object)new Replacement(this.Env.getSourceManager(), CharSourceRange.getCharRange((SourceRange)InsertionPoint), new StringRef(ReferencesText)))));
            std.setType setType3 = new std.setType(Result);
            return setType3;
        }
        finally {
            if (References != null) {
                References.$destroy();
            }
            $c$.$destroy();
        }
    }

    private void skipComments() {
        this.Current = this.skipComments(this.Current);
    }

    private FormatToken skipComments(FormatToken Tok) {
        while (Tok != null && Tok.is_TokenKind('\u0004')) {
            Tok = Tok.Next;
        }
        return Tok;
    }

    private void nextToken() {
        this.Current = this.Current.Next;
        this.skipComments();
        if (this.Current == null || this.Current == this.LineEnd.Next) {
            this.invalidToken.Tok.setKind('\u0000');
            this.Current = this.invalidToken;
        }
    }

    private StringRef getSourceText(SourceRange Range2) {
        return this.getSourceText(Range2.getBegin(), Range2.getEnd());
    }

    private StringRef getSourceText(SourceLocation Begin, SourceLocation End) {
        SourceManager SM = this.Env.getSourceManager();
        return this.FileContents.substr(SM.getFileOffset(Begin), SM.getFileOffset(End) - SM.getFileOffset(Begin));
    }

    private boolean appendReference(std.string Buffer, JsModuleReference Reference) {
        SmallVector Symbols = new SmallVector(Reference.Symbols);
        std.stable_sort((type.ptr)Symbols.begin(), (type.ptr)Symbols.end(), (LHS, RHS) -> LHS.Symbol.compare_lower(RHS.Symbol) < 0);
        if (Symbols.$eq(Reference.Symbols)) {
            StringRef ReferenceStmt = this.getSourceText(new SourceRange(Reference.Range));
            llvm.$addassign_string_StringRef((std.string)Buffer, (StringRef)ReferenceStmt);
            return false;
        }
        SourceLocation SymbolsStart = ((JsImportedSymbol)Reference.Symbols.front()).Range.getBegin();
        SourceLocation SymbolsEnd = ((JsImportedSymbol)Reference.Symbols.back()).Range.getEnd();
        llvm.$addassign_string_StringRef((std.string)Buffer, (StringRef)this.getSourceText(Reference.Range.getBegin(), new SourceLocation(SymbolsStart)));
        type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)Symbols.begin());
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)Symbols.end());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            if (Native.$noteq_ptr((void.ptr)I, (void.ptr)Symbols.begin())) {
                Buffer.$addassign_T$C$P((CharSequence)",");
            }
            llvm.$addassign_string_StringRef((std.string)Buffer, (StringRef)this.getSourceText(new SourceRange(((JsImportedSymbol)I.$star()).Range)));
            I.$preInc();
        }
        llvm.$addassign_string_StringRef((std.string)Buffer, (StringRef)this.getSourceText(new SourceLocation(SymbolsEnd), Reference.Range.getEnd()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private std_pair.pair<SmallVector<JsModuleReference>, AnnotatedLine> parseModuleReferences(AdditionalKeywords Keywords, SmallVectorImpl<AnnotatedLine> AnnotatedLines) {
        SmallVector References = null;
        try {
            References = new SmallVector(16, (Object)new JsModuleReference());
            SourceLocation Start = new SourceLocation();
            boolean FoundLines = false;
            AnnotatedLine FirstNonImportLine = null;
            for (AnnotatedLine Line : AnnotatedLines) {
                JsModuleReference Reference = null;
                try {
                    if (!Line.Affected) {
                        if (!FoundLines) continue;
                        break;
                    }
                    this.Current = Line.First;
                    this.LineEnd = Line.Last;
                    this.skipComments();
                    if (Start.isInvalid() || References.empty()) {
                        Start.$assignMove(Line.First.Tok.getLocation());
                    }
                    if (this.Current == null) continue;
                    FoundLines = true;
                    Reference = new JsModuleReference();
                    Reference.Range.setBegin(Start);
                    if (!this.parseModuleReference(Keywords, Reference)) {
                        FirstNonImportLine = Line;
                        break;
                    }
                    Reference.Range.setEnd(this.LineEnd.Tok.getEndLoc());
                    References.push_back_T$C$R((Object)Reference);
                    Start.$assignMove(new SourceLocation());
                }
                finally {
                    if (Reference == null) continue;
                    Reference.$destroy();
                }
            }
            Iterator iterator2 = std.make_pair_T_Ptr((Object)new SmallVector(JavaDifferentiators.JD$Move.INSTANCE, References), FirstNonImportLine);
            return iterator2;
        }
        finally {
            if (References != null) {
                References.$destroy();
            }
        }
    }

    private boolean parseModuleReference(AdditionalKeywords Keywords, JsModuleReference Reference) {
        if (this.Current == null || !this.Current.isOneOf(Keywords.kw_import, '\u0082')) {
            return false;
        }
        Reference.IsExport = this.Current.is_TokenKind('\u0082');
        this.nextToken();
        if (this.Current.isStringLiteral() && !Reference.IsExport) {
            Reference.Category = JsModuleReference.ReferenceCategory.SIDE_EFFECT;
            Reference.URL.$assignMove(this.Current.TokenText.substr(1, this.Current.TokenText.size() - 2));
            return true;
        }
        if (!this.parseModuleBindings(Keywords, Reference)) {
            return false;
        }
        this.nextToken();
        if (this.Current.is(Keywords.kw_from)) {
            this.nextToken();
            if (!this.Current.isStringLiteral()) {
                return false;
            }
            Reference.URL.$assignMove(this.Current.TokenText.substr(1, this.Current.TokenText.size() - 2));
            Reference.Category = Reference.URL.startswith("..") ? JsModuleReference.ReferenceCategory.RELATIVE_PARENT : (Reference.URL.startswith(".") ? JsModuleReference.ReferenceCategory.RELATIVE : JsModuleReference.ReferenceCategory.ABSOLUTE);
        } else {
            Reference.Category = JsModuleReference.ReferenceCategory.RELATIVE;
        }
        return true;
    }

    private boolean parseModuleBindings(AdditionalKeywords Keywords, JsModuleReference Reference) {
        if (this.parseStarBinding(Keywords, Reference)) {
            return true;
        }
        return this.parseNamedBindings(Keywords, Reference);
    }

    private boolean parseStarBinding(AdditionalKeywords Keywords, JsModuleReference Reference) {
        if (this.Current.isNot('\u001e')) {
            return false;
        }
        this.nextToken();
        if (this.Current.isNot(Keywords.kw_as)) {
            return false;
        }
        this.nextToken();
        if (this.Current.isNot('\u0005')) {
            return false;
        }
        Reference.Prefix.$assign(this.Current.TokenText);
        return true;
    }

    private boolean parseNamedBindings(AdditionalKeywords Keywords, JsModuleReference Reference) {
        if (this.Current.isNot('\u0017')) {
            return false;
        }
        this.nextToken();
        while (!this.Current.is_TokenKind('\u0018')) {
            if (this.Current.isNot('\u0005')) {
                return false;
            }
            JsImportedSymbol Symbol = new JsImportedSymbol();
            Symbol.Symbol.$assign(this.Current.TokenText);
            Symbol.Range.setBegin(this.Current.getPreviousNonComment().Next.WhitespaceRange.getBegin());
            this.nextToken();
            if (this.Current.is(Keywords.kw_as)) {
                this.nextToken();
                if (this.Current.isNot('\u0005')) {
                    return false;
                }
                Symbol.Alias.$assign(this.Current.TokenText);
                this.nextToken();
            }
            Symbol.Range.setEnd(this.Current.Tok.getLocation());
            Reference.Symbols.push_back((Object)Symbol);
            if (this.Current.is_TokenKind('\u0018')) {
                return true;
            }
            if (this.Current.isNot('@')) {
                return false;
            }
            this.nextToken();
        }
        return true;
    }

    @Override
    public void $destroy() {
        this.invalidToken.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "Current=" + this.Current + ", LineEnd=" + this.LineEnd + ", invalidToken=" + this.invalidToken + ", FileContents=" + this.FileContents + super.toString();
    }
}

