/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import java.util.Iterator;
import org.clang.basic.BasicClangGlobals;
import org.clang.basic.SourceManager;
import org.clang.basic.prec;
import org.clang.format.FormatGlobals;
import org.clang.format.FormatStyle;
import org.clang.format.impl.AdditionalKeywords;
import org.clang.format.impl.AnnotatedLine;
import org.clang.format.impl.BraceBlockKind;
import org.clang.format.impl.EncodingStatics;
import org.clang.format.impl.Environment;
import org.clang.format.impl.FormatStatics$getLineCommentIndentPrefix$$;
import org.clang.format.impl.FormatStatics$getTokenTypeName$$;
import org.clang.format.impl.FormatToken;
import org.clang.format.impl.IncludeCategoryManager;
import org.clang.format.impl.IncludeDirective;
import org.clang.format.impl.JavaScriptImportSorter;
import org.clang.format.impl.JsModuleReference;
import org.clang.format.impl.LineState;
import org.clang.format.impl.ParenState;
import org.clang.format.impl.TokenType;
import org.clang.format.impl.UnwrappedLine;
import org.clang.format.impl.UnwrappedLineNode;
import org.clang.format.impl.WhitespaceManager;
import org.clang.format.java.FormatFunctionPointers;
import org.clang.lex.Lexer;
import org.clang.lex.Token;
import org.clang.tooling.ToolingGlobals;
import org.clang.tooling.core.Range;
import org.clang.tooling.core.Replacement;
import org.clank.java.std;
import org.clank.java.std_list;
import org.clank.java.std_map;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.StdSetInt;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.void;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorUInt;
import org.llvm.support.Error;
import org.llvm.support.Expected;
import org.llvm.support.Regex;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public final class FormatStatics {
    public static char.ptr Blanks = NativePointer.$((String)" \t\u000b\f\r");
    public static char.ptr IncludeRegexPattern = NativePointer.$((String)"^[\\t\\ ]*#[\\t\\ ]*(import|include)[^\"<]*([\"<][^\">]*[\">])");
    public static int PrecedenceUnaryOperator = prec.Level.PointerToMember.getValue() + 1;
    public static int PrecedenceArrowAndPeriod = prec.Level.PointerToMember.getValue() + 2;

    public static boolean IsBlank(byte C) {
        switch (C) {
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static std_pair.pairUIntUInt getCommentSplit(StringRef Text, int ContentStartColumn, int ColumnLimit, int TabWidth, EncodingStatics.Encoding $Encoding) {
        if (Unsigned.$lesseq_uint((int)ColumnLimit, (int)(ContentStartColumn + 1))) {
            return new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$C$R_T$RR.INSTANCE, StringRef.npos, 0);
        }
        int MaxSplit = ColumnLimit - ContentStartColumn + 1;
        int MaxSplitBytes = 0;
        int NumChars = 0;
        while (Unsigned.$less_uint((int)NumChars, (int)MaxSplit) && Unsigned.$less_uint((int)MaxSplitBytes, (int)Text.size())) {
            int BytesInChar = EncodingStatics.getCodePointNumBytes(Text.$at(MaxSplitBytes), $Encoding);
            NumChars += EncodingStatics.columnWidthWithTabs(Text.substr(MaxSplitBytes, BytesInChar), ContentStartColumn, TabWidth, $Encoding);
            MaxSplitBytes += BytesInChar;
        }
        int SpaceOffset = Text.find_last_of(Blanks, MaxSplitBytes);
        if (SpaceOffset == StringRef.npos || Text.find_last_not_of(Blanks, SpaceOffset) == StringRef.npos) {
            int FirstNonWhitespace = Text.find_first_not_of(Blanks);
            if (FirstNonWhitespace == StringRef.npos) {
                return new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$C$R_T$RR.INSTANCE, StringRef.npos, 0);
            }
            SpaceOffset = Text.find_first_of(Blanks, std.max((int)MaxSplitBytes, (int)FirstNonWhitespace));
        }
        if (SpaceOffset != StringRef.npos && SpaceOffset != 0) {
            StringRef BeforeCut = Text.substr(0, SpaceOffset).rtrim(Blanks);
            StringRef AfterCut = Text.substr(SpaceOffset).ltrim(Blanks);
            return new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, BeforeCut.size(), AfterCut.begin().$sub((abstract_iterator)BeforeCut.end()));
        }
        return new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$C$R_T$RR.INSTANCE, StringRef.npos, 0);
    }

    public static std_pair.pairUIntUInt getStringSplit(StringRef Text, int UsedColumns, int ColumnLimit, int TabWidth, EncodingStatics.Encoding $Encoding) {
        if (Text.empty()) {
            return new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$C$R_T$RR.INSTANCE, StringRef.npos, 0);
        }
        if (Unsigned.$lesseq_uint((int)ColumnLimit, (int)UsedColumns)) {
            return new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$C$R_T$RR.INSTANCE, StringRef.npos, 0);
        }
        int MaxSplit = ColumnLimit - UsedColumns;
        int SpaceOffset = 0;
        int SlashOffset = 0;
        int WordStartOffset = 0;
        int SplitPoint = 0;
        int Chars = 0;
        while (true) {
            int Advance;
            if (Text.$at(0) == 92) {
                Advance = EncodingStatics.getEscapeSequenceLength(new StringRef(Text));
                Chars += Advance;
            } else {
                Advance = EncodingStatics.getCodePointNumBytes(Text.$at(0), $Encoding);
                Chars += EncodingStatics.columnWidthWithTabs(Text.substr(0, Advance), UsedColumns + Chars, TabWidth, $Encoding);
            }
            if (Unsigned.$greater_uint((int)Chars, (int)MaxSplit) || Unsigned.$lesseq_uint((int)Text.size(), (int)Advance)) break;
            if (FormatStatics.IsBlank(Text.$at(0))) {
                SpaceOffset = SplitPoint;
            }
            if (Text.$at(0) == 47) {
                SlashOffset = SplitPoint;
            }
            if (Advance == 1 && !BasicClangGlobals.isAlphanumeric((byte)Text.$at(0))) {
                WordStartOffset = SplitPoint;
            }
            SplitPoint += Advance;
            Text.$assignMove(Text.substr(Advance));
        }
        if (SpaceOffset != 0) {
            return new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, SpaceOffset + 1, 0);
        }
        if (SlashOffset != 0) {
            return new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, SlashOffset + 1, 0);
        }
        if (WordStartOffset != 0) {
            return new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, WordStartOffset + 1, 0);
        }
        if (SplitPoint != 0) {
            return new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$RR_T1$RR.INSTANCE, SplitPoint, 0);
        }
        return new std_pair.pairUIntUInt(JavaDifferentiators.JD$T$C$R_T$RR.INSTANCE, StringRef.npos, 0);
    }

    public static StringRef getLineCommentIndentPrefix(StringRef Comment) {
        StringRef[] KnownPrefixes = FormatStatics$getLineCommentIndentPrefix$$.KnownPrefixes;
        StringRef LongestPrefix = new StringRef();
        for (StringRef KnownPrefix : KnownPrefixes) {
            if (!Comment.startswith(KnownPrefix)) continue;
            int PrefixLength = KnownPrefix.size();
            while (Unsigned.$less_uint((int)PrefixLength, (int)Comment.size()) && Comment.$at(PrefixLength) == 32) {
                ++PrefixLength;
            }
            if (!Unsigned.$greater_uint((int)PrefixLength, (int)LongestPrefix.size())) continue;
            LongestPrefix.$assignMove(Comment.substr(0, PrefixLength));
        }
        return LongestPrefix;
    }

    public static int getLengthToMatchingParen(FormatToken Tok) {
        if (Tok.MatchingParen == null) {
            return 0;
        }
        FormatToken End = Tok.MatchingParen;
        while (End.Next != null && !End.Next.CanBreakBefore) {
            End = End.Next;
        }
        return End.TotalLength - Tok.TotalLength + 1;
    }

    public static int getLengthToNextOperator(FormatToken Tok) {
        if (Tok.NextOperator == null) {
            return 0;
        }
        return Tok.NextOperator.TotalLength - Tok.TotalLength;
    }

    public static boolean startsSegmentOfBuilderTypeCall(FormatToken Tok) {
        return Tok.isMemberAccess() && Tok.Previous != null && Tok.Previous.closesScope();
    }

    public static boolean startsNextParameter(FormatToken Current, FormatStyle Style) {
        FormatToken Previous = Current.Previous;
        if (Current.is_TokenType(TokenType.TT_CtorInitializerComma) && Style.BreakConstructorInitializersBeforeComma) {
            return true;
        }
        return Previous.is_TokenKind('@') && !Current.isTrailingComment() && (Previous.isNot(TokenType.TT_CtorInitializerComma) || !Style.BreakConstructorInitializersBeforeComma);
    }

    public static FormatStyle expandPresets(FormatStyle Style) {
        if (Style.BreakBeforeBraces == FormatStyle.BraceBreakingStyle.BS_Custom) {
            return new FormatStyle(Style);
        }
        FormatStyle Expanded = new FormatStyle(Style);
        Expanded.BraceWrapping.$assignMove(new FormatStyle.BraceWrappingFlags(false, false, false, false, false, false, false, false, false, false, false));
        switch (Style.BreakBeforeBraces) {
            case BS_Linux: {
                Expanded.BraceWrapping.AfterClass = true;
                Expanded.BraceWrapping.AfterFunction = true;
                Expanded.BraceWrapping.AfterNamespace = true;
                break;
            }
            case BS_Mozilla: {
                Expanded.BraceWrapping.AfterClass = true;
                Expanded.BraceWrapping.AfterEnum = true;
                Expanded.BraceWrapping.AfterFunction = true;
                Expanded.BraceWrapping.AfterStruct = true;
                Expanded.BraceWrapping.AfterUnion = true;
                break;
            }
            case BS_Stroustrup: {
                Expanded.BraceWrapping.AfterFunction = true;
                Expanded.BraceWrapping.BeforeCatch = true;
                Expanded.BraceWrapping.BeforeElse = true;
                break;
            }
            case BS_Allman: {
                Expanded.BraceWrapping.AfterClass = true;
                Expanded.BraceWrapping.AfterControlStatement = true;
                Expanded.BraceWrapping.AfterEnum = true;
                Expanded.BraceWrapping.AfterFunction = true;
                Expanded.BraceWrapping.AfterNamespace = true;
                Expanded.BraceWrapping.AfterObjCDeclaration = true;
                Expanded.BraceWrapping.AfterStruct = true;
                Expanded.BraceWrapping.BeforeCatch = true;
                Expanded.BraceWrapping.BeforeElse = true;
                break;
            }
            case BS_GNU: {
                Expanded.BraceWrapping.$assignMove(new FormatStyle.BraceWrappingFlags(true, true, true, true, true, true, true, true, true, true, true));
                break;
            }
            case BS_WebKit: {
                Expanded.BraceWrapping.AfterFunction = true;
                break;
            }
        }
        return Expanded;
    }

    public static boolean affectsRange(ArrayRef<Range> Ranges, int Start, int End) {
        for (Range $Range : Ranges) {
            if (!Unsigned.$less_uint((int)$Range.getOffset(), (int)End) || !Unsigned.$greater_uint((int)($Range.getOffset() + $Range.getLength()), (int)Start)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sortCppIncludes(FormatStyle Style, final SmallVectorImpl<IncludeDirective> Includes, ArrayRef<Range> Ranges, StringRef FileName, std.setType<Replacement> Replaces, uint.ptr Cursor) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if (!FormatStatics.affectsRange((ArrayRef<Range>)new ArrayRef(Ranges), ((IncludeDirective)Includes.front$Const()).Offset, ((IncludeDirective)Includes.back$Const()).Offset + ((IncludeDirective)Includes.back$Const()).Text.size())) {
                return;
            }
            SmallVectorUInt Indices = new SmallVectorUInt(16, 0);
            int e = Includes.size();
            for (int i = 0; i != e; ++i) {
                Indices.push_back(i);
            }
            std.Compare<Integer> comparator = new std.Compare<Integer>(){

                public boolean compare(Integer LHSI, Integer RHSI) {
                    int res = ((IncludeDirective)Includes.$at$Const((int)LHSI.intValue())).Category - ((IncludeDirective)Includes.$at$Const((int)RHSI.intValue())).Category;
                    if (res < 0) {
                        return true;
                    }
                    if (res == 0) {
                        res = ((IncludeDirective)Includes.$at$Const((int)LHSI.intValue())).Filename.compare(((IncludeDirective)Includes.$at$Const((int)RHSI.intValue())).Filename);
                        if (res < 0) {
                            return true;
                        }
                        if (res == 0) {
                            return ((IncludeDirective)Includes.$at$Const((int)LHSI.intValue())).Offset < ((IncludeDirective)Includes.$at$Const((int)RHSI.intValue())).Offset;
                        }
                    }
                    return false;
                }
            };
            std.stable_sort((uint.ptr)Indices.begin(), (uint.ptr)Indices.end(), (std.Compare)comparator);
            if (std.is_sorted((uint.ptr)Indices.begin(), (uint.ptr)Indices.end())) {
                return;
            }
            std.string result = new std.string();
            boolean CursorMoved = false;
            Iterator iterator2 = Indices.iterator();
            while (iterator2.hasNext()) {
                int Index = (Integer)iterator2.next();
                if (!result.empty()) {
                    result.$addassign_T$C$P((CharSequence)"\n");
                }
                llvm.$addassign_string_StringRef((std.string)result, (StringRef)((IncludeDirective)Includes.$at$Const((int)Index)).Text);
                if (!Native.$bool((Native.Native$Bool)Cursor) || CursorMoved) continue;
                int Start = ((IncludeDirective)Includes.$at$Const((int)Index)).Offset;
                int End = Start + ((IncludeDirective)Includes.$at$Const((int)Index)).Text.size();
                if (!Unsigned.$greatereq_uint((int)Cursor.$star(), (int)Start) || !Unsigned.$less_uint((int)Cursor.$star(), (int)End)) continue;
                Cursor.$set(((IncludeDirective)Includes.front$Const()).Offset + result.size() + Cursor.$star() - End);
                CursorMoved = true;
            }
            assert (result.size() == ((IncludeDirective)Includes.back$Const()).Offset + ((IncludeDirective)Includes.back$Const()).Text.size() - ((IncludeDirective)Includes.front$Const()).Offset);
            $c$.clean((Object)Replaces.insert_T$RR($c$.track((Object)new Replacement(new StringRef(FileName), ((IncludeDirective)Includes.front$Const()).Offset, result.size(), new StringRef(result)))));
        }
        finally {
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.setType<Replacement> sortCppIncludes(FormatStyle Style, StringRef Code, ArrayRef<Range> Ranges, StringRef FileName, std.setType<Replacement> Replaces, uint.ptr Cursor) {
        Regex IncludeRegex = null;
        IncludeCategoryManager Categories = null;
        try {
            int Prev = 0;
            int SearchFrom = 0;
            IncludeRegex = new Regex(new StringRef(IncludeRegexPattern));
            SmallVector Matches = new SmallVector(4, (Object)new StringRef());
            SmallVector IncludesInBlock = new SmallVector(16, (Object)new IncludeDirective());
            Categories = new IncludeCategoryManager(Style, new StringRef(FileName));
            boolean FirstIncludeBlock = true;
            boolean MainIncludeFound = false;
            boolean FormattingOff = false;
            while (true) {
                int Pos;
                StringRef Line;
                StringRef Trimmed;
                if (llvm.$eq_StringRef((StringRef)(Trimmed = (Line = Code.substr(Prev, ((Pos = Code.find((byte)10, SearchFrom)) != StringRef.npos ? Pos : Code.size()) - Prev)).trim()), (String)"// clang-format off")) {
                    FormattingOff = true;
                } else if (llvm.$eq_StringRef((StringRef)Trimmed, (String)"// clang-format on")) {
                    FormattingOff = false;
                }
                if (!FormattingOff && !Line.endswith("\\")) {
                    if (IncludeRegex.match(Line, (SmallVectorImpl)Matches)) {
                        StringRef IncludeName = new StringRef((StringRef)Matches.$at(2));
                        int Category = Categories.getIncludePriority(new StringRef(IncludeName), !MainIncludeFound && FirstIncludeBlock);
                        if (Category == 0) {
                            MainIncludeFound = true;
                        }
                        IncludesInBlock.push_back((Object)new IncludeDirective(IncludeName, Line, Prev, Category));
                    } else if (!IncludesInBlock.empty()) {
                        FormatStatics.sortCppIncludes(Style, (SmallVectorImpl<IncludeDirective>)IncludesInBlock, (ArrayRef<Range>)new ArrayRef(Ranges), new StringRef(FileName), Replaces, Cursor);
                        IncludesInBlock.clear();
                        FirstIncludeBlock = false;
                    }
                    Prev = Pos + 1;
                }
                if (Pos == StringRef.npos || Pos + 1 == Code.size()) break;
                SearchFrom = Pos + 1;
            }
            if (!IncludesInBlock.empty()) {
                FormatStatics.sortCppIncludes(Style, (SmallVectorImpl<IncludeDirective>)IncludesInBlock, (ArrayRef<Range>)new ArrayRef(Ranges), new StringRef(FileName), Replaces, Cursor);
            }
            std.setType setType2 = new std.setType(Replaces);
            return setType2;
        }
        finally {
            if (Categories != null) {
                Categories.$destroy();
            }
            if (IncludeRegex != null) {
                IncludeRegex.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends FormatFunctionPointers.FormatStyleStringRefvectorStringRef2Replacements> Expected<std.setType<Replacement>> processReplacements(T ProcessFunc, StringRef Code, std.setType<Replacement> Replaces, FormatStyle Style) {
        Expected NewCode = null;
        std.vector ChangedRanges = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if (Replaces.empty()) {
                Expected expected = (Expected)$c$.clean((Object)new Expected(JavaDifferentiators.JD$ConvertibleMove.INSTANCE, $c$.track((Object)new std.setType())));
                return expected;
            }
            NewCode = ToolingGlobals.applyAllReplacements((StringRef)new StringRef(Code), Replaces);
            if (!NewCode.$bool()) {
                Expected expected = (Expected)$c$.clean((Object)new Expected((Error)$c$.track((Object)NewCode.takeError())));
                return expected;
            }
            ChangedRanges = ToolingGlobals.calculateChangedRanges(Replaces);
            StringRef FileName = ((Replacement)Replaces.begin().$arrow()).getFilePath();
            std.setType<Replacement> FormatReplaces = ProcessFunc.$call(Style, new StringRef((std.string)NewCode.$star()), (std.vector<Range>)ChangedRanges, FileName);
            Expected expected = (Expected)$c$.clean((Object)new Expected(JavaDifferentiators.JD$ConvertibleMove.INSTANCE, $c$.track((Object)ToolingGlobals.mergeReplacements(Replaces, FormatReplaces))));
            return expected;
        }
        finally {
            if (ChangedRanges != null) {
                ChangedRanges.$destroy();
            }
            if (NewCode != null) {
                NewCode.$destroy();
            }
            $c$.$destroy();
        }
    }

    public static boolean isHeaderInsertion(Replacement Replace) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            boolean bl = $c$.clean(Replace.getOffset() == -1 && ((Regex)$c$.track((Object)new Regex(new StringRef(IncludeRegexPattern)))).find(Replace.getReplacementText()));
            return bl;
        }
        finally {
            $c$.$destroy();
        }
    }

    public static void skipComments(Lexer Lex, Token Tok) {
        while (Tok.is('\u0004')) {
            if (!Lex.LexFromRawLexer(Tok)) continue;
            return;
        }
    }

    public static boolean checkAndConsumeDirectiveWithName(Lexer Lex, StringRef Name, Token Tok) {
        boolean Matched;
        boolean bl = Matched = Tok.is('A') && !Lex.LexFromRawLexer(Tok) && Tok.is('\u0006') && llvm.$eq_StringRef((StringRef)Tok.getRawIdentifier(), (StringRef)Name) && !Lex.LexFromRawLexer(Tok) && Tok.is('\u0006');
        if (Matched) {
            Lex.LexFromRawLexer(Tok);
        }
        return Matched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOffsetAfterHeaderGuardsAndComments(StringRef FileName, StringRef Code, FormatStyle Style) {
        std_ptr.unique_ptr<Environment> Env = null;
        Lexer Lex = null;
        try {
            Env = Environment.CreateVirtualEnvironment(new StringRef(Code), new StringRef(FileName), (ArrayRef<Range>)new ArrayRef(false));
            SourceManager SourceMgr = ((Environment)Env.$arrow()).getSourceManager();
            Lex = new Lexer(((Environment)Env.$arrow()).getFileID(), SourceMgr.getBuffer(((Environment)Env.$arrow()).getFileID()), SourceMgr, FormatGlobals.getFormattingLangOpts(Style));
            Token Tok = new Token();
            Lex.LexFromRawLexer(Tok);
            FormatStatics.skipComments(Lex, Tok);
            int AfterComments = SourceMgr.getFileOffset(Tok.getLocation());
            if (FormatStatics.checkAndConsumeDirectiveWithName(Lex, new StringRef(NativePointer.$ifndef), Tok)) {
                FormatStatics.skipComments(Lex, Tok);
                if (FormatStatics.checkAndConsumeDirectiveWithName(Lex, new StringRef(NativePointer.$define), Tok)) {
                    int n = SourceMgr.getFileOffset(Tok.getLocation());
                    return n;
                }
            }
            int n = AfterComments;
            return n;
        }
        finally {
            if (Lex != null) {
                Lex.$destroy();
            }
            if (Env != null) {
                Env.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.setType<Replacement> fixCppIncludeInsertions(StringRef Code, std.setType<Replacement> Replaces, FormatStyle Style) {
        std.setType HeaderInsertions = null;
        std.setType Result = null;
        Regex IncludeRegex = null;
        Regex DefineRegex = null;
        IncludeCategoryManager Categories = null;
        std_map.mapIntInt CategoryEndOffsets = null;
        std.setInt Priorities = null;
        std.setType ExistingIncludes = null;
        try {
            if (Style.Language != FormatStyle.LanguageKind.LK_Cpp) {
                std.setType setType2 = new std.setType(Replaces);
                return setType2;
            }
            HeaderInsertions = new std.setType();
            for (Replacement R : Replaces) {
                if (FormatStatics.isHeaderInsertion(R)) {
                    HeaderInsertions.insert_T$C$R((Object)R);
                    continue;
                }
                if (R.getOffset() != -1) continue;
                llvm.errs().$out("Insertions other than header #include insertion are not supported! ").$out(R.getReplacementText()).$out(NativePointer.$LF);
            }
            if (HeaderInsertions.empty()) {
                Iterator iterator2 = new std.setType(Replaces);
                return iterator2;
            }
            Result = new std.setType();
            std.set_difference2((type.iterator)Replaces.begin(), (type.iterator)Replaces.end(), (type.iterator)HeaderInsertions.begin(), (type.iterator)HeaderInsertions.end(), (std.setType)Result);
            IncludeRegex = new Regex(new StringRef(IncludeRegexPattern));
            DefineRegex = new Regex(new StringRef("^[\\t\\ ]*#[\\t\\ ]*define[\\t\\ ]*[^\\\\]*$"));
            SmallVector Matches = new SmallVector(4, (Object)new StringRef());
            StringRef FileName = ((Replacement)Replaces.begin().$arrow()).getFilePath();
            Categories = new IncludeCategoryManager(Style, new StringRef(FileName));
            CategoryEndOffsets = new std_map.mapIntInt();
            Priorities = new std.setInt(JavaDifferentiators.JD$Initializer_list$_Key_T1$C$R_T2$C$R.INSTANCE, NativePointer.new$int((int)2, (int[])new int[]{0, Integer.MAX_VALUE}));
            for (FormatStyle.IncludeCategory Category : Style.IncludeCategories) {
                Priorities.insert_T$C$R(Category.Priority);
            }
            int FirstIncludeOffset = -1;
            int MinInsertOffset = FormatStatics.getOffsetAfterHeaderGuardsAndComments(new StringRef(FileName), new StringRef(Code), Style);
            StringRef TrimmedCode = Code.drop_front(MinInsertOffset);
            SmallVector Lines = new SmallVector(32, (Object)new StringRef());
            TrimmedCode.split((SmallVectorImpl)Lines, (byte)10);
            int Offset = MinInsertOffset;
            ExistingIncludes = new std.setType(StringRef.COMPARATOR);
            for (StringRef Line : Lines) {
                int NextLineOffset = std.min_uint((int)Code.size(), (int)(Offset + Line.size() + 1));
                if (IncludeRegex.match(Line, (SmallVectorImpl)Matches)) {
                    StringRef IncludeName = new StringRef((StringRef)Matches.$at(2));
                    ExistingIncludes.insert_T$C$R((Object)IncludeName);
                    int Category = Categories.getIncludePriority(new StringRef(IncludeName), FirstIncludeOffset < 0);
                    CategoryEndOffsets.$set(Integer.valueOf(Category), NextLineOffset);
                    if (FirstIncludeOffset < 0) {
                        FirstIncludeOffset = Offset;
                    }
                }
                Offset = NextLineOffset;
            }
            StdSetInt.iterator Highest = Priorities.begin();
            if (CategoryEndOffsets.find(Integer.valueOf(Highest.$star())).$eq((Object)CategoryEndOffsets.end())) {
                if (FirstIncludeOffset >= 0) {
                    CategoryEndOffsets.$set(Integer.valueOf(Highest.$star()), FirstIncludeOffset);
                } else {
                    CategoryEndOffsets.$set(Integer.valueOf(Highest.$star()), MinInsertOffset);
                }
            }
            StdSetInt.iterator I = new StdSetInt.iterator(Priorities.begin().$preInc());
            StdSetInt.iterator E = Priorities.end();
            while (I.$noteq((Object)E)) {
                if (CategoryEndOffsets.find(Integer.valueOf(I.$star())).$eq((Object)CategoryEndOffsets.end())) {
                    CategoryEndOffsets.$set(Integer.valueOf(I.$star()), CategoryEndOffsets.$at_T$C$R(Integer.valueOf(((StdSetInt.iterator)std.prev((abstract_iterator)new StdSetInt.iterator(I))).$star())));
                }
                I.$preInc();
            }
            for (Replacement R : HeaderInsertions) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    StringRef IncludeDirective2 = R.getReplacementText();
                    boolean Matched = IncludeRegex.match(IncludeDirective2, (SmallVectorImpl)Matches);
                    assert (Matched) : "Header insertion replacement must have replacement text '#include ...'";
                    StringRef IncludeName = new StringRef((StringRef)Matches.$at(2));
                    if (ExistingIncludes.find((Object)IncludeName).$noteq((Object)ExistingIncludes.end())) continue;
                    int Category = Categories.getIncludePriority(new StringRef(IncludeName), true);
                    Offset = CategoryEndOffsets.$at_T$C$R(Integer.valueOf(Category));
                    std.string NewInclude = !IncludeDirective2.endswith("\n") ? llvm.$add_StringRef$C_char$ptr$C((StringRef)IncludeDirective2, (char.ptr)NativePointer.$LF).str() : IncludeDirective2.str();
                    $c$.clean((Object)Result.insert_T$RR($c$.track((Object)new Replacement(new StringRef(FileName), Offset, 0, new StringRef(NewInclude)))));
                }
                finally {
                    $c$.$destroy();
                }
            }
            Iterator iterator3 = new std.setType(JavaDifferentiators.JD$Move.INSTANCE, Result);
            return iterator3;
        }
        finally {
            if (ExistingIncludes != null) {
                ExistingIncludes.$destroy();
            }
            if (Priorities != null) {
                Priorities.$destroy();
            }
            if (CategoryEndOffsets != null) {
                CategoryEndOffsets.$destroy();
            }
            if (Categories != null) {
                Categories.$destroy();
            }
            if (DefineRegex != null) {
                DefineRegex.$destroy();
            }
            if (IncludeRegex != null) {
                IncludeRegex.$destroy();
            }
            if (Result != null) {
                Result.$destroy();
            }
            if (HeaderInsertions != null) {
                HeaderInsertions.$destroy();
            }
        }
    }

    public static FormatStyle.LanguageKind getLanguageByFileName(StringRef FileName) {
        if (FileName.endswith(".java")) {
            return FormatStyle.LanguageKind.LK_Java;
        }
        if (FileName.endswith_lower(".js") || FileName.endswith_lower(".ts")) {
            return FormatStyle.LanguageKind.LK_JavaScript;
        }
        if (FileName.endswith_lower(".proto") || FileName.endswith_lower(".protodevel")) {
            return FormatStyle.LanguageKind.LK_Proto;
        }
        if (FileName.endswith_lower(".td")) {
            return FormatStyle.LanguageKind.LK_TableGen;
        }
        return FormatStyle.LanguageKind.LK_Cpp;
    }

    public static char.ptr getTokenTypeName(TokenType Type2) {
        type.ptr<char.ptr> TokNames = FormatStatics$getTokenTypeName$$.TokNames;
        if (Type2.getValue() < TokenType.NUM_TOKEN_TYPES.getValue()) {
            return (char.ptr)TokNames.$at(Type2.getValue());
        }
        throw new llvm_unreachable("unknown TokenType");
    }

    public static int CodePointsBetween(FormatToken Begin, FormatToken End) {
        assert (Unsigned.$greatereq_uint((int)End.TotalLength, (int)Begin.TotalLength));
        return End.TotalLength - Begin.TotalLength + Begin.ColumnWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.setType<Replacement> sortJavaScriptImports(FormatStyle Style, StringRef Code, ArrayRef<Range> Ranges, StringRef FileName) {
        std_ptr.unique_ptr<Environment> Env = null;
        JavaScriptImportSorter Sorter = null;
        try {
            Env = Environment.CreateVirtualEnvironment(new StringRef(Code), new StringRef(FileName), (ArrayRef<Range>)new ArrayRef(Ranges));
            Sorter = new JavaScriptImportSorter((Environment)Env.$star(), Style);
            std.setType<Replacement> setType2 = Sorter.process();
            return setType2;
        }
        finally {
            if (Sorter != null) {
                Sorter.$destroy();
            }
            if (Env != null) {
                Env.$destroy();
            }
        }
    }

    public static boolean $less_JsModuleReference$C(JsModuleReference LHS, JsModuleReference RHS) {
        if (LHS.IsExport != RHS.IsExport) {
            return LHS.IsExport < RHS.IsExport;
        }
        if (LHS.Category != RHS.Category) {
            return LHS.Category.getValue() < RHS.Category.getValue();
        }
        if (LHS.Category == JsModuleReference.ReferenceCategory.SIDE_EFFECT) {
            return false;
        }
        if (LHS.URL.empty() != RHS.URL.empty()) {
            return LHS.URL.empty() < RHS.URL.empty();
        }
        int Res = LHS.URL.compare_lower(RHS.URL);
        if (Res != 0) {
            return Res < 0;
        }
        if (LHS.Prefix.empty() != RHS.Prefix.empty()) {
            return LHS.Prefix.empty() < RHS.Prefix.empty();
        }
        if (llvm.$noteq_StringRef((StringRef)LHS.Prefix, (StringRef)RHS.Prefix)) {
            return llvm.$greater_StringRef((StringRef)LHS.Prefix, (StringRef)RHS.Prefix);
        }
        return false;
    }

    public static boolean isFunctionDeclarationName(FormatToken Current, AnnotatedLine Line) {
        FormatFunctionPointers.FormatToken2FormatToken skipOperatorName = Next -> {
            while (Next != null) {
                if (Next.is_TokenType(TokenType.TT_OverloadedOperatorLParen)) {
                    return Next;
                }
                if (!Next.is_TokenType(TokenType.TT_OverloadedOperator)) {
                    if (!Next.isOneOf('\u0087', '\u007f')) break;
                    if (Next.Next != null && Next.Next.is_TokenKind('\u0013') && Next.Next.Next != null && Next.Next.Next.is_TokenKind('\u0014')) {
                        Next = Next.Next.Next;
                    }
                }
                Next = Next.Next;
            }
            return null;
        };
        FormatToken Next2 = Current.Next;
        if (Current.is_TokenKind('\u0088')) {
            if (Current.Previous != null && Current.Previous.is_TokenKind('F')) {
                return false;
            }
            Next2 = skipOperatorName.$call(Next2);
        } else {
            if (!Current.is_TokenType(TokenType.TT_StartOfName) || Current.NestingLevel != 0) {
                return false;
            }
            while (Next2 != null) {
                if (Next2.is_TokenType(TokenType.TT_TemplateOpener)) {
                    Next2 = Next2.MatchingParen;
                } else if (Next2.is_TokenKind('F')) {
                    Next2 = Next2.Next;
                    if (Next2 == null) {
                        return false;
                    }
                    if (Next2.is_TokenKind('\u0088')) {
                        Next2 = skipOperatorName.$call(Next2.Next);
                        break;
                    }
                    if (!Next2.is_TokenKind('\u0005')) {
                        return false;
                    }
                } else {
                    if (Next2.is_TokenKind('\u0015')) break;
                    return false;
                }
                Next2 = Next2.Next;
            }
        }
        if (Next2 == null || !Next2.is_TokenKind('\u0015') || Next2.MatchingParen == null) {
            return false;
        }
        if (Line.Last.is_TokenKind('\u0017')) {
            return true;
        }
        if (Next2.Next == Next2.MatchingParen) {
            return true;
        }
        if (Next2.MatchingParen.Next != null && Next2.MatchingParen.Next.is_TokenType(TokenType.TT_PointerOrReference)) {
            return true;
        }
        FormatToken Tok = Next2.Next;
        while (Tok != null && Tok != Next2.MatchingParen) {
            if (Tok.is_TokenKind('O') || Tok.isSimpleTypeSpecifier() || Tok.isOneOf(TokenType.TT_PointerOrReference, TokenType.TT_StartOfName, '\u001a')) {
                return true;
            }
            if (Tok.isOneOf('\u0017', '\r', TokenType.TT_ObjCMethodExpr) || Tok.Tok.isLiteral()) {
                return false;
            }
            Tok = Tok.Next;
        }
        return false;
    }

    public static boolean isAllmanBrace(FormatToken Tok) {
        return Tok.is_TokenKind('\u0017') && Tok.BlockKind == BraceBlockKind.BK_Block && !Tok.isOneOf(TokenType.TT_ObjCBlockLBrace, TokenType.TT_DictLiteral);
    }

    public static boolean startsExternCBlock(AnnotatedLine Line) {
        FormatToken Next = Line.First.getNextNonComment();
        FormatToken NextNext = Next != null ? Next.getNextNonComment() : null;
        return Line.startsWith('V') && Next != null && Next.isStringLiteral() && NextNext != null && NextNext.is_TokenKind('\u0017');
    }

    public static void markFinalized(FormatToken Tok) {
        while (Tok != null) {
            Tok.Finalized = true;
            for (AnnotatedLine Child : Tok.Children) {
                FormatStatics.markFinalized(Child.First);
            }
            Tok = Tok.Next;
        }
    }

    public static void printLineState(LineState State) {
        llvm.dbgs().$out("State: ");
        for (ParenState P : State.Stack) {
            llvm.dbgs().$out_uint(P.Indent).$out(NativePointer.$PIPE).$out_uint(P.LastSpace).$out(NativePointer.$PIPE).$out_uint(P.NestedBlockIndent).$out(NativePointer.$SPACE);
        }
        llvm.dbgs().$out(State.NextToken.TokenText).$out(NativePointer.$LF);
    }

    public static boolean isGoogScope(UnwrappedLine Line) {
        if (Unsigned.$less_uint((int)Line.Tokens.size(), (int)4)) {
            return false;
        }
        std_list.list.iterator I = Line.Tokens.begin$Const();
        if (llvm.$noteq_StringRef((StringRef)((UnwrappedLineNode)I.$arrow()).Tok.TokenText, (String)"goog")) {
            return false;
        }
        I.$preInc();
        if (((UnwrappedLineNode)I.$arrow()).Tok.isNot('\u0019')) {
            return false;
        }
        I.$preInc();
        if (llvm.$noteq_StringRef((StringRef)((UnwrappedLineNode)I.$arrow()).Tok.TokenText, (String)"scope")) {
            return false;
        }
        I.$preInc();
        return ((UnwrappedLineNode)I.$arrow()).Tok.is_TokenKind('\u0015');
    }

    public static boolean ShouldBreakBeforeBrace(FormatStyle Style, FormatToken InitialToken) {
        if (InitialToken.is_TokenKind('\u0086')) {
            return Style.BraceWrapping.AfterNamespace;
        }
        if (InitialToken.is_TokenKind('}')) {
            return Style.BraceWrapping.AfterClass;
        }
        if (InitialToken.is_TokenKind('h')) {
            return Style.BraceWrapping.AfterUnion;
        }
        if (InitialToken.is_TokenKind('e')) {
            return Style.BraceWrapping.AfterStruct;
        }
        return false;
    }

    public static boolean tokenCanStartNewLine(Token Tok) {
        return Tok.isNot('=') && Tok.isNot('\u0017') && Tok.isNot('\u0013') && Tok.isNot('\u0019') && Tok.isNot('D') && Tok.isNot('$') && Tok.isNot('E') && Tok.isNot('.') && Tok.isNot('2') && Tok.isNot('*') && Tok.isNot(',') && Tok.isNot('/') && Tok.isNot('3') && Tok.isNot('>') && Tok.isNot('\"') && Tok.isNot('&') && Tok.isNot('\u001f') && Tok.isNot('+') && Tok.isNot('-') && Tok.isNot('\u001d') && Tok.isNot(':') && Tok.isNot('7') && Tok.isNot('5') && Tok.isNot('1') && Tok.isNot('<') && Tok.isNot('\u009e');
    }

    public static boolean mustBeJSIdent(AdditionalKeywords Keywords, FormatToken FormatTok) {
        return FormatTok.is_TokenKind('\u0005') && (FormatTok.Tok.getIdentifierInfo() == null || !FormatTok.isOneOf(Keywords.kw_in, Keywords.kw_of, Keywords.kw_as, Keywords.kw_async, Keywords.kw_await, Keywords.kw_yield, Keywords.kw_finally, Keywords.kw_function, Keywords.kw_import, Keywords.kw_is, Keywords.kw_let, Keywords.kw_var, Keywords.kw_abstract, Keywords.kw_extends, Keywords.kw_implements, Keywords.kw_instanceof, Keywords.kw_interface, Keywords.kw_throws));
    }

    public static boolean mustBeJSIdentOrValue(AdditionalKeywords Keywords, FormatToken FormatTok) {
        return FormatTok.Tok.isLiteral() || FormatStatics.mustBeJSIdent(Keywords, FormatTok);
    }

    public static boolean isJSDeclOrStmt(AdditionalKeywords Keywords, FormatToken FormatTok) {
        return FormatTok.isOneOf('`', 'Z', 'T', 'X', 'l', 'R', 'P', 'L', 'f', 'M', '\u0090', '\u0092', '|', 'O', '}', '\u0082') || FormatTok.isOneOf(Keywords.kw_finally, Keywords.kw_yield, Keywords.kw_var, Keywords.kw_let, Keywords.kw_async, Keywords.kw_function, Keywords.kw_import);
    }

    public static void printDebugInfo(UnwrappedLine Line) {
        FormatStatics.printDebugInfo(Line, new StringRef(NativePointer.$EMPTY));
    }

    public static void printDebugInfo(UnwrappedLine Line, StringRef Prefix) {
        llvm.dbgs().$out(Prefix).$out("Line(").$out_uint(Line.Level).$out(NativePointer.$RPAREN).$out(Line.InPPDirective ? NativePointer.$((String)" MACRO") : NativePointer.$EMPTY).$out(": ");
        std_list.list.iterator I = Line.Tokens.begin$Const();
        std_list.list.iterator E = Line.Tokens.end$Const();
        while (I.$noteq((Object)E)) {
            llvm.dbgs().$out(((UnwrappedLineNode)I.$arrow()).Tok.Tok.getName()).$out(NativePointer.$LSQUARE).$out_int(((UnwrappedLineNode)I.$arrow()).Tok.Type.getValue()).$out("] ");
            I.$preInc();
        }
        I = Line.Tokens.begin$Const();
        E = Line.Tokens.end$Const();
        while (I.$noteq((Object)E)) {
            UnwrappedLineNode Node = (UnwrappedLineNode)I.$star();
            type.ptr I$1 = (type.ptr)Native.$tryClone((NativeCloneable)Node.Children.begin$Const());
            type.ptr E$1 = (type.ptr)Native.$tryClone((NativeCloneable)Node.Children.end$Const());
            while (Native.$noteq_ptr((void.ptr)I$1, (void.ptr)E$1)) {
                FormatStatics.printDebugInfo((UnwrappedLine)I$1.$star(), new StringRef("\nChild: "));
                I$1.$preInc();
            }
            I.$preInc();
        }
        llvm.dbgs().$out(NativePointer.$LF);
    }

    public static <F extends FormatFunctionPointers.Change2Bool> void AlignTokenSequence(int Start, int End, int Column, F Matches, SmallVector<WhitespaceManager.Change> Changes) {
        boolean FoundMatchOnLine = false;
        int Shift = 0;
        for (int i = Start; i != End; ++i) {
            if (Unsigned.$greater_uint((int)((WhitespaceManager.Change)Changes.$at((int)i)).NewlinesBefore, (int)0)) {
                FoundMatchOnLine = false;
                Shift = 0;
            }
            if (!FoundMatchOnLine && Matches.$call((WhitespaceManager.Change)Changes.$at(i))) {
                FoundMatchOnLine = true;
                Shift = Column - ((WhitespaceManager.Change)Changes.$at((int)i)).StartOfTokenColumn;
                ((WhitespaceManager.Change)Changes.$at((int)i)).Spaces += Shift;
            }
            assert (Shift >= 0);
            ((WhitespaceManager.Change)Changes.$at((int)i)).StartOfTokenColumn += Shift;
            if (i + 1 == Changes.size()) continue;
            ((WhitespaceManager.Change)Changes.$at((int)(i + 1))).PreviousEndOfTokenColumn += Shift;
        }
    }

    public static <F extends FormatFunctionPointers.Change2Bool> void AlignTokens(FormatStyle Style, F Matches, SmallVector<WhitespaceManager.Change> Changes) {
        uint.ref MinColumn = NativePointer.create_uint$ref((int)0);
        uint.ref MaxColumn = NativePointer.create_uint$ref((int)-1);
        uint.ref StartOfSequence = NativePointer.create_uint$ref((int)0);
        uint.ref EndOfSequence = NativePointer.create_uint$ref((int)0);
        int NestingLevelOfLastMatch = 0;
        int NestingLevel = 0;
        int CommasBeforeLastMatch = 0;
        int CommasBeforeMatch = 0;
        boolean FoundMatchOnLine = false;
        NativeCallback.Void2Void AlignCurrentSequence = () -> {
            if (Unsigned.$greater_uint((int)StartOfSequence.$deref(), (int)0) && Unsigned.$less_uint((int)StartOfSequence.$deref(), (uint.ref)EndOfSequence)) {
                FormatStatics.AlignTokenSequence(StartOfSequence.$deref(), EndOfSequence.$deref(), MinColumn.$deref(), Matches, Changes);
            }
            MinColumn.$set(0);
            MaxColumn.$set(-1);
            StartOfSequence.$set(0);
            EndOfSequence.$set(0);
        };
        int e = Changes.size();
        for (int i = 0; i != e; ++i) {
            if (((WhitespaceManager.Change)Changes.$at((int)i)).NewlinesBefore != 0) {
                CommasBeforeMatch = 0;
                EndOfSequence.$set(i);
                if (Unsigned.$greater_uint((int)((WhitespaceManager.Change)Changes.$at((int)i)).NewlinesBefore, (int)1) || !FoundMatchOnLine) {
                    AlignCurrentSequence.$call();
                }
                FoundMatchOnLine = false;
            }
            if (((WhitespaceManager.Change)Changes.$at((int)i)).Kind == '@') {
                ++CommasBeforeMatch;
            } else if (((WhitespaceManager.Change)Changes.$at((int)i)).Kind == '\u0018' || ((WhitespaceManager.Change)Changes.$at((int)i)).Kind == '\u0016' || ((WhitespaceManager.Change)Changes.$at((int)i)).Kind == '\u0014') {
                --NestingLevel;
            } else if (((WhitespaceManager.Change)Changes.$at((int)i)).Kind == '\u0017' || ((WhitespaceManager.Change)Changes.$at((int)i)).Kind == '\u0015' || ((WhitespaceManager.Change)Changes.$at((int)i)).Kind == '\u0013') {
                NestingLevelOfLastMatch = std.min_uint((int)NestingLevelOfLastMatch, (int)NestingLevel);
                ++NestingLevel;
            }
            if (Native.$not((boolean)Matches.$call((WhitespaceManager.Change)Changes.$at(i)))) continue;
            if (FoundMatchOnLine || CommasBeforeMatch != CommasBeforeLastMatch || NestingLevel != NestingLevelOfLastMatch) {
                AlignCurrentSequence.$call();
            }
            CommasBeforeLastMatch = CommasBeforeMatch;
            NestingLevelOfLastMatch = NestingLevel;
            FoundMatchOnLine = true;
            if (StartOfSequence.$deref() == 0) {
                StartOfSequence.$set(i);
            }
            int ChangeMinColumn = ((WhitespaceManager.Change)Changes.$at((int)i)).StartOfTokenColumn;
            int LineLengthAfter = -((WhitespaceManager.Change)Changes.$at((int)i)).Spaces;
            for (int j = i; j != e && ((WhitespaceManager.Change)Changes.$at((int)j)).NewlinesBefore == 0; ++j) {
                LineLengthAfter += ((WhitespaceManager.Change)Changes.$at((int)j)).Spaces + ((WhitespaceManager.Change)Changes.$at((int)j)).TokenLength;
            }
            int ChangeMaxColumn = Style.ColumnLimit - LineLengthAfter;
            if (Unsigned.$greater_uint((int)ChangeMinColumn, (int)MaxColumn.$deref()) || Unsigned.$less_uint((int)ChangeMaxColumn, (uint.ref)MinColumn) || CommasBeforeLastMatch != CommasBeforeMatch) {
                AlignCurrentSequence.$call();
                StartOfSequence.$set(i);
            }
            MinColumn.$set(std.max((int)MinColumn.$deref(), (int)ChangeMinColumn));
            MaxColumn.$set(std.min_uint((int)MaxColumn.$deref(), (int)ChangeMaxColumn));
        }
        EndOfSequence.$set(Changes.size());
        AlignCurrentSequence.$call();
    }
}

