/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import java.util.Iterator;
import org.clang.basic.SourceManager;
import org.clang.format.FormatGlobals;
import org.clang.format.FormatStyle;
import org.clang.format.impl.Environment;
import org.clang.format.impl.FormatStatics;
import org.clang.format.impl.IncludeCategoryManager;
import org.clang.format.impl.IncludeDirective;
import org.clang.format.java.FormatFunctionPointers;
import org.clang.lex.Lexer;
import org.clang.lex.Token;
import org.clang.tooling.ToolingGlobals;
import org.clang.tooling.core.Range;
import org.clang.tooling.core.Replacement;
import org.clank.java.std;
import org.clank.java.std_map;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.StdSetInt;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorUInt;
import org.llvm.support.Error;
import org.llvm.support.Expected;
import org.llvm.support.Regex;
import org.llvm.support.llvm;

public final class FormatFormatStatics {
    public static FormatStyle expandPresets(FormatStyle Style) {
        if (Style.BreakBeforeBraces == FormatStyle.BraceBreakingStyle.BS_Custom) {
            return new FormatStyle(Style);
        }
        FormatStyle Expanded = new FormatStyle(Style);
        Expanded.BraceWrapping.$assignMove(new FormatStyle.BraceWrappingFlags(false, false, false, false, false, false, false, false, false, false, false));
        switch (Style.BreakBeforeBraces) {
            case BS_Linux: {
                Expanded.BraceWrapping.AfterClass = true;
                Expanded.BraceWrapping.AfterFunction = true;
                Expanded.BraceWrapping.AfterNamespace = true;
                break;
            }
            case BS_Mozilla: {
                Expanded.BraceWrapping.AfterClass = true;
                Expanded.BraceWrapping.AfterEnum = true;
                Expanded.BraceWrapping.AfterFunction = true;
                Expanded.BraceWrapping.AfterStruct = true;
                Expanded.BraceWrapping.AfterUnion = true;
                break;
            }
            case BS_Stroustrup: {
                Expanded.BraceWrapping.AfterFunction = true;
                Expanded.BraceWrapping.BeforeCatch = true;
                Expanded.BraceWrapping.BeforeElse = true;
                break;
            }
            case BS_Allman: {
                Expanded.BraceWrapping.AfterClass = true;
                Expanded.BraceWrapping.AfterControlStatement = true;
                Expanded.BraceWrapping.AfterEnum = true;
                Expanded.BraceWrapping.AfterFunction = true;
                Expanded.BraceWrapping.AfterNamespace = true;
                Expanded.BraceWrapping.AfterObjCDeclaration = true;
                Expanded.BraceWrapping.AfterStruct = true;
                Expanded.BraceWrapping.BeforeCatch = true;
                Expanded.BraceWrapping.BeforeElse = true;
                break;
            }
            case BS_GNU: {
                Expanded.BraceWrapping.$assignMove(new FormatStyle.BraceWrappingFlags(true, true, true, true, true, true, true, true, true, true, true));
                break;
            }
            case BS_WebKit: {
                Expanded.BraceWrapping.AfterFunction = true;
                break;
            }
        }
        return Expanded;
    }

    public static boolean affectsRange(ArrayRef<Range> Ranges, int Start, int End) {
        for (Range $Range : Ranges) {
            if (!Unsigned.$less_uint((int)$Range.getOffset(), (int)End) || !Unsigned.$greater_uint((int)($Range.getOffset() + $Range.getLength()), (int)Start)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sortCppIncludes(FormatStyle Style, final SmallVectorImpl<IncludeDirective> Includes, ArrayRef<Range> Ranges, StringRef FileName, std.setType<Replacement> Replaces, uint.ptr Cursor) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if (!FormatFormatStatics.affectsRange((ArrayRef<Range>)new ArrayRef(Ranges), ((IncludeDirective)Includes.front$Const()).Offset, ((IncludeDirective)Includes.back$Const()).Offset + ((IncludeDirective)Includes.back$Const()).Text.size())) {
                return;
            }
            SmallVectorUInt Indices = new SmallVectorUInt(16, 0);
            int e = Includes.size();
            for (int i = 0; i != e; ++i) {
                Indices.push_back(i);
            }
            std.Compare<Integer> comparator = new std.Compare<Integer>(){

                public boolean compare(Integer LHSI, Integer RHSI) {
                    int res = ((IncludeDirective)Includes.$at$Const((int)LHSI.intValue())).Category - ((IncludeDirective)Includes.$at$Const((int)RHSI.intValue())).Category;
                    if (res < 0) {
                        return true;
                    }
                    if (res == 0) {
                        res = ((IncludeDirective)Includes.$at$Const((int)LHSI.intValue())).Filename.compare(((IncludeDirective)Includes.$at$Const((int)RHSI.intValue())).Filename);
                        if (res < 0) {
                            return true;
                        }
                        if (res == 0) {
                            return ((IncludeDirective)Includes.$at$Const((int)LHSI.intValue())).Offset < ((IncludeDirective)Includes.$at$Const((int)RHSI.intValue())).Offset;
                        }
                    }
                    return false;
                }
            };
            std.stable_sort((uint.ptr)Indices.begin(), (uint.ptr)Indices.end(), (std.Compare)comparator);
            if (std.is_sorted((uint.ptr)Indices.begin(), (uint.ptr)Indices.end())) {
                return;
            }
            std.string result = new std.string();
            boolean CursorMoved = false;
            Iterator iterator2 = Indices.iterator();
            while (iterator2.hasNext()) {
                int Index = (Integer)iterator2.next();
                if (!result.empty()) {
                    result.$addassign_T$C$P((CharSequence)"\n");
                }
                llvm.$addassign_string_StringRef((std.string)result, (StringRef)((IncludeDirective)Includes.$at$Const((int)Index)).Text);
                if (!Native.$bool((Native.Native$Bool)Cursor) || CursorMoved) continue;
                int Start = ((IncludeDirective)Includes.$at$Const((int)Index)).Offset;
                int End = Start + ((IncludeDirective)Includes.$at$Const((int)Index)).Text.size();
                if (!Unsigned.$greatereq_uint((int)Cursor.$star(), (int)Start) || !Unsigned.$less_uint((int)Cursor.$star(), (int)End)) continue;
                Cursor.$set(((IncludeDirective)Includes.front$Const()).Offset + result.size() + Cursor.$star() - End);
                CursorMoved = true;
            }
            assert (result.size() == ((IncludeDirective)Includes.back$Const()).Offset + ((IncludeDirective)Includes.back$Const()).Text.size() - ((IncludeDirective)Includes.front$Const()).Offset);
            $c$.clean((Object)Replaces.insert_T$RR($c$.track((Object)new Replacement(new StringRef(FileName), ((IncludeDirective)Includes.front$Const()).Offset, result.size(), new StringRef(result)))));
        }
        finally {
            $c$.$destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.setType<Replacement> sortCppIncludes(FormatStyle Style, StringRef Code, ArrayRef<Range> Ranges, StringRef FileName, std.setType<Replacement> Replaces, uint.ptr Cursor) {
        Regex IncludeRegex = null;
        IncludeCategoryManager Categories = null;
        try {
            int Prev = 0;
            int SearchFrom = 0;
            IncludeRegex = new Regex(new StringRef(FormatStatics.IncludeRegexPattern));
            SmallVector Matches = new SmallVector(4, (Object)new StringRef());
            SmallVector IncludesInBlock = new SmallVector(16, (Object)new IncludeDirective());
            Categories = new IncludeCategoryManager(Style, new StringRef(FileName));
            boolean FirstIncludeBlock = true;
            boolean MainIncludeFound = false;
            boolean FormattingOff = false;
            while (true) {
                int Pos;
                StringRef Line;
                StringRef Trimmed;
                if (llvm.$eq_StringRef((StringRef)(Trimmed = (Line = Code.substr(Prev, ((Pos = Code.find((byte)10, SearchFrom)) != StringRef.npos ? Pos : Code.size()) - Prev)).trim()), (String)"// clang-format off")) {
                    FormattingOff = true;
                } else if (llvm.$eq_StringRef((StringRef)Trimmed, (String)"// clang-format on")) {
                    FormattingOff = false;
                }
                if (!FormattingOff && !Line.endswith("\\")) {
                    if (IncludeRegex.match(Line, (SmallVectorImpl)Matches)) {
                        StringRef IncludeName = new StringRef((StringRef)Matches.$at(2));
                        int Category = Categories.getIncludePriority(new StringRef(IncludeName), !MainIncludeFound && FirstIncludeBlock);
                        if (Category == 0) {
                            MainIncludeFound = true;
                        }
                        IncludesInBlock.push_back((Object)new IncludeDirective(IncludeName, Line, Prev, Category));
                    } else if (!IncludesInBlock.empty()) {
                        FormatFormatStatics.sortCppIncludes(Style, (SmallVectorImpl<IncludeDirective>)IncludesInBlock, (ArrayRef<Range>)new ArrayRef(Ranges), new StringRef(FileName), Replaces, Cursor);
                        IncludesInBlock.clear();
                        FirstIncludeBlock = false;
                    }
                    Prev = Pos + 1;
                }
                if (Pos == StringRef.npos || Pos + 1 == Code.size()) break;
                SearchFrom = Pos + 1;
            }
            if (!IncludesInBlock.empty()) {
                FormatFormatStatics.sortCppIncludes(Style, (SmallVectorImpl<IncludeDirective>)IncludesInBlock, (ArrayRef<Range>)new ArrayRef(Ranges), new StringRef(FileName), Replaces, Cursor);
            }
            std.setType setType2 = new std.setType(Replaces);
            return setType2;
        }
        finally {
            if (Categories != null) {
                Categories.$destroy();
            }
            if (IncludeRegex != null) {
                IncludeRegex.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends FormatFunctionPointers.FormatStyleStringRefvectorStringRef2Replacements> Expected<std.setType<Replacement>> processReplacements(T ProcessFunc, StringRef Code, std.setType<Replacement> Replaces, FormatStyle Style) {
        Expected NewCode = null;
        std.vector ChangedRanges = null;
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            if (Replaces.empty()) {
                Expected expected = (Expected)$c$.clean((Object)new Expected(JavaDifferentiators.JD$Convertible.INSTANCE, $c$.track((Object)new std.setType())));
                return expected;
            }
            NewCode = ToolingGlobals.applyAllReplacements((StringRef)new StringRef(Code), Replaces);
            if (!NewCode.$bool()) {
                Expected expected = (Expected)$c$.clean((Object)new Expected((Error)$c$.track((Object)NewCode.takeError())));
                return expected;
            }
            ChangedRanges = ToolingGlobals.calculateChangedRanges(Replaces);
            StringRef FileName = ((Replacement)Replaces.begin().$arrow()).getFilePath();
            std.setType<Replacement> FormatReplaces = ProcessFunc.$call(Style, new StringRef((std.string)NewCode.$star()), (std.vector<Range>)ChangedRanges, FileName);
            Expected expected = (Expected)$c$.clean((Object)new Expected(JavaDifferentiators.JD$Convertible.INSTANCE, $c$.track((Object)ToolingGlobals.mergeReplacements(Replaces, FormatReplaces))));
            return expected;
        }
        finally {
            if (ChangedRanges != null) {
                ChangedRanges.$destroy();
            }
            if (NewCode != null) {
                NewCode.$destroy();
            }
            $c$.$destroy();
        }
    }

    public static boolean isHeaderInsertion(Replacement Replace) {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            boolean bl = $c$.clean(Replace.getOffset() == -1 && ((Regex)$c$.track((Object)new Regex(new StringRef(FormatStatics.IncludeRegexPattern)))).find(Replace.getReplacementText()));
            return bl;
        }
        finally {
            $c$.$destroy();
        }
    }

    public static void skipComments(Lexer Lex, Token Tok) {
        while (Tok.is('\u0004')) {
            if (!Lex.LexFromRawLexer(Tok)) continue;
            return;
        }
    }

    public static boolean checkAndConsumeDirectiveWithName(Lexer Lex, StringRef Name, Token Tok) {
        boolean Matched;
        boolean bl = Matched = Tok.is('A') && !Lex.LexFromRawLexer(Tok) && Tok.is('\u0006') && llvm.$eq_StringRef((StringRef)Tok.getRawIdentifier(), (StringRef)Name) && !Lex.LexFromRawLexer(Tok) && Tok.is('\u0006');
        if (Matched) {
            Lex.LexFromRawLexer(Tok);
        }
        return Matched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOffsetAfterHeaderGuardsAndComments(StringRef FileName, StringRef Code, FormatStyle Style) {
        std_ptr.unique_ptr<Environment> Env = null;
        Lexer Lex = null;
        try {
            Env = Environment.CreateVirtualEnvironment(new StringRef(Code), new StringRef(FileName), (ArrayRef<Range>)new ArrayRef(false));
            SourceManager SourceMgr = ((Environment)Env.$arrow()).getSourceManager();
            Lex = new Lexer(((Environment)Env.$arrow()).getFileID(), SourceMgr.getBuffer(((Environment)Env.$arrow()).getFileID()), SourceMgr, FormatGlobals.getFormattingLangOpts(Style));
            Token Tok = new Token();
            Lex.LexFromRawLexer(Tok);
            FormatFormatStatics.skipComments(Lex, Tok);
            int AfterComments = SourceMgr.getFileOffset(Tok.getLocation());
            if (FormatFormatStatics.checkAndConsumeDirectiveWithName(Lex, new StringRef(NativePointer.$ifndef), Tok)) {
                FormatFormatStatics.skipComments(Lex, Tok);
                if (FormatFormatStatics.checkAndConsumeDirectiveWithName(Lex, new StringRef(NativePointer.$define), Tok)) {
                    int n = SourceMgr.getFileOffset(Tok.getLocation());
                    return n;
                }
            }
            int n = AfterComments;
            return n;
        }
        finally {
            if (Lex != null) {
                Lex.$destroy();
            }
            if (Env != null) {
                Env.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.setType<Replacement> fixCppIncludeInsertions(StringRef Code, std.setType<Replacement> Replaces, FormatStyle Style) {
        std.setType HeaderInsertions = null;
        std.setType Result = null;
        Regex IncludeRegex = null;
        Regex DefineRegex = null;
        IncludeCategoryManager Categories = null;
        std_map.mapIntInt CategoryEndOffsets = null;
        std.setInt Priorities = null;
        std.setType ExistingIncludes = null;
        try {
            if (Style.Language != FormatStyle.LanguageKind.LK_Cpp) {
                std.setType setType2 = new std.setType(Replaces);
                return setType2;
            }
            HeaderInsertions = new std.setType();
            for (Replacement R : Replaces) {
                if (FormatFormatStatics.isHeaderInsertion(R)) {
                    HeaderInsertions.insert_T$C$R((Object)R);
                    continue;
                }
                if (R.getOffset() != -1) continue;
                llvm.errs().$out("Insertions other than header #include insertion are not supported! ").$out(R.getReplacementText()).$out(NativePointer.$LF);
            }
            if (HeaderInsertions.empty()) {
                Iterator iterator2 = new std.setType(Replaces);
                return iterator2;
            }
            Result = new std.setType();
            std.set_difference((type.iterator)Replaces.begin(), (type.iterator)Replaces.end(), (type.iterator)HeaderInsertions.begin(), (type.iterator)HeaderInsertions.end(), (type.iterator)std.inserter((Object)Result, (type.iterator)Result.begin()));
            IncludeRegex = new Regex(new StringRef(FormatStatics.IncludeRegexPattern));
            DefineRegex = new Regex(new StringRef("^[\\t\\ ]*#[\\t\\ ]*define[\\t\\ ]*[^\\\\]*$"));
            SmallVector Matches = new SmallVector(4, (Object)new StringRef());
            StringRef FileName = ((Replacement)Replaces.begin().$arrow()).getFilePath();
            Categories = new IncludeCategoryManager(Style, new StringRef(FileName));
            CategoryEndOffsets = new std_map.mapIntInt();
            Priorities = new std.setInt(JavaDifferentiators.JD$Initializer_list$_Key_T1$C$R_T2$C$R.INSTANCE, NativePointer.new$int((int)2, (int[])new int[]{0, Integer.MAX_VALUE}));
            for (FormatStyle.IncludeCategory Category : Style.IncludeCategories) {
                Priorities.insert_T$C$R(Category.Priority);
            }
            int FirstIncludeOffset = -1;
            int MinInsertOffset = FormatFormatStatics.getOffsetAfterHeaderGuardsAndComments(new StringRef(FileName), new StringRef(Code), Style);
            StringRef TrimmedCode = Code.drop_front(MinInsertOffset);
            SmallVector Lines = new SmallVector(32, (Object)new StringRef());
            TrimmedCode.split((SmallVectorImpl)Lines, (byte)10);
            int Offset = MinInsertOffset;
            ExistingIncludes = new std.setType();
            for (StringRef Line : Lines) {
                int NextLineOffset = std.min_uint((int)Code.size(), (int)(Offset + Line.size() + 1));
                if (IncludeRegex.match(Line, (SmallVectorImpl)Matches)) {
                    StringRef IncludeName = new StringRef((StringRef)Matches.$at(2));
                    ExistingIncludes.insert_T$C$R((Object)IncludeName);
                    int Category = Categories.getIncludePriority(new StringRef(IncludeName), FirstIncludeOffset < 0);
                    CategoryEndOffsets.$set(Integer.valueOf(Category), NextLineOffset);
                    if (FirstIncludeOffset < 0) {
                        FirstIncludeOffset = Offset;
                    }
                }
                Offset = NextLineOffset;
            }
            StdSetInt.iterator Highest = Priorities.begin();
            if (CategoryEndOffsets.find(Integer.valueOf(Highest.$star())).$eq((Object)CategoryEndOffsets.end())) {
                if (FirstIncludeOffset >= 0) {
                    CategoryEndOffsets.$set(Integer.valueOf(Highest.$star()), FirstIncludeOffset);
                } else {
                    CategoryEndOffsets.$set(Integer.valueOf(Highest.$star()), MinInsertOffset);
                }
            }
            StdSetInt.iterator I = new StdSetInt.iterator(Priorities.begin().$preInc());
            StdSetInt.iterator E = Priorities.end();
            while (I.$noteq((Object)E)) {
                if (CategoryEndOffsets.find(Integer.valueOf(I.$star())).$eq((Object)CategoryEndOffsets.end())) {
                    CategoryEndOffsets.$set(Integer.valueOf(I.$star()), CategoryEndOffsets.$at_T$C$R(Integer.valueOf(((StdSetInt.iterator)std.prev((abstract_iterator)new StdSetInt.iterator(I))).$star())));
                }
                I.$preInc();
            }
            for (Replacement R : HeaderInsertions) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    StringRef IncludeDirective2 = R.getReplacementText();
                    boolean Matched = IncludeRegex.match(IncludeDirective2, (SmallVectorImpl)Matches);
                    assert (Matched) : "Header insertion replacement must have replacement text '#include ...'";
                    StringRef IncludeName = new StringRef((StringRef)Matches.$at(2));
                    if (ExistingIncludes.find((Object)IncludeName).$noteq((Object)ExistingIncludes.end())) continue;
                    int Category = Categories.getIncludePriority(new StringRef(IncludeName), true);
                    Offset = CategoryEndOffsets.$at_T$C$R(Integer.valueOf(Category));
                    std.string NewInclude = !IncludeDirective2.endswith("\n") ? llvm.$add_StringRef$C_char$ptr$C((StringRef)IncludeDirective2, (char.ptr)NativePointer.$LF).str() : IncludeDirective2.str();
                    $c$.clean((Object)Result.insert_T$RR($c$.track((Object)new Replacement(new StringRef(FileName), Offset, 0, new StringRef(NewInclude)))));
                }
                finally {
                    $c$.$destroy();
                }
            }
            Iterator iterator3 = new std.setType(JavaDifferentiators.JD$Move.INSTANCE, Result);
            return iterator3;
        }
        finally {
            if (ExistingIncludes != null) {
                ExistingIncludes.$destroy();
            }
            if (Priorities != null) {
                Priorities.$destroy();
            }
            if (CategoryEndOffsets != null) {
                CategoryEndOffsets.$destroy();
            }
            if (Categories != null) {
                Categories.$destroy();
            }
            if (DefineRegex != null) {
                DefineRegex.$destroy();
            }
            if (IncludeRegex != null) {
                IncludeRegex.$destroy();
            }
            if (Result != null) {
                Result.$destroy();
            }
            if (HeaderInsertions != null) {
                HeaderInsertions.$destroy();
            }
        }
    }

    public static FormatStyle.LanguageKind getLanguageByFileName(StringRef FileName) {
        if (FileName.endswith(".java")) {
            return FormatStyle.LanguageKind.LK_Java;
        }
        if (FileName.endswith_lower(".js") || FileName.endswith_lower(".ts")) {
            return FormatStyle.LanguageKind.LK_JavaScript;
        }
        if (FileName.endswith_lower(".proto") || FileName.endswith_lower(".protodevel")) {
            return FormatStyle.LanguageKind.LK_Proto;
        }
        if (FileName.endswith_lower(".td")) {
            return FormatStyle.LanguageKind.LK_TableGen;
        }
        return FormatStyle.LanguageKind.LK_Cpp;
    }
}

