/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clank.support.Casts;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.StringRef;
import org.llvm.support.ConvertUTFGlobals;
import org.llvm.support.sys.unicode;

public final class EncodingStatics {
    public static Encoding detectEncoding(StringRef Text) {
        char.ptr Ptr = Native.$tryClone((char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)Text.begin())));
        char.ptr BufEnd = Native.$tryClone((char.ptr)((char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)Text.end())));
        if (ConvertUTFGlobals.isLegalUTF8String((type.ptr)Ptr.$addr(), (char.ptr)BufEnd) != 0) {
            return Encoding.Encoding_UTF8;
        }
        return Encoding.Encoding_Unknown;
    }

    public static int getCodePointCountUTF8(StringRef Text) {
        int CodePoints = 0;
        int i = 0;
        int e = Text.size();
        while (Unsigned.$less_uint((int)i, (int)e)) {
            ++CodePoints;
            i += ConvertUTFGlobals.getNumBytesForUTF8((byte)Text.$at(i));
        }
        return CodePoints;
    }

    public static int getCodePointCount(StringRef Text, Encoding $Encoding) {
        switch ($Encoding) {
            case Encoding_UTF8: {
                return EncodingStatics.getCodePointCountUTF8(new StringRef(Text));
            }
        }
        return Text.size();
    }

    public static int columnWidth(StringRef Text, Encoding $Encoding) {
        int ContentWidth;
        if ($Encoding == Encoding.Encoding_UTF8 && (ContentWidth = unicode.columnWidthUTF8((StringRef)new StringRef(Text))) >= 0) {
            return ContentWidth;
        }
        return Text.size();
    }

    public static int columnWidthWithTabs(StringRef Text, int StartColumn, int TabWidth, Encoding $Encoding) {
        int TotalWidth = 0;
        StringRef Tail = new StringRef(Text);
        int TabPos;
        while ((TabPos = Tail.find((byte)9)) != StringRef.npos) {
            TotalWidth += EncodingStatics.columnWidth(Tail.substr(0, TabPos), $Encoding);
            TotalWidth += TabWidth - Unsigned.$rem_uint((int)(TotalWidth + StartColumn), (int)TabWidth);
            Tail.$assignMove(Tail.substr(TabPos + 1));
        }
        return TotalWidth + EncodingStatics.columnWidth(new StringRef(Tail), $Encoding);
    }

    public static int getCodePointNumBytes(byte FirstChar, Encoding $Encoding) {
        switch ($Encoding) {
            case Encoding_UTF8: {
                return ConvertUTFGlobals.getNumBytesForUTF8((byte)FirstChar);
            }
        }
        return 1;
    }

    public static boolean isOctDigit(byte c) {
        return 48 <= c && c <= 55;
    }

    public static boolean isHexDigit(byte c) {
        return 48 <= c && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70;
    }

    public static int getEscapeSequenceLength(StringRef Text) {
        assert (Text.$at(0) == 92);
        if (Unsigned.$less_uint((int)Text.size(), (int)2)) {
            return 1;
        }
        switch (Text.$at(1)) {
            case 117: {
                return 6;
            }
            case 85: {
                return 10;
            }
            case 120: {
                int I = 2;
                while (Unsigned.$less_uint((int)I, (int)Text.size()) && EncodingStatics.isHexDigit(Text.$at(I))) {
                    ++I;
                }
                return I;
            }
        }
        if (EncodingStatics.isOctDigit(Text.$at(1))) {
            int I = 1;
            while (Unsigned.$less_uint((int)I, (int)Text.size()) && Unsigned.$less_uint((int)I, (int)4) && EncodingStatics.isOctDigit(Text.$at(I))) {
                ++I;
            }
            return I;
        }
        return 1 + ConvertUTFGlobals.getNumBytesForUTF8((byte)Text.$at(1));
    }

    public static final class Encoding
    extends Enum<Encoding>
    implements Native.NativeUIntEnum {
        public static final /* enum */ Encoding Encoding_UTF8 = new Encoding(0);
        public static final /* enum */ Encoding Encoding_Unknown = new Encoding(Encoding_UTF8.getValue() + 1);
        private final int value;
        private static final /* synthetic */ Encoding[] $VALUES;

        public static Encoding[] values() {
            return (Encoding[])$VALUES.clone();
        }

        public static Encoding valueOf(String name) {
            return Enum.valueOf(Encoding.class, name);
        }

        public static Encoding valueOf(int val) {
            Encoding out;
            Encoding encoding = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private Encoding(int val) {
            this.value = val;
        }

        public final int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Encoding[]{Encoding_UTF8, Encoding_Unknown};
        }

        private static final class Values {
            private static final Encoding[] VALUES;
            private static final Encoding[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Encoding kind : Encoding.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Encoding[min < 0 ? 1 - min : 0];
                VALUES = new Encoding[max >= 0 ? 1 + max : 0];
                for (Encoding kind : Encoding.values()) {
                    if (kind.value < 0) {
                        if (_VALUES[-kind.value] != null) continue;
                        Values._VALUES[-((Encoding)kind).value] = kind;
                        continue;
                    }
                    if (VALUES[kind.value] != null) continue;
                    Values.VALUES[((Encoding)kind).value] = kind;
                }
            }
        }
    }
}

