/*
 * Decompiled with CFR 0.152.
 */
package org.clang.format.impl;

import org.clang.basic.CharSourceRange;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.format.impl.AnnotatedLine;
import org.clang.format.impl.FormatToken;
import org.clank.support.Destructors;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;

public class AffectedRangeManager
implements Destructors.ClassWithDestructor {
    private final SourceManager SourceMgr;
    private SmallVector<CharSourceRange> Ranges;

    public AffectedRangeManager(SourceManager SourceMgr, ArrayRef<CharSourceRange> Ranges) {
        this.SourceMgr = SourceMgr;
        this.Ranges = new SmallVector(JavaDifferentiators.JD$T.INSTANCE, 8, (type.iterator)Ranges.begin(), (type.iterator)Ranges.end(), (Object)new CharSourceRange());
    }

    public boolean computeAffectedLines(type.ptr<AnnotatedLine> I, type.ptr<AnnotatedLine> E) {
        boolean SomeLineAffected = false;
        AnnotatedLine PreviousLine = null;
        while (Native.$noteq_ptr(I, E)) {
            AnnotatedLine Line = (AnnotatedLine)I.$star();
            Line.LeadingEmptyLinesAffected = this.affectsLeadingEmptyLines(Line.First);
            if (Line.InPPDirective) {
                FormatToken Last = Line.Last;
                type.ptr PPEnd = (type.ptr)Native.$tryClone((NativeCloneable)I.$add(1));
                while (Native.$noteq_ptr((void.ptr)PPEnd, E) && !((AnnotatedLine)PPEnd.$star()).First.HasUnescapedNewline) {
                    Last = ((AnnotatedLine)PPEnd.$star()).Last;
                    PPEnd.$preInc();
                }
                if (this.affectsTokenRange(Line.First, Last, false)) {
                    SomeLineAffected = true;
                    this.markAllAsAffected((type.ptr<AnnotatedLine>)I, (type.ptr<AnnotatedLine>)PPEnd);
                }
                I = (type.ptr)Native.$tryClone((NativeCloneable)PPEnd);
                continue;
            }
            if (this.nonPPLineAffected(Line, PreviousLine)) {
                SomeLineAffected = true;
            }
            PreviousLine = Line;
            I.$preInc();
        }
        return SomeLineAffected;
    }

    public boolean affectsCharSourceRange(CharSourceRange Range2) {
        type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)this.Ranges.begin$Const());
        type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)this.Ranges.end$Const());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            if (!this.SourceMgr.isBeforeInTranslationUnit(Range2.getEnd(), ((CharSourceRange)I.$star()).getBegin()) && !this.SourceMgr.isBeforeInTranslationUnit(((CharSourceRange)I.$star()).getEnd(), Range2.getBegin())) {
                return true;
            }
            I.$preInc();
        }
        return false;
    }

    private boolean affectsTokenRange(FormatToken First, FormatToken Last, boolean IncludeLeadingNewlines) {
        SourceLocation Start = First.WhitespaceRange.getBegin();
        if (!IncludeLeadingNewlines) {
            Start.$assignMove(Start.getLocWithOffset(First.LastNewlineOffset));
        }
        SourceLocation End = Last.getStartOfNonWhitespace();
        End.$assignMove(End.getLocWithOffset(Last.TokenText.size()));
        CharSourceRange Range2 = CharSourceRange.getCharRange((SourceLocation)Start, (SourceLocation)End);
        return this.affectsCharSourceRange(Range2);
    }

    private boolean affectsLeadingEmptyLines(FormatToken Tok) {
        CharSourceRange EmptyLineRange = CharSourceRange.getCharRange((SourceLocation)Tok.WhitespaceRange.getBegin(), (SourceLocation)Tok.WhitespaceRange.getBegin().getLocWithOffset(Tok.LastNewlineOffset));
        return this.affectsCharSourceRange(EmptyLineRange);
    }

    private void markAllAsAffected(type.ptr<AnnotatedLine> I, type.ptr<AnnotatedLine> E) {
        while (Native.$noteq_ptr(I, E)) {
            ((AnnotatedLine)I.$star()).Affected = true;
            this.markAllAsAffected((type.ptr<AnnotatedLine>)((AnnotatedLine)I.$star()).Children.begin(), (type.ptr<AnnotatedLine>)((AnnotatedLine)I.$star()).Children.end());
            I.$preInc();
        }
    }

    private boolean nonPPLineAffected(AnnotatedLine Line, AnnotatedLine PreviousLine) {
        boolean IsContinuedComment;
        boolean SomeLineAffected = false;
        Line.ChildrenAffected = this.computeAffectedLines((type.ptr<AnnotatedLine>)Line.Children.begin(), (type.ptr<AnnotatedLine>)Line.Children.end());
        if (Line.ChildrenAffected) {
            SomeLineAffected = true;
        }
        boolean SomeTokenAffected = false;
        boolean IncludeLeadingNewlines = false;
        boolean SomeFirstChildAffected = false;
        FormatToken Tok = Line.First;
        while (Tok != null) {
            if (this.affectsTokenRange(Tok, Tok, IncludeLeadingNewlines)) {
                SomeTokenAffected = true;
            }
            if (!Tok.Children.empty() && ((AnnotatedLine)Tok.Children.front()).Affected) {
                SomeFirstChildAffected = true;
            }
            IncludeLeadingNewlines = Tok.Children.empty();
            Tok = Tok.Next;
        }
        boolean LineMoved = PreviousLine != null && PreviousLine.Affected && Line.First.NewlinesBefore == 0;
        boolean bl = IsContinuedComment = Line.First.is_TokenKind('\u0004') && Line.First.Next == null && Unsigned.$less_uint((int)Line.First.NewlinesBefore, (int)2) && PreviousLine != null && PreviousLine.Affected && PreviousLine.Last.is_TokenKind('\u0004');
        if (SomeTokenAffected || SomeFirstChildAffected || LineMoved || IsContinuedComment) {
            Line.Affected = true;
            SomeLineAffected = true;
        }
        return SomeLineAffected;
    }

    public void $destroy() {
        this.Ranges.$destroy();
    }

    public String toString() {
        return "SourceMgr=[SourceManager], Ranges=" + this.Ranges;
    }
}

