/*
 * Decompiled with CFR 0.152.
 */
package fleet.plugins.markdown.frontend.language;

import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.plugins.markdown.frontend.language.MarkdownLanguageKt;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import noria.model.EditorSchemeGenerator;
import noria.model.components.editor.TextAttributesKey;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0000\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Keywords", "", "Lorg/intellij/markdown/IElementType;", "MarkdownColors", "", "Lnoria/model/components/editor/TextAttributesKey;", "MarkdownEditorScheme", "Lnoria/model/EditorSchemeGenerator;", "getMarkdownEditorScheme", "()Lnoria/model/EditorSchemeGenerator;", "markdownNodeHighlighter", "walker", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "fleet.plugins.markdown.frontend"})
public final class HighlighterKt {
    @NotNull
    private static final EditorSchemeGenerator MarkdownEditorScheme = new EditorSchemeGenerator(MarkdownLanguageKt.getMarkdownLanguageId().getName());
    @NotNull
    private static final Set<IElementType> Keywords;
    @NotNull
    private static final Map<IElementType, TextAttributesKey> MarkdownColors;

    @NotNull
    public static final EditorSchemeGenerator getMarkdownEditorScheme() {
        return MarkdownEditorScheme;
    }

    @Nullable
    public static final TextAttributesKey markdownNodeHighlighter(@NotNull SyntaxNode walker) {
        Intrinsics.checkNotNullParameter((Object)walker, (String)"walker");
        Object object = walker.getType();
        IElementType iElementType = object instanceof IElementType ? (IElementType)object : null;
        if (iElementType == null) {
            return null;
        }
        IElementType type = iElementType;
        if (Intrinsics.areEqual((Object)type, (Object)MarkdownTokenTypes.TEXT)) {
            SyntaxNode syntaxNode = walker.parent();
            if (Intrinsics.areEqual((Object)(syntaxNode != null ? syntaxNode.getType() : null), (Object)GFMElementTypes.STRIKETHROUGH)) {
                return MarkdownEditorScheme.getUnused();
            }
        }
        return MarkdownColors.get(type);
    }

    static {
        Object object = new IElementType[]{MarkdownTokenTypes.ATX_HEADER, MarkdownTokenTypes.SETEXT_1, MarkdownTokenTypes.SETEXT_2, MarkdownTokenTypes.BACKTICK, MarkdownTokenTypes.EMPH, GFMTokenTypes.TILDE, MarkdownTokenTypes.EXCLAMATION_MARK, MarkdownTokenTypes.LIST_BULLET, MarkdownTokenTypes.LIST_NUMBER};
        Keywords = SetsKt.setOf((Object[])object);
        Object $this$MarkdownColors_u24lambda_u240 = object = MapsKt.createMapBuilder();
        boolean bl = false;
        for (IElementType type : Keywords) {
            $this$MarkdownColors_u24lambda_u240.put(type, MarkdownEditorScheme.getKeyword());
        }
        $this$MarkdownColors_u24lambda_u240.put(MarkdownTokenTypes.TEXT, MarkdownEditorScheme.getText());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownTokenTypes.CODE_FENCE_START, MarkdownEditorScheme.getKeyword());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownTokenTypes.CODE_FENCE_END, MarkdownEditorScheme.getKeyword());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownTokenTypes.CODE_FENCE_CONTENT, MarkdownEditorScheme.getMarkupCodeBlock());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownTokenTypes.CODE_LINE, MarkdownEditorScheme.getMarkupCodeBlock());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownTokenTypes.FENCE_LANG, MarkdownEditorScheme.getCommentDoc());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownElementTypes.CODE_SPAN, MarkdownEditorScheme.getMarkupCodeBlock());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownElementTypes.STRONG, MarkdownEditorScheme.getMarkupBold());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownElementTypes.EMPH, MarkdownEditorScheme.getMarkupItalic());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownTokenTypes.HORIZONTAL_RULE, MarkdownEditorScheme.getKeyword());
        $this$MarkdownColors_u24lambda_u240.put(GFMTokenTypes.TABLE_SEPARATOR, MarkdownEditorScheme.getKeyword());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownTokenTypes.BLOCK_QUOTE, MarkdownEditorScheme.getKeyword());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownTokenTypes.LINK_TITLE, MarkdownEditorScheme.getString());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownElementTypes.LINK_LABEL, MarkdownEditorScheme.getKeyword());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownTokenTypes.AUTOLINK, MarkdownEditorScheme.getLink());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownTokenTypes.EMAIL_AUTOLINK, MarkdownEditorScheme.getLink());
        $this$MarkdownColors_u24lambda_u240.put(GFMTokenTypes.GFM_AUTOLINK, MarkdownEditorScheme.getLink());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownElementTypes.LINK_DESTINATION, MarkdownEditorScheme.getLink());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownElementTypes.HTML_BLOCK, MarkdownEditorScheme.getString());
        $this$MarkdownColors_u24lambda_u240.put(MarkdownTokenTypes.HTML_TAG, MarkdownEditorScheme.getString());
        $this$MarkdownColors_u24lambda_u240.put(GFMTokenTypes.CHECK_BOX, MarkdownEditorScheme.getConstant());
        MarkdownColors = MapsKt.build((Map)object);
    }
}

