/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.testspark.core.generation.llm;

import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.research.testspark.core.data.Report;
import org.jetbrains.research.testspark.core.data.TestCase;
import org.jetbrains.research.testspark.core.generation.llm.FeedbackCycleExecutionResult;
import org.jetbrains.research.testspark.core.generation.llm.FeedbackResponse;
import org.jetbrains.research.testspark.core.generation.llm.LLMWithFeedbackCycle;
import org.jetbrains.research.testspark.core.generation.llm.UtilsKt;
import org.jetbrains.research.testspark.core.generation.llm.network.LLMResponse;
import org.jetbrains.research.testspark.core.generation.llm.network.RequestManager;
import org.jetbrains.research.testspark.core.generation.llm.network.ResponseErrorCode;
import org.jetbrains.research.testspark.core.generation.llm.prompt.PromptSizeReductionStrategy;
import org.jetbrains.research.testspark.core.progress.CustomProgressIndicator;
import org.jetbrains.research.testspark.core.test.TestCasesCompilationResult;
import org.jetbrains.research.testspark.core.test.TestCompiler;
import org.jetbrains.research.testspark.core.test.TestsAssembler;
import org.jetbrains.research.testspark.core.test.TestsPersistentStorage;
import org.jetbrains.research.testspark.core.test.TestsPresenter;
import org.jetbrains.research.testspark.core.test.data.TestCaseGeneratedByLLM;
import org.jetbrains.research.testspark.core.test.data.TestSuiteGeneratedByLLM;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&Bu\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u001e\u0010 \u001a\u00020!2\u0016\b\u0002\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%\u0018\u00010#R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/research/testspark/core/generation/llm/LLMWithFeedbackCycle;", "", "report", "Lorg/jetbrains/research/testspark/core/data/Report;", "initialPromptMessage", "", "promptSizeReductionStrategy", "Lorg/jetbrains/research/testspark/core/generation/llm/prompt/PromptSizeReductionStrategy;", "testSuiteFilename", "packageName", "resultPath", "buildPath", "requestManager", "Lorg/jetbrains/research/testspark/core/generation/llm/network/RequestManager;", "testsAssembler", "Lorg/jetbrains/research/testspark/core/test/TestsAssembler;", "testCompiler", "Lorg/jetbrains/research/testspark/core/test/TestCompiler;", "testStorage", "Lorg/jetbrains/research/testspark/core/test/TestsPersistentStorage;", "testsPresenter", "Lorg/jetbrains/research/testspark/core/test/TestsPresenter;", "indicator", "Lorg/jetbrains/research/testspark/core/progress/CustomProgressIndicator;", "requestsCountThreshold", "", "(Lorg/jetbrains/research/testspark/core/data/Report;Ljava/lang/String;Lorg/jetbrains/research/testspark/core/generation/llm/prompt/PromptSizeReductionStrategy;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/research/testspark/core/generation/llm/network/RequestManager;Lorg/jetbrains/research/testspark/core/test/TestsAssembler;Lorg/jetbrains/research/testspark/core/test/TestCompiler;Lorg/jetbrains/research/testspark/core/test/TestsPersistentStorage;Lorg/jetbrains/research/testspark/core/test/TestsPresenter;Lorg/jetbrains/research/testspark/core/progress/CustomProgressIndicator;I)V", "log", "Lio/github/oshai/kotlinlogging/KLogger;", "isLastIteration", "", "requestsCount", "run", "Lorg/jetbrains/research/testspark/core/generation/llm/FeedbackResponse;", "onWarningCallback", "Lkotlin/Function1;", "Lorg/jetbrains/research/testspark/core/generation/llm/LLMWithFeedbackCycle$WarningType;", "", "WarningType", "core"})
public final class LLMWithFeedbackCycle {
    @NotNull
    private final Report report;
    @NotNull
    private final String initialPromptMessage;
    @NotNull
    private final PromptSizeReductionStrategy promptSizeReductionStrategy;
    @NotNull
    private final String testSuiteFilename;
    @NotNull
    private final String packageName;
    @NotNull
    private final String resultPath;
    @NotNull
    private final String buildPath;
    @NotNull
    private final RequestManager requestManager;
    @NotNull
    private final TestsAssembler testsAssembler;
    @NotNull
    private final TestCompiler testCompiler;
    @NotNull
    private final TestsPersistentStorage testStorage;
    @NotNull
    private final TestsPresenter testsPresenter;
    @NotNull
    private final CustomProgressIndicator indicator;
    private final int requestsCountThreshold;
    @NotNull
    private final KLogger log;

    public LLMWithFeedbackCycle(@NotNull Report report, @NotNull String initialPromptMessage, @NotNull PromptSizeReductionStrategy promptSizeReductionStrategy, @NotNull String testSuiteFilename, @NotNull String packageName, @NotNull String resultPath, @NotNull String buildPath, @NotNull RequestManager requestManager, @NotNull TestsAssembler testsAssembler, @NotNull TestCompiler testCompiler, @NotNull TestsPersistentStorage testStorage, @NotNull TestsPresenter testsPresenter, @NotNull CustomProgressIndicator indicator, int requestsCountThreshold) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        Intrinsics.checkNotNullParameter((Object)initialPromptMessage, (String)"initialPromptMessage");
        Intrinsics.checkNotNullParameter((Object)promptSizeReductionStrategy, (String)"promptSizeReductionStrategy");
        Intrinsics.checkNotNullParameter((Object)testSuiteFilename, (String)"testSuiteFilename");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)resultPath, (String)"resultPath");
        Intrinsics.checkNotNullParameter((Object)buildPath, (String)"buildPath");
        Intrinsics.checkNotNullParameter((Object)requestManager, (String)"requestManager");
        Intrinsics.checkNotNullParameter((Object)testsAssembler, (String)"testsAssembler");
        Intrinsics.checkNotNullParameter((Object)testCompiler, (String)"testCompiler");
        Intrinsics.checkNotNullParameter((Object)testStorage, (String)"testStorage");
        Intrinsics.checkNotNullParameter((Object)testsPresenter, (String)"testsPresenter");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.report = report;
        this.initialPromptMessage = initialPromptMessage;
        this.promptSizeReductionStrategy = promptSizeReductionStrategy;
        this.testSuiteFilename = testSuiteFilename;
        this.packageName = packageName;
        this.resultPath = resultPath;
        this.buildPath = buildPath;
        this.requestManager = requestManager;
        this.testsAssembler = testsAssembler;
        this.testCompiler = testCompiler;
        this.testStorage = testStorage;
        this.testsPresenter = testsPresenter;
        this.indicator = indicator;
        this.requestsCountThreshold = requestsCountThreshold;
        this.log = KotlinLogging.INSTANCE.logger((Function0)new Function0<Unit>(this){
            final /* synthetic */ LLMWithFeedbackCycle this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getClass();
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final FeedbackResponse run(@Nullable Function1<? super WarningType, Unit> onWarningCallback) {
        Ref.IntRef requestsCount = new Ref.IntRef();
        boolean generatedTestsArePassing = false;
        Ref.ObjectRef nextPromptMessage = new Ref.ObjectRef();
        nextPromptMessage.element = this.initialPromptMessage;
        FeedbackCycleExecutionResult executionResult = FeedbackCycleExecutionResult.OK;
        Set compilableTestCases = new LinkedHashSet();
        Ref.ObjectRef generatedTestSuite = new Ref.ObjectRef();
        block6: while (!generatedTestsArePassing) {
            int n;
            int n2 = requestsCount.element;
            requestsCount.element = n2 + 1;
            this.log.info((Function0)new Function0<Object>(requestsCount){
                final /* synthetic */ Ref.IntRef $requestsCount;
                {
                    this.$requestsCount = $requestsCount;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Iteration #" + this.$requestsCount.element + " of feedback cycle";
                }
            });
            if (this.indicator.isCanceled()) {
                executionResult = FeedbackCycleExecutionResult.CANCELED;
                break;
            }
            if (this.isLastIteration(requestsCount.element) && compilableTestCases.isEmpty()) {
                executionResult = FeedbackCycleExecutionResult.NO_COMPILABLE_TEST_CASES_GENERATED;
                break;
            }
            this.testsAssembler.clear();
            LLMResponse response = this.requestManager.request((String)nextPromptMessage.element, this.indicator, this.packageName, this.testsAssembler, false);
            switch (WhenMappings.$EnumSwitchMapping$0[response.getErrorCode().ordinal()]) {
                case 1: {
                    this.log.info((Function0)new Function0<Object>(response){
                        final /* synthetic */ LLMResponse $response;
                        {
                            this.$response = $response;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            TestSuiteGeneratedByLLM testSuiteGeneratedByLLM = this.$response.getTestSuite();
                            Intrinsics.checkNotNull((Object)testSuiteGeneratedByLLM);
                            return "Test suite generated successfully: " + testSuiteGeneratedByLLM;
                        }
                    });
                    TestSuiteGeneratedByLLM testSuiteGeneratedByLLM = response.getTestSuite();
                    Intrinsics.checkNotNull((Object)testSuiteGeneratedByLLM);
                    if (!testSuiteGeneratedByLLM.getTestCases().isEmpty()) break;
                    Function1<? super WarningType, Unit> function1 = onWarningCallback;
                    if (function1 != null) {
                        function1.invoke((Object)WarningType.NO_TEST_CASES_GENERATED);
                    }
                    nextPromptMessage.element = "You have provided an empty answer! Please answer my previous question with the same formats.";
                    continue block6;
                }
                case 2: {
                    if (this.promptSizeReductionStrategy.isReductionPossible()) {
                        nextPromptMessage.element = this.promptSizeReductionStrategy.reduceSizeAndGeneratePrompt();
                        n = requestsCount.element;
                        requestsCount.element = n + -1;
                        continue block6;
                    }
                    executionResult = FeedbackCycleExecutionResult.PROVIDED_PROMPT_TOO_LONG;
                    break block6;
                }
                case 3: {
                    nextPromptMessage.element = "You have provided an empty answer! Please, answer my previous question with the same formats";
                    continue block6;
                }
                case 4: {
                    Function1<? super WarningType, Unit> function1 = onWarningCallback;
                    if (function1 != null) {
                        function1.invoke((Object)WarningType.TEST_SUITE_PARSING_FAILED);
                    }
                    this.log.info((Function0)new Function0<Object>(response){
                        final /* synthetic */ LLMResponse $response;
                        {
                            this.$response = $response;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return "Cannot parse a test suite from the LLM response. LLM response: '" + this.$response + "'";
                        }
                    });
                    nextPromptMessage.element = "The provided code is not parsable. Please, generate the correct code";
                    continue block6;
                }
            }
            generatedTestSuite.element = response.getTestSuite();
            if (this.indicator.isCanceled()) {
                executionResult = FeedbackCycleExecutionResult.CANCELED;
                break;
            }
            List generatedTestCasesPaths = new ArrayList();
            if (this.isLastIteration(requestsCount.element)) {
                ((TestSuiteGeneratedByLLM)generatedTestSuite.element).updateTestCases(CollectionsKt.toMutableList((Collection)compilableTestCases));
            } else {
                n = ((TestSuiteGeneratedByLLM)generatedTestSuite.element).getTestCases().size();
                for (int testCaseIndex = 0; testCaseIndex < n; ++testCaseIndex) {
                    String testCaseFilename = UtilsKt.getClassWithTestCaseName(((TestSuiteGeneratedByLLM)generatedTestSuite.element).getTestCases().get(testCaseIndex).getName()) + ".java";
                    String testCaseRepresentation = this.testsPresenter.representTestCase((TestSuiteGeneratedByLLM)generatedTestSuite.element, testCaseIndex);
                    String saveFilepath = this.testStorage.saveGeneratedTest(((TestSuiteGeneratedByLLM)generatedTestSuite.element).getPackageString(), testCaseRepresentation, this.resultPath, testCaseFilename);
                    generatedTestCasesPaths.add(saveFilepath);
                }
            }
            String generatedTestSuitePath = this.testStorage.saveGeneratedTest(((TestSuiteGeneratedByLLM)generatedTestSuite.element).getPackageString(), this.testsPresenter.representTestSuite((TestSuiteGeneratedByLLM)generatedTestSuite.element), this.resultPath, this.testSuiteFilename);
            boolean allFilesCreated = true;
            for (String path : generatedTestCasesPaths) {
                allFilesCreated = allFilesCreated && new File(path).exists();
            }
            if (!allFilesCreated || !new File(generatedTestSuitePath).exists()) {
                executionResult = FeedbackCycleExecutionResult.SAVING_TEST_FILES_ISSUE;
                break;
            }
            List<TestCaseGeneratedByLLM> testCases = !this.isLastIteration(requestsCount.element) ? ((TestSuiteGeneratedByLLM)generatedTestSuite.element).getTestCases() : CollectionsKt.toMutableList((Collection)compilableTestCases);
            this.indicator.setText("Compilation tests checking");
            TestCasesCompilationResult testCasesCompilationResult = this.testCompiler.compileTestCases(generatedTestCasesPaths, this.buildPath, testCases);
            String string = new File(generatedTestSuitePath).getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            Pair<Boolean, String> testSuiteCompilationResult = this.testCompiler.compileCode(string, this.buildPath);
            compilableTestCases.addAll((Collection)testCasesCompilationResult.getCompilableTestCases());
            if (!testCasesCompilationResult.getAllTestCasesCompilable() && !this.isLastIteration(requestsCount.element)) {
                this.log.info((Function0)new Function0<Object>(this, (Ref.ObjectRef<TestSuiteGeneratedByLLM>)generatedTestSuite){
                    final /* synthetic */ LLMWithFeedbackCycle this$0;
                    final /* synthetic */ Ref.ObjectRef<TestSuiteGeneratedByLLM> $generatedTestSuite;
                    {
                        this.this$0 = $receiver;
                        this.$generatedTestSuite = $generatedTestSuite;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        TestsPresenter testsPresenter = LLMWithFeedbackCycle.access$getTestsPresenter$p(this.this$0);
                        Object object = this.$generatedTestSuite.element;
                        Intrinsics.checkNotNull((Object)object);
                        return "Non-compilable test suite: \n" + testsPresenter.representTestSuite((TestSuiteGeneratedByLLM)object);
                    }
                });
                Function1<? super WarningType, Unit> function1 = onWarningCallback;
                if (function1 != null) {
                    function1.invoke((Object)WarningType.COMPILATION_ERROR_OCCURRED);
                }
                nextPromptMessage.element = "I cannot compile the tests that you provided. The error is:\n" + testSuiteCompilationResult.getSecond() + "\n Fix this issue in the provided tests.\nGenerate public classes and public methods. Response only a code with tests between ```, do not provide any other text.";
                this.log.info((Function0)new Function0<Object>((Ref.ObjectRef<String>)nextPromptMessage){
                    final /* synthetic */ Ref.ObjectRef<String> $nextPromptMessage;
                    {
                        this.$nextPromptMessage = $nextPromptMessage;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return this.$nextPromptMessage.element;
                    }
                });
                continue;
            }
            this.log.info((Function0)run.6.INSTANCE);
            generatedTestsArePassing = true;
            int n3 = testCases.size();
            for (int index = 0; index < n3; ++index) {
                Integer n4 = index;
                ((Map)this.report.getTestCaseList()).put(n4, new TestCase(index, testCases.get(index).getName(), testCases.get(index).toString(), SetsKt.emptySet()));
            }
        }
        if (executionResult != FeedbackCycleExecutionResult.OK) {
            generatedTestSuite.element = null;
        }
        return new FeedbackResponse(executionResult, (TestSuiteGeneratedByLLM)generatedTestSuite.element, compilableTestCases);
    }

    public static /* synthetic */ FeedbackResponse run$default(LLMWithFeedbackCycle lLMWithFeedbackCycle, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return lLMWithFeedbackCycle.run((Function1<? super WarningType, Unit>)function1);
    }

    private final boolean isLastIteration(int requestsCount) {
        return requestsCount > this.requestsCountThreshold;
    }

    public static final /* synthetic */ TestsPresenter access$getTestsPresenter$p(LLMWithFeedbackCycle $this) {
        return $this.testsPresenter;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/research/testspark/core/generation/llm/LLMWithFeedbackCycle$WarningType;", "", "(Ljava/lang/String;I)V", "TEST_SUITE_PARSING_FAILED", "NO_TEST_CASES_GENERATED", "COMPILATION_ERROR_OCCURRED", "core"})
    public static final class WarningType
    extends Enum<WarningType> {
        public static final /* enum */ WarningType TEST_SUITE_PARSING_FAILED = new WarningType();
        public static final /* enum */ WarningType NO_TEST_CASES_GENERATED = new WarningType();
        public static final /* enum */ WarningType COMPILATION_ERROR_OCCURRED = new WarningType();
        private static final /* synthetic */ WarningType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static WarningType[] values() {
            return (WarningType[])$VALUES.clone();
        }

        public static WarningType valueOf(String value) {
            return Enum.valueOf(WarningType.class, value);
        }

        @NotNull
        public static EnumEntries<WarningType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = warningTypeArray = new WarningType[]{WarningType.TEST_SUITE_PARSING_FAILED, WarningType.NO_TEST_CASES_GENERATED, WarningType.COMPILATION_ERROR_OCCURRED};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResponseErrorCode.values().length];
            try {
                nArray[ResponseErrorCode.OK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseErrorCode.PROMPT_TOO_LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseErrorCode.EMPTY_LLM_RESPONSE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResponseErrorCode.TEST_SUITE_PARSING_FAILURE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

