/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.ui.internal;

import fleet.compose.theme.util.RoundingKt;
import fleet.frontend.ui.internal.MetricStats;
import java.math.RoundingMode;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lfleet/frontend/ui/internal/StatsCalculator;", "", "()V", "metrics", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lfleet/frontend/ui/internal/StatsCalculator$Metric;", "handle", "Lfleet/frontend/ui/internal/MetricStats;", "name", "value", "", "reset", "", "Metric", "fleet.frontend.ui"})
@SourceDebugExtension(value={"SMAP\nActionLatencyWidget.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionLatencyWidget.kt\nfleet/frontend/ui/internal/StatsCalculator\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n72#2,2:159\n1#3:161\n*S KotlinDebug\n*F\n+ 1 ActionLatencyWidget.kt\nfleet/frontend/ui/internal/StatsCalculator\n*L\n121#1:159,2\n121#1:161\n*E\n"})
final class StatsCalculator {
    @NotNull
    public static final StatsCalculator INSTANCE = new StatsCalculator();
    @NotNull
    private static final ConcurrentHashMap<String, Metric> metrics = new ConcurrentHashMap();

    private StatsCalculator() {
    }

    public final void reset() {
        metrics.clear();
    }

    @NotNull
    public final MetricStats handle(@NotNull String name, double value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ConcurrentMap $this$getOrPut$iv = metrics;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(name);
        if (object == null) {
            boolean bl = false;
            Metric default$iv = new Metric(name);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(name, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Metric metric = (Metric)object;
        return metric.handle(value);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lfleet/frontend/ui/internal/StatsCalculator$Metric;", "", "name", "", "(Ljava/lang/String;)V", "acc", "", "avg", "max", "maxCount", "min", "getName", "()Ljava/lang/String;", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "handle", "Lfleet/frontend/ui/internal/MetricStats;", "value", "", "fleet.frontend.ui"})
    private static final class Metric {
        @NotNull
        private final String name;
        private final int maxCount;
        private int min;
        private int max;
        private int avg;
        @NotNull
        private final ConcurrentLinkedQueue<Integer> queue;
        private int acc;

        public Metric(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.maxCount = 200;
            this.min = Integer.MAX_VALUE;
            this.max = Integer.MIN_VALUE;
            this.queue = new ConcurrentLinkedQueue();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final MetricStats handle(double value) {
            int ivalue = RoundingKt.round((double)value, (RoundingMode)RoundingMode.HALF_EVEN);
            if (this.queue.add(ivalue)) {
                this.acc += ivalue;
                if (ivalue < this.min) {
                    this.min = ivalue;
                }
                if (ivalue > this.max) {
                    this.max = ivalue;
                }
                if (this.maxCount < this.queue.size()) {
                    Integer valueToRemove = (Integer)this.queue.remove();
                    Intrinsics.checkNotNull((Object)valueToRemove);
                    this.acc -= valueToRemove.intValue();
                    int n = ivalue;
                    if (valueToRemove != n) {
                        n = this.min;
                        if (valueToRemove == n) {
                            Comparable comparable = CollectionsKt.minOrThrow((Iterable)this.queue);
                            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"min(...)");
                            this.min = ((Number)((Object)comparable)).intValue();
                        }
                        n = this.max;
                        if (valueToRemove == n) {
                            Comparable comparable = CollectionsKt.maxOrThrow((Iterable)this.queue);
                            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"max(...)");
                            this.max = ((Number)((Object)comparable)).intValue();
                        }
                    }
                }
                this.avg = this.acc / this.queue.size();
            }
            return new MetricStats(this.name, this.min, this.avg, this.max);
        }
    }
}

