/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.ui;

import com.jetbrains.rhizomedb.ChangeScope;
import com.jetbrains.rhizomedb.EntitiesKt;
import fleet.common.settings.SettingsEntityKt;
import fleet.common.settings.SettingsKey;
import fleet.dock.api.DockExit;
import fleet.frontend.FleetFrontendSettingsKeys;
import fleet.frontend.ui.CloseInterceptor;
import fleet.frontend.ui.CloseInterceptorResult;
import fleet.frontend.ui.CloseType;
import fleet.frontend.ui.QuitHandlerKt;
import fleet.frontend.ui.SafeQuitInterceptor;
import fleet.frontend.ui.SafeQuitInterceptorEntity;
import fleet.frontend.ui.SafeQuitInterceptorKt;
import fleet.kernel.plugins.PluginScope;
import fleet.util.logging.KLogger;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\r\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0016J\r\u0010\u0017\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0018R\u0016\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0019"}, d2={"Lfleet/frontend/ui/SafeQuitInterceptor;", "Lfleet/frontend/ui/CloseInterceptor;", "pluginScope", "Lfleet/kernel/plugins/PluginScope;", "(Lfleet/kernel/plugins/PluginScope;)V", "lastQuitPressed", "Lkotlin/time/Duration;", "J", "logger", "Lfleet/util/logging/KLogger;", "getLogger", "()Lfleet/util/logging/KLogger;", "logger$delegate", "Lkotlin/Lazy;", "quitting", "", "handle", "Lfleet/frontend/ui/CloseInterceptorResult;", "close", "Lkotlin/Function0;", "", "processQuitPressed", "processQuitPressed$fleet_frontend_ui", "waitsForSafeQuit", "waitsForSafeQuit$fleet_frontend_ui", "fleet.frontend.ui"})
@SourceDebugExtension(value={"SMAP\nSafeQuitInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SafeQuitInterceptor.kt\nfleet/frontend/ui/SafeQuitInterceptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,123:1\n1726#2,3:124\n9#3,2:127\n9#3,2:129\n9#3,2:131\n9#3,2:133\n9#3,2:135\n*S KotlinDebug\n*F\n+ 1 SafeQuitInterceptor.kt\nfleet/frontend/ui/SafeQuitInterceptor\n*L\n81#1:124,3\n82#1:127,2\n86#1:129,2\n96#1:131,2\n110#1:133,2\n115#1:135,2\n*E\n"})
public final class SafeQuitInterceptor
implements CloseInterceptor {
    @NotNull
    private final PluginScope pluginScope;
    @NotNull
    private final Lazy logger$delegate;
    private volatile boolean quitting;
    private long lastQuitPressed;

    public SafeQuitInterceptor(@NotNull PluginScope pluginScope) {
        Intrinsics.checkNotNullParameter((Object)pluginScope, (String)"pluginScope");
        this.pluginScope = pluginScope;
        this.logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
        this.lastQuitPressed = Duration.Companion.getZERO-UwyO8pc();
    }

    private final KLogger getLogger() {
        Lazy lazy = this.logger$delegate;
        return (KLogger)lazy.getValue();
    }

    public final void processQuitPressed$fleet_frontend_ui() {
        if (((Boolean)SettingsEntityKt.querySettingsKey$default((SettingsKey)FleetFrontendSettingsKeys.INSTANCE.getSafeQuitting(), null, null, (int)6, null)).booleanValue()) {
            long now = DurationKt.toDuration((long)System.nanoTime(), (DurationUnit)DurationUnit.NANOSECONDS);
            long delta = Duration.minus-LRDsOJo((long)now, (long)this.lastQuitPressed);
            if (Duration.compareTo-LRDsOJo((long)delta, (long)SafeQuitInterceptorKt.getSAFE_QUIT_HANDLER_DELAY_MILLIS()) < 0) {
                boolean bl;
                DockExit dockExit;
                block12: {
                    this.quitting = true;
                    CoroutineContext.Element element = this.pluginScope.getCoroutineContext().get((CoroutineContext.Key)DockExit.Companion);
                    Intrinsics.checkNotNull((Object)element);
                    dockExit = (DockExit)element;
                    Iterable $this$all$iv = QuitHandlerKt.sortedInterceptors(CloseType.APPLICATION);
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            CloseInterceptor it = (CloseInterceptor)element$iv;
                            boolean bl2 = false;
                            if (it.handle((Function0<Unit>)((Function0)new Function0<Unit>((Object)dockExit){

                                public final void invoke() {
                                    ((DockExit)this.receiver).quit();
                                }
                            })) == CloseInterceptorResult.CONTINUE) continue;
                            bl = false;
                            break block12;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    this_$iv = this.getLogger();
                    $i$f$debug = false;
                    if (this_$iv.isDebugEnabled()) {
                        KLogger kLogger = this_$iv;
                        boolean bl3 = false;
                        kLogger.debug((Object)"Quitting (double \u2318Q)...");
                    }
                    dockExit.quit();
                } else {
                    this_$iv = this.getLogger();
                    $i$f$debug = false;
                    if (this_$iv.isDebugEnabled()) {
                        KLogger kLogger = this_$iv;
                        boolean bl4 = false;
                        kLogger.debug((Object)"Quit request ignored because other interceptors block (double \u2318Q)...");
                    }
                }
            } else {
                this.quitting = false;
            }
            this.lastQuitPressed = now;
        } else {
            this.quitting = true;
            KLogger this_$iv = this.getLogger();
            boolean $i$f$debug = false;
            if (this_$iv.isDebugEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.debug((Object)"Scheduling quit on \u2318Q...");
            }
        }
    }

    @Override
    @NotNull
    public CloseInterceptorResult handle(@NotNull Function0<Unit> close) {
        CloseInterceptorResult closeInterceptorResult;
        Intrinsics.checkNotNullParameter(close, (String)"close");
        SafeQuitInterceptorEntity stateEntity = (SafeQuitInterceptorEntity)EntitiesKt.singleton((KClass)Reflection.getOrCreateKotlinClass(SafeQuitInterceptorEntity.class));
        long now = DurationKt.toDuration((long)System.nanoTime(), (DurationUnit)DurationUnit.NANOSECONDS);
        this.pluginScope.changeAsync((Function1)new Function1<ChangeScope, Unit>(stateEntity, now){
            final /* synthetic */ SafeQuitInterceptorEntity $stateEntity;
            final /* synthetic */ long $now;
            {
                this.$stateEntity = $stateEntity;
                this.$now = $now;
                super(1);
            }

            public final void invoke(@NotNull ChangeScope $this$changeAsync) {
                Intrinsics.checkNotNullParameter((Object)$this$changeAsync, (String)"$this$changeAsync");
                this.$stateEntity.setLastHandled-LRDsOJo(this.$now);
            }
        });
        long delta = Duration.minus-LRDsOJo((long)DurationKt.toDuration((long)System.nanoTime(), (DurationUnit)DurationUnit.NANOSECONDS), (long)this.lastQuitPressed);
        if (this.quitting) {
            KLogger this_$iv = this.getLogger();
            boolean $i$f$debug = false;
            if (this_$iv.isDebugEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.debug((Object)"Perform quit on previous schedule...");
            }
            closeInterceptorResult = CloseInterceptorResult.CONTINUE;
        } else if (Duration.compareTo-LRDsOJo((long)delta, (long)SafeQuitInterceptorKt.access$getNO_SHORTCUT_PRESSED_THRESHOLD_MILLIS$p()) > 0) {
            KLogger this_$iv = this.getLogger();
            boolean $i$f$debug = false;
            if (this_$iv.isDebugEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.debug((Object)"Perform quit supposedly non-shortcut quit...");
            }
            closeInterceptorResult = CloseInterceptorResult.CONTINUE;
        } else {
            closeInterceptorResult = CloseInterceptorResult.CANCEL_CLOSE;
        }
        return closeInterceptorResult;
    }

    public final boolean waitsForSafeQuit$fleet_frontend_ui() {
        return !this.quitting && Duration.compareTo-LRDsOJo((long)((SafeQuitInterceptorEntity)EntitiesKt.singleton((KClass)Reflection.getOrCreateKotlinClass(SafeQuitInterceptorEntity.class))).getLastHandled-UwyO8pc(), (long)this.lastQuitPressed) > 0;
    }
}

