/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class DiffRangeUtil {
    private DiffRangeUtil() {
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull CharSequence sequence, @NotNull LineOffsets lineOffsets, int line1, int line2) {
        if (sequence == null) {
            DiffRangeUtil.$$$reportNull$$$0(0);
        }
        if (lineOffsets == null) {
            DiffRangeUtil.$$$reportNull$$$0(1);
        }
        return DiffRangeUtil.getLinesContent(sequence, lineOffsets, line1, line2, false);
    }

    @NotNull
    public static CharSequence getLinesContent(@NotNull CharSequence sequence, @NotNull LineOffsets lineOffsets, int line1, int line2, boolean includeNewline) {
        if (sequence == null) {
            DiffRangeUtil.$$$reportNull$$$0(2);
        }
        if (lineOffsets == null) {
            DiffRangeUtil.$$$reportNull$$$0(3);
        }
        assert (sequence.length() == lineOffsets.getTextLength());
        CharSequence charSequence = DiffRangeUtil.getLinesRange(lineOffsets, line1, line2, includeNewline).subSequence(sequence);
        if (charSequence == null) {
            DiffRangeUtil.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    @NotNull
    public static TextRange getLinesRange(@NotNull LineOffsets lineOffsets, int line1, int line2, boolean includeNewline) {
        if (lineOffsets == null) {
            DiffRangeUtil.$$$reportNull$$$0(5);
        }
        if (line1 == line2) {
            int lineStartOffset = line1 < lineOffsets.getLineCount() ? lineOffsets.getLineStart(line1) : lineOffsets.getTextLength();
            return new TextRange(lineStartOffset, lineStartOffset);
        }
        int startOffset = lineOffsets.getLineStart(line1);
        int endOffset = lineOffsets.getLineEnd(line2 - 1);
        if (includeNewline && endOffset < lineOffsets.getTextLength()) {
            ++endOffset;
        }
        return new TextRange(startOffset, endOffset);
    }

    @NotNull
    public static List<String> getLines(@NotNull CharSequence text, @NonNls LineOffsets lineOffsets) {
        if (text == null) {
            DiffRangeUtil.$$$reportNull$$$0(6);
        }
        return DiffRangeUtil.getLines(text, lineOffsets, 0, lineOffsets.getLineCount());
    }

    @NotNull
    public static List<String> getLines(@NotNull CharSequence text, @NonNls LineOffsets lineOffsets, int startLine, int endLine) {
        if (text == null) {
            DiffRangeUtil.$$$reportNull$$$0(7);
        }
        if (startLine < 0 || startLine > endLine || endLine > lineOffsets.getLineCount()) {
            throw new IndexOutOfBoundsException(String.format("Wrong line range: [%d, %d); lineCount: '%d'", startLine, endLine, lineOffsets.getLineCount()));
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = startLine; i < endLine; ++i) {
            int start = lineOffsets.getLineStart(i);
            int end = lineOffsets.getLineEnd(i);
            result.add(text.subSequence(start, end).toString());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            DiffRangeUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineOffsets";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffRangeUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffRangeUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinesContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLines";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLinesContent";
                break;
            }
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLinesRange";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLines";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

