/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.MergeResolveUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.MergeRange;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.util.containers.PeekableIterator;
import com.intellij.util.containers.PeekableIteratorWrapper;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComparisonMergeUtil {
    private ComparisonMergeUtil() {
    }

    @NotNull
    public static List<MergeRange> buildSimple(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2, @NotNull CancellationChecker indicator) {
        if (fragments1 == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(0);
        }
        if (fragments2 == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(1);
        }
        if (indicator == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(2);
        }
        assert (fragments1.getLength1() == fragments2.getLength1());
        List<MergeRange> list = new FairMergeBuilder().execute(fragments1, fragments2);
        if (list == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    static List<MergeRange> buildMerge(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2, @NotNull SideEquality trueEquality, @NotNull CancellationChecker indicator) {
        if (fragments1 == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(4);
        }
        if (fragments2 == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(5);
        }
        if (trueEquality == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(7);
        }
        assert (fragments1.getLength1() == fragments2.getLength1());
        List<MergeRange> list = new FairMergeBuilder(trueEquality).execute(fragments1, fragments2);
        if (list == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public static CharSequence tryResolveConflict(@NotNull CharSequence leftText, @NotNull CharSequence baseText, @NotNull CharSequence rightText) {
        if (leftText == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(9);
        }
        if (baseText == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(10);
        }
        if (rightText == null) {
            ComparisonMergeUtil.$$$reportNull$$$0(11);
        }
        return MergeResolveUtil.tryResolve(leftText, baseText, rightText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments1";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments2";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/comparison/ComparisonMergeUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trueEquality";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftText";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseText";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/comparison/ComparisonMergeUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSimple";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildMerge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildSimple";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildMerge";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryResolveConflict";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FairMergeBuilder {
        @NotNull
        private final ChangeBuilder myChangesBuilder;

        private FairMergeBuilder() {
            this.myChangesBuilder = new ChangeBuilder();
        }

        private FairMergeBuilder(@NotNull SideEquality trueEquality) {
            if (trueEquality == null) {
                FairMergeBuilder.$$$reportNull$$$0(0);
            }
            this.myChangesBuilder = new IgnoringChangeBuilder(trueEquality);
        }

        @NotNull
        public List<MergeRange> execute(@NotNull FairDiffIterable fragments1, @NotNull FairDiffIterable fragments2) {
            if (fragments1 == null) {
                FairMergeBuilder.$$$reportNull$$$0(1);
            }
            if (fragments2 == null) {
                FairMergeBuilder.$$$reportNull$$$0(2);
            }
            PeekableIteratorWrapper unchanged1 = new PeekableIteratorWrapper(fragments1.unchanged());
            PeekableIteratorWrapper unchanged2 = new PeekableIteratorWrapper(fragments2.unchanged());
            while (unchanged1.hasNext() && unchanged2.hasNext()) {
                Side side = this.add((Range)unchanged1.peek(), (Range)unchanged2.peek());
                ((PeekableIterator)side.select(unchanged1, unchanged2)).next();
            }
            List<MergeRange> list = this.myChangesBuilder.finish(fragments1.getLength2(), fragments1.getLength1(), fragments2.getLength2());
            if (list == null) {
                FairMergeBuilder.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        private Side add(@NotNull Range range1, @NotNull Range range2) {
            if (range1 == null) {
                FairMergeBuilder.$$$reportNull$$$0(4);
            }
            if (range2 == null) {
                FairMergeBuilder.$$$reportNull$$$0(5);
            }
            int start1 = range1.start1;
            int end1 = range1.end1;
            int start2 = range2.start1;
            int end2 = range2.end1;
            if (end1 <= start2) {
                Side side = Side.LEFT;
                if (side == null) {
                    FairMergeBuilder.$$$reportNull$$$0(6);
                }
                return side;
            }
            if (end2 <= start1) {
                Side side = Side.RIGHT;
                if (side == null) {
                    FairMergeBuilder.$$$reportNull$$$0(7);
                }
                return side;
            }
            int startBase = Math.max(start1, start2);
            int endBase = Math.min(end1, end2);
            int count = endBase - startBase;
            int startShift1 = startBase - start1;
            int startShift2 = startBase - start2;
            int startLeft = range1.start2 + startShift1;
            int endLeft = startLeft + count;
            int startRight = range2.start2 + startShift2;
            int endRight = startRight + count;
            this.myChangesBuilder.markEqual(startLeft, startBase, startRight, endLeft, endBase, endRight);
            Side side = Side.fromLeft(end1 <= end2);
            if (side == null) {
                FairMergeBuilder.$$$reportNull$$$0(8);
            }
            return side;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trueEquality";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragments1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fragments2";
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/comparison/ComparisonMergeUtil$FairMergeBuilder";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range1";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/comparison/ComparisonMergeUtil$FairMergeBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "execute";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "add";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "execute";
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static interface SideEquality {
        public boolean equals(int var1, int var2, int var3);
    }

    private static final class IgnoringChangeBuilder
    extends ChangeBuilder {
        @NotNull
        private final SideEquality myTrueEquality;

        private IgnoringChangeBuilder(@NotNull SideEquality trueEquality) {
            if (trueEquality == null) {
                IgnoringChangeBuilder.$$$reportNull$$$0(0);
            }
            this.myTrueEquality = trueEquality;
        }

        @Override
        protected void processChange(int start1, int start2, int start3, int end1, int end2, int end3) {
            MergeRange lastChange = this.myChanges.isEmpty() ? null : (MergeRange)this.myChanges.get(this.myChanges.size() - 1);
            int unchangedStart1 = lastChange != null ? lastChange.end1 : 0;
            int unchangedStart2 = lastChange != null ? lastChange.end2 : 0;
            int unchangedStart3 = lastChange != null ? lastChange.end3 : 0;
            this.addIgnoredChanges(unchangedStart1, unchangedStart2, unchangedStart3, start1, start2, start3);
            this.addChange(start1, start2, start3, end1, end2, end3);
        }

        private void addIgnoredChanges(int start1, int start2, int start3, int end1, int end2, int end3) {
            int count = end2 - start2;
            assert (end1 - start1 == count);
            assert (end3 - start3 == count);
            int firstIgnoredCount = -1;
            for (int i = 0; i < count; ++i) {
                boolean previousAreIgnored;
                boolean isIgnored = !this.myTrueEquality.equals(start1 + i, start2 + i, start3 + i);
                boolean bl = previousAreIgnored = firstIgnoredCount != -1;
                if (isIgnored && !previousAreIgnored) {
                    firstIgnoredCount = i;
                }
                if (isIgnored || !previousAreIgnored) continue;
                this.addChange(start1 + firstIgnoredCount, start2 + firstIgnoredCount, start3 + firstIgnoredCount, start1 + i, start2 + i, start3 + i);
                firstIgnoredCount = -1;
            }
            if (firstIgnoredCount != -1) {
                this.addChange(start1 + firstIgnoredCount, start2 + firstIgnoredCount, start3 + firstIgnoredCount, start1 + count, start2 + count, start3 + count);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trueEquality", "com/intellij/diff/comparison/ComparisonMergeUtil$IgnoringChangeBuilder", "<init>"));
        }
    }

    private static class ChangeBuilder {
        @NotNull
        protected final List<MergeRange> myChanges = new ArrayList<MergeRange>();
        private int myIndex1 = 0;
        private int myIndex2 = 0;
        private int myIndex3 = 0;

        private ChangeBuilder() {
        }

        protected void addChange(int start1, int start2, int start3, int end1, int end2, int end3) {
            if (start1 == end1 && start2 == end2 && start3 == end3) {
                return;
            }
            this.myChanges.add(new MergeRange(start1, end1, start2, end2, start3, end3));
        }

        public void markEqual(int start1, int start2, int start3, int end1, int end2, int end3) {
            assert (this.myIndex1 <= start1);
            assert (this.myIndex2 <= start2);
            assert (this.myIndex3 <= start3);
            assert (start1 <= end1);
            assert (start2 <= end2);
            assert (start3 <= end3);
            this.processChange(this.myIndex1, this.myIndex2, this.myIndex3, start1, start2, start3);
            this.myIndex1 = end1;
            this.myIndex2 = end2;
            this.myIndex3 = end3;
        }

        @NotNull
        public List<MergeRange> finish(int length1, int length2, int length3) {
            assert (this.myIndex1 <= length1);
            assert (this.myIndex2 <= length2);
            assert (this.myIndex3 <= length3);
            this.processChange(this.myIndex1, this.myIndex2, this.myIndex3, length1, length2, length3);
            List<MergeRange> list = this.myChanges;
            if (list == null) {
                ChangeBuilder.$$$reportNull$$$0(0);
            }
            return list;
        }

        protected void processChange(int start1, int start2, int start3, int end1, int end2, int end3) {
            this.addChange(start1, start2, start3, end1, end2, end3);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonMergeUtil$ChangeBuilder", "finish"));
        }
    }
}

