/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.java.parser;

import fleet.com.intellij.core.java.JavaPsiBundle;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiBuilderUtil;
import fleet.com.intellij.lang.WhitespacesBinders;
import fleet.com.intellij.lang.java.parser.BasicDeclarationParser;
import fleet.com.intellij.lang.java.parser.BasicJavaParser;
import fleet.com.intellij.lang.java.parser.BasicJavaParserUtil;
import fleet.com.intellij.lang.java.parser.BasicReferenceParser;
import fleet.com.intellij.openapi.util.Pair;
import fleet.com.intellij.pom.java.JavaFeature;
import fleet.com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import fleet.com.intellij.psi.impl.source.BasicElementTypes;
import fleet.com.intellij.psi.impl.source.WhiteSpaceAndCommentSetHolder;
import fleet.com.intellij.psi.java.JavaTokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.ILazyParseableElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicStatementParser {
    private static final TokenSet YIELD_STMT_INDICATOR_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.PLUS, JavaTokenType.MINUS, JavaTokenType.EXCL, JavaTokenType.TILDE, JavaTokenType.SUPER_KEYWORD, JavaTokenType.THIS_KEYWORD, JavaTokenType.TRUE_KEYWORD, JavaTokenType.FALSE_KEYWORD, JavaTokenType.NULL_KEYWORD, JavaTokenType.STRING_LITERAL, JavaTokenType.INTEGER_LITERAL, JavaTokenType.DOUBLE_LITERAL, JavaTokenType.FLOAT_LITERAL, JavaTokenType.LONG_LITERAL, JavaTokenType.CHARACTER_LITERAL, JavaTokenType.TEXT_BLOCK_LITERAL, JavaTokenType.IDENTIFIER, JavaTokenType.SWITCH_KEYWORD, JavaTokenType.NEW_KEYWORD, JavaTokenType.LPARENTH, JavaTokenType.RBRACE, JavaTokenType.SEMICOLON, JavaTokenType.CASE_KEYWORD});
    private static final TokenSet TRY_CLOSERS_SET = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.CATCH_KEYWORD, JavaTokenType.FINALLY_KEYWORD});
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;
    private final WhiteSpaceAndCommentSetHolder myWhiteSpaceAndCommentSetHolder = WhiteSpaceAndCommentSetHolder.INSTANCE;

    public BasicStatementParser(@NotNull BasicJavaParser javaParser) {
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(@NotNull PsiBuilder builder) {
        return this.parseCodeBlock(builder, false);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlock(@NotNull PsiBuilder builder, boolean isStatement) {
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        if (isStatement && BasicJavaParserUtil.isParseStatementCodeBlocksDeep(builder)) {
            return this.parseCodeBlockDeep(builder, false);
        }
        return PsiBuilderUtil.parseBlockLazy((PsiBuilder)builder, (IElementType)JavaTokenType.LBRACE, (IElementType)JavaTokenType.RBRACE, (IElementType)this.myJavaElementTypeContainer.CODE_BLOCK);
    }

    @Nullable
    public PsiBuilder.Marker parseCodeBlockDeep(@NotNull PsiBuilder builder, boolean parseUntilEof) {
        if (builder.getTokenType() != JavaTokenType.LBRACE) {
            return null;
        }
        PsiBuilder.Marker codeBlock = builder.mark();
        builder.advanceLexer();
        this.parseStatements(builder, parseUntilEof ? BraceMode.TILL_LAST : BraceMode.TILL_FIRST);
        boolean greedyBlock = !BasicJavaParserUtil.expectOrError(builder, JavaTokenType.RBRACE, "expected.rbrace");
        builder.getTokenType();
        BasicJavaParserUtil.done(codeBlock, this.myJavaElementTypeContainer.CODE_BLOCK, this.myWhiteSpaceAndCommentSetHolder);
        if (greedyBlock) {
            codeBlock.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return codeBlock;
    }

    public void parseStatements(@NotNull PsiBuilder builder) {
        this.parseStatements(builder, null);
    }

    private void parseStatements(PsiBuilder builder, @Nullable BraceMode braceMode) {
        while (builder.getTokenType() != null) {
            PsiBuilder.Marker statement = this.parseStatement(builder);
            if (statement != null) continue;
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.RBRACE && (braceMode == BraceMode.TILL_FIRST || braceMode == BraceMode.TILL_LAST && builder.lookAhead(1) == null)) break;
            PsiBuilder.Marker error = builder.mark();
            builder.advanceLexer();
            if (tokenType == JavaTokenType.ELSE_KEYWORD) {
                error.error(JavaPsiBundle.message("else.without.if", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.CATCH_KEYWORD) {
                error.error(JavaPsiBundle.message("catch.without.try", new Object[0]));
                continue;
            }
            if (tokenType == JavaTokenType.FINALLY_KEYWORD) {
                error.error(JavaPsiBundle.message("finally.without.try", new Object[0]));
                continue;
            }
            error.error(JavaPsiBundle.message("unexpected.token", new Object[0]));
        }
    }

    @Nullable
    public PsiBuilder.Marker parseStatement(@NotNull PsiBuilder builder) {
        PsiBuilder.Marker statement;
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.IF_KEYWORD) {
            return this.parseIfStatement(builder);
        }
        if (tokenType == JavaTokenType.WHILE_KEYWORD) {
            return this.parseWhileStatement(builder);
        }
        if (tokenType == JavaTokenType.FOR_KEYWORD) {
            return this.parseForStatement(builder);
        }
        if (tokenType == JavaTokenType.DO_KEYWORD) {
            return this.parseDoWhileStatement(builder);
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.parseSwitchStatement(builder);
        }
        if (tokenType == JavaTokenType.CASE_KEYWORD || tokenType == JavaTokenType.DEFAULT_KEYWORD) {
            return this.parseSwitchLabelStatement(builder);
        }
        if (tokenType == JavaTokenType.BREAK_KEYWORD) {
            return this.parseBreakStatement(builder);
        }
        if (BasicStatementParser.isStmtYieldToken(builder, tokenType)) {
            return this.parseYieldStatement(builder);
        }
        if (tokenType == JavaTokenType.CONTINUE_KEYWORD) {
            return this.parseContinueStatement(builder);
        }
        if (tokenType == JavaTokenType.RETURN_KEYWORD) {
            return this.parseReturnStatement(builder);
        }
        if (tokenType == JavaTokenType.THROW_KEYWORD) {
            return this.parseThrowStatement(builder);
        }
        if (tokenType == JavaTokenType.SYNCHRONIZED_KEYWORD) {
            return this.parseSynchronizedStatement(builder);
        }
        if (tokenType == JavaTokenType.TRY_KEYWORD) {
            return this.parseTryStatement(builder);
        }
        if (tokenType == JavaTokenType.ASSERT_KEYWORD) {
            return this.parseAssertStatement(builder);
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseBlockStatement(builder);
        }
        if (tokenType instanceof ILazyParseableElementType) {
            builder.advanceLexer();
            return null;
        }
        if (tokenType == JavaTokenType.SEMICOLON) {
            PsiBuilder.Marker empty = builder.mark();
            builder.advanceLexer();
            BasicJavaParserUtil.done(empty, this.myJavaElementTypeContainer.EMPTY_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
            return empty;
        }
        if (tokenType == JavaTokenType.IDENTIFIER || tokenType == JavaTokenType.AT) {
            PsiBuilder.Marker refPos = builder.mark();
            boolean nonSealed = BasicDeclarationParser.isNonSealedToken(builder, tokenType);
            this.myParser.getDeclarationParser().parseAnnotations(builder);
            BasicStatementParser.skipQualifiedName(builder);
            IElementType current = builder.getTokenType();
            IElementType next = builder.lookAhead(1);
            refPos.rollbackTo();
            if (current == JavaTokenType.LT || current == JavaTokenType.DOT && next == JavaTokenType.AT || nonSealed) {
                PsiBuilder.Marker declStatement = builder.mark();
                if (this.myParser.getDeclarationParser().parse(builder, BasicDeclarationParser.BaseContext.CODE_BLOCK) != null) {
                    BasicJavaParserUtil.done(declStatement, this.myJavaElementTypeContainer.DECLARATION_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                    return declStatement;
                }
                BasicReferenceParser.TypeInfo type = this.myParser.getReferenceParser().parseTypeInfo(builder, 0);
                if (!(current != JavaTokenType.LT || type != null && type.isParameterized)) {
                    declStatement.rollbackTo();
                } else {
                    if (type == null || builder.getTokenType() != JavaTokenType.DOUBLE_COLON) {
                        BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                        if (type == null) {
                            builder.advanceLexer();
                        }
                        BasicJavaParserUtil.done(declStatement, this.myJavaElementTypeContainer.DECLARATION_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                        return declStatement;
                    }
                    declStatement.rollbackTo();
                }
            }
        }
        PsiBuilder.Marker pos = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr != null) {
            int count = 1;
            PsiBuilder.Marker list = expr.precede();
            PsiBuilder.Marker statement2 = list.precede();
            while (builder.getTokenType() == JavaTokenType.COMMA) {
                PsiBuilder.Marker commaPos = builder.mark();
                builder.advanceLexer();
                PsiBuilder.Marker expr1 = this.myParser.getExpressionParser().parse(builder);
                if (expr1 == null) {
                    commaPos.rollbackTo();
                    break;
                }
                commaPos.drop();
                ++count;
            }
            if (count > 1) {
                pos.drop();
                BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.EXPRESSION_LIST, this.myWhiteSpaceAndCommentSetHolder);
                BasicJavaParserUtil.semicolon(builder);
                BasicJavaParserUtil.done(statement2, this.myJavaElementTypeContainer.EXPRESSION_LIST_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                return statement2;
            }
            if (BasicJavaParserUtil.exprType(expr) != this.myJavaElementTypeContainer.REFERENCE_EXPRESSION) {
                PsiBuilderUtil.drop((PsiBuilder.Marker[])new PsiBuilder.Marker[]{list, pos});
                BasicJavaParserUtil.semicolon(builder);
                BasicJavaParserUtil.done(statement2, this.myJavaElementTypeContainer.EXPRESSION_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                return statement2;
            }
            pos.rollbackTo();
        } else {
            pos.drop();
        }
        PsiBuilder.Marker decl = this.myParser.getDeclarationParser().parse(builder, BasicDeclarationParser.BaseContext.CODE_BLOCK);
        if (decl != null) {
            statement = decl.precede();
            BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.DECLARATION_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
            return statement;
        }
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER && builder.lookAhead(1) == JavaTokenType.COLON) {
            statement = builder.mark();
            PsiBuilderUtil.advance((PsiBuilder)builder, (int)2);
            this.parseStatement(builder);
            BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.LABELED_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
            return statement;
        }
        if (expr != null) {
            statement = builder.mark();
            this.myParser.getExpressionParser().parse(builder);
            BasicJavaParserUtil.semicolon(builder);
            BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.EXPRESSION_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
            return statement;
        }
        return null;
    }

    private static boolean isStmtYieldToken(@NotNull PsiBuilder builder, IElementType tokenType) {
        if (tokenType != JavaTokenType.IDENTIFIER || !"yield".equals(builder.getTokenText()) || !JavaFeature.SWITCH_EXPRESSION.isSufficient(BasicJavaParserUtil.getLanguageLevel(builder))) {
            return false;
        }
        PsiBuilder.Marker maybeYieldStmt = builder.mark();
        builder.advanceLexer();
        IElementType tokenAfterYield = builder.getTokenType();
        if (tokenAfterYield == null || YIELD_STMT_INDICATOR_TOKENS.contains(tokenAfterYield)) {
            maybeYieldStmt.rollbackTo();
            return true;
        }
        if (JavaTokenType.PLUSPLUS.equals(tokenAfterYield) || JavaTokenType.MINUSMINUS.equals(tokenAfterYield)) {
            builder.advanceLexer();
            boolean isYieldStmt = !builder.getTokenType().equals(JavaTokenType.SEMICOLON);
            maybeYieldStmt.rollbackTo();
            return isYieldStmt;
        }
        maybeYieldStmt.rollbackTo();
        return false;
    }

    private static void skipQualifiedName(PsiBuilder builder) {
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER)) {
            return;
        }
        while (builder.getTokenType() == JavaTokenType.DOT && builder.lookAhead(1) == JavaTokenType.IDENTIFIER) {
            PsiBuilderUtil.advance((PsiBuilder)builder, (int)2);
        }
    }

    @NotNull
    private PsiBuilder.Marker parseIfStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.parseExprInParenth(builder)) {
            PsiBuilder.Marker elseStatement;
            PsiBuilder.Marker thenStatement = this.parseStatement(builder);
            if (thenStatement == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
            } else if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.ELSE_KEYWORD) && (elseStatement = this.parseStatement(builder)) == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
            }
        }
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.IF_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseWhileStatement(PsiBuilder builder) {
        return this.parseExprInParenthWithBlock(builder, this.myJavaElementTypeContainer.WHILE_STATEMENT, false);
    }

    @Contract(pure=true)
    private boolean isRecordPatternInForEach(PsiBuilder builder) {
        PsiBuilder.Marker patternStart = this.myParser.getPatternParser().preParsePattern(builder);
        if (patternStart == null) {
            return false;
        }
        if (builder.getTokenType() != JavaTokenType.LPARENTH) {
            patternStart.rollbackTo();
            return false;
        }
        builder.advanceLexer();
        int parenBalance = 1;
        while (true) {
            IElementType current;
            if ((current = builder.getTokenType()) == null) {
                patternStart.rollbackTo();
                return false;
            }
            if (current == JavaTokenType.LPARENTH) {
                ++parenBalance;
            }
            if (current == JavaTokenType.RPARENTH && --parenBalance == 0) break;
            builder.advanceLexer();
        }
        builder.advanceLexer();
        boolean isRecordPattern = builder.getTokenType() != JavaTokenType.SEMICOLON && builder.getTokenType() != JavaTokenType.DOT;
        patternStart.rollbackTo();
        return isRecordPattern;
    }

    @NotNull
    private PsiBuilder.Marker parseForStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LPARENTH)) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.lparen", new Object[0]));
            BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.FOR_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
            return statement;
        }
        if (this.isRecordPatternInForEach(builder)) {
            this.myParser.getPatternParser().parsePattern(builder);
            if (builder.getTokenType() == JavaTokenType.COLON) {
                return this.parseForEachFromColon(builder, statement, this.myJavaElementTypeContainer.FOREACH_PATTERN_STATEMENT);
            }
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.colon", new Object[0]));
            while (true) {
                IElementType tokenType;
                if ((tokenType = builder.getTokenType()) == null) {
                    BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.FOREACH_PATTERN_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                    return statement;
                }
                if (tokenType == JavaTokenType.RPARENTH) {
                    return this.parserForEachFromRparenth(builder, statement, this.myJavaElementTypeContainer.FOREACH_PATTERN_STATEMENT);
                }
                builder.advanceLexer();
            }
        }
        PsiBuilder.Marker afterParenth = builder.mark();
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder, false, false, true);
        if (param == null || BasicJavaParserUtil.exprType(param) != this.myJavaElementTypeContainer.PARAMETER || builder.getTokenType() != JavaTokenType.COLON) {
            afterParenth.rollbackTo();
            return this.parseForLoopFromInitializer(builder, statement);
        }
        afterParenth.drop();
        return this.parseForEachFromColon(builder, statement, this.myJavaElementTypeContainer.FOREACH_STATEMENT);
    }

    @NotNull
    private PsiBuilder.Marker parseForLoopFromInitializer(PsiBuilder builder, PsiBuilder.Marker statement) {
        PsiBuilder.Marker bodyStatement;
        if (this.parseStatement(builder) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
                BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.FOR_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                return statement;
            }
        } else {
            PsiBuilder.Marker expr;
            boolean missingSemicolon = false;
            if (BasicStatementParser.getLastToken(builder) != JavaTokenType.SEMICOLON) {
                missingSemicolon = !BasicJavaParserUtil.expectOrError(builder, JavaTokenType.SEMICOLON, "expected.semicolon");
            }
            missingSemicolon &= (expr = this.myParser.getExpressionParser().parse(builder)) == null;
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON)) {
                if (!missingSemicolon) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.semicolon", new Object[0]));
                }
                if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
                    BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.FOR_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                    return statement;
                }
            } else {
                this.parseForUpdateExpressions(builder);
                if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
                    BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.FOR_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
                    return statement;
                }
            }
        }
        if ((bodyStatement = this.parseStatement(builder)) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
        }
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.FOR_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    private static IElementType getLastToken(PsiBuilder builder) {
        IElementType token;
        int offset = -1;
        while (BasicElementTypes.BASIC_JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(token = builder.rawLookup(offset))) {
            --offset;
        }
        return token;
    }

    private void parseForUpdateExpressions(PsiBuilder builder) {
        PsiBuilder.Marker expressionStatement;
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null) {
            return;
        }
        if (builder.getTokenType() != JavaTokenType.COMMA) {
            expressionStatement = expr.precede();
            BasicJavaParserUtil.done(expressionStatement, this.myJavaElementTypeContainer.EXPRESSION_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        } else {
            PsiBuilder.Marker expressionList = expr.precede();
            expressionStatement = expressionList.precede();
            do {
                builder.advanceLexer();
                PsiBuilder.Marker nextExpression = this.myParser.getExpressionParser().parse(builder);
                if (nextExpression != null) continue;
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            } while (builder.getTokenType() == JavaTokenType.COMMA);
            BasicJavaParserUtil.done(expressionList, this.myJavaElementTypeContainer.EXPRESSION_LIST, this.myWhiteSpaceAndCommentSetHolder);
            BasicJavaParserUtil.done(expressionStatement, this.myJavaElementTypeContainer.EXPRESSION_LIST_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        }
        expressionStatement.setCustomEdgeTokenBinders(null, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    @NotNull
    private PsiBuilder.Marker parseForEachFromColon(PsiBuilder builder, PsiBuilder.Marker statement, IElementType foreachStatement) {
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        }
        return this.parserForEachFromRparenth(builder, statement, foreachStatement);
    }

    private PsiBuilder.Marker parserForEachFromRparenth(PsiBuilder builder, PsiBuilder.Marker statement, IElementType forEachType) {
        if (BasicJavaParserUtil.expectOrError(builder, JavaTokenType.RPARENTH, "expected.rparen") && this.parseStatement(builder) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
        }
        BasicJavaParserUtil.done(statement, forEachType, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseDoWhileStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilder.Marker body = this.parseStatement(builder);
        if (body == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.statement", new Object[0]));
        } else if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.WHILE_KEYWORD)) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.while", new Object[0]));
        } else if (this.parseExprInParenth(builder)) {
            BasicJavaParserUtil.semicolon(builder);
        }
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.DO_WHILE_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseSwitchStatement(PsiBuilder builder) {
        return this.parseExprInParenthWithBlock(builder, this.myJavaElementTypeContainer.SWITCH_STATEMENT, true);
    }

    @NotNull
    @ApiStatus.Internal
    public @NotNull Pair<// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable PsiBuilder.Marker, Boolean> parseCaseLabel(PsiBuilder builder) {
        if (builder.getTokenType() == JavaTokenType.DEFAULT_KEYWORD) {
            PsiBuilder.Marker defaultElement = builder.mark();
            builder.advanceLexer();
            BasicJavaParserUtil.done(defaultElement, this.myJavaElementTypeContainer.DEFAULT_CASE_LABEL_ELEMENT, this.myWhiteSpaceAndCommentSetHolder);
            return Pair.create((Object)defaultElement, (Object)false);
        }
        if (this.myParser.getPatternParser().isPattern(builder)) {
            PsiBuilder.Marker pattern = this.myParser.getPatternParser().parsePattern(builder);
            return Pair.create((Object)pattern, (Object)false);
        }
        return Pair.create((Object)this.myParser.getExpressionParser().parseAssignmentForbiddingLambda(builder), (Object)true);
    }

    private PsiBuilder.Marker parseSwitchLabelStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        boolean isCase = builder.getTokenType() == JavaTokenType.CASE_KEYWORD;
        builder.advanceLexer();
        if (isCase) {
            boolean patternsAllowed = JavaFeature.PATTERNS_IN_SWITCH.isSufficient(BasicJavaParserUtil.getLanguageLevel(builder));
            PsiBuilder.Marker list = builder.mark();
            do {
                Pair<PsiBuilder.Marker, Boolean> markerAndIsExpression = this.parseCaseLabel(builder);
                PsiBuilder.Marker caseLabel = (PsiBuilder.Marker)markerAndIsExpression.first;
                if (caseLabel != null) continue;
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message(patternsAllowed ? "expected.case.label.element" : "expected.expression", new Object[0]));
            } while (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.COMMA));
            BasicJavaParserUtil.done(list, this.myJavaElementTypeContainer.CASE_LABEL_ELEMENT_LIST, this.myWhiteSpaceAndCommentSetHolder);
            this.parseGuard(builder);
        }
        if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.ARROW)) {
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                body = builder.mark();
                this.parseCodeBlock(builder, true);
                body.done(this.myJavaElementTypeContainer.BLOCK_STATEMENT);
                if (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                    PsiBuilder.Marker mark = builder.mark();
                    while (builder.getTokenType() == JavaTokenType.SEMICOLON) {
                        builder.advanceLexer();
                    }
                    mark.error(JavaPsiBundle.message("expected.switch.label", new Object[0]));
                }
            } else if (builder.getTokenType() == JavaTokenType.THROW_KEYWORD) {
                this.parseThrowStatement(builder);
            } else {
                PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
                if (expr != null) {
                    body = expr.precede();
                    BasicJavaParserUtil.semicolon(builder);
                    body.done(this.myJavaElementTypeContainer.EXPRESSION_STATEMENT);
                } else {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.switch.rule", new Object[0]));
                    PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.SEMICOLON);
                }
            }
            BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.SWITCH_LABELED_RULE, this.myWhiteSpaceAndCommentSetHolder);
        } else {
            BasicJavaParserUtil.expectOrError(builder, JavaTokenType.COLON, "expected.colon.or.arrow");
            BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.SWITCH_LABEL_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        }
        return statement;
    }

    private void parseGuard(PsiBuilder builder) {
        if (builder.getTokenType() == JavaTokenType.IDENTIFIER && "when".equals(builder.getTokenText())) {
            builder.remapCurrentToken(JavaTokenType.WHEN_KEYWORD);
            builder.advanceLexer();
            PsiBuilder.Marker guardingExpression = this.myParser.getExpressionParser().parseAssignmentForbiddingLambda(builder);
            if (guardingExpression == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
        }
    }

    @NotNull
    private PsiBuilder.Marker parseBreakStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER);
        BasicJavaParserUtil.semicolon(builder);
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.BREAK_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseYieldStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.remapCurrentToken(JavaTokenType.YIELD_KEYWORD);
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            BasicJavaParserUtil.semicolon(builder);
        }
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.YIELD_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseContinueStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER);
        BasicJavaParserUtil.semicolon(builder);
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.CONTINUE_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseReturnStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        this.myParser.getExpressionParser().parse(builder);
        BasicJavaParserUtil.semicolon(builder);
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.RETURN_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseThrowStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            BasicJavaParserUtil.semicolon(builder);
        }
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.THROW_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseSynchronizedStatement(PsiBuilder builder) {
        return this.parseExprInParenthWithBlock(builder, this.myJavaElementTypeContainer.SYNCHRONIZED_STATEMENT, true);
    }

    @NotNull
    private PsiBuilder.Marker parseTryStatement(PsiBuilder builder) {
        PsiBuilder.Marker tryBlock;
        boolean hasResourceList;
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        boolean bl = hasResourceList = builder.getTokenType() == JavaTokenType.LPARENTH;
        if (hasResourceList) {
            this.myParser.getDeclarationParser().parseResourceList(builder);
        }
        if ((tryBlock = this.parseCodeBlock(builder, true)) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.lbrace", new Object[0]));
        } else if (!hasResourceList && !TRY_CLOSERS_SET.contains(builder.getTokenType())) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.catch.or.finally", new Object[0]));
        } else {
            PsiBuilder.Marker finallyBlock;
            while (builder.getTokenType() == JavaTokenType.CATCH_KEYWORD && this.parseCatchBlock(builder)) {
            }
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.FINALLY_KEYWORD) && (finallyBlock = this.parseCodeBlock(builder, true)) == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.lbrace", new Object[0]));
            }
        }
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.TRY_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    public boolean parseCatchBlock(@NotNull PsiBuilder builder) {
        assert (builder.getTokenType() == JavaTokenType.CATCH_KEYWORD) : builder.getTokenType();
        PsiBuilder.Marker section = builder.mark();
        builder.advanceLexer();
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LPARENTH)) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.lparen", new Object[0]));
            BasicJavaParserUtil.done(section, this.myJavaElementTypeContainer.CATCH_SECTION, this.myWhiteSpaceAndCommentSetHolder);
            return false;
        }
        PsiBuilder.Marker param = this.myParser.getDeclarationParser().parseParameter(builder, false, true, false);
        if (param == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.parameter", new Object[0]));
        }
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
            BasicJavaParserUtil.done(section, this.myJavaElementTypeContainer.CATCH_SECTION, this.myWhiteSpaceAndCommentSetHolder);
            return false;
        }
        PsiBuilder.Marker body = this.parseCodeBlock(builder, true);
        if (body == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.lbrace", new Object[0]));
            BasicJavaParserUtil.done(section, this.myJavaElementTypeContainer.CATCH_SECTION, this.myWhiteSpaceAndCommentSetHolder);
            return false;
        }
        BasicJavaParserUtil.done(section, this.myJavaElementTypeContainer.CATCH_SECTION, this.myWhiteSpaceAndCommentSetHolder);
        return true;
    }

    @NotNull
    private PsiBuilder.Marker parseAssertStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.myParser.getExpressionParser().parse(builder) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.boolean.expression", new Object[0]));
        } else if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.COLON) && this.myParser.getExpressionParser().parse(builder) == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
        } else {
            BasicJavaParserUtil.semicolon(builder);
        }
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.ASSERT_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    private PsiBuilder.Marker parseBlockStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        this.parseCodeBlock(builder, true);
        BasicJavaParserUtil.done(statement, this.myJavaElementTypeContainer.BLOCK_STATEMENT, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    @NotNull
    public PsiBuilder.Marker parseExprInParenthWithBlock(@NotNull PsiBuilder builder, @NotNull IElementType type, boolean block) {
        PsiBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        if (this.parseExprInParenth(builder)) {
            PsiBuilder.Marker body;
            PsiBuilder.Marker marker = body = block ? this.parseCodeBlock(builder, true) : this.parseStatement(builder);
            if (body == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message(block ? "expected.lbrace" : "expected.statement", new Object[0]));
            }
        }
        BasicJavaParserUtil.done(statement, type, this.myWhiteSpaceAndCommentSetHolder);
        return statement;
    }

    private boolean parseExprInParenth(PsiBuilder builder) {
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.LPARENTH)) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.lparen", new Object[0]));
            return false;
        }
        PsiBuilder.Marker beforeExpr = builder.mark();
        PsiBuilder.Marker expr = this.myParser.getExpressionParser().parse(builder);
        if (expr == null || builder.getTokenType() == JavaTokenType.SEMICOLON) {
            beforeExpr.rollbackTo();
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            if (builder.getTokenType() != JavaTokenType.RPARENTH) {
                return false;
            }
        } else {
            beforeExpr.drop();
            if (builder.getTokenType() != JavaTokenType.RPARENTH) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
                return false;
            }
        }
        builder.advanceLexer();
        return true;
    }

    private static enum BraceMode {
        TILL_FIRST,
        TILL_LAST;

    }
}

