/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.intellij.lang.java.parser;

import fleet.com.intellij.core.java.JavaPsiBundle;
import fleet.com.intellij.lang.PsiBuilder;
import fleet.com.intellij.lang.PsiBuilderUtil;
import fleet.com.intellij.lang.WhitespacesBinders;
import fleet.com.intellij.lang.java.parser.BasicExpressionParser;
import fleet.com.intellij.lang.java.parser.BasicJavaParser;
import fleet.com.intellij.lang.java.parser.BasicJavaParserUtil;
import fleet.com.intellij.lang.java.parser.BasicReferenceParser;
import fleet.com.intellij.psi.TokenType;
import fleet.com.intellij.psi.impl.source.AbstractBasicJavaElementTypeFactory;
import fleet.com.intellij.psi.impl.source.BasicElementTypes;
import fleet.com.intellij.psi.java.JavaTokenType;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.tree.TokenSet;
import fleet.com.intellij.util.BitUtil;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class BasicOldExpressionParser {
    static final TokenSet RELATIONAL_OPS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.LT, JavaTokenType.GT, JavaTokenType.LE, JavaTokenType.GE});
    static final TokenSet POSTFIX_OPS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.PLUSPLUS, JavaTokenType.MINUSMINUS});
    static final TokenSet PREF_ARITHMETIC_OPS = TokenSet.orSet((TokenSet[])new TokenSet[]{POSTFIX_OPS, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.PLUS, JavaTokenType.MINUS})});
    static final TokenSet PREFIX_OPS = TokenSet.orSet((TokenSet[])new TokenSet[]{PREF_ARITHMETIC_OPS, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.TILDE, JavaTokenType.EXCL})});
    static final TokenSet CONDITIONAL_OR_OPS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.OROR});
    static final TokenSet CONDITIONAL_AND_OPS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.ANDAND});
    static final TokenSet OR_OPS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.OR});
    static final TokenSet XOR_OPS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.XOR});
    static final TokenSet AND_OPS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.AND});
    static final TokenSet EQUALITY_OPS = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.EQEQ, JavaTokenType.NE});
    static final TokenSet ARGS_LIST_END = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.RPARENTH, JavaTokenType.RBRACE, JavaTokenType.RBRACKET});
    static final TokenSet ARGS_LIST_CONTINUE = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER, TokenType.BAD_CHARACTER, JavaTokenType.COMMA, JavaTokenType.INTEGER_LITERAL, JavaTokenType.STRING_LITERAL});
    static final TokenSet THIS_OR_SUPER = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.THIS_KEYWORD, JavaTokenType.SUPER_KEYWORD});
    static final TokenSet ID_OR_SUPER = TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.SUPER_KEYWORD});
    final TokenSet TYPE_START;
    private final BasicJavaParser myParser;
    private final AbstractBasicJavaElementTypeFactory.JavaElementTypeContainer myJavaElementTypeContainer;

    public BasicOldExpressionParser(@NotNull BasicJavaParser javaParser) {
        this.myParser = javaParser;
        this.myJavaElementTypeContainer = javaParser.getJavaElementTypeFactory().getContainer();
        this.TYPE_START = TokenSet.orSet((TokenSet[])new TokenSet[]{BasicElementTypes.BASIC_PRIMITIVE_TYPE_BIT_SET, TokenSet.create((IElementType[])new IElementType[]{JavaTokenType.IDENTIFIER, JavaTokenType.AT})});
    }

    @Nullable
    public PsiBuilder.Marker parse(@NotNull PsiBuilder builder) {
        return this.parseAssignment(builder);
    }

    @Nullable
    PsiBuilder.Marker parse(@NotNull PsiBuilder builder, int mode) {
        return this.parseAssignment(builder, mode);
    }

    @Nullable
    public PsiBuilder.Marker parseCaseLabel(@NotNull PsiBuilder builder) {
        return (PsiBuilder.Marker)this.myParser.getStatementParser().parseCaseLabel((PsiBuilder)builder).first;
    }

    @Nullable
    PsiBuilder.Marker parseAssignment(PsiBuilder builder) {
        return this.parseAssignment(builder, 0);
    }

    @Nullable
    PsiBuilder.Marker parseAssignment(PsiBuilder builder, int mode) {
        PsiBuilder.Marker left = this.parseConditional(builder, mode);
        if (left == null) {
            return null;
        }
        IElementType tokenType = BasicOldExpressionParser.getGtTokenType(builder);
        if (tokenType != null && BasicExpressionParser.ASSIGNMENT_OPS.contains(tokenType)) {
            PsiBuilder.Marker assignment = left.precede();
            BasicOldExpressionParser.advanceGtToken(builder, tokenType);
            PsiBuilder.Marker right = this.parse(builder);
            if (right == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            assignment.done(this.myJavaElementTypeContainer.ASSIGNMENT_EXPRESSION);
            return assignment;
        }
        return left;
    }

    @Nullable
    PsiBuilder.Marker parseConditionalAnd(PsiBuilder builder, int mode) {
        return this.parseExpression(builder, ExprType.CONDITIONAL_AND, mode);
    }

    @Nullable
    public PsiBuilder.Marker parseConditional(PsiBuilder builder, int mode) {
        PsiBuilder.Marker condition = this.parseExpression(builder, ExprType.CONDITIONAL_OR, mode);
        if (condition == null) {
            return null;
        }
        if (builder.getTokenType() != JavaTokenType.QUEST) {
            return condition;
        }
        PsiBuilder.Marker ternary = condition.precede();
        builder.advanceLexer();
        PsiBuilder.Marker truePart = this.parse(builder);
        if (truePart == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            ternary.done(this.myJavaElementTypeContainer.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        if (builder.getTokenType() != JavaTokenType.COLON) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.colon", new Object[0]));
            ternary.done(this.myJavaElementTypeContainer.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        builder.advanceLexer();
        PsiBuilder.Marker falsePart = this.parseConditional(builder, mode);
        if (falsePart == null) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            ternary.done(this.myJavaElementTypeContainer.CONDITIONAL_EXPRESSION);
            return ternary;
        }
        ternary.done(this.myJavaElementTypeContainer.CONDITIONAL_EXPRESSION);
        return ternary;
    }

    @Nullable
    private PsiBuilder.Marker parseExpression(PsiBuilder builder, ExprType type, int mode) {
        switch (type) {
            case CONDITIONAL_OR: {
                return this.parseBinary(builder, ExprType.CONDITIONAL_AND, CONDITIONAL_OR_OPS, mode);
            }
            case CONDITIONAL_AND: {
                return this.parseBinary(builder, ExprType.OR, CONDITIONAL_AND_OPS, mode);
            }
            case OR: {
                return this.parseBinary(builder, ExprType.XOR, OR_OPS, mode);
            }
            case XOR: {
                return this.parseBinary(builder, ExprType.AND, XOR_OPS, mode);
            }
            case AND: {
                return this.parseBinary(builder, ExprType.EQUALITY, AND_OPS, mode);
            }
            case EQUALITY: {
                return this.parseBinary(builder, ExprType.RELATIONAL, EQUALITY_OPS, mode);
            }
            case RELATIONAL: {
                return this.parseRelational(builder, mode);
            }
            case SHIFT: {
                return this.parseBinary(builder, ExprType.ADDITIVE, BasicExpressionParser.SHIFT_OPS, mode);
            }
            case ADDITIVE: {
                return this.parseBinary(builder, ExprType.MULTIPLICATIVE, BasicExpressionParser.ADDITIVE_OPS, mode);
            }
            case MULTIPLICATIVE: {
                return this.parseBinary(builder, ExprType.UNARY, BasicExpressionParser.MULTIPLICATIVE_OPS, mode);
            }
            case UNARY: {
                return this.parseUnary(builder, mode);
            }
            case TYPE: {
                return this.myParser.getReferenceParser().parseType(builder, 5);
            }
        }
        assert (false) : "Unexpected type: " + type;
        return null;
    }

    @Nullable
    private PsiBuilder.Marker parseBinary(PsiBuilder builder, ExprType type, TokenSet ops, int mode) {
        IElementType tokenType;
        PsiBuilder.Marker result = this.parseExpression(builder, type, mode);
        if (result == null) {
            return null;
        }
        int operandCount = 1;
        IElementType currentExprTokenType = tokenType = BasicOldExpressionParser.getGtTokenType(builder);
        while (tokenType != null && ops.contains(tokenType)) {
            BasicOldExpressionParser.advanceGtToken(builder, tokenType);
            PsiBuilder.Marker right = this.parseExpression(builder, type, mode);
            ++operandCount;
            tokenType = BasicOldExpressionParser.getGtTokenType(builder);
            if (tokenType != null && ops.contains(tokenType) && tokenType == currentExprTokenType && right != null) continue;
            result = result.precede();
            if (right == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            result.done(operandCount > 2 ? this.myJavaElementTypeContainer.POLYADIC_EXPRESSION : this.myJavaElementTypeContainer.BINARY_EXPRESSION);
            if (right == null) break;
            currentExprTokenType = tokenType;
            operandCount = 1;
        }
        return result;
    }

    @Nullable
    private PsiBuilder.Marker parseRelational(PsiBuilder builder, int mode) {
        IElementType tokenType;
        PsiBuilder.Marker left = this.parseExpression(builder, ExprType.SHIFT, mode);
        if (left == null) {
            return null;
        }
        while ((tokenType = BasicOldExpressionParser.getGtTokenType(builder)) != null) {
            boolean patternExpected;
            IElementType toCreate;
            if (RELATIONAL_OPS.contains(tokenType)) {
                toCreate = this.myJavaElementTypeContainer.BINARY_EXPRESSION;
                patternExpected = false;
            } else {
                if (tokenType != JavaTokenType.INSTANCEOF_KEYWORD) break;
                toCreate = this.myJavaElementTypeContainer.INSTANCE_OF_EXPRESSION;
                patternExpected = true;
            }
            PsiBuilder.Marker expression = left.precede();
            BasicOldExpressionParser.advanceGtToken(builder, tokenType);
            if (patternExpected) {
                if (!this.myParser.getPatternParser().isPattern(builder)) {
                    PsiBuilder.Marker type = this.parseExpression(builder, ExprType.TYPE, mode);
                    if (type == null) {
                        BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.type", new Object[0]));
                    }
                    expression.done(toCreate);
                    return expression;
                }
                this.myParser.getPatternParser().parsePrimaryPattern(builder, false);
            } else {
                PsiBuilder.Marker right = this.parseExpression(builder, ExprType.SHIFT, mode);
                if (right == null) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
                    expression.done(toCreate);
                    return expression;
                }
            }
            expression.done(toCreate);
            left = expression;
        }
        return left;
    }

    @Nullable
    private PsiBuilder.Marker parseUnary(PsiBuilder builder, int mode) {
        IElementType tokenType = builder.getTokenType();
        if (PREFIX_OPS.contains(tokenType)) {
            PsiBuilder.Marker unary = builder.mark();
            builder.advanceLexer();
            PsiBuilder.Marker operand = this.parseUnary(builder, mode);
            if (operand == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            unary.done(this.myJavaElementTypeContainer.PREFIX_EXPRESSION);
            return unary;
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker typeCast = builder.mark();
            builder.advanceLexer();
            BasicReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, 101);
            if (typeInfo == null || !PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
                typeCast.rollbackTo();
                return this.parsePostfix(builder, mode);
            }
            if (PREF_ARITHMETIC_OPS.contains(builder.getTokenType()) && !typeInfo.isPrimitive) {
                typeCast.rollbackTo();
                return this.parsePostfix(builder, mode);
            }
            PsiBuilder.Marker expr = this.parseUnary(builder, mode);
            if (expr == null) {
                if (!typeInfo.isParameterized) {
                    typeCast.rollbackTo();
                    return this.parsePostfix(builder, mode);
                }
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            typeCast.done(this.myJavaElementTypeContainer.TYPE_CAST_EXPRESSION);
            return typeCast;
        }
        if (tokenType == JavaTokenType.SWITCH_KEYWORD) {
            return this.myParser.getStatementParser().parseExprInParenthWithBlock(builder, this.myJavaElementTypeContainer.SWITCH_EXPRESSION, true);
        }
        return this.parsePostfix(builder, mode);
    }

    @Nullable
    private PsiBuilder.Marker parsePostfix(PsiBuilder builder, int mode) {
        PsiBuilder.Marker operand = this.parsePrimary(builder, null, -1, mode);
        if (operand == null) {
            return null;
        }
        while (POSTFIX_OPS.contains(builder.getTokenType())) {
            PsiBuilder.Marker postfix = operand.precede();
            builder.advanceLexer();
            postfix.done(this.myJavaElementTypeContainer.POSTFIX_EXPRESSION);
            operand = postfix;
        }
        return operand;
    }

    @Nullable
    private PsiBuilder.Marker parsePrimary(PsiBuilder builder, @Nullable BreakPoint breakPoint, int breakOffset, int mode) {
        IElementType tokenType;
        PsiBuilder.Marker startMarker = builder.mark();
        PsiBuilder.Marker expr = this.parsePrimaryExpressionStart(builder, mode);
        if (expr == null) {
            startMarker.drop();
            return null;
        }
        while (true) {
            if ((tokenType = builder.getTokenType()) == JavaTokenType.DOT) {
                PsiBuilder.Marker refExpr;
                int offset;
                PsiBuilder.Marker copy;
                PsiBuilder.Marker dotPos = builder.mark();
                int dotOffset = builder.getCurrentOffset();
                builder.advanceLexer();
                IElementType dotTokenType = builder.getTokenType();
                if (dotTokenType == JavaTokenType.AT) {
                    this.myParser.getDeclarationParser().parseAnnotations(builder);
                    dotTokenType = builder.getTokenType();
                }
                if (dotTokenType == JavaTokenType.CLASS_KEYWORD && BasicJavaParserUtil.exprType(expr) == this.myJavaElementTypeContainer.REFERENCE_EXPRESSION) {
                    if (breakPoint == BreakPoint.P1 && builder.getCurrentOffset() == breakOffset) {
                        BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                        PsiBuilderUtil.drop((PsiBuilder.Marker[])new PsiBuilder.Marker[]{startMarker, dotPos});
                        return expr;
                    }
                    copy = startMarker.precede();
                    offset = builder.getCurrentOffset();
                    startMarker.rollbackTo();
                    PsiBuilder.Marker classObjAccess = this.parseClassAccessOrMethodReference(builder);
                    if (classObjAccess == null || builder.getCurrentOffset() < offset) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P1, offset, mode);
                    }
                    startMarker = copy;
                    expr = classObjAccess;
                    continue;
                }
                if (dotTokenType == JavaTokenType.NEW_KEYWORD) {
                    dotPos.drop();
                    expr = this.parseNew(builder, expr);
                    continue;
                }
                if (dotTokenType == JavaTokenType.SUPER_KEYWORD && builder.lookAhead(1) == JavaTokenType.LPARENTH) {
                    dotPos.drop();
                    refExpr = expr.precede();
                    builder.mark().done(this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST);
                    builder.advanceLexer();
                    refExpr.done(this.myJavaElementTypeContainer.REFERENCE_EXPRESSION);
                    expr = refExpr;
                    continue;
                }
                if (dotTokenType == JavaTokenType.STRING_TEMPLATE_BEGIN || dotTokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN) {
                    dotPos.drop();
                    expr = this.parseStringTemplate(builder, expr, dotTokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN);
                    continue;
                }
                if (dotTokenType == JavaTokenType.STRING_LITERAL || dotTokenType == JavaTokenType.TEXT_BLOCK_LITERAL) {
                    dotPos.drop();
                    PsiBuilder.Marker templateExpression = expr.precede();
                    PsiBuilder.Marker literal = builder.mark();
                    builder.advanceLexer();
                    literal.done(this.myJavaElementTypeContainer.LITERAL_EXPRESSION);
                    templateExpression.done(this.myJavaElementTypeContainer.TEMPLATE_EXPRESSION);
                    expr = templateExpression;
                    continue;
                }
                if (THIS_OR_SUPER.contains(dotTokenType) && BasicJavaParserUtil.exprType(expr) == this.myJavaElementTypeContainer.REFERENCE_EXPRESSION) {
                    if (breakPoint == BreakPoint.P2 && builder.getCurrentOffset() == breakOffset) {
                        dotPos.rollbackTo();
                        startMarker.drop();
                        return expr;
                    }
                    copy = startMarker.precede();
                    offset = builder.getCurrentOffset();
                    startMarker.rollbackTo();
                    PsiBuilder.Marker ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, false, true, false, false);
                    if (ref == null || builder.getTokenType() != JavaTokenType.DOT || builder.getCurrentOffset() != dotOffset) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P2, offset, mode);
                    }
                    builder.advanceLexer();
                    if (builder.getTokenType() != dotTokenType) {
                        copy.rollbackTo();
                        return this.parsePrimary(builder, BreakPoint.P2, offset, mode);
                    }
                    builder.advanceLexer();
                    startMarker = copy;
                    expr = ref.precede();
                    expr.done(dotTokenType == JavaTokenType.THIS_KEYWORD ? this.myJavaElementTypeContainer.THIS_EXPRESSION : this.myJavaElementTypeContainer.SUPER_EXPRESSION);
                    continue;
                }
                refExpr = expr.precede();
                this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
                if (!PsiBuilderUtil.expect((PsiBuilder)builder, (TokenSet)ID_OR_SUPER)) {
                    dotPos.rollbackTo();
                    builder.advanceLexer();
                    this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                    refExpr.done(this.myJavaElementTypeContainer.REFERENCE_EXPRESSION);
                    startMarker.drop();
                    return refExpr;
                }
                dotPos.drop();
                refExpr.done(this.myJavaElementTypeContainer.REFERENCE_EXPRESSION);
                expr = refExpr;
                continue;
            }
            if (tokenType == JavaTokenType.LPARENTH) {
                if (BasicJavaParserUtil.exprType(expr) != this.myJavaElementTypeContainer.REFERENCE_EXPRESSION) {
                    startMarker.drop();
                    return expr;
                }
                PsiBuilder.Marker callExpr = expr.precede();
                this.parseArgumentList(builder);
                callExpr.done(this.myJavaElementTypeContainer.METHOD_CALL_EXPRESSION);
                expr = callExpr;
                continue;
            }
            if (tokenType != JavaTokenType.LBRACKET) break;
            if (breakPoint == BreakPoint.P4) {
                startMarker.drop();
                return expr;
            }
            builder.advanceLexer();
            if (builder.getTokenType() == JavaTokenType.RBRACKET && BasicJavaParserUtil.exprType(expr) == this.myJavaElementTypeContainer.REFERENCE_EXPRESSION) {
                int pos = builder.getCurrentOffset();
                PsiBuilder.Marker copy = startMarker.precede();
                startMarker.rollbackTo();
                PsiBuilder.Marker classObjAccess = this.parseClassAccessOrMethodReference(builder);
                if (classObjAccess == null || builder.getCurrentOffset() <= pos) {
                    copy.rollbackTo();
                    return this.parsePrimary(builder, BreakPoint.P4, -1, mode);
                }
                startMarker = copy;
                expr = classObjAccess;
                continue;
            }
            PsiBuilder.Marker arrayAccess = expr.precede();
            PsiBuilder.Marker index = this.parse(builder);
            if (index == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
                arrayAccess.done(this.myJavaElementTypeContainer.ARRAY_ACCESS_EXPRESSION);
                startMarker.drop();
                return arrayAccess;
            }
            if (builder.getTokenType() != JavaTokenType.RBRACKET) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rbracket", new Object[0]));
                arrayAccess.done(this.myJavaElementTypeContainer.ARRAY_ACCESS_EXPRESSION);
                startMarker.drop();
                return arrayAccess;
            }
            builder.advanceLexer();
            arrayAccess.done(this.myJavaElementTypeContainer.ARRAY_ACCESS_EXPRESSION);
            expr = arrayAccess;
        }
        if (tokenType == JavaTokenType.DOUBLE_COLON) {
            return this.parseMethodReference(builder, startMarker);
        }
        startMarker.drop();
        return expr;
    }

    @Nullable
    private PsiBuilder.Marker parsePrimaryExpressionStart(PsiBuilder builder, int mode) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN || tokenType == JavaTokenType.STRING_TEMPLATE_BEGIN) {
            return this.parseStringTemplate(builder, null, tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN);
        }
        if (BasicElementTypes.BASIC_ALL_LITERALS.contains(tokenType)) {
            PsiBuilder.Marker literal = builder.mark();
            builder.advanceLexer();
            literal.done(this.myJavaElementTypeContainer.LITERAL_EXPRESSION);
            return literal;
        }
        if (tokenType == JavaTokenType.LBRACE) {
            return this.parseArrayInitializer(builder);
        }
        if (tokenType == JavaTokenType.NEW_KEYWORD) {
            return this.parseNew(builder, null);
        }
        if (tokenType == JavaTokenType.LPARENTH) {
            PsiBuilder.Marker lambda;
            if (!BitUtil.isSet((int)mode, (int)1) && (lambda = this.parseLambdaAfterParenth(builder)) != null) {
                return lambda;
            }
            PsiBuilder.Marker parenth = builder.mark();
            builder.advanceLexer();
            PsiBuilder.Marker inner = this.parse(builder);
            if (inner == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
            }
            if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH) && inner != null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
            }
            parenth.done(this.myJavaElementTypeContainer.PARENTH_EXPRESSION);
            return parenth;
        }
        if (this.TYPE_START.contains(tokenType)) {
            PsiBuilder.Marker mark = builder.mark();
            BasicReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, 0);
            if (typeInfo != null) {
                PsiBuilder.Marker result;
                boolean optionalClassKeyword;
                boolean bl = optionalClassKeyword = typeInfo.isPrimitive || typeInfo.isArray;
                if ((optionalClassKeyword || !typeInfo.hasErrors && typeInfo.isParameterized) && (result = this.parseClassAccessOrMethodReference(builder, mark, optionalClassKeyword)) != null) {
                    return result;
                }
            }
            mark.rollbackTo();
        }
        PsiBuilder.Marker annotation = null;
        if (tokenType == JavaTokenType.AT) {
            annotation = this.myParser.getDeclarationParser().parseAnnotations(builder);
            tokenType = builder.getTokenType();
        }
        if (tokenType == JavaTokenType.VAR_KEYWORD) {
            tokenType = JavaTokenType.IDENTIFIER;
            builder.remapCurrentToken(tokenType);
        }
        if (tokenType == JavaTokenType.IDENTIFIER) {
            PsiBuilder.Marker refExpr;
            if (!BitUtil.isSet((int)mode, (int)1) && builder.lookAhead(1) == JavaTokenType.ARROW) {
                return this.parseLambdaExpression(builder, false);
            }
            if (annotation != null) {
                PsiBuilder.Marker refParam = annotation.precede();
                refParam.doneBefore(this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST, annotation);
                refExpr = refParam.precede();
            } else {
                refExpr = builder.mark();
                builder.mark().done(this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST);
            }
            builder.advanceLexer();
            refExpr.done(this.myJavaElementTypeContainer.REFERENCE_EXPRESSION);
            return refExpr;
        }
        if (annotation != null) {
            annotation.rollbackTo();
            tokenType = builder.getTokenType();
        }
        PsiBuilder.Marker expr = null;
        if (tokenType == JavaTokenType.LT) {
            expr = builder.mark();
            if (!this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false)) {
                expr.rollbackTo();
                return null;
            }
            tokenType = builder.getTokenType();
            if (!THIS_OR_SUPER.contains(tokenType)) {
                expr.rollbackTo();
                return null;
            }
        }
        if (THIS_OR_SUPER.contains(tokenType)) {
            if (expr == null) {
                expr = builder.mark();
                builder.mark().done(this.myJavaElementTypeContainer.REFERENCE_PARAMETER_LIST);
            }
            builder.advanceLexer();
            expr.done(builder.getTokenType() == JavaTokenType.LPARENTH ? this.myJavaElementTypeContainer.REFERENCE_EXPRESSION : (tokenType == JavaTokenType.THIS_KEYWORD ? this.myJavaElementTypeContainer.THIS_EXPRESSION : this.myJavaElementTypeContainer.SUPER_EXPRESSION));
            return expr;
        }
        return null;
    }

    @NotNull
    private PsiBuilder.Marker parseArrayInitializer(PsiBuilder builder) {
        return this.parseArrayInitializer(builder, this.myJavaElementTypeContainer.ARRAY_INITIALIZER_EXPRESSION, this::parse, "expected.expression");
    }

    @NotNull
    public PsiBuilder.Marker parseArrayInitializer(@NotNull PsiBuilder builder, @NotNull IElementType type, @NotNull Function<? super PsiBuilder, PsiBuilder.Marker> elementParser, @NotNull @PropertyKey(resourceBundle="messages.JavaPsiBundle") @NotNull @PropertyKey(resourceBundle="messages.JavaPsiBundle") String missingElementKey) {
        PsiBuilder.Marker arrayInit = builder.mark();
        builder.advanceLexer();
        boolean first = true;
        while (true) {
            if (builder.getTokenType() == JavaTokenType.RBRACE) {
                builder.advanceLexer();
                break;
            }
            if (builder.getTokenType() == null) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rbrace", new Object[0]));
                break;
            }
            if (elementParser.apply((PsiBuilder)builder) == null) {
                if (builder.getTokenType() == JavaTokenType.COMMA) {
                    if (first && builder.lookAhead(1) == JavaTokenType.RBRACE) {
                        PsiBuilderUtil.advance((PsiBuilder)builder, (int)2);
                        break;
                    }
                    builder.error(JavaPsiBundle.message(missingElementKey, new Object[0]));
                } else if (builder.getTokenType() != JavaTokenType.RBRACE) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rbrace", new Object[0]));
                    break;
                }
            }
            first = false;
            IElementType tokenType = builder.getTokenType();
            if (PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.COMMA) || tokenType == JavaTokenType.RBRACE) continue;
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.comma", new Object[0]));
        }
        arrayInit.done(type);
        return arrayInit;
    }

    private PsiBuilder.Marker parseStringTemplate(PsiBuilder builder, PsiBuilder.Marker start, boolean textBlock) {
        IElementType tokenType;
        PsiBuilder.Marker templateExpression = start == null ? builder.mark() : start.precede();
        PsiBuilder.Marker template = builder.mark();
        do {
            builder.advanceLexer();
            tokenType = builder.getTokenType();
            if (textBlock ? tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_MID || tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_END : tokenType == JavaTokenType.STRING_TEMPLATE_MID || tokenType == JavaTokenType.STRING_TEMPLATE_END) {
                this.emptyExpression(builder);
                continue;
            }
            this.parse(builder);
            tokenType = builder.getTokenType();
        } while (!textBlock ? tokenType == JavaTokenType.STRING_TEMPLATE_MID : tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_MID);
        if (textBlock ? tokenType != JavaTokenType.TEXT_BLOCK_TEMPLATE_END : tokenType != JavaTokenType.STRING_TEMPLATE_END) {
            builder.error(JavaPsiBundle.message("expected.template.fragment", new Object[0]));
        } else {
            builder.advanceLexer();
        }
        template.done(this.myJavaElementTypeContainer.TEMPLATE);
        templateExpression.done(this.myJavaElementTypeContainer.TEMPLATE_EXPRESSION);
        return templateExpression;
    }

    @NotNull
    private PsiBuilder.Marker parseNew(PsiBuilder builder, @Nullable PsiBuilder.Marker start) {
        int dimCount;
        PsiBuilder.Marker anno;
        PsiBuilder.Marker newExpr;
        block13: {
            PsiBuilder.Marker refOrType;
            newExpr = start != null ? start.precede() : builder.mark();
            builder.advanceLexer();
            this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, true);
            anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
            IElementType tokenType = builder.getTokenType();
            if (tokenType == JavaTokenType.IDENTIFIER) {
                PsiBuilderUtil.rollbackTo((PsiBuilder.Marker)anno);
                refOrType = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, true, true, true);
                if (refOrType == null) {
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                    newExpr.done(this.myJavaElementTypeContainer.NEW_EXPRESSION);
                    return newExpr;
                }
            } else if (BasicElementTypes.BASIC_PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) {
                refOrType = null;
                builder.advanceLexer();
            } else {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
                newExpr.done(this.myJavaElementTypeContainer.NEW_EXPRESSION);
                return newExpr;
            }
            if (refOrType != null && builder.getTokenType() == JavaTokenType.LPARENTH) {
                this.parseArgumentList(builder);
                if (builder.getTokenType() == JavaTokenType.LBRACE) {
                    PsiBuilder.Marker classElement = refOrType.precede();
                    this.myParser.getDeclarationParser().parseClassBodyWithBraces(builder, false, false);
                    classElement.done(this.myJavaElementTypeContainer.ANONYMOUS_CLASS);
                }
                newExpr.done(this.myJavaElementTypeContainer.NEW_EXPRESSION);
                return newExpr;
            }
            anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
            if (builder.getTokenType() != JavaTokenType.LBRACKET) {
                PsiBuilderUtil.rollbackTo((PsiBuilder.Marker)anno);
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message(refOrType == null ? "expected.lbracket" : "expected.lparen.or.lbracket", new Object[0]));
                newExpr.done(this.myJavaElementTypeContainer.NEW_EXPRESSION);
                return newExpr;
            }
            int bracketCount = 0;
            dimCount = 0;
            do {
                PsiBuilder.Marker dimExpr;
                anno = this.myParser.getDeclarationParser().parseAnnotations(builder);
                if (builder.getTokenType() != JavaTokenType.LBRACKET) break block13;
                builder.advanceLexer();
                if (bracketCount == dimCount && (dimExpr = this.parse(builder)) != null) {
                    ++dimCount;
                }
                ++bracketCount;
            } while (BasicJavaParserUtil.expectOrError(builder, JavaTokenType.RBRACKET, "expected.rbracket"));
            newExpr.done(this.myJavaElementTypeContainer.NEW_EXPRESSION);
            return newExpr;
        }
        PsiBuilderUtil.rollbackTo((PsiBuilder.Marker)anno);
        if (dimCount == 0) {
            if (builder.getTokenType() == JavaTokenType.LBRACE) {
                this.parseArrayInitializer(builder);
            } else {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.array.initializer", new Object[0]));
            }
        }
        newExpr.done(this.myJavaElementTypeContainer.NEW_EXPRESSION);
        return newExpr;
    }

    @Nullable
    private PsiBuilder.Marker parseClassAccessOrMethodReference(PsiBuilder builder) {
        PsiBuilder.Marker expr = builder.mark();
        boolean primitive = BasicElementTypes.BASIC_PRIMITIVE_TYPE_BIT_SET.contains(builder.getTokenType());
        if (this.myParser.getReferenceParser().parseType(builder, 0) == null) {
            expr.drop();
            return null;
        }
        PsiBuilder.Marker result = this.parseClassAccessOrMethodReference(builder, expr, primitive);
        if (result == null) {
            expr.rollbackTo();
        }
        return result;
    }

    @Nullable
    private PsiBuilder.Marker parseClassAccessOrMethodReference(PsiBuilder builder, PsiBuilder.Marker expr, boolean optionalClassKeyword) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType == JavaTokenType.DOT) {
            return this.parseClassObjectAccess(builder, expr, optionalClassKeyword);
        }
        if (tokenType == JavaTokenType.DOUBLE_COLON) {
            return this.parseMethodReference(builder, expr);
        }
        return null;
    }

    @Nullable
    private PsiBuilder.Marker parseClassObjectAccess(PsiBuilder builder, PsiBuilder.Marker expr, boolean optionalClassKeyword) {
        PsiBuilder.Marker mark = builder.mark();
        builder.advanceLexer();
        if (builder.getTokenType() == JavaTokenType.CLASS_KEYWORD) {
            mark.drop();
            builder.advanceLexer();
        } else {
            if (!optionalClassKeyword) {
                return null;
            }
            mark.rollbackTo();
            builder.error(JavaPsiBundle.message("class.literal.expected", new Object[0]));
        }
        expr.done(this.myJavaElementTypeContainer.CLASS_OBJECT_ACCESS_EXPRESSION);
        return expr;
    }

    @NotNull
    private PsiBuilder.Marker parseMethodReference(PsiBuilder builder, PsiBuilder.Marker start) {
        builder.advanceLexer();
        this.myParser.getReferenceParser().parseReferenceParameterList(builder, false, false);
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.IDENTIFIER) && !PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.NEW_KEYWORD)) {
            BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.identifier", new Object[0]));
        }
        start.done(this.myJavaElementTypeContainer.METHOD_REF_EXPRESSION);
        return start;
    }

    @Nullable
    private PsiBuilder.Marker parseLambdaAfterParenth(PsiBuilder builder) {
        boolean isTyped;
        boolean isLambda;
        IElementType nextToken1 = builder.lookAhead(1);
        IElementType nextToken2 = builder.lookAhead(2);
        if (nextToken1 == JavaTokenType.RPARENTH && nextToken2 == JavaTokenType.ARROW) {
            isLambda = true;
            isTyped = false;
        } else if (nextToken1 == JavaTokenType.AT || BasicElementTypes.BASIC_MODIFIER_BIT_SET.contains(nextToken1) || BasicElementTypes.BASIC_PRIMITIVE_TYPE_BIT_SET.contains(nextToken1)) {
            isLambda = true;
            isTyped = true;
        } else if (nextToken1 == JavaTokenType.IDENTIFIER) {
            if (nextToken2 == JavaTokenType.COMMA || nextToken2 == JavaTokenType.RPARENTH && builder.lookAhead(3) == JavaTokenType.ARROW) {
                isLambda = true;
                isTyped = false;
            } else if (nextToken2 == JavaTokenType.ARROW) {
                isLambda = false;
                isTyped = false;
            } else {
                IElementType t;
                boolean lambda = false;
                PsiBuilder.Marker marker = builder.mark();
                builder.advanceLexer();
                BasicReferenceParser.TypeInfo typeInfo = this.myParser.getReferenceParser().parseTypeInfo(builder, 7);
                if (typeInfo != null && ((t = builder.getTokenType()) == JavaTokenType.IDENTIFIER || t == JavaTokenType.THIS_KEYWORD || t == JavaTokenType.RPARENTH && builder.lookAhead(1) == JavaTokenType.ARROW)) {
                    lambda = true;
                }
                marker.rollbackTo();
                isLambda = lambda;
                isTyped = true;
            }
        } else {
            isLambda = false;
            isTyped = false;
        }
        return isLambda ? this.parseLambdaExpression(builder, isTyped) : null;
    }

    @Nullable
    private PsiBuilder.Marker parseLambdaExpression(PsiBuilder builder, boolean typed) {
        PsiBuilder.Marker start = builder.mark();
        this.myParser.getDeclarationParser().parseLambdaParameterList(builder, typed);
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.ARROW)) {
            start.rollbackTo();
            return null;
        }
        PsiBuilder.Marker body = builder.getTokenType() == JavaTokenType.LBRACE ? this.myParser.getStatementParser().parseCodeBlock(builder) : this.parse(builder);
        if (body == null) {
            builder.error(JavaPsiBundle.message("expected.lbrace", new Object[0]));
        }
        start.done(this.myJavaElementTypeContainer.LAMBDA_EXPRESSION);
        return start;
    }

    @NotNull
    public PsiBuilder.Marker parseArgumentList(PsiBuilder builder) {
        PsiBuilder.Marker list = builder.mark();
        builder.advanceLexer();
        boolean first = true;
        while (true) {
            IElementType tokenType = builder.getTokenType();
            if (first && (ARGS_LIST_END.contains(tokenType) || builder.eof()) || !first && !ARGS_LIST_CONTINUE.contains(tokenType)) break;
            boolean hasError = false;
            if (!first) {
                if (builder.getTokenType() == JavaTokenType.COMMA) {
                    builder.advanceLexer();
                } else {
                    hasError = true;
                    BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.comma.or.rparen", new Object[0]));
                    this.emptyExpression(builder);
                }
            }
            first = false;
            PsiBuilder.Marker arg = this.parse(builder);
            if (arg != null) continue;
            if (!hasError) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.expression", new Object[0]));
                this.emptyExpression(builder);
            }
            if (!ARGS_LIST_CONTINUE.contains(builder.getTokenType())) break;
            if (builder.getTokenType() == JavaTokenType.COMMA || builder.eof()) continue;
            builder.advanceLexer();
        }
        boolean closed = true;
        if (!PsiBuilderUtil.expect((PsiBuilder)builder, (IElementType)JavaTokenType.RPARENTH)) {
            if (first) {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.rparen", new Object[0]));
            } else {
                BasicJavaParserUtil.error(builder, JavaPsiBundle.message("expected.comma.or.rparen", new Object[0]));
            }
            closed = false;
        }
        list.done(this.myJavaElementTypeContainer.EXPRESSION_LIST);
        if (!closed) {
            list.setCustomEdgeTokenBinders(null, WhitespacesBinders.GREEDY_RIGHT_BINDER);
        }
        return list;
    }

    private void emptyExpression(PsiBuilder builder) {
        BasicJavaParserUtil.emptyElement(builder, this.myJavaElementTypeContainer.EMPTY_EXPRESSION);
    }

    @Nullable
    private static IElementType getGtTokenType(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (tokenType != JavaTokenType.GT) {
            return tokenType;
        }
        if (builder.rawLookup(1) == JavaTokenType.GT) {
            tokenType = builder.rawLookup(2) == JavaTokenType.GT ? (builder.rawLookup(3) == JavaTokenType.EQ ? JavaTokenType.GTGTGTEQ : JavaTokenType.GTGTGT) : (builder.rawLookup(2) == JavaTokenType.EQ ? JavaTokenType.GTGTEQ : JavaTokenType.GTGT);
        } else if (builder.rawLookup(1) == JavaTokenType.EQ) {
            tokenType = JavaTokenType.GE;
        }
        return tokenType;
    }

    private static void advanceGtToken(PsiBuilder builder, IElementType type) {
        PsiBuilder.Marker gtToken = builder.mark();
        if (type == JavaTokenType.GTGTGTEQ) {
            PsiBuilderUtil.advance((PsiBuilder)builder, (int)4);
        } else if (type == JavaTokenType.GTGTGT || type == JavaTokenType.GTGTEQ) {
            PsiBuilderUtil.advance((PsiBuilder)builder, (int)3);
        } else if (type == JavaTokenType.GTGT || type == JavaTokenType.GE) {
            PsiBuilderUtil.advance((PsiBuilder)builder, (int)2);
        } else {
            gtToken.drop();
            builder.advanceLexer();
            return;
        }
        gtToken.collapse(type);
    }

    private static enum ExprType {
        CONDITIONAL_OR,
        CONDITIONAL_AND,
        OR,
        XOR,
        AND,
        EQUALITY,
        RELATIONAL,
        SHIFT,
        ADDITIVE,
        MULTIPLICATIVE,
        UNARY,
        TYPE;

    }

    private static enum BreakPoint {
        P1,
        P2,
        P4;

    }
}

