/*
 * Decompiled with CFR 0.152.
 */
package fleet.language.xml;

import andel.editor.Caret;
import andel.editor.CaretPosition;
import andel.editor.EditorExtKt;
import andel.editor.MutableEditor;
import andel.editor.TransientEditor;
import andel.text.Text;
import fleet.ast.NodeAspectProvider;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.psi.xml.XmlElementType;
import fleet.com.intellij.psi.xml.XmlTokenType;
import fleet.com.jetbrains.lang.syntax.SyntaxNode;
import fleet.language.xml.XmlAstUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001e\u0010\t\u001a\u00020\u0001*\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0000\u00a8\u0006\u000b"}, d2={"canTagBeCompleted", "", "root", "Lfleet/com/jetbrains/lang/syntax/SyntaxNode;", "caret", "Landel/editor/Caret;", "leafAtCaret", "aspectProvider", "Lfleet/ast/NodeAspectProvider;", "tryTransformIntoSelfClosingTag", "Landel/editor/TransientEditor;", "fleet.plugins.xml.frontend"})
public final class XmlSlashHandlerKt {
    public static final boolean canTagBeCompleted(@NotNull SyntaxNode root, @NotNull Caret caret, @Nullable SyntaxNode leafAtCaret, @NotNull NodeAspectProvider aspectProvider) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)aspectProvider, (String)"aspectProvider");
        if (leafAtCaret == null) {
            return false;
        }
        long offset = caret.getOffset();
        if (!XmlAstUtilsKt.canEndTagBeInsertedIntoLeaf(leafAtCaret, offset)) {
            return false;
        }
        SyntaxNode syntaxNode = XmlAstUtilsKt.getTag(leafAtCaret, root, offset);
        if (syntaxNode == null) {
            return false;
        }
        SyntaxNode baseElement = syntaxNode;
        if (!XmlAstUtilsKt.isTagDeclaration(aspectProvider, baseElement)) {
            if (baseElement.getStartOffset() != offset) {
                SyntaxNode syntaxNode2 = baseElement.prevSibling();
                if (Intrinsics.areEqual((Object)(syntaxNode2 != null ? syntaxNode2.getType() : null), (Object)XmlElementType.XML_START_TAG_START)) {
                    return true;
                }
            }
            return false;
        }
        if (XmlAstUtilsKt.isClosedTag(baseElement)) {
            return false;
        }
        if (XmlAstUtilsKt.isSingletoneHtmlTag(baseElement)) {
            return false;
        }
        String string = XmlAstUtilsKt.xmlTagName(baseElement);
        if (string == null) {
            return false;
        }
        String name = string;
        return !XmlAstUtilsKt.isEndTagStart(XmlAstUtilsKt.nextToken(baseElement), name);
    }

    public static final boolean tryTransformIntoSelfClosingTag(@NotNull TransientEditor $this$tryTransformIntoSelfClosingTag, @NotNull Caret caret, @Nullable SyntaxNode leafAtCaret) {
        Intrinsics.checkNotNullParameter((Object)$this$tryTransformIntoSelfClosingTag, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        if (leafAtCaret == null) {
            return false;
        }
        long offset = caret.getOffset();
        IElementType iElementType = XmlTokenType.XML_TAG_END;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"XML_TAG_END");
        if (!XmlAstUtilsKt.isAtStartOf(leafAtCaret, offset, iElementType)) {
            return false;
        }
        Object object = leafAtCaret.parent();
        if (object == null || (object = XmlAstUtilsKt.xmlTagName(object)) == null) {
            return false;
        }
        Object name = object;
        SyntaxNode endTagStart = leafAtCaret.nextSibling();
        if (!XmlAstUtilsKt.isEndTagStart(endTagStart, (String)name)) {
            return false;
        }
        SyntaxNode syntaxNode = endTagStart;
        if (syntaxNode == null || (syntaxNode = syntaxNode.parent()) == null || (syntaxNode = syntaxNode.lastChild()) == null) {
            return false;
        }
        SyntaxNode endLeaf = syntaxNode;
        long caretPosition = $this$tryTransformIntoSelfClosingTag.getCurrentCaret().getOffset();
        $this$tryTransformIntoSelfClosingTag.getDocument().edit(Text.replaceOperation$default((Text)$this$tryTransformIntoSelfClosingTag.getDocument().getText(), (long)caretPosition, (long)endLeaf.getEndOffset(), (String)"/>", (boolean)false, (int)8, null));
        EditorExtKt.moveAllCarets((MutableEditor)((MutableEditor)$this$tryTransformIntoSelfClosingTag), (Function1)((Function1)new Function1<Caret, Caret>($this$tryTransformIntoSelfClosingTag, caretPosition){
            final /* synthetic */ TransientEditor $this_tryTransformIntoSelfClosingTag;
            final /* synthetic */ long $caretPosition;
            {
                this.$this_tryTransformIntoSelfClosingTag = $receiver;
                this.$caretPosition = $caretPosition;
                super(1);
            }

            @Nullable
            public final Caret invoke(@NotNull Caret it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getCaretId(), (Object)this.$this_tryTransformIntoSelfClosingTag.getCurrentCaret().getCaretId()) ? Caret.copy$default((Caret)it, (CaretPosition)new CaretPosition(this.$caretPosition + 1L), null, null, (int)6, null) : it;
            }
        }));
        return true;
    }
}

