/*
 * Decompiled with CFR 0.152.
 */
package fleet.git.workspace;

import com.jetbrains.fus.reporting.schema.EventId1;
import fleet.api.FileAddress;
import fleet.common.FusEntityKt;
import fleet.git.common.GitReports;
import fleet.git.workspace.GitRepositoryDiscovery;
import fleet.util.logging.KLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\n\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lfleet/git/workspace/RepositoryDiscoveryMetrics;", "", "pluginInitializationTimeMs", "", "(J)V", "discoveryStartedTimeMs", "Ljava/util/concurrent/ConcurrentHashMap;", "Lfleet/api/FileAddress;", "firstDiscoveryResultTimeMs", "workerRequestedTimeMs", "component1", "copy", "equals", "", "other", "hashCode", "", "markDiscoveryStarted", "", "workspace", "markFirstDiscoveryResult", "markWorkerRequested", "toString", "", "fleet.git.workspace"})
@SourceDebugExtension(value={"SMAP\nGitRepositoryDiscovery.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepositoryDiscovery.kt\nfleet/git/workspace/RepositoryDiscoveryMetrics\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,229:1\n5#2,2:230\n5#2,2:232\n5#2,2:234\n*S KotlinDebug\n*F\n+ 1 GitRepositoryDiscovery.kt\nfleet/git/workspace/RepositoryDiscoveryMetrics\n*L\n52#1:230,2\n62#1:232,2\n73#1:234,2\n*E\n"})
public final class RepositoryDiscoveryMetrics {
    private final long pluginInitializationTimeMs;
    @NotNull
    private final ConcurrentHashMap<FileAddress, Long> workerRequestedTimeMs;
    @NotNull
    private final ConcurrentHashMap<FileAddress, Long> discoveryStartedTimeMs;
    @NotNull
    private final ConcurrentHashMap<FileAddress, Long> firstDiscoveryResultTimeMs;

    public RepositoryDiscoveryMetrics(long pluginInitializationTimeMs) {
        this.pluginInitializationTimeMs = pluginInitializationTimeMs;
        this.workerRequestedTimeMs = new ConcurrentHashMap();
        this.discoveryStartedTimeMs = new ConcurrentHashMap();
        this.firstDiscoveryResultTimeMs = new ConcurrentHashMap();
    }

    public final void markWorkerRequested(@NotNull FileAddress workspace) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        long now = System.currentTimeMillis();
        Long l = now;
        ((Map)this.workerRequestedTimeMs).put(workspace, l);
        FusEntityKt.log((EventId1)GitReports.INSTANCE.getTimeToRepositoryDiscoveryWorkerRequest(), (Object)(now - this.pluginInitializationTimeMs));
        KLogger this_$iv = GitRepositoryDiscovery.INSTANCE.getLogger();
        boolean $i$f$trace = false;
        if (this_$iv.isTraceEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.trace((Object)("Repository discovery worker for " + workspace + " requested after " + (now - this.pluginInitializationTimeMs) + "ms since the plugin initialization"));
        }
    }

    public final void markDiscoveryStarted(@NotNull FileAddress workspace) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        long now = System.currentTimeMillis();
        Long l = now;
        ((Map)this.discoveryStartedTimeMs).put(workspace, l);
        Long l2 = this.workerRequestedTimeMs.get(workspace);
        if (l2 == null) {
            l2 = this.pluginInitializationTimeMs;
        }
        long workerRequested = ((Number)l2).longValue();
        FusEntityKt.log((EventId1)GitReports.INSTANCE.getTimeToRepositoryDiscoveryStart(), (Object)(now - workerRequested));
        KLogger this_$iv = GitRepositoryDiscovery.INSTANCE.getLogger();
        boolean $i$f$trace = false;
        if (this_$iv.isTraceEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.trace((Object)("Repository discovery for " + workspace + " started after " + (now - workerRequested) + "ms since the worker request"));
        }
    }

    public final void markFirstDiscoveryResult(@NotNull FileAddress workspace) {
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        long now = System.currentTimeMillis();
        Long l = now;
        ((Map)this.firstDiscoveryResultTimeMs).put(workspace, l);
        Long l2 = this.discoveryStartedTimeMs.get(workspace);
        if (l2 == null) {
            l2 = this.pluginInitializationTimeMs;
        }
        long discoveryStarted = ((Number)l2).longValue();
        FusEntityKt.log((EventId1)GitReports.INSTANCE.getTimeToFirstRepositoryDiscoveryResult(), (Object)(now - discoveryStarted));
        FusEntityKt.log((EventId1)GitReports.INSTANCE.getOverallTimeToFirstRepositoryDiscoveryResult(), (Object)(now - this.pluginInitializationTimeMs));
        KLogger this_$iv = GitRepositoryDiscovery.INSTANCE.getLogger();
        boolean $i$f$trace = false;
        if (this_$iv.isTraceEnabled()) {
            KLogger kLogger = this_$iv;
            boolean bl = false;
            kLogger.trace((Object)("First repository discovery result received after " + (now - discoveryStarted) + "ms since the discovery started and after " + (now - this.pluginInitializationTimeMs) + "ms since the plugin initialization"));
        }
    }

    private final long component1() {
        return this.pluginInitializationTimeMs;
    }

    @NotNull
    public final RepositoryDiscoveryMetrics copy(long pluginInitializationTimeMs) {
        return new RepositoryDiscoveryMetrics(pluginInitializationTimeMs);
    }

    public static /* synthetic */ RepositoryDiscoveryMetrics copy$default(RepositoryDiscoveryMetrics repositoryDiscoveryMetrics, long l, int n, Object object) {
        if ((n & 1) != 0) {
            l = repositoryDiscoveryMetrics.pluginInitializationTimeMs;
        }
        return repositoryDiscoveryMetrics.copy(l);
    }

    @NotNull
    public String toString() {
        return "RepositoryDiscoveryMetrics(pluginInitializationTimeMs=" + this.pluginInitializationTimeMs + ")";
    }

    public int hashCode() {
        return Long.hashCode(this.pluginInitializationTimeMs);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RepositoryDiscoveryMetrics)) {
            return false;
        }
        RepositoryDiscoveryMetrics repositoryDiscoveryMetrics = (RepositoryDiscoveryMetrics)other;
        return this.pluginInitializationTimeMs == repositoryDiscoveryMetrics.pluginInitializationTimeMs;
    }
}

