/*
 * Decompiled with CFR 0.152.
 */
package fleet.frontend.lang.quoteHandler;

import andel.text.Text;
import andel.text.TextFragmentCharSequence;
import andel.text.TextLine;
import andel.text.TextView;
import fleet.ast.AST;
import fleet.frontend.lang.quoteHandler.CharCursor;
import fleet.frontend.lang.quoteHandler.QuoteHandler;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0016J(\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0016J&\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0016J&\u0010\u0014\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0016J&\u0010\u0015\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0016J \u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00042\u000e\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J&\u0010\u001b\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000fH\u0016J\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u0004*\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u001dJ,\u0010\u001e\u001a\u00020\u001f*\u00020\u00072\u001d\u0010 \u001a\u0019\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130!\u00a2\u0006\u0002\b\"H\u0082\bJ\u0013\u0010#\u001a\u0004\u0018\u00010\u0004*\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lfleet/frontend/lang/quoteHandler/PlainTextQuoteHandler;", "Lfleet/frontend/lang/quoteHandler/QuoteHandler;", "()V", "QUOTE", "", "TICK", "createCharCursorFromLineStart", "Lfleet/frontend/lang/quoteHandler/CharCursor;", "offset", "", "text", "Landel/text/Text;", "getClosingQuote", "", "ast", "Lfleet/ast/AST;", "getRangeToDeleteOnBackspace", "Lkotlin/ranges/LongRange;", "isClosingQuote", "", "isInsideLiteral", "isOpeningQuote", "isQuote", "ch", "previousCharSupplier", "Lkotlin/Function0;", "isQuoteOnOffset", "missingClosingQuote", "getNearestOnLeftQuote", "(Lfleet/frontend/lang/quoteHandler/CharCursor;)Ljava/lang/Character;", "processCharsToLeft", "", "processor", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "safePrevious", "fleet.frontend.lang"})
@SourceDebugExtension(value={"SMAP\nQuoteHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QuoteHandler.kt\nfleet/frontend/lang/quoteHandler/PlainTextQuoteHandler\n*L\n1#1,166:1\n135#1,4:167\n135#1,4:171\n135#1,4:175\n*S KotlinDebug\n*F\n+ 1 QuoteHandler.kt\nfleet/frontend/lang/quoteHandler/PlainTextQuoteHandler\n*L\n98#1:167,4\n107#1:171,4\n141#1:175,4\n*E\n"})
final class PlainTextQuoteHandler
implements QuoteHandler {
    @NotNull
    public static final PlainTextQuoteHandler INSTANCE = new PlainTextQuoteHandler();
    private static final char QUOTE = (char)34;
    private static final char TICK = '\'';

    private PlainTextQuoteHandler() {
    }

    @Override
    public boolean isOpeningQuote(long offset, @NotNull Text text, @Nullable AST<?> ast2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.isQuoteOnOffset(offset, text) && !this.isInsideLiteral(offset, text, ast2);
    }

    @Override
    public boolean isClosingQuote(long offset, @NotNull Text text, @Nullable AST<?> ast2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.isQuoteOnOffset(offset, text) && this.isInsideLiteral(offset, text, ast2);
    }

    @Override
    public boolean missingClosingQuote(long offset, @NotNull Text text, @Nullable AST<?> ast2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (!(offset < text.charsCount())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (offset + 1L < text.charsCount() && Character.isLetterOrDigit(text.charSequence().getAbsolute(offset + 1L))) {
            return false;
        }
        Character c = this.getNearestOnLeftQuote(this.createCharCursorFromLineStart(offset + 1L, text));
        if (c == null) {
            return false;
        }
        char quote = c.charValue();
        long quoteCount = 0L;
        Ref.ObjectRef previousChar = new Ref.ObjectRef();
        TextLine line = Text.line$default((Text)text, (long)text.lines(true).offsetToLineNumber(offset), (boolean)false, (int)2, null);
        TextFragmentCharSequence textFragmentCharSequence = line.asCharSequence();
        for (int i = 0; i < textFragmentCharSequence.length(); ++i) {
            char ch = textFragmentCharSequence.charAt(i);
            if (ch == quote && this.isQuote(ch, (Function0<Character>)((Function0)new Function0<Character>((Ref.ObjectRef<Character>)previousChar){
                final /* synthetic */ Ref.ObjectRef<Character> $previousChar;
                {
                    this.$previousChar = $previousChar;
                    super(0);
                }

                @Nullable
                public final Character invoke() {
                    return (Character)this.$previousChar.element;
                }
            }))) {
                ++quoteCount;
            }
            previousChar.element = Character.valueOf(ch);
        }
        return quoteCount % 2L == 1L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isInsideLiteral(long offset, @NotNull Text text, @Nullable AST<?> ast2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        CharCursor $this$isInsideLiteral_u24lambda_u241 = this.createCharCursorFromLineStart(offset, text);
        boolean bl = false;
        Character c = INSTANCE.getNearestOnLeftQuote($this$isInsideLiteral_u24lambda_u241);
        if (c == null) {
            return false;
        }
        char quote = c.charValue();
        long quoteCnt = 0L;
        quoteCnt = 1L;
        PlainTextQuoteHandler plainTextQuoteHandler = INSTANCE;
        CharCursor $this$processCharsToLeft$iv = $this$isInsideLiteral_u24lambda_u241;
        boolean $i$f$processCharsToLeft = false;
        while ($this$processCharsToLeft$iv.hasPrevious()) {
            void ch;
            char c2 = $this$processCharsToLeft$iv.previous();
            CharCursor $this$isInsideLiteral_u24lambda_u241_u24lambda_u240 = $this$processCharsToLeft$iv;
            boolean bl2 = false;
            if (ch == quote && INSTANCE.isQuote((char)ch, (Function0<Character>)((Function0)new Function0<Character>($this$isInsideLiteral_u24lambda_u241_u24lambda_u240){
                final /* synthetic */ CharCursor $this_processCharsToLeft;
                {
                    this.$this_processCharsToLeft = $receiver;
                    super(0);
                }

                @Nullable
                public final Character invoke() {
                    return PlainTextQuoteHandler.access$safePrevious(PlainTextQuoteHandler.INSTANCE, this.$this_processCharsToLeft);
                }
            }))) {
                ++quoteCnt;
            }
            if (true) continue;
            break;
        }
        return quoteCnt % 2L == 1L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getClosingQuote(long offset, @NotNull Text text, @Nullable AST<?> ast2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        PlainTextQuoteHandler plainTextQuoteHandler = this;
        CharCursor $this$processCharsToLeft$iv = this.createCharCursorFromLineStart(offset + 1L, text);
        boolean $i$f$processCharsToLeft = false;
        while ($this$processCharsToLeft$iv.hasPrevious()) {
            void ch;
            char c = $this$processCharsToLeft$iv.previous();
            CharCursor $this$getClosingQuote_u24lambda_u242 = $this$processCharsToLeft$iv;
            boolean bl = false;
            if (INSTANCE.isQuote((char)ch, (Function0<Character>)((Function0)new Function0<Character>($this$getClosingQuote_u24lambda_u242){
                final /* synthetic */ CharCursor $this_processCharsToLeft;
                {
                    this.$this_processCharsToLeft = $receiver;
                    super(0);
                }

                @Nullable
                public final Character invoke() {
                    return PlainTextQuoteHandler.access$safePrevious(PlainTextQuoteHandler.INSTANCE, this.$this_processCharsToLeft);
                }
            }))) {
                return String.valueOf((char)ch);
            }
            if (true) continue;
            break;
        }
        return "";
    }

    @Override
    @Nullable
    public LongRange getRangeToDeleteOnBackspace(long offset, @NotNull Text text, @Nullable AST<?> ast2) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TextFragmentCharSequence chars = text.charSequence();
        if (offset < 1L || offset >= (long)chars.length() || !this.isClosingQuote(offset, text, ast2)) {
            return null;
        }
        if (chars.getAbsolute(offset - 1L) == chars.getAbsolute(offset)) {
            return new LongRange(offset - 1L, offset);
        }
        return null;
    }

    private final CharCursor createCharCursorFromLineStart(long offset, Text text) {
        if (!(offset <= text.charsCount())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        TextView textView = text.view();
        int lineIndex = textView.lineAt-fZAJ6bk((int)offset);
        int lineStartOffset = textView.lineStartOffset-8njyGSM(lineIndex);
        return new CharCursor((int)offset, lineStartOffset, text.getCharCount(), textView);
    }

    private final void processCharsToLeft(CharCursor $this$processCharsToLeft, Function2<? super CharCursor, ? super Character, Boolean> processor) {
        boolean $i$f$processCharsToLeft = false;
        while ($this$processCharsToLeft.hasPrevious() && ((Boolean)processor.invoke((Object)$this$processCharsToLeft, (Object)Character.valueOf($this$processCharsToLeft.previous()))).booleanValue()) {
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Character getNearestOnLeftQuote(CharCursor $this$getNearestOnLeftQuote) {
        PlainTextQuoteHandler plainTextQuoteHandler = this;
        CharCursor $this$processCharsToLeft$iv = $this$getNearestOnLeftQuote;
        boolean $i$f$processCharsToLeft = false;
        while ($this$processCharsToLeft$iv.hasPrevious()) {
            void ch;
            char c = $this$processCharsToLeft$iv.previous();
            CharCursor $this$getNearestOnLeftQuote_u24lambda_u243 = $this$processCharsToLeft$iv;
            boolean bl = false;
            if (INSTANCE.isQuote((char)ch, (Function0<Character>)((Function0)new Function0<Character>($this$getNearestOnLeftQuote_u24lambda_u243){
                final /* synthetic */ CharCursor $this_processCharsToLeft;
                {
                    this.$this_processCharsToLeft = $receiver;
                    super(0);
                }

                @Nullable
                public final Character invoke() {
                    return PlainTextQuoteHandler.access$safePrevious(PlainTextQuoteHandler.INSTANCE, this.$this_processCharsToLeft);
                }
            }))) {
                return Character.valueOf((char)ch);
            }
            if (true) continue;
            break;
        }
        return null;
    }

    private final boolean isQuoteOnOffset(long offset, Text text) {
        TextFragmentCharSequence charSequence = text.charSequence();
        return offset >= text.charsCount() ? false : this.isQuote(charSequence.getAbsolute(offset), (Function0<Character>)((Function0)new Function0<Character>(offset, charSequence){
            final /* synthetic */ long $offset;
            final /* synthetic */ TextFragmentCharSequence $charSequence;
            {
                this.$offset = $offset;
                this.$charSequence = $charSequence;
                super(0);
            }

            @Nullable
            public final Character invoke() {
                return this.$offset == 0L ? null : Character.valueOf(this.$charSequence.getAbsolute(this.$offset - 1L));
            }
        }));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isQuote(char ch, Function0<Character> previousCharSupplier) {
        if (ch == QUOTE) return true;
        if (ch != '\'') return false;
        Character c = (Character)previousCharSupplier.invoke();
        if (c == null) return true;
        if (!Character.isLetter(c.charValue())) return true;
        return false;
    }

    private final Character safePrevious(CharCursor $this$safePrevious) {
        return $this$safePrevious.hasPrevious() ? Character.valueOf($this$safePrevious.previous()) : null;
    }

    public static final /* synthetic */ Character access$safePrevious(PlainTextQuoteHandler $this, CharCursor $receiver) {
        return $this.safePrevious($receiver);
    }
}

