/*
 * Decompiled with CFR 0.152.
 */
package fleet.util;

import fleet.util.RandomKt;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lfleet/util/Random;", "", "()V", "cacheBits", "", "rnd", "Ljava/security/SecureRandom;", "served", "", "nextBytes", "len", "nextInt", "bound", "nextLong", "", "fleet.util.core"})
public final class Random {
    @NotNull
    public static final Random INSTANCE = new Random();
    @NotNull
    private static final byte[] cacheBits = new byte[8192];
    private static int served = cacheBits.length;
    @NotNull
    private static final SecureRandom rnd = new SecureRandom();

    private Random() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] nextBytes(int len) {
        byte[] byArray;
        byte[] answer = byArray = new byte[len];
        boolean bl = false;
        if (len >= cacheBits.length) {
            rnd.nextBytes(answer);
        } else {
            byte[] byArray2 = cacheBits;
            synchronized (byArray2) {
                boolean bl2 = false;
                if (served + len > cacheBits.length) {
                    rnd.nextBytes(cacheBits);
                    served = 0;
                }
                ArraysKt.copyInto((byte[])cacheBits, (byte[])answer, (int)0, (int)served, (int)(served + len));
                served += len;
                Unit unit = Unit.INSTANCE;
            }
        }
        return byArray;
    }

    public final long nextLong() {
        long l = RandomKt.access$toLong(this.nextBytes(8));
        return l == 0L ? 1L : (l < 0L ? -l : l);
    }

    public final int nextInt(int bound) {
        int i = (int)RandomKt.access$toLong(this.nextBytes(4)) % bound;
        return i == 0 ? 1 : (i < 0 ? -i : i);
    }
}

