/*
 * Decompiled with CFR 0.152.
 */
package fleet.diff.frontend;

import andel.lines.Line;
import andel.lines.LineBasedHeight;
import andel.lines.LinesLayout;
import andel.text.Text;
import andel.text.TextLine;
import andel.text.TextLines;
import fleet.diff.frontend.DiffFragmentReader;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\nH\u0002J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\nJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\nR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lfleet/diff/frontend/LinesIterator;", "", "text", "Landel/text/Text;", "layout", "Landel/lines/LinesLayout;", "reader", "Lfleet/diff/frontend/DiffFragmentReader;", "(Landel/text/Text;Landel/lines/LinesLayout;Lfleet/diff/frontend/DiffFragmentReader;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "lines", "Landel/text/TextLines;", "afterFragmentLine", "fragment", "hasNext", "", "isAtLineAfterFragment", "next", "Lfleet/diff/frontend/LinesIterator$WrappedLine;", "peak", "skippedFragment", "WrappedLine", "fleet.diff.frontend"})
final class LinesIterator {
    @NotNull
    private final LinesLayout layout;
    @NotNull
    private final DiffFragmentReader reader;
    @NotNull
    private final TextLines lines;
    private int index;

    public LinesIterator(@NotNull Text text, @NotNull LinesLayout layout, @NotNull DiffFragmentReader reader) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.layout = layout;
        this.reader = reader;
        this.lines = text.lines(true);
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    @NotNull
    public final WrappedLine peak() {
        TextLine currentLine = (TextLine)this.lines.get(this.index);
        List wrappedLines2 = SequencesKt.toList((Sequence)SequencesKt.takeWhile((Sequence)this.layout.lines(currentLine.getFromChar()), (Function1)((Function1)new Function1<Line, Boolean>(currentLine){
            final /* synthetic */ TextLine $currentLine;
            {
                this.$currentLine = $currentLine;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Line it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$currentLine.getFromChar() <= it.getFrom() && it.getTo() <= this.$currentLine.getToChar();
            }
        })));
        Line first = (Line)CollectionsKt.first((List)wrappedLines2);
        Line last = (Line)CollectionsKt.last((List)wrappedLines2);
        long top = first.getLineTop-x8klknc();
        long bottom = LineBasedHeight.plus-RJHVaDk((long)last.getLineTop-x8klknc(), (long)last.getLineHeight-x8klknc());
        return new WrappedLine(first.getFrom(), last.getTo(), this.index, LineBasedHeight.minus-RJHVaDk((long)bottom, (long)top), wrappedLines2, null);
    }

    @NotNull
    public final WrappedLine next() {
        WrappedLine line = this.peak();
        this.index = RangesKt.coerceAtMost((int)(this.index + 1), (int)this.lines.size());
        return line;
    }

    public final boolean hasNext() {
        return this.index < this.lines.size();
    }

    public final boolean isAtLineAfterFragment(int fragment) {
        return this.index == this.afterFragmentLine(this.reader, fragment);
    }

    public final boolean skippedFragment(int fragment) {
        return this.index > this.afterFragmentLine(this.reader, fragment);
    }

    private final int afterFragmentLine(DiffFragmentReader reader, int fragment) {
        return fragment >= reader.fragmentCounts() ? Integer.MAX_VALUE : reader.startLine(fragment) + reader.lineCount(fragment);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J\u0016\u0010\u001b\u001a\u00020\bH\u00c6\u0003\u00f8\u0001\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001c\u0010\u000fJ\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0003JK\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c6\u0001\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001f\u0010 J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020\u0006H\u00d6\u0001J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u0019\u0010\r\u001a\u00020\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0019\u0010\u0007\u001a\u00020\b\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u0012\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006'"}, d2={"Lfleet/diff/frontend/LinesIterator$WrappedLine;", "", "from", "", "to", "lineIdx", "", "lineHeight", "Landel/lines/LineBasedHeight;", "parts", "", "Landel/lines/Line;", "(JJIJLjava/util/List;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "firstPartHeight", "getFirstPartHeight-x8klknc", "()J", "J", "getFrom", "getLineHeight-x8klknc", "getLineIdx", "()I", "getParts", "()Ljava/util/List;", "getTo", "component1", "component2", "component3", "component4", "component4-x8klknc", "component5", "copy", "copy-PzKxK-o", "(JJIJLjava/util/List;)Lfleet/diff/frontend/LinesIterator$WrappedLine;", "equals", "", "other", "hashCode", "toString", "", "fleet.diff.frontend"})
    public static final class WrappedLine {
        private final long from;
        private final long to;
        private final int lineIdx;
        private final long lineHeight;
        @NotNull
        private final List<Line> parts;
        private final long firstPartHeight;

        private WrappedLine(long from, long to, int lineIdx, long lineHeight, List<Line> parts) {
            Intrinsics.checkNotNullParameter(parts, (String)"parts");
            this.from = from;
            this.to = to;
            this.lineIdx = lineIdx;
            this.lineHeight = lineHeight;
            this.parts = parts;
            this.firstPartHeight = ((Line)CollectionsKt.first(this.parts)).getLineHeight-x8klknc();
        }

        public final long getFrom() {
            return this.from;
        }

        public final long getTo() {
            return this.to;
        }

        public final int getLineIdx() {
            return this.lineIdx;
        }

        public final long getLineHeight-x8klknc() {
            return this.lineHeight;
        }

        @NotNull
        public final List<Line> getParts() {
            return this.parts;
        }

        public final long getFirstPartHeight-x8klknc() {
            return this.firstPartHeight;
        }

        public final long component1() {
            return this.from;
        }

        public final long component2() {
            return this.to;
        }

        public final int component3() {
            return this.lineIdx;
        }

        public final long component4-x8klknc() {
            return this.lineHeight;
        }

        @NotNull
        public final List<Line> component5() {
            return this.parts;
        }

        @NotNull
        public final WrappedLine copy-PzKxK-o(long from, long to, int lineIdx, long lineHeight, @NotNull List<Line> parts) {
            Intrinsics.checkNotNullParameter(parts, (String)"parts");
            return new WrappedLine(from, to, lineIdx, lineHeight, parts, null);
        }

        public static /* synthetic */ WrappedLine copy-PzKxK-o$default(WrappedLine wrappedLine, long l, long l2, int n, long l3, List list, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = wrappedLine.from;
            }
            if ((n2 & 2) != 0) {
                l2 = wrappedLine.to;
            }
            if ((n2 & 4) != 0) {
                n = wrappedLine.lineIdx;
            }
            if ((n2 & 8) != 0) {
                l3 = wrappedLine.lineHeight;
            }
            if ((n2 & 0x10) != 0) {
                list = wrappedLine.parts;
            }
            return wrappedLine.copy-PzKxK-o(l, l2, n, l3, list);
        }

        @NotNull
        public String toString() {
            return "WrappedLine(from=" + this.from + ", to=" + this.to + ", lineIdx=" + this.lineIdx + ", lineHeight=" + LineBasedHeight.toString-impl((long)this.lineHeight) + ", parts=" + this.parts + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.from);
            result = result * 31 + Long.hashCode(this.to);
            result = result * 31 + Integer.hashCode(this.lineIdx);
            result = result * 31 + LineBasedHeight.hashCode-impl((long)this.lineHeight);
            result = result * 31 + ((Object)this.parts).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WrappedLine)) {
                return false;
            }
            WrappedLine wrappedLine = (WrappedLine)other;
            if (this.from != wrappedLine.from) {
                return false;
            }
            if (this.to != wrappedLine.to) {
                return false;
            }
            if (this.lineIdx != wrappedLine.lineIdx) {
                return false;
            }
            if (!LineBasedHeight.equals-impl0((long)this.lineHeight, (long)wrappedLine.lineHeight)) {
                return false;
            }
            return Intrinsics.areEqual(this.parts, wrappedLine.parts);
        }

        public /* synthetic */ WrappedLine(long from, long to, int lineIdx, long lineHeight, List parts, DefaultConstructorMarker $constructor_marker) {
            this(from, to, lineIdx, lineHeight, parts);
        }
    }
}

