/*
 * Decompiled with CFR 0.152.
 */
package noria.windowManagement.impl.skiko;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.StdCallLibrary;
import fleet.tracing.TracingKt;
import fleet.util.logging.KLogger;
import fleet.util.os.Os;
import java.awt.Desktop;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import noria.windowManagement.api.BoundedOpenPropertyMap;
import noria.windowManagement.api.CommandExecutor;
import noria.windowManagement.api.FileManager;
import noria.windowManagement.api.MutableBoundedOpenPropertyMap;
import noria.windowManagement.api.PropertyHolder;
import noria.windowManagement.api.PropertyKey;
import noria.windowManagement.extensions.CommandImplementation;
import noria.windowManagement.extensions.FileManagerPropertyKeys;
import noria.windowManagement.extensions.FleetUtilCommandExecutor;
import noria.windowManagement.extensions.FleetUtilCommandExecutorKt;
import noria.windowManagement.extensions.FleetUtilPropertyHolder;
import noria.windowManagement.extensions.FleetUtilPropertyHolderKt;
import noria.windowManagement.extensions.PropertyImplementation;
import noria.windowManagement.impl.skiko.FileManagerImpl;
import noria.windowManagement.impl.skiko.FileManagerImplKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006JI\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0014\"\u0004\b\u0000\u0010\u0016\"\u0004\b\u0001\u0010\u00152\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u00010\u00182\u0006\u0010\u0019\u001a\u0002H\u0016H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ.\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u00010 H\u0096\u0002\u00a2\u0006\u0002\u0010!J\u0014\u0010\"\u001a\u0004\u0018\u00010\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'H\u0002J\"\u0010(\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'H\u0002J\u0010\u0010+\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0018\u0010,\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'H\u0002JB\u0010-\u001a\b\u0012\u0004\u0012\u00020$0\u0014\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u00010.2\u0006\u0010/\u001a\u0002H\u001dH\u0096\u0002\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b0\u00101JW\u00102\u001a\u0010\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u000204\u0018\u000103\"\b\b\u0000\u0010\u001d*\u00020\u001e2\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u0002H\u001d\u0012\u0004\u0012\u00020\u00010 2!\u00105\u001a\u001d\u0012\u0013\u0012\u0011H\u001d\u00a2\u0006\f\b7\u0012\b\b\u0002\u0012\u0004\b\b(8\u0012\u0004\u0012\u00020$06H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006:"}, d2={"Lnoria/windowManagement/impl/skiko/FileManagerImpl;", "Lnoria/windowManagement/api/FileManager;", "name", "", "userHome", "Ljava/nio/file/Path;", "(Ljava/lang/String;Ljava/nio/file/Path;)V", "commandExecutor", "Lnoria/windowManagement/extensions/FleetUtilCommandExecutor;", "getName", "()Ljava/lang/String;", "propertyHolder", "Lnoria/windowManagement/extensions/FleetUtilPropertyHolder;", "getPropertyHolder", "()Lnoria/windowManagement/extensions/FleetUtilPropertyHolder;", "propertyHolder$delegate", "Lkotlin/Lazy;", "getUserHome", "()Ljava/nio/file/Path;", "execute", "Lkotlin/Result;", "ReturnType", "ParameterType", "command", "Lnoria/windowManagement/api/CommandExecutor$Command;", "argument", "execute-gIAlu-s", "(Lnoria/windowManagement/api/CommandExecutor$Command;Ljava/lang/Object;)Ljava/lang/Object;", "get", "ValueType", "", "propertyKey", "Lnoria/windowManagement/api/PropertyKey;", "(Lnoria/windowManagement/api/PropertyKey;)Ljava/lang/Object;", "getLinuxFileManager", "navigate", "", "path", "select", "", "navigateOnLinux", "navigateOnWindows", "normalized", "openFile", "openViaShellApi", "set", "Lnoria/windowManagement/api/PropertyHolder$WritablePropertyKey;", "value", "set-gIAlu-s", "(Lnoria/windowManagement/api/PropertyHolder$WritablePropertyKey;Ljava/lang/Object;)Ljava/lang/Object;", "subscribeToProperty", "Lkotlin/Pair;", "Lnoria/windowManagement/api/PropertyHolder$Subscription;", "handleUpdatedValue", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "updatedValue", "Shell32Ex", "fleet.noria.windowManagement.impl"})
@SourceDebugExtension(value={"SMAP\nFileManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileManagerImpl.kt\nnoria/windowManagement/impl/skiko/FileManagerImpl\n+ 2 KLogger.kt\nfleet/util/logging/KLogger\n+ 3 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,309:1\n21#2,2:310\n21#2,2:312\n21#2,2:319\n26#3:314\n37#4,2:315\n37#4,2:317\n*S KotlinDebug\n*F\n+ 1 FileManagerImpl.kt\nnoria/windowManagement/impl/skiko/FileManagerImpl\n*L\n118#1:310,2\n123#1:312,2\n203#1:319,2\n154#1:314\n190#1:315,2\n193#1:317,2\n*E\n"})
public final class FileManagerImpl
implements FileManager {
    @NotNull
    private final String name;
    @Nullable
    private final Path userHome;
    @NotNull
    private final Lazy propertyHolder$delegate;
    @NotNull
    private final FleetUtilCommandExecutor<FileManager> commandExecutor;

    public FileManagerImpl(@NotNull String name, @Nullable Path userHome) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.userHome = userHome;
        this.propertyHolder$delegate = LazyKt.lazy((Function0)((Function0)new Function0<FleetUtilPropertyHolder<FileManager>>(this){
            final /* synthetic */ FileManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final FleetUtilPropertyHolder<FileManager> invoke() {
                return (FleetUtilPropertyHolder)TracingKt.span$default((String)"fileManager propertyHolder", null, (Function0)((Function0)new Function0<FleetUtilPropertyHolder<FileManager>>(this.this$0){
                    final /* synthetic */ FileManagerImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final FleetUtilPropertyHolder<FileManager> invoke() {
                        return new FleetUtilPropertyHolder((Function1)new Function1<MutableBoundedOpenPropertyMap<FileManager, PropertyImplementation<Object>>, Unit>(this.this$0){
                            final /* synthetic */ FileManagerImpl this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull MutableBoundedOpenPropertyMap<FileManager, PropertyImplementation<Object>> $this$$receiver) {
                                Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                                FleetUtilPropertyHolderKt.implement($this$$receiver, (PropertyHolder.ReadonlyPropertyKey)((PropertyHolder.ReadonlyPropertyKey)FileManager.ReadonlyPropertyKey.box-impl((String)FileManagerPropertyKeys.INSTANCE.getDisplayName-wUp_sLw())), (Function0)((Function0)new Function0<String>(this.this$0){
                                    final /* synthetic */ FileManagerImpl this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(0);
                                    }

                                    @NotNull
                                    public final String invoke() {
                                        return this.this$0.getName();
                                    }
                                }));
                            }
                        });
                    }
                }), (int)2, null);
            }
        }));
        this.commandExecutor = new FleetUtilCommandExecutor((Function1)new Function1<MutableBoundedOpenPropertyMap<FileManager, CommandImplementation<Object, Object>>, Unit>(this){
            final /* synthetic */ FileManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MutableBoundedOpenPropertyMap<FileManager, CommandImplementation<Object, Object>> $this$$receiver) {
                Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                FleetUtilCommandExecutorKt.implement($this$$receiver, (CommandExecutor.Command)((CommandExecutor.Command)FileManager.Command.box-impl((String)FileManagerPropertyKeys.INSTANCE.getRevealFile-HVjSBRA())), (Function1)((Function1)new Function1<Path, Unit>(this.this$0){
                    final /* synthetic */ FileManagerImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Path path) {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        FileManagerImpl.access$navigate(this.this$0, path, true);
                    }
                }));
                FleetUtilCommandExecutorKt.implement($this$$receiver, (CommandExecutor.Command)((CommandExecutor.Command)FileManager.Command.box-impl((String)FileManagerPropertyKeys.INSTANCE.getOpenFile-HVjSBRA())), (Function1)((Function1)new Function1<Path, Unit>(this.this$0){
                    final /* synthetic */ FileManagerImpl this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Path path) {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            FileManagerImpl.access$navigate(this.this$0, path, false);
                        } else {
                            FileManagerImpl.access$openFile(this.this$0, path);
                        }
                    }
                }));
            }
        });
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final Path getUserHome() {
        return this.userHome;
    }

    private final FleetUtilPropertyHolder<FileManager> getPropertyHolder() {
        Lazy lazy = this.propertyHolder$delegate;
        return (FleetUtilPropertyHolder)lazy.getValue();
    }

    @Nullable
    public <ValueType> Pair<ValueType, PropertyHolder.Subscription> subscribeToProperty(@NotNull PropertyKey<ValueType, ? super FileManager> propertyKey, @NotNull Function1<? super ValueType, Unit> handleUpdatedValue) {
        Intrinsics.checkNotNullParameter(propertyKey, (String)"propertyKey");
        Intrinsics.checkNotNullParameter(handleUpdatedValue, (String)"handleUpdatedValue");
        return this.getPropertyHolder().subscribeToProperty(propertyKey, handleUpdatedValue);
    }

    @Nullable
    public <ValueType> ValueType get(@NotNull PropertyKey<ValueType, ? super FileManager> propertyKey) {
        Intrinsics.checkNotNullParameter(propertyKey, (String)"propertyKey");
        return (ValueType)this.getPropertyHolder().get(propertyKey);
    }

    @NotNull
    public <ValueType> Object set-gIAlu-s(@NotNull PropertyHolder.WritablePropertyKey<ValueType, ? super FileManager> propertyKey, @NotNull ValueType value) {
        Intrinsics.checkNotNullParameter(propertyKey, (String)"propertyKey");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        return this.getPropertyHolder().set-gIAlu-s(propertyKey, value);
    }

    @NotNull
    public <ParameterType, ReturnType> Object execute-gIAlu-s(@NotNull CommandExecutor.Command<ParameterType, ReturnType, ? super FileManager> command, ParameterType argument) {
        Intrinsics.checkNotNullParameter(command, (String)"command");
        return this.commandExecutor.execute-gIAlu-s(command, argument);
    }

    private final void openFile(Path path) {
        String normalizedPath = ((Object)path.toAbsolutePath().normalize()).toString();
        Os.Type type = Os.INSTANCE.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                String[] stringArray = new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", normalizedPath};
                Runtime.getRuntime().exec(stringArray);
                break;
            }
            case 2: {
                String[] stringArray = new String[]{"/usr/bin/open", normalizedPath};
                Runtime.getRuntime().exec(stringArray);
                break;
            }
            case 3: {
                if (FileManagerImplKt.access$programExistsInPATH("xdg-open")) {
                    String[] stringArray = new String[]{"xdg-open", normalizedPath};
                    Runtime.getRuntime().exec(stringArray);
                    break;
                }
                if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                    Desktop.getDesktop().open(path.toFile());
                    break;
                }
                KLogger this_$iv = FileManagerImplKt.access$getLog();
                boolean $i$f$error = false;
                if (!this_$iv.isErrorEnabled()) break;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.error((Object)("Don't know how to open " + path));
                break;
            }
            default: {
                KLogger this_$iv = FileManagerImplKt.access$getLog();
                boolean $i$f$error = false;
                if (!this_$iv.isErrorEnabled()) break;
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.error((Object)("Don't know how to open " + path));
            }
        }
    }

    private final void navigate(Path path, boolean select) {
        Path normalized = path.toAbsolutePath().normalize();
        Os.Type type = Os.INSTANCE.getType();
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 2: {
                String[] stringArray;
                Runtime runtime = Runtime.getRuntime();
                if (select) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "open";
                    stringArray2[1] = "-R";
                    Intrinsics.checkNotNull((Object)normalized);
                    stringArray2[2] = ((Object)normalized).toString();
                    stringArray = stringArray2;
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = "open";
                    Intrinsics.checkNotNull((Object)normalized);
                    stringArray3[1] = ((Object)normalized).toString();
                    stringArray = stringArray3;
                }
                runtime.exec(stringArray);
                break;
            }
            case 1: {
                Intrinsics.checkNotNull((Object)normalized);
                this.navigateOnWindows(normalized, select);
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)normalized);
                this.navigateOnLinux(normalized, this.userHome, select);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private final void navigateOnWindows(Path normalized, boolean select) {
        this.openViaShellApi(normalized, select);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void openViaShellApi(Path path, boolean select) {
        Pointer[] apIdl;
        Pointer pIdl;
        block6: {
            Pointer[] pointerArray;
            Pair pair = select ? TuplesKt.to((Object)path.getParent(), (Object)path) : TuplesKt.to((Object)path, null);
            Path dir = (Path)pair.component1();
            Path toSelect = (Path)pair.component2();
            Shell32Ex shell32Ex = Shell32Ex.Companion.getInstance();
            Intrinsics.checkNotNull((Object)dir);
            pIdl = shell32Ex.ILCreateFromPath(((Object)dir).toString());
            if (toSelect != null) {
                Pointer[] pointerArray2 = new Pointer[]{Shell32Ex.Companion.getInstance().ILCreateFromPath(((Object)toSelect).toString())};
                pointerArray = pointerArray2;
            } else {
                boolean $i$f$emptyArray = false;
                pointerArray = new Pointer[]{};
            }
            apIdl = pointerArray;
            try {
                WinNT.HRESULT result = Shell32Ex.Companion.getInstance().SHOpenFolderAndSelectItems(pIdl, new WinDef.UINT((long)apIdl.length), apIdl, new WinDef.DWORD(0L));
                if (WinError.S_OK.equals((Object)result)) break block6;
                Path path2 = toSelect;
                FileManagerImplKt.access$getLog().error((Object)("SHOpenFolderAndSelectItems(" + ((Object)dir).toString() + "," + (path2 != null ? ((Object)path2).toString() : null) + "): 0x" + Integer.toHexString(result.intValue())));
            }
            catch (Throwable throwable) {
                if (!(apIdl.length == 0)) {
                    Shell32Ex.Companion.getInstance().ILFree(apIdl[0]);
                }
                Shell32Ex.Companion.getInstance().ILFree(pIdl);
                throw throwable;
            }
        }
        if (!(apIdl.length == 0)) {
            Shell32Ex.Companion.getInstance().ILFree(apIdl[0]);
        }
        Shell32Ex.Companion.getInstance().ILFree(pIdl);
    }

    private final void navigateOnLinux(Path path, Path userHome, boolean select) {
        String linuxFileManager = this.getLinuxFileManager(userHome);
        if (linuxFileManager != null) {
            if (StringsKt.endsWith$default((String)linuxFileManager, (String)"dolphin", (boolean)false, (int)2, null)) {
                char[] cArray = new char[]{' '};
                Object[] $this$toTypedArray$iv = (Object[])StringsKt.split$default((CharSequence)linuxFileManager, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                Object[] thisCollection$iv = $this$toTypedArray$iv;
                $this$toTypedArray$iv = new String[]{"--select", ((Object)path).toString()};
                Runtime.getRuntime().exec((String[])ArraysKt.plus((Object[])thisCollection$iv.toArray(new String[0]), (Object[])$this$toTypedArray$iv));
            } else {
                Object $this$toTypedArray$iv = new char[]{' '};
                $this$toTypedArray$iv = StringsKt.split$default((CharSequence)linuxFileManager, (char[])$this$toTypedArray$iv, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$toTypedArray = false;
                char[] thisCollection$iv = $this$toTypedArray$iv;
                Runtime.getRuntime().exec((String[])ArraysKt.plus((Object[])thisCollection$iv.toArray(new String[0]), (Object)((Object)path).toString()));
            }
        } else if (FileManagerImplKt.access$programExistsInPATH("xdg-open")) {
            String string;
            Runtime runtime = Runtime.getRuntime();
            String[] $this$toTypedArray$iv = new String[2];
            $this$toTypedArray$iv[0] = "xdg-open";
            if (select) {
                Path path2 = path.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
                string = ((Object)path2).toString();
            } else {
                string = ((Object)path).toString();
            }
            $this$toTypedArray$iv[1] = string;
            runtime.exec($this$toTypedArray$iv);
        } else if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
            Desktop.getDesktop().open(path.getParent().toFile());
        } else {
            KLogger this_$iv = FileManagerImplKt.access$getLog();
            boolean $i$f$error = false;
            if (this_$iv.isErrorEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.error((Object)("Don't know how to navigate to " + path));
            }
        }
    }

    private final String getLinuxFileManager(Path userHome) {
        String[] stringArray;
        Object object = FileManagerImplKt.access$tryReadXdmKey("Exec", userHome);
        return object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{" "}), (boolean)false, (int)0, (int)6, null)) != null ? (String)CollectionsKt.first((List)object) : null;
    }

    @NotNull
    public Map<PropertyHolder.WritablePropertyKey<Object, FileManager>, Result<Unit>> setAll(@NotNull BoundedOpenPropertyMap<? super FileManager, Object> properties) {
        return FileManager.DefaultImpls.setAll((FileManager)this, properties);
    }

    public static final /* synthetic */ void access$navigate(FileManagerImpl $this, Path path, boolean select) {
        $this.navigate(path, select);
    }

    public static final /* synthetic */ void access$openFile(FileManagerImpl $this, Path path) {
        $this.openFile(path);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bb\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H&J3\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H&\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lnoria/windowManagement/impl/skiko/FileManagerImpl$Shell32Ex;", "Lcom/sun/jna/win32/StdCallLibrary;", "ILCreateFromPath", "Lcom/sun/jna/Pointer;", "path", "", "ILFree", "", "pIdl", "SHOpenFolderAndSelectItems", "Lcom/sun/jna/platform/win32/WinNT$HRESULT;", "pIdlFolder", "cIdl", "Lcom/sun/jna/platform/win32/WinDef$UINT;", "apIdl", "", "dwFlags", "Lcom/sun/jna/platform/win32/WinDef$DWORD;", "(Lcom/sun/jna/Pointer;Lcom/sun/jna/platform/win32/WinDef$UINT;[Lcom/sun/jna/Pointer;Lcom/sun/jna/platform/win32/WinDef$DWORD;)Lcom/sun/jna/platform/win32/WinNT$HRESULT;", "Companion", "fleet.noria.windowManagement.impl"})
    private static interface Shell32Ex
    extends StdCallLibrary {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public Pointer ILCreateFromPath(@NotNull String var1);

        public void ILFree(@NotNull Pointer var1);

        @NotNull
        public WinNT.HRESULT SHOpenFolderAndSelectItems(@NotNull Pointer var1, @NotNull WinDef.UINT var2, @NotNull Pointer[] var3, @NotNull WinDef.DWORD var4);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lnoria/windowManagement/impl/skiko/FileManagerImpl$Shell32Ex$Companion;", "", "()V", "instance", "Lnoria/windowManagement/impl/skiko/FileManagerImpl$Shell32Ex;", "getInstance", "()Lnoria/windowManagement/impl/skiko/FileManagerImpl$Shell32Ex;", "instance$delegate", "Lkotlin/Lazy;", "fleet.noria.windowManagement.impl"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Lazy<Shell32Ex> instance$delegate;

            private Companion() {
            }

            @NotNull
            public final Shell32Ex getInstance() {
                Lazy<Shell32Ex> lazy = instance$delegate;
                return (Shell32Ex)lazy.getValue();
            }

            static {
                $$INSTANCE = new Companion();
                instance$delegate = LazyKt.lazy((Function0)instance.2.INSTANCE);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Os.Type.values().length];
            try {
                nArray[Os.Type.Windows.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Type.MacOS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Os.Type.Linux.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

