/*
 * Decompiled with CFR 0.152.
 */
package fleet.ssh.frontend.mina;

import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.sshd.client.auth.pubkey.KeyAgentIdentity;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKey;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0002\u0010\u0006JL\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0015"}, d2={"Lfleet/ssh/frontend/mina/FleetUserAuthPublicKey;", "Lorg/apache/sshd/client/auth/pubkey/UserAuthPublicKey;", "factories", "", "Lorg/apache/sshd/common/NamedFactory;", "Lorg/apache/sshd/common/signature/Signature;", "(Ljava/util/List;)V", "appendSignature", "", "session", "Lorg/apache/sshd/client/session/ClientSession;", "service", "", "name", "username", "algo", "key", "Ljava/security/PublicKey;", "serverKey", "buffer", "Lorg/apache/sshd/common/util/buffer/Buffer;", "fleet.plugins.ssh.frontend"})
final class FleetUserAuthPublicKey
extends UserAuthPublicKey {
    public FleetUserAuthPublicKey(@NotNull List<? extends NamedFactory<Signature>> factories) {
        Intrinsics.checkNotNullParameter(factories, (String)"factories");
        super(factories);
    }

    @NotNull
    protected byte[] appendSignature(@NotNull ClientSession session2, @NotNull String service, @NotNull String name, @NotNull String username, @NotNull String algo, @Nullable PublicKey key, @Nullable PublicKey serverKey, @NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)algo, (String)"algo");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        byte[] id = session2.getSessionId();
        int length = id.length + username.length() + service.length() + name.length() + algo.length() + 256 + 64;
        Buffer bs = (Buffer)new ByteArrayBuffer(length, false);
        bs.putBytes(id);
        bs.putByte((byte)50);
        bs.putString(username);
        bs.putString(service);
        bs.putString(name);
        bs.putBoolean(true);
        bs.putString(algo);
        bs.putPublicKey(key);
        if (serverKey != null) {
            bs.putPublicKey(serverKey);
        }
        byte[] contents = bs.getCompactData();
        byte[] sig = null;
        try {
            Map.Entry result2 = this.current.sign((SessionContext)session2, algo, contents);
            String factoryName = (String)result2.getKey();
            Object[] objectArray = new Object[]{algo, factoryName};
            ValidateUtils.checkState((boolean)StringsKt.equals((String)algo, (String)factoryName, (boolean)true), (String)"Mismatched signature type generated: requested=%s, used=%s", (Object[])objectArray);
            Object v = result2.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
            sig = (byte[])v;
        }
        catch (Error e) {
            this.warn("appendSignature({})[{}][{}] failed ({}) to sign contents using {}: {}", session2, service, name, e.getClass().getSimpleName(), algo, e.getMessage(), e);
            throw new RuntimeSshException((Throwable)e);
        }
        String signatureAlgo = KeyUtils.getSignatureAlgorithm((String)algo, (PublicKey)key);
        if (this.log.isTraceEnabled()) {
            Object[] objectArray = new Object[]{session2, service, name, signatureAlgo, KeyUtils.getFingerPrint((PublicKey)key), BufferUtils.toHex((byte[])Arrays.copyOf(contents, contents.length))};
            this.log.trace("appendSignature({})[{}] name={}, key type={}, fingerprint={} - verification data={}", objectArray);
            objectArray = new Object[]{session2, service, name, signatureAlgo, KeyUtils.getFingerPrint((PublicKey)key), BufferUtils.toHex((byte[])Arrays.copyOf(sig, sig.length))};
            this.log.trace("appendSignature({})[{}] name={}, key type={}, fingerprint={} - generated signature={}", objectArray);
        }
        bs.clear();
        bs.putString(signatureAlgo);
        if ((Intrinsics.areEqual((Object)signatureAlgo, (Object)"sk-ecdsa-sha2-nistp256@openssh.com") || Intrinsics.areEqual((Object)signatureAlgo, (Object)"sk-ssh-ed25519@openssh.com")) && this.current instanceof KeyAgentIdentity) {
            bs.putRawBytes(sig);
        } else {
            bs.putBytes(sig);
        }
        buffer.putBytes(bs.array(), bs.rpos(), bs.available());
        return sig;
    }
}

