/*
 * Decompiled with CFR 0.152.
 */
package fleet.ssh.frontend.mina;

import fleet.rpc.core.Blob;
import fleet.ssh.frontend.HostConnectionScope;
import fleet.ssh.frontend.mina.FleetSshAgentKt;
import fleet.util.channels.ChannelExtKt;
import fleet.util.logging.KLogger;
import java.io.Closeable;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.SendChannel;
import org.apache.sshd.agent.SshAgentConstants;
import org.apache.sshd.agent.SshAgentKeyConstraint;
import org.apache.sshd.agent.common.AbstractAgentProxy;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.io.der.DERParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010&\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ1\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0012\"\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\fH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\nH\u0014J>\u0010\u001e\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0004\u0012\u00020 0\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010#\u001a\u0004\u0018\u00010\u00102\b\u0010$\u001a\u0004\u0018\u00010 H\u0016J\u0014\u0010%\u001a\u00020\f*\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lfleet/ssh/frontend/mina/FleetSshAgentClient;", "Lorg/apache/sshd/agent/common/AbstractAgentProxy;", "inputChannel", "Lkotlinx/coroutines/channels/Channel;", "Lfleet/rpc/core/Blob;", "outputChannel", "connectionScope", "Lfleet/ssh/frontend/HostConnectionScope;", "(Lkotlinx/coroutines/channels/Channel;Lkotlinx/coroutines/channels/Channel;Lfleet/ssh/frontend/HostConnectionScope;)V", "messageChannel", "Lorg/apache/sshd/common/util/buffer/Buffer;", "addIdentity", "", "kp", "Ljava/security/KeyPair;", "comment", "", "constraints", "", "Lorg/apache/sshd/agent/SshAgentKeyConstraint;", "(Ljava/security/KeyPair;Ljava/lang/String;[Lorg/apache/sshd/agent/SshAgentKeyConstraint;)V", "close", "isOpen", "", "removeAllIdentities", "removeIdentity", "key", "Ljava/security/PublicKey;", "request", "buffer", "sign", "", "", "session", "Lorg/apache/sshd/common/session/SessionContext;", "algo", "data", "putEd25519", "fleet.plugins.ssh.frontend"})
@SourceDebugExtension(value={"SMAP\nFleetSshAgent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FleetSshAgent.kt\nfleet/ssh/frontend/mina/FleetSshAgentClient\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 KLogger.kt\nfleet/util/logging/KLogger\n*L\n1#1,306:1\n13309#2,2:307\n1#3:309\n17#4,2:310\n*S KotlinDebug\n*F\n+ 1 FleetSshAgent.kt\nfleet/ssh/frontend/mina/FleetSshAgentClient\n*L\n188#1:307,2\n286#1:310,2\n*E\n"})
public final class FleetSshAgentClient
extends AbstractAgentProxy {
    @NotNull
    private final Channel<Blob> inputChannel;
    @NotNull
    private final Channel<Blob> outputChannel;
    @NotNull
    private final HostConnectionScope connectionScope;
    @NotNull
    private final Channel<Buffer> messageChannel;

    public FleetSshAgentClient(@NotNull Channel<Blob> inputChannel, @NotNull Channel<Blob> outputChannel, @NotNull HostConnectionScope connectionScope) {
        Intrinsics.checkNotNullParameter(inputChannel, (String)"inputChannel");
        Intrinsics.checkNotNullParameter(outputChannel, (String)"outputChannel");
        Intrinsics.checkNotNullParameter((Object)connectionScope, (String)"connectionScope");
        super(null);
        this.inputChannel = inputChannel;
        this.outputChannel = outputChannel;
        this.connectionScope = connectionScope;
        this.messageChannel = ChannelKt.Channel$default((int)1, null, null, (int)6, null);
        BuildersKt.launch$default((CoroutineScope)this.connectionScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FleetSshAgentClient this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        SendChannel[] sendChannelArray = new SendChannel[]{this.this$0.inputChannel, this.this$0.outputChannel, this.this$0.messageChannel};
                        this.label = 1;
                        Object object3 = ChannelExtKt.useAll((SendChannel[])sendChannelArray, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            Object L$1;
                            Object L$2;
                            Object L$3;
                            Object L$4;
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ FleetSshAgentClient this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Exception decompiling
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object var1_1) {
                                /*
                                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                 * 
                                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 14[UNCONDITIONALDOLOOP]
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                 */
                                throw new IllegalStateException("Decompilation failed");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public boolean isOpen() {
        return !this.messageChannel.isClosedForReceive();
    }

    @NotNull
    protected synchronized Buffer request(@NotNull Buffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        FleetSshAgentKt.access$ensureCorrectLength(buffer);
        return (Buffer)this.connectionScope.blockingAsync((Function2)new Function2<CoroutineScope, Continuation<? super Buffer>, Object>(this, buffer, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ FleetSshAgentClient this$0;
            final /* synthetic */ Buffer $buffer;
            {
                this.this$0 = $receiver;
                this.$buffer = $buffer;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var3_4 /* !! */  = $this$blockingAsync = (CoroutineScope)this.L$0;
                        var4_5 = this.this$0;
                        var5_6 /* !! */  = this.$buffer;
                        $i$a$-runCatching-FleetSshAgentClient$request$1$1 = false;
                        this.label = 1;
                        v0 = FleetSshAgentClient.access$getInputChannel$p(var4_5).send((Object)FleetSshAgentKt.access$getCompactBlob(var5_6 /* !! */ ), (Continuation)this);
                        ** if (v0 != var8_2) goto lbl16
lbl15:
                        // 1 sources

                        return var8_2;
lbl16:
                        // 1 sources

                        ** GOTO lbl23
                    }
                    case 1: {
                        $i$a$-runCatching-FleetSshAgentClient$request$1$1 = false;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl23:
                            // 2 sources

                            var6_9 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable $i$a$-runCatching-FleetSshAgentClient$request$1$1) {
                            var6_9 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-FleetSshAgentClient$request$1$1));
                        }
                        var3_4 /* !! */  = var6_9;
                        var4_5 = this.this$0;
                        v1 = Result.exceptionOrNull-impl((Object)var3_4 /* !! */ );
                        if (v1 != null) {
                            var5_6 /* !! */  = v1;
                            $i$a$-onFailure-FleetSshAgentClient$request$1$2 = false;
                            var4_5.close();
                        }
                        this.label = 2;
                        v2 = FleetSshAgentClient.access$getMessageChannel$p(this.this$0).receive((Continuation)this);
                        if (v2 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl43
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl43:
                        // 2 sources

                        return v2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Buffer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    public void close() {
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.inputChannel), null, (int)1, null);
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.outputChannel), null, (int)1, null);
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this.messageChannel), null, (int)1, null);
    }

    public void addIdentity(@NotNull KeyPair kp, @NotNull String comment, SshAgentKeyConstraint ... constraints) {
        int response;
        Intrinsics.checkNotNullParameter((Object)kp, (String)"kp");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        byte cmd = constraints.length == 0 ? (byte)17 : 25;
        Buffer buffer = null;
        buffer = this.createBuffer(cmd);
        if (Intrinsics.areEqual((Object)KeyUtils.getKeyType((KeyPair)kp), (Object)"ssh-ed25519")) {
            Buffer buffer2 = buffer;
            Intrinsics.checkNotNullExpressionValue((Object)buffer2, (String)"element");
            this.putEd25519(buffer2, kp);
        } else {
            buffer.putKeyPair(kp);
        }
        buffer.putString(comment);
        SshAgentKeyConstraint[] $this$forEach$iv = constraints;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            SshAgentKeyConstraint element$iv;
            SshAgentKeyConstraint it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.put(buffer);
        }
        Buffer buffer3 = this.prepare(buffer);
        Intrinsics.checkNotNullExpressionValue((Object)buffer3, (String)"prepare(...)");
        buffer = this.request(buffer3);
        int available = buffer.available();
        int n2 = response = available >= 1 ? buffer.getUByte() : -1;
        if (available != 1 || response != 6) {
            throw new SshException("Bad addIdentity response (" + SshAgentConstants.getCommandMessageName((int)response) + ") - available=" + available);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void putEd25519(Buffer $this$putEd25519, KeyPair kp) {
        byte[] byArray;
        ByteArrayBuffer byteArrayBuffer;
        ByteArrayBuffer $this$putEd25519_u24lambda_u241 = byteArrayBuffer = new ByteArrayBuffer(32);
        boolean bl = false;
        $this$putEd25519_u24lambda_u241.putRawPublicKeyBytes(kp.getPublic());
        byte[] publicBytes = byteArrayBuffer.getBytes();
        $this$putEd25519.putString("ssh-ed25519");
        $this$putEd25519.putBytes(publicBytes);
        if (!StringsKt.equals((String)"PKCS#8", (String)kp.getPrivate().getFormat(), (boolean)true)) {
            boolean $i$a$-require-FleetSshAgentClient$putEd25519$22 = false;
            String $i$a$-require-FleetSshAgentClient$putEd25519$22 = "Unsupported private key encoding for ED25519 key: " + kp.getPrivate().getFormat();
            throw new IllegalArgumentException($i$a$-require-FleetSshAgentClient$putEd25519$22.toString());
        }
        Object $i$a$-require-FleetSshAgentClient$putEd25519$22 = kp.getPrivate().getEncoded();
        $i$a$-require-FleetSshAgentClient$putEd25519$22 = (Closeable)new DERParser(Arrays.copyOf($i$a$-require-FleetSshAgentClient$putEd25519$22, ((byte[])$i$a$-require-FleetSshAgentClient$putEd25519$22).length));
        Throwable throwable = null;
        try {
            byte[] byArray2;
            DERParser byteParser = (DERParser)$i$a$-require-FleetSshAgentClient$putEd25519$22;
            boolean bl2 = false;
            Closeable closeable = (Closeable)byteParser.readObject().createParser();
            Throwable throwable2 = null;
            try {
                DERParser oneAsymmetricKeyParser = (DERParser)closeable;
                boolean bl3 = false;
                oneAsymmetricKeyParser.readObject();
                oneAsymmetricKeyParser.readObject();
                byte[] byArray3 = oneAsymmetricKeyParser.readObject().getValue();
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getValue(...)");
                byArray2 = CollectionsKt.toByteArray((Collection)ArraysKt.takeLast((byte[])byArray3, (int)32));
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            byArray = byArray2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$i$a$-require-FleetSshAgentClient$putEd25519$22, (Throwable)throwable);
        }
        byte[] privateBytes = byArray;
        Intrinsics.checkNotNull((Object)publicBytes);
        byte[] combinedBytes = ArraysKt.plus((byte[])privateBytes, (byte[])publicBytes);
        $this$putEd25519.putBytes(combinedBytes);
    }

    @NotNull
    public Map.Entry<String, byte[]> sign(@Nullable SessionContext session2, @Nullable PublicKey key, @Nullable String algo, @Nullable byte[] data) {
        int flags;
        String keyType;
        Buffer buffer;
        int okcmd;
        FleetSshAgentClient $this$sign_u24lambda_u246;
        block22: {
            String string;
            $this$sign_u24lambda_u246 = this;
            boolean bl = false;
            int cmd = 13;
            okcmd = 14;
            buffer = $this$sign_u24lambda_u246.createBuffer((byte)cmd);
            keyType = KeyUtils.getKeyType((Key)key);
            flags = 0;
            CharSequence charSequence = algo;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                if (!Intrinsics.areEqual((Object)KeyUtils.getCanonicalKeyType((String)algo), (Object)keyType)) {
                    boolean $i$a$-require-FleetSshAgentClient$sign$1$signatureAlgorithm$22 = false;
                    String $i$a$-require-FleetSshAgentClient$sign$1$signatureAlgorithm$22 = "Bad signing request: signature algorithm '" + algo + "' not applicable to '" + keyType + "' key";
                    throw new IllegalArgumentException($i$a$-require-FleetSshAgentClient$sign$1$signatureAlgorithm$22.toString());
                }
                string = algo;
            } else {
                string = keyType;
            }
            String signatureAlgorithm = string;
            charSequence = signatureAlgorithm;
            if (charSequence == null) break block22;
            int n = -1;
            switch (((String)charSequence).hashCode()) {
                case -1078036292: {
                    if (((String)charSequence).equals("rsa-sha2-512")) {
                        n = 1;
                    }
                    break;
                }
                case -1095576560: {
                    if (((String)charSequence).equals("rsa-sha2-512-cert-v01@openssh.com")) {
                        n = 1;
                    }
                    break;
                }
                case -1078039047: {
                    if (((String)charSequence).equals("rsa-sha2-256")) {
                        n = 2;
                    }
                    break;
                }
                case 227243763: {
                    if (((String)charSequence).equals("rsa-sha2-256-cert-v01@openssh.com")) {
                        n = 2;
                    }
                    break;
                }
            }
            switch (n) {
                case 1: {
                    flags = 4;
                    break;
                }
                case 2: {
                    flags = 2;
                }
            }
        }
        buffer.putPublicKey(key);
        buffer.putBytes(data);
        buffer.putInt((long)flags);
        Buffer buffer2 = $this$sign_u24lambda_u246.prepare(buffer);
        Intrinsics.checkNotNullExpressionValue((Object)buffer2, (String)"prepare(...)");
        buffer = $this$sign_u24lambda_u246.request(buffer2);
        int responseType = buffer.getUByte();
        if (responseType != okcmd) {
            throw new SshException("Bad signing response type: " + SshAgentConstants.getCommandMessageName((int)responseType));
        }
        byte[] signature = buffer.getBytes();
        Buffer buf = (Buffer)new ByteArrayBuffer(signature);
        Object[] algorithm = buf.getString();
        Object[] objectArray = algorithm;
        if (Intrinsics.areEqual((Object)objectArray, (Object)"sk-ecdsa-sha2-nistp256@openssh.com") ? true : Intrinsics.areEqual((Object)objectArray, (Object)"sk-ssh-ed25519@openssh.com")) {
            ByteArrayBuffer anotherBuf = new ByteArrayBuffer();
            anotherBuf.putBytes(buf.getBytes());
            anotherBuf.putByte(buf.getByte());
            anotherBuf.putUInt(buf.getUInt());
            signature = anotherBuf.getCompactData();
        } else {
            signature = buf.getBytes();
        }
        objectArray = new Object[]{algo, keyType, KeyUtils.getFingerPrint((PublicKey)key), algorithm, BufferUtils.toHex((char)':', (byte[])Arrays.copyOf(signature, signature.length))};
        $this$sign_u24lambda_u246.log.debug("sign({}/{})[{}] {}: {}", objectArray);
        AbstractMap.SimpleImmutableEntry<Object[], byte[]> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Object[], byte[]>(algorithm, signature);
        String resultAlgorithm = (String)((Map.Entry)simpleImmutableEntry).getKey();
        byte[] signature2 = (byte[])((Map.Entry)simpleImmutableEntry).getValue();
        if (!Intrinsics.areEqual((Object)resultAlgorithm, (Object)algo) && !Intrinsics.areEqual((Object)KeyUtils.getSignatureAlgorithm((String)algo, (PublicKey)key), (Object)KeyUtils.getSignatureAlgorithm((String)resultAlgorithm, (PublicKey)key))) {
            KLogger this_$iv = FleetSshAgentKt.access$getLogger();
            boolean $i$f$warn = false;
            if (this_$iv.isWarnEnabled()) {
                KLogger kLogger = this_$iv;
                boolean bl = false;
                kLogger.warn((Object)("Algorithm mismatch in agent response. Requested: " + algo + ", Received: " + resultAlgorithm + ". Signature might be invalid."));
            }
        }
        return new AbstractMap.SimpleImmutableEntry<String, byte[]>(algo, signature2);
    }

    public void removeIdentity(@NotNull PublicKey key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        throw new UnsupportedOperationException();
    }

    public void removeAllIdentities() {
        throw new UnsupportedOperationException();
    }
}

