/*
 * Decompiled with CFR 0.152.
 */
package noria.model;

import fleet.compose.theme.keys.TextStyleKeys;
import fleet.compose.theme.keys.ThemeKeys;
import fleet.compose.theme.keys.ThemeKind;
import fleet.compose.theme.text.TextSpec;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import noria.model.Theme;
import noria.model.ThemeKey;
import noria.model.ThemeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0019\u0010\u000e\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u0018\b\u0002\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J&\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0017\u001a\u0004\u0018\u0001H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0004\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0018\u001a\u0004\u0018\u0001H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00012\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0004\u00a2\u0006\u0002\u0010\u0016Jm\u0010\u0018\u001a\u0004\u0018\u0001H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u0001\"\b\b\u0001\u0010\u0019*\u00020\u00012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00042:\u0010\u001b\u001a6\u0012\u0018\u0012\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00140\u0004\u0012\u0006\u0012\u0004\u0018\u0001H\u00190\u001d\u0012\u0018\u0012\u0016\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010\u0004\u0012\u0004\u0012\u0002H\u00190\u001d0\u001cH\u0002\u00a2\u0006\u0002\u0010\u001eJ\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J?\u0010!\u001a\u00020\u000022\u0010\"\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u001d0#\"\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u001d\u00a2\u0006\u0002\u0010$J\u001a\u0010%\u001a\u00020\u00012\u0010\u0010\u0015\u001a\f\u0012\u0004\u0012\u00020&0\u0004j\u0002`'H\u0002J\u0014\u0010(\u001a\u00020)2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020)0\u0004J\t\u0010*\u001a\u00020&H\u00d6\u0001R!\u0010\u0006\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR!\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006+"}, d2={"Lnoria/model/Theme;", "", "map", "Lkotlinx/collections/immutable/PersistentMap;", "Lnoria/model/ThemeKey;", "(Lkotlinx/collections/immutable/PersistentMap;)V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "getCache", "()Ljava/util/concurrent/ConcurrentMap;", "cacheAnything", "getCacheAnything", "getMap", "()Lkotlinx/collections/immutable/PersistentMap;", "component1", "copy", "equals", "", "other", "get", "T", "key", "(Lnoria/model/ThemeKey;)Ljava/lang/Object;", "getOrNull", "getTextAttribute", "S", "attr", "fallback", "Lkotlin/Function1;", "Lkotlin/Pair;", "(Lnoria/model/ThemeKey;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "hashCode", "", "patch", "items", "", "([Lkotlin/Pair;)Lnoria/model/Theme;", "resolveIcon", "", "Lnoria/model/IconKey;", "textSpec", "Lfleet/compose/theme/text/TextSpec;", "toString", "fleet.noria.ui"})
public final class Theme {
    @NotNull
    private final PersistentMap<ThemeKey<?>, Object> map;
    @NotNull
    private final ConcurrentMap<ThemeKey<?>, Object> cache;
    @NotNull
    private final ConcurrentMap<Object, Object> cacheAnything;

    public Theme(@NotNull PersistentMap<ThemeKey<?>, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this.map = map;
        this.cache = new ConcurrentHashMap();
        this.cacheAnything = new ConcurrentHashMap();
    }

    @NotNull
    public final PersistentMap<ThemeKey<?>, Object> getMap() {
        return this.map;
    }

    @NotNull
    public final ConcurrentMap<ThemeKey<?>, Object> getCache() {
        return this.cache;
    }

    @NotNull
    public final ConcurrentMap<Object, Object> getCacheAnything() {
        return this.cacheAnything;
    }

    @NotNull
    public final TextSpec textSpec(@NotNull ThemeKey<TextSpec> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        TextSpec textSpec = (TextSpec)this.map.get(key);
        if (textSpec == null && (textSpec = (TextSpec)this.map.get(TextStyleKeys.INSTANCE.getDefault())) == null) {
            throw new IllegalStateException(("Unable to get Theme Key '" + key.getName() + "'").toString());
        }
        return textSpec;
    }

    @NotNull
    public final <T> T get(@NotNull ThemeKey<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        if (StringsKt.startsWith$default((String)key.getName(), (String)"icons.", (boolean)false, (int)2, null)) {
            Object object = this.resolveIcon(key);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of noria.model.Theme.get");
            return (T)object;
        }
        String string = this.getOrNull(key);
        if (string == null) {
            throw new IllegalStateException(("Unable to get Theme Key '" + key.getName() + "'").toString());
        }
        return (T)string;
    }

    private final Object resolveIcon(ThemeKey<String> key) {
        ThemeKind themeKind = this.getOrNull(ThemeKeys.INSTANCE.getThemeKind());
        if (themeKind == null) {
            themeKind = ThemeKind.Light;
        }
        ThemeKind themeKind2 = themeKind;
        Object object = this.cache.computeIfAbsent(key, arg_0 -> Theme.resolveIcon$lambda$0((Function1)new Function1<ThemeKey<?>, Object>(themeKind2, key){
            final /* synthetic */ ThemeKind $themeKind;
            final /* synthetic */ ThemeKey<String> $key;
            {
                this.$themeKind = $themeKind;
                this.$key = $key;
                super(1);
            }

            public final Object invoke(ThemeKey<?> it) {
                String iconDir = switch (resolveIcon.WhenMappings.$EnumSwitchMapping$0[this.$themeKind.ordinal()]) {
                    case 1 -> "light";
                    case 2 -> "dark";
                    default -> throw new NoWhenBranchMatchedException();
                };
                return StringsKt.replace$default((String)StringsKt.replace$default((String)this.$key.getName(), (String)"icons.", (String)(iconDir + "/"), (boolean)false, (int)4, null), (String)".", (String)"/", (boolean)false, (int)4, null) + ".svg";
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
        return object;
    }

    @Nullable
    public final <T> T getOrNull(@NotNull ThemeKey<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return ThemeKt.get(key, this.map);
    }

    @Nullable
    public final <T> T getTextAttribute(@NotNull ThemeKey<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.getTextAttribute(key, getTextAttribute.1.INSTANCE);
    }

    private final <T, S> T getTextAttribute(ThemeKey<T> attr, Function1<? super Pair<ThemeKey<T>, ? extends S>, ? extends Pair<ThemeKey<T>, ? extends S>> fallback) {
        return Theme.getTextAttribute$getAux(this, fallback, attr, TuplesKt.to(attr, null));
    }

    @NotNull
    public final Theme patch(Pair<? extends ThemeKey<?>, ? extends Object> ... items2) {
        Intrinsics.checkNotNullParameter(items2, (String)"items");
        return new Theme(ExtensionsKt.putAll(this.map, items2));
    }

    @NotNull
    public final PersistentMap<ThemeKey<?>, Object> component1() {
        return this.map;
    }

    @NotNull
    public final Theme copy(@NotNull PersistentMap<ThemeKey<?>, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        return new Theme(map);
    }

    public static /* synthetic */ Theme copy$default(Theme theme, PersistentMap persistentMap, int n, Object object) {
        if ((n & 1) != 0) {
            persistentMap = theme.map;
        }
        return theme.copy(persistentMap);
    }

    @NotNull
    public String toString() {
        return "Theme(map=" + this.map + ")";
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Theme)) {
            return false;
        }
        Theme theme = (Theme)other;
        return Intrinsics.areEqual(this.map, theme.map);
    }

    private static final Object resolveIcon$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return $tmp0.invoke(p0);
    }

    private static final <T, S> T getTextAttribute$getAux(Theme this$0, Function1<? super Pair<ThemeKey<T>, ? extends S>, ? extends Pair<ThemeKey<T>, ? extends S>> $fallback, ThemeKey<T> initial, Pair<ThemeKey<T>, ? extends S> current) {
        Object t;
        block3: {
            while (true) {
                ThemeKey currentKey;
                if (this$0.cache.containsKey(currentKey = (ThemeKey)current.component1())) {
                    t = ThemeKt.get(currentKey, (Map)this$0.cache);
                    break block3;
                }
                Object attrs = ThemeKt.get(currentKey, this$0.map);
                if (attrs != null) {
                    ((Map)this$0.cache).put(initial, attrs);
                    t = attrs;
                    break block3;
                }
                Pair next = (Pair)$fallback.invoke(current);
                ThemeKey nextKey = (ThemeKey)next.component1();
                if (nextKey == null) break;
                ThemeKey<T> themeKey = initial;
                Intrinsics.checkNotNull((Object)next, (String)"null cannot be cast to non-null type kotlin.Pair<noria.model.ThemeKey<T of noria.model.Theme.getTextAttribute$getAux>, S of noria.model.Theme.getTextAttribute$getAux?>");
                Pair pair = next;
                initial = themeKey;
                current = pair;
            }
            t = null;
        }
        return t;
    }
}

