/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.input.pointer;

import androidx.compose.runtime.collection.MutableVector;
import androidx.compose.ui.input.pointer.HistoricalChange;
import androidx.compose.ui.input.pointer.InternalPointerEvent;
import androidx.compose.ui.input.pointer.NodeParent;
import androidx.compose.ui.input.pointer.PointerEvent;
import androidx.compose.ui.input.pointer.PointerEventPass;
import androidx.compose.ui.input.pointer.PointerEventType;
import androidx.compose.ui.input.pointer.PointerId;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.input.pointer.PointerInputFilter;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.node.PointerInputModifierNodeKt;
import androidx.compose.ui.unit.IntSize;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import noria.ui.core.LayoutNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J,\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020#0'2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020%2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010,\u001a\u00020%H\u0002J\b\u0010-\u001a\u00020%H\u0016J\u0010\u0010.\u001a\u00020\t2\u0006\u0010)\u001a\u00020*H\u0016J,\u0010/\u001a\u00020\t2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020#0'2\u0006\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u00100\u001a\u00020\t2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u00101\u001a\u00020%2\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000205H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0017\u001a\u00060\u0018j\u0002`\u0019X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0019\u0010\u0003\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u00066"}, d2={"Landroidx/compose/ui/input/pointer/Node;", "Landroidx/compose/ui/input/pointer/NodeParent;", "parent", "pointerInputNodeId", "Lnoria/ID;", "(Landroidx/compose/ui/input/pointer/NodeParent;ILkotlin/jvm/internal/DefaultConstructorMarker;)V", "coordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "hasEntered", "", "isIn", "()Z", "setIn", "(Z)V", "getParent", "()Landroidx/compose/ui/input/pointer/NodeParent;", "pointerEvent", "Landroidx/compose/ui/input/pointer/PointerEvent;", "pointerIds", "Landroidx/compose/runtime/collection/MutableVector;", "Landroidx/compose/ui/input/pointer/PointerId;", "getPointerIds", "()Landroidx/compose/runtime/collection/MutableVector;", "pointerInputNode", "Lnoria/ui/core/LayoutNode;", "Landroidx/compose/ui/node/PointerInputModifierNode;", "getPointerInputNode", "()Lnoria/ui/core/LayoutNode;", "setPointerInputNode", "(Lnoria/ui/core/LayoutNode;)V", "getPointerInputNodeId-gZoixdo", "()I", "I", "relevantChanges", "", "Landroidx/compose/ui/input/pointer/PointerInputChange;", "buildCache", "", "changes", "", "parentCoordinates", "internalPointerEvent", "Landroidx/compose/ui/input/pointer/InternalPointerEvent;", "cleanUpHits", "clearCache", "dispatchCancel", "dispatchFinalEventPass", "dispatchInitialEventPass", "dispatchMainEventPass", "print", "depth", "", "toString", "", "fleet.noria.ui"})
@SourceDebugExtension(value={"SMAP\nHitPathTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/Node\n+ 2 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVectorKt\n+ 3 MutableVector.kt\nandroidx/compose/runtime/collection/MutableVector\n+ 4 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,633:1\n1182#2:634\n1161#2,2:635\n460#3,11:637\n460#3,11:648\n492#3,11:659\n492#3,11:670\n460#3,11:681\n48#3:698\n523#3:699\n492#3,11:709\n460#3,11:726\n33#4,6:692\n116#4,2:700\n33#4,6:702\n118#4:708\n33#4,6:720\n*S KotlinDebug\n*F\n+ 1 HitPathTracker.kt\nandroidx/compose/ui/input/pointer/Node\n*L\n263#1:634\n263#1:635,2\n304#1:637,11\n314#1:648,11\n340#1:659,11\n344#1:670,11\n378#1:681,11\n446#1:698\n447#1:699\n500#1:709,11\n526#1:726,11\n422#1:692,6\n458#1:700,2\n458#1:702,6\n458#1:708\n510#1:720,6\n*E\n"})
public final class Node
extends NodeParent {
    @NotNull
    private final NodeParent parent;
    private final int pointerInputNodeId;
    public LayoutNode pointerInputNode;
    @NotNull
    private final MutableVector<PointerId> pointerIds;
    @NotNull
    private final Map<PointerId, PointerInputChange> relevantChanges;
    @Nullable
    private LayoutCoordinates coordinates;
    @Nullable
    private PointerEvent pointerEvent;
    private boolean isIn;
    private boolean hasEntered;

    private Node(NodeParent parent, int pointerInputNodeId) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(parent.getResolvePointerInputModifierNode());
        this.parent = parent;
        this.pointerInputNodeId = pointerInputNodeId;
        boolean $i$f$mutableVectorOf = false;
        int capacity$iv$iv = 16;
        boolean $i$f$MutableVector = false;
        this.pointerIds = new MutableVector((Object[])new PointerId[capacity$iv$iv], 0);
        this.relevantChanges = new LinkedHashMap();
        this.isIn = true;
    }

    @NotNull
    public final NodeParent getParent() {
        return this.parent;
    }

    public final int getPointerInputNodeId-gZoixdo() {
        return this.pointerInputNodeId;
    }

    @NotNull
    public final LayoutNode getPointerInputNode() {
        LayoutNode layoutNode = this.pointerInputNode;
        if (layoutNode != null) {
            return layoutNode;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"pointerInputNode");
        return null;
    }

    public final void setPointerInputNode(@NotNull LayoutNode layoutNode) {
        Intrinsics.checkNotNullParameter((Object)layoutNode, (String)"<set-?>");
        this.pointerInputNode = layoutNode;
    }

    @NotNull
    public final MutableVector<PointerId> getPointerIds() {
        return this.pointerIds;
    }

    public final boolean isIn() {
        return this.isIn;
    }

    public final void setIn(boolean bl) {
        this.isIn = bl;
    }

    @Override
    public boolean dispatchInitialEventPass(@NotNull Map<PointerId, PointerInputChange> changes, @NotNull LayoutCoordinates parentCoordinates, @NotNull InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)parentCoordinates, (String)"parentCoordinates");
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        if (!this.getPointerInputNode().isAttached()) {
            return false;
        }
        this.buildCache(changes, parentCoordinates, internalPointerEvent);
        PointerEvent pointerEvent = this.pointerEvent;
        if (pointerEvent != null) {
            PointerEvent event = pointerEvent;
            boolean bl = false;
            LayoutNode layoutNode = this.getPointerInputNode();
            LayoutCoordinates layoutCoordinates = this.coordinates;
            Intrinsics.checkNotNull((Object)layoutCoordinates);
            PointerInputModifierNodeKt.onPointerEvent-hUlJWOE(layoutNode, event, PointerEventPass.Initial, layoutCoordinates.getSize-YbymL2g());
        }
        if (this.getPointerInputNode().isAttached()) {
            if (this.pointerEvent != null) {
                MutableVector<Node> this_$iv = this.getChildren();
                boolean $i$f$forEach = false;
                int size$iv = this_$iv.getSize();
                if (size$iv > 0) {
                    i$iv = 0;
                    Object[] content$iv = this_$iv.getContent();
                    do {
                        Node it = (Node)content$iv[i$iv];
                        boolean bl = false;
                        LayoutCoordinates layoutCoordinates = this.coordinates;
                        Intrinsics.checkNotNull((Object)layoutCoordinates);
                        it.dispatchInitialEventPass(this.relevantChanges, layoutCoordinates, internalPointerEvent);
                    } while (++i$iv < size$iv);
                }
            } else {
                MutableVector<Node> this_$iv = this.getChildren();
                boolean $i$f$forEach = false;
                int size$iv = this_$iv.getSize();
                if (size$iv > 0) {
                    i$iv = 0;
                    Object[] content$iv = this_$iv.getContent();
                    do {
                        Node it = (Node)content$iv[i$iv];
                        boolean bl = false;
                        it.dispatchInitialEventPass(changes, parentCoordinates, internalPointerEvent);
                    } while (++i$iv < size$iv);
                }
            }
        }
        return true;
    }

    @Override
    public boolean dispatchMainEventPass(@NotNull InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        if (!this.getPointerInputNode().isAttached()) {
            return false;
        }
        if (this.getPointerInputNode().isAttached()) {
            if (this.pointerEvent != null) {
                MutableVector<Node> this_$iv = this.getChildren();
                boolean $i$f$forEachReversed = false;
                int size$iv = this_$iv.getSize();
                if (size$iv > 0) {
                    int i$iv = size$iv - 1;
                    Object[] content$iv = this_$iv.getContent();
                    do {
                        Node it = (Node)content$iv[i$iv];
                        boolean bl = false;
                        it.dispatchMainEventPass(internalPointerEvent);
                    } while (--i$iv >= 0);
                }
            } else {
                MutableVector<Node> this_$iv = this.getChildren();
                boolean $i$f$forEachReversed = false;
                int size$iv = this_$iv.getSize();
                if (size$iv > 0) {
                    int i$iv = size$iv - 1;
                    Object[] content$iv = this_$iv.getContent();
                    do {
                        Node it = (Node)content$iv[i$iv];
                        boolean bl = false;
                        it.dispatchMainEventPass(internalPointerEvent);
                    } while (--i$iv >= 0);
                }
            }
        }
        if (this.pointerEvent != null && this.getPointerInputNode().isAttached()) {
            LayoutNode layoutNode = this.getPointerInputNode();
            PointerEvent pointerEvent = this.pointerEvent;
            Intrinsics.checkNotNull((Object)pointerEvent);
            LayoutCoordinates layoutCoordinates = this.coordinates;
            Intrinsics.checkNotNull((Object)layoutCoordinates);
            PointerInputModifierNodeKt.onPointerEvent-hUlJWOE(layoutNode, pointerEvent, PointerEventPass.Main, layoutCoordinates.getSize-YbymL2g());
        }
        return true;
    }

    @Override
    public boolean dispatchFinalEventPass(@NotNull InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        if (!this.getPointerInputNode().isAttached()) {
            return false;
        }
        boolean dispatched = false;
        PointerEvent pointerEvent = this.pointerEvent;
        if (pointerEvent != null) {
            PointerEvent event = pointerEvent;
            boolean bl = false;
            LayoutCoordinates layoutCoordinates = this.coordinates;
            Intrinsics.checkNotNull((Object)layoutCoordinates);
            long size2 = layoutCoordinates.getSize-YbymL2g();
            PointerInputModifierNodeKt.onPointerEvent-hUlJWOE(this.getPointerInputNode(), event, PointerEventPass.Final, size2);
            dispatched = true;
        }
        if (this.getPointerInputNode().isAttached()) {
            MutableVector<Node> this_$iv = this.getChildren();
            boolean $i$f$forEach = false;
            int size$iv = this_$iv.getSize();
            if (size$iv > 0) {
                int i$iv = 0;
                Object[] content$iv = this_$iv.getContent();
                do {
                    Node it = (Node)content$iv[i$iv];
                    boolean bl = false;
                    dispatched = it.dispatchFinalEventPass(internalPointerEvent) || dispatched;
                } while (++i$iv < size$iv);
            }
        }
        if (!PointerEventType.equals-impl0(internalPointerEvent.getType-7fucELk(), PointerEventType.Companion.getScroll-7fucELk())) {
            this.cleanUpHits(internalPointerEvent);
        }
        this.clearCache();
        return dispatched;
    }

    private final void buildCache(Map<PointerId, PointerInputChange> changes, LayoutCoordinates parentCoordinates, InternalPointerEvent internalPointerEvent) {
        PointerInputChange pointerInputChange;
        PointerEvent event;
        block10: {
            if (!this.getPointerInputNode().isAttached()) {
                return;
            }
            this.coordinates = PointerInputModifierNodeKt.getLayoutCoordinates(this.getPointerInputNode());
            for (Map.Entry<PointerId, PointerInputChange> entry : changes.entrySet()) {
                boolean isRelevantForInboundDrag;
                long key = entry.getKey().unbox-impl();
                PointerInputChange change = entry.getValue();
                boolean isInOrJustExited = this.isIn || this.hasEntered;
                boolean isRelevantForHover = internalPointerEvent.issuesEnterExitEvent-0FcD4WY(change.getId-J3iCeTQ()) && !change.getPressed() && !change.getPreviousPressed();
                PointerInputFilter pointerInputFilter = this.getPointerInputNode().getPointerInputFilter();
                Intrinsics.checkNotNull((Object)pointerInputFilter);
                boolean bl = isRelevantForInboundDrag = pointerInputFilter.getInboundDragEnabled() && change.getPreviousPressed();
                if ((!isInOrJustExited || !isRelevantForHover && !isRelevantForInboundDrag) && !this.pointerIds.contains((Object)PointerId.box-impl(key))) continue;
                List historical = new ArrayList();
                Object $this$fastForEach$iv = change.getHistorical();
                boolean $i$f$fastForEach22 = false;
                int n = $this$fastForEach$iv.size();
                for (int index$iv22 = 0; index$iv22 < n; ++index$iv22) {
                    HistoricalChange item$iv;
                    HistoricalChange it = item$iv = $this$fastForEach$iv.get(index$iv22);
                    boolean bl2 = false;
                    long l = it.getUptimeMillis();
                    LayoutCoordinates layoutCoordinates = this.coordinates;
                    Intrinsics.checkNotNull((Object)layoutCoordinates);
                    historical.add(new HistoricalChange(l, layoutCoordinates.localPositionOf-R5De75A(parentCoordinates, it.getPosition-F1C5BW0()), null));
                }
                $this$fastForEach$iv = this.relevantChanges;
                PointerId $i$f$fastForEach22 = PointerId.box-impl(key);
                LayoutCoordinates layoutCoordinates = this.coordinates;
                Intrinsics.checkNotNull((Object)layoutCoordinates);
                long index$iv22 = layoutCoordinates.localPositionOf-R5De75A(parentCoordinates, change.getPreviousPosition-F1C5BW0());
                LayoutCoordinates layoutCoordinates2 = this.coordinates;
                Intrinsics.checkNotNull((Object)layoutCoordinates2);
                long l = layoutCoordinates2.localPositionOf-R5De75A(parentCoordinates, change.getPosition-F1C5BW0());
                PointerInputChange index$iv22 = PointerInputChange.copy-1nIveYk$default(change, 0L, 0L, l, 0L, false, 0.0f, 0L, index$iv22, 0L, false, 0, historical, 0L, 6011, null);
                $this$fastForEach$iv.put($i$f$fastForEach22, index$iv22);
            }
            MutableVector<PointerId> this_$iv = this.pointerIds;
            boolean $i$f$getLastIndex = false;
            for (int i = this_$iv.getSize() - 1; -1 < i; --i) {
                MutableVector<PointerId> this_$iv2 = this.pointerIds;
                boolean $i$f$get = false;
                long pointerId = ((PointerId)this_$iv2.getContent()[i]).unbox-impl();
                if (changes.containsKey(PointerId.box-impl(pointerId))) continue;
                this.pointerIds.removeAt(i);
            }
            if (this.relevantChanges.isEmpty()) {
                return;
            }
            event = new PointerEvent(CollectionsKt.toList((Iterable)this.relevantChanges.values()), internalPointerEvent);
            List<PointerInputChange> $this$fastFirstOrNull$iv = event.getChanges();
            boolean $i$f$fastFirstOrNull = false;
            List<PointerInputChange> $this$fastForEach$iv$iv = $this$fastFirstOrNull$iv;
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv$iv.size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                PointerInputChange item$iv$iv;
                PointerInputChange it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl = false;
                PointerInputChange it = it$iv;
                boolean bl3 = false;
                if (!internalPointerEvent.issuesEnterExitEvent-0FcD4WY(it.getId-J3iCeTQ())) continue;
                pointerInputChange = it$iv;
                break block10;
            }
            pointerInputChange = null;
        }
        PointerInputChange enterExitChange = pointerInputChange;
        if (enterExitChange != null) {
            if (PointerEventType.equals-impl0(event.getType-7fucELk(), PointerEventType.Companion.getMove-7fucELk())) {
                event.setType-EhbLWgg$fleet_noria_ui(!this.hasEntered && this.isIn ? PointerEventType.Companion.getEnter-7fucELk() : (this.hasEntered && !this.isIn ? PointerEventType.Companion.getExit-7fucELk() : PointerEventType.Companion.getMove-7fucELk()));
            }
            if (PointerEventType.equals-impl0(event.getType-7fucELk(), PointerEventType.Companion.getEnter-7fucELk())) {
                this.hasEntered = true;
            }
            if (PointerEventType.equals-impl0(event.getType-7fucELk(), PointerEventType.Companion.getExit-7fucELk())) {
                this.hasEntered = false;
            }
        }
        this.pointerEvent = event;
    }

    private final void clearCache() {
        this.relevantChanges.clear();
        this.coordinates = null;
        this.pointerEvent = null;
    }

    @Override
    public void dispatchCancel() {
        MutableVector<Node> this_$iv = this.getChildren();
        boolean $i$f$forEachReversed = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = size$iv - 1;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                it.dispatchCancel();
            } while (--i$iv >= 0);
        }
        PointerInputModifierNodeKt.onCancelPointerInput(this.getPointerInputNode());
    }

    @Override
    public void cleanUpHits(@NotNull InternalPointerEvent internalPointerEvent) {
        Intrinsics.checkNotNullParameter((Object)internalPointerEvent, (String)"internalPointerEvent");
        super.cleanUpHits(internalPointerEvent);
        PointerEvent pointerEvent = this.pointerEvent;
        if (pointerEvent == null) {
            return;
        }
        PointerEvent event = pointerEvent;
        if (this.pointerIds.isNotEmpty()) {
            List<PointerInputChange> $this$fastForEach$iv = event.getChanges();
            boolean $i$f$fastForEach = false;
            int n = $this$fastForEach$iv.size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                PointerInputChange item$iv;
                PointerInputChange change = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl = false;
                if (change.getPressed()) {
                    if (this.isIn) continue;
                    PointerInputFilter pointerInputFilter = this.getPointerInputNode().getPointerInputFilter();
                    Intrinsics.checkNotNull((Object)pointerInputFilter);
                    if (pointerInputFilter.getInterceptOutOfBoundsDragEventsAfterPress()) continue;
                }
                this.pointerIds.remove((Object)PointerId.box-impl(change.getId-J3iCeTQ()));
            }
        }
    }

    @NotNull
    public String toString() {
        return "Node(pointerInputFilter=" + this.getPointerInputNode() + ", children=" + this.getChildren() + ", pointerIds=" + this.pointerIds + ")";
    }

    @Override
    public void print(int depth) {
        String string = StringsKt.repeat((CharSequence)"  ", (int)depth);
        String string2 = IntSize.toString-impl(this.getPointerInputNode().getSize-YbymL2g());
        String string3 = this.getPointerInputNode().getDebugName();
        PointerInputFilter pointerInputFilter = this.getPointerInputNode().getPointerInputFilter();
        Intrinsics.checkNotNull((Object)pointerInputFilter);
        System.out.println((Object)(string + this.pointerInputNodeId + ": " + string2 + " " + string3 + ", isIn=" + this.isIn + ", hasEntered=" + this.hasEntered + ", shareWithNodesBehind=" + pointerInputFilter.getShareWithNodesBehind() + ", pointerIds=" + CollectionsKt.joinToString$default((Iterable)this.pointerIds.asMutableList(), null, null, null, (int)0, null, null, (int)63, null)));
        MutableVector<Node> this_$iv = this.getChildren();
        boolean $i$f$forEach = false;
        int size$iv = this_$iv.getSize();
        if (size$iv > 0) {
            int i$iv = 0;
            Object[] content$iv = this_$iv.getContent();
            do {
                Node it = (Node)content$iv[i$iv];
                boolean bl = false;
                it.print(depth + 1);
            } while (++i$iv < size$iv);
        }
    }

    public /* synthetic */ Node(NodeParent parent, int pointerInputNodeId, DefaultConstructorMarker $constructor_marker) {
        this(parent, pointerInputNodeId);
    }
}

