/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.transport.jre;

import java.io.File;
import java.util.Random;
import org.freedesktop.dbus.connections.BusAddress;
import org.freedesktop.dbus.connections.transports.AbstractTransport;
import org.freedesktop.dbus.exceptions.TransportConfigurationException;
import org.freedesktop.dbus.spi.transport.ITransportProvider;
import org.freedesktop.dbus.transport.jre.NativeUnixSocketTransport;
import org.freedesktop.dbus.utils.Util;
import org.slf4j.LoggerFactory;

public class NativeTransportProvider
implements ITransportProvider {
    public String getTransportName() {
        return "dbus-java-transport-native-unixsocket";
    }

    public AbstractTransport createTransport(BusAddress _address, int _timeout) throws TransportConfigurationException {
        return new NativeUnixSocketTransport(_address);
    }

    public String getSupportedBusType() {
        return "UNIX";
    }

    public String createDynamicSessionAddress(boolean _listeningSocket) {
        Object address = "unix:";
        String path = new File(System.getProperty("java.io.tmpdir"), "dbus-XXXXXXXXXX").getAbsolutePath();
        Random r = new Random();
        do {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < 10; ++i) {
                sb.append((char)(Math.abs(r.nextInt()) % 26 + 65));
            }
            path = path.replaceAll("..........$", sb.toString());
            LoggerFactory.getLogger(this.getClass()).trace("Trying path {}", (Object)path);
        } while (new File(path).exists());
        address = (String)address + "path=" + path + ",";
        if (_listeningSocket) {
            address = (String)address + "listen=true,";
        }
        address = (String)address + "guid=" + Util.genGUID();
        LoggerFactory.getLogger(this.getClass()).debug("Created Session address: {}", address);
        return address;
    }
}

