/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.python.psi;

import com.google.common.collect.ImmutableList;
import fleet.com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringLiteralCoreUtil {
    public static final String PREFIX_CHARACTERS = "ubcrf";
    public static final int MAX_PREFIX_LENGTH = 3;
    private static final ImmutableList<String> QUOTES = ImmutableList.of((Object)"'''", (Object)"\"\"\"", (Object)"'", (Object)"\"");

    protected PyStringLiteralCoreUtil() {
    }

    @Nullable
    public static Pair<String, String> getQuotes(@NotNull String text) {
        String prefix = PyStringLiteralCoreUtil.getPrefix(text);
        String mainText = text.substring(prefix.length());
        for (String quote : QUOTES) {
            Pair<String, String> quotes = PyStringLiteralCoreUtil.getQuotes(mainText, prefix, quote);
            if (quotes == null) continue;
            return quotes;
        }
        return null;
    }

    public static int getPrefixEndOffset(@NotNull CharSequence text, int startOffset) {
        int offset;
        for (offset = startOffset; offset < Math.min(startOffset + 3, text.length()) && PREFIX_CHARACTERS.indexOf(Character.toLowerCase(text.charAt(offset))) >= 0; ++offset) {
        }
        return offset;
    }

    @NotNull
    public static String getPrefix(@NotNull CharSequence text) {
        return PyStringLiteralCoreUtil.getPrefix(text, 0);
    }

    @NotNull
    public static String getPrefix(@NotNull CharSequence text, int startOffset) {
        return text.subSequence(startOffset, PyStringLiteralCoreUtil.getPrefixEndOffset(text, startOffset)).toString();
    }

    @Nullable
    private static Pair<String, String> getQuotes(@NotNull String text, @NotNull String prefix, @NotNull String quote) {
        int n;
        int length = text.length();
        if (length >= 2 * (n = quote.length()) && text.startsWith(quote) && text.endsWith(quote)) {
            return Pair.create((Object)(prefix + text.substring(0, n)), (Object)text.substring(length - n));
        }
        return null;
    }

    public static String stripQuotesAroundValue(String text) {
        Pair<String, String> quotes = PyStringLiteralCoreUtil.getQuotes(text);
        if (quotes == null) {
            return text;
        }
        return text.substring(((String)quotes.first).length(), text.length() - ((String)quotes.second).length());
    }

    public static boolean isQuoted(@Nullable String text) {
        return text != null && PyStringLiteralCoreUtil.getQuotes(text) != null;
    }
}

