/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.python.parsing;

import fleet.com.intellij.lang.SyntaxTreeBuilder;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.intellij.util.containers.Stack;
import fleet.com.jetbrains.python.PyElementTypes;
import fleet.com.jetbrains.python.PyParsingBundle;
import fleet.com.jetbrains.python.PyTokenTypes;
import fleet.com.jetbrains.python.parsing.Parsing;
import fleet.com.jetbrains.python.parsing.ParsingContext;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;

public class PatternParsing
extends Parsing {
    private final Stack<IElementType> myPendingClosingBraces = new Stack();

    protected PatternParsing(@NotNull ParsingContext context) {
        super(context);
    }

    public boolean parseCasePattern() {
        try {
            boolean bl = this.parseMaybeSequencePatternWithoutParentheses();
            return bl;
        }
        finally {
            this.myPendingClosingBraces.clear();
        }
    }

    private boolean parseMaybeSequencePatternWithoutParentheses() {
        SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
        CommaSeparation result = this.parseCommaSeparatedPatterns(this::parsePattern);
        if (result != CommaSeparation.NO_ELEMENTS) {
            if (result == CommaSeparation.EXISTS) {
                mark.done((IElementType)PyElementTypes.SEQUENCE_PATTERN);
            } else {
                mark.drop();
            }
            return true;
        }
        mark.drop();
        return false;
    }

    private boolean parsePattern() {
        return this.parseMaybeAsPattern();
    }

    private boolean parseMaybeAsPattern() {
        SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
        if (this.parseMaybeOrPattern()) {
            if (this.atToken(PyTokenTypes.AS_KEYWORD)) {
                this.nextToken();
                if (this.atSimpleNameNotUnderscore()) {
                    PatternParsing.buildTokenElement(PyElementTypes.TARGET_EXPRESSION, this.myBuilder);
                } else {
                    this.myBuilder.error(PyParsingBundle.message("PARSE.expected.name", new Object[0]));
                }
                mark.done((IElementType)PyElementTypes.AS_PATTERN);
                this.consumeIllegalLeftoverExpressionTokens();
            } else {
                mark.drop();
            }
            return true;
        }
        mark.drop();
        return false;
    }

    private boolean parseMaybeOrPattern() {
        SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
        if (this.parseClosedPattern()) {
            if (this.atToken(PyTokenTypes.OR)) {
                while (this.atToken(PyTokenTypes.OR)) {
                    this.nextToken();
                    if (this.parseClosedPattern()) continue;
                    this.myBuilder.error(PyParsingBundle.message("PARSE.expected.pattern", new Object[0]));
                    break;
                }
                mark.done((IElementType)PyElementTypes.OR_PATTERN);
            } else {
                mark.drop();
            }
            return true;
        }
        mark.drop();
        return false;
    }

    private boolean parseClosedPattern() {
        boolean parsed;
        boolean bl = parsed = this.parseLiteralPattern() || this.parseGroupOrParenthesizedSequencePattern() || this.parseSequencePatternInBrackets() || this.parseMappingPattern() || this.parseClassPattern() || this.parseValuePattern() || this.parseWildcardPattern() || this.parseCapturePattern() || this.parseDoubleStarPattern() || this.parseSingleStarPattern();
        if (parsed) {
            this.consumeIllegalLeftoverExpressionTokens();
        }
        return parsed;
    }

    private boolean parseClassPattern() {
        if (this.atToken(PyTokenTypes.IDENTIFIER)) {
            SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
            this.parseReferenceExpression();
            if (!this.atToken(PyTokenTypes.LPAR)) {
                mark.rollbackTo();
                return false;
            }
            this.parseClassPatternArgumentList();
            mark.done((IElementType)PyElementTypes.CLASS_PATTERN);
            return true;
        }
        return false;
    }

    private void parseClassPatternArgumentList() {
        assert (this.atToken(PyTokenTypes.LPAR));
        SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
        this.nextToken();
        this.registerConsumedBracket(PyTokenTypes.LPAR);
        this.parseCommaSeparatedPatterns(this::parseClassPatternArgument);
        if (this.checkMatches(PyTokenTypes.RPAR, PyParsingBundle.message("PARSE.expected.rpar", new Object[0]))) {
            this.registerConsumedBracket(PyTokenTypes.RPAR);
        }
        mark.done((IElementType)PyElementTypes.PATTERN_ARGUMENT_LIST);
    }

    private boolean parseClassPatternArgument() {
        if (this.atToken(PyTokenTypes.IDENTIFIER) && this.myBuilder.lookAhead(1) == PyTokenTypes.EQ) {
            SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
            this.nextToken();
            this.nextToken();
            if (!this.parsePattern()) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.pattern", new Object[0]));
            }
            mark.done((IElementType)PyElementTypes.KEYWORD_PATTERN);
            return true;
        }
        return this.parsePattern();
    }

    private boolean parseMappingPattern() {
        if (this.atToken(PyTokenTypes.LBRACE)) {
            SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
            this.nextToken();
            this.registerConsumedBracket(PyTokenTypes.LBRACE);
            this.parseCommaSeparatedPatterns(this::parseKeyValuePatternOrDoubleStarPattern);
            if (this.checkMatches(PyTokenTypes.RBRACE, PyParsingBundle.message("PARSE.expected.rbrace", new Object[0]))) {
                this.registerConsumedBracket(PyTokenTypes.RBRACE);
            }
            mark.done((IElementType)PyElementTypes.MAPPING_PATTERN);
            return true;
        }
        return false;
    }

    private boolean parseKeyValuePatternOrDoubleStarPattern() {
        if (this.parseDoubleStarPattern()) {
            this.consumeIllegalLeftoverExpressionTokens();
            return true;
        }
        SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
        if (this.parsePattern()) {
            if (!this.checkMatches(PyTokenTypes.COLON, PyParsingBundle.message("PARSE.expected.colon", new Object[0]))) {
                mark.drop();
                return true;
            }
            if (!this.parsePattern()) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.pattern", new Object[0]));
            }
            mark.done((IElementType)PyElementTypes.KEY_VALUE_PATTERN);
            return true;
        }
        mark.drop();
        return false;
    }

    private boolean parseDoubleStarPattern() {
        if (this.atToken(PyTokenTypes.EXP)) {
            SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
            this.nextToken();
            if (!this.parseCapturePattern()) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.name", new Object[0]));
            }
            mark.done((IElementType)PyElementTypes.DOUBLE_STAR_PATTERN);
            return true;
        }
        return false;
    }

    private boolean parseSingleStarPattern() {
        if (this.atToken(PyTokenTypes.MULT)) {
            SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
            this.nextToken();
            if (!this.parseWildcardPattern() && !this.parseCapturePattern()) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.name.or.wildcard", new Object[0]));
            }
            mark.done((IElementType)PyElementTypes.SINGLE_STAR_PATTERN);
            return true;
        }
        return false;
    }

    private boolean parseGroupOrParenthesizedSequencePattern() {
        if (this.atToken(PyTokenTypes.LPAR)) {
            SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
            this.nextToken();
            this.registerConsumedBracket(PyTokenTypes.LPAR);
            CommaSeparation result = this.parseCommaSeparatedPatterns(this::parsePattern);
            if (this.checkMatches(PyTokenTypes.RPAR, PyParsingBundle.message("PARSE.expected.rpar", new Object[0]))) {
                this.registerConsumedBracket(PyTokenTypes.RPAR);
            }
            mark.done((IElementType)(result == CommaSeparation.SINGLE_NO_COMMA ? PyElementTypes.GROUP_PATTERN : PyElementTypes.SEQUENCE_PATTERN));
            return true;
        }
        return false;
    }

    private boolean parseSequencePatternInBrackets() {
        if (this.atToken(PyTokenTypes.LBRACKET)) {
            SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
            this.nextToken();
            this.registerConsumedBracket(PyTokenTypes.LBRACKET);
            this.parseCommaSeparatedPatterns(this::parsePattern);
            if (this.checkMatches(PyTokenTypes.RBRACKET, PyParsingBundle.message("PARSE.expected.rbracket", new Object[0]))) {
                this.registerConsumedBracket(PyTokenTypes.RBRACKET);
            }
            mark.done((IElementType)PyElementTypes.SEQUENCE_PATTERN);
            return true;
        }
        return false;
    }

    @NotNull
    private CommaSeparation parseCommaSeparatedPatterns(@NotNull BooleanSupplier patternParser) {
        CommaSeparation result = CommaSeparation.NO_ELEMENTS;
        boolean afterPattern = patternParser.getAsBoolean();
        if (afterPattern || this.atToken(PyTokenTypes.COMMA)) {
            result = CommaSeparation.SINGLE_NO_COMMA;
            while (this.atToken(PyTokenTypes.COMMA)) {
                result = CommaSeparation.EXISTS;
                if (!afterPattern) {
                    this.myBuilder.error(PyParsingBundle.message("PARSE.expected.pattern", new Object[0]));
                }
                this.nextToken();
                afterPattern = patternParser.getAsBoolean();
                if (afterPattern || this.atToken(PyTokenTypes.COMMA)) continue;
                break;
            }
        }
        return result;
    }

    private boolean parseWildcardPattern() {
        if (this.atToken(PyTokenTypes.IDENTIFIER, "_")) {
            IElementType nextToken = this.myBuilder.lookAhead(1);
            if (nextToken == PyTokenTypes.DOT || nextToken == PyTokenTypes.LPAR) {
                return false;
            }
            PatternParsing.buildTokenElement(PyElementTypes.WILDCARD_PATTERN, this.myBuilder);
            return true;
        }
        return false;
    }

    private boolean parseCapturePattern() {
        if (this.atSimpleNameNotUnderscore()) {
            SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
            PatternParsing.buildTokenElement(PyElementTypes.TARGET_EXPRESSION, this.myBuilder);
            mark.done((IElementType)PyElementTypes.CAPTURE_PATTERN);
            return true;
        }
        return false;
    }

    private boolean atSimpleNameNotUnderscore() {
        if (!this.atToken(PyTokenTypes.IDENTIFIER) || "_".equals(this.myBuilder.getTokenText())) {
            return false;
        }
        IElementType afterName = this.myBuilder.lookAhead(1);
        return afterName != PyTokenTypes.DOT && afterName != PyTokenTypes.LPAR;
    }

    private boolean parseValuePattern() {
        if (this.atToken(PyTokenTypes.IDENTIFIER) && this.myBuilder.lookAhead(1) == PyTokenTypes.DOT) {
            SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
            this.parseReferenceExpression();
            mark.done((IElementType)PyElementTypes.VALUE_PATTERN);
            return true;
        }
        return false;
    }

    private boolean parseReferenceExpression() {
        if (this.atToken(PyTokenTypes.IDENTIFIER)) {
            SyntaxTreeBuilder.Marker refExpr = this.myBuilder.mark();
            this.nextToken();
            refExpr.done((IElementType)PyElementTypes.REFERENCE_EXPRESSION);
            while (this.matchToken(PyTokenTypes.DOT)) {
                refExpr = refExpr.precede();
                this.checkMatches(PyTokenTypes.IDENTIFIER, PyParsingBundle.message("PARSE.expected.name", new Object[0]));
                refExpr.done((IElementType)PyElementTypes.REFERENCE_EXPRESSION);
            }
            return true;
        }
        return false;
    }

    private boolean parseLiteralPattern() {
        SyntaxTreeBuilder.Marker marker = this.myBuilder.mark();
        if (this.parseAllowedLiteralExpression()) {
            marker.done((IElementType)PyElementTypes.LITERAL_PATTERN);
            return true;
        }
        marker.drop();
        return false;
    }

    private boolean parseAllowedLiteralExpression() {
        if (this.atAnyOfTokens(PyTokenTypes.STRING_NODES)) {
            SyntaxTreeBuilder.Marker stringLiteral = this.myBuilder.mark();
            while (this.atAnyOfTokens(PyTokenTypes.STRING_NODES)) {
                this.nextToken();
            }
            stringLiteral.done((IElementType)PyElementTypes.STRING_LITERAL_EXPRESSION);
            return true;
        }
        if (this.atAnyOfTokens(PyTokenTypes.TRUE_KEYWORD, PyTokenTypes.FALSE_KEYWORD)) {
            PatternParsing.buildTokenElement(PyElementTypes.BOOL_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (this.atToken(PyTokenTypes.NONE_KEYWORD)) {
            PatternParsing.buildTokenElement(PyElementTypes.NONE_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (this.atAnyOfTokens(PyTokenTypes.PLUS, PyTokenTypes.MINUS) || this.atAnyOfTokens(PyTokenTypes.NUMERIC_LITERALS)) {
            this.parseComplexNumber();
            return true;
        }
        return false;
    }

    private void parseComplexNumber() {
        SyntaxTreeBuilder.Marker complexLiteral = this.myBuilder.mark();
        if (this.atAnyOfTokens(PyTokenTypes.PLUS, PyTokenTypes.MINUS)) {
            SyntaxTreeBuilder.Marker prefixExpression = this.myBuilder.mark();
            this.nextToken();
            if (!this.parseNumericLiteral()) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.number", new Object[0]));
            }
            prefixExpression.done((IElementType)PyElementTypes.PREFIX_EXPRESSION);
        } else {
            this.parseNumericLiteral();
        }
        if (this.atAnyOfTokens(PyTokenTypes.PLUS, PyTokenTypes.MINUS)) {
            this.nextToken();
            if (!this.parseNumericLiteral()) {
                this.myBuilder.error(PyParsingBundle.message("PARSE.expected.number", new Object[0]));
            }
            complexLiteral.done((IElementType)PyElementTypes.BINARY_EXPRESSION);
        } else {
            complexLiteral.drop();
        }
    }

    private boolean parseNumericLiteral() {
        if (this.atToken(PyTokenTypes.INTEGER_LITERAL)) {
            PatternParsing.buildTokenElement(PyElementTypes.INTEGER_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (this.atToken(PyTokenTypes.FLOAT_LITERAL)) {
            PatternParsing.buildTokenElement(PyElementTypes.FLOAT_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        if (this.atToken(PyTokenTypes.IMAGINARY_LITERAL)) {
            PatternParsing.buildTokenElement(PyElementTypes.IMAGINARY_LITERAL_EXPRESSION, this.myBuilder);
            return true;
        }
        return false;
    }

    private void consumeIllegalLeftoverExpressionTokens() {
        SyntaxTreeBuilder.Marker mark = this.myBuilder.mark();
        int initialBalance = this.myPendingClosingBraces.size();
        boolean consumedAny = false;
        while (!this.myBuilder.eof() && !this.atAnyOfTokens(PyTokenTypes.IF_KEYWORD, PyTokenTypes.COLON, PyTokenTypes.AS_KEYWORD, PyTokenTypes.OR, PyTokenTypes.STATEMENT_BREAK)) {
            IElementType token = this.myBuilder.getTokenType();
            if (this.myPendingClosingBraces.size() == initialBalance && (this.myPendingClosingBraces.contains((Object)token) || token == PyTokenTypes.COMMA)) break;
            this.nextToken();
            consumedAny = true;
            if (!PyTokenTypes.ALL_BRACES.contains(token)) continue;
            this.registerConsumedBracket(token);
        }
        if (consumedAny) {
            mark.error(PyParsingBundle.message("unexpected.tokens", new Object[0]));
        } else {
            mark.drop();
        }
    }

    private void registerConsumedBracket(@NotNull IElementType bracketType) {
        if (PyTokenTypes.OPEN_BRACES.contains(bracketType)) {
            this.myPendingClosingBraces.push((Object)(bracketType == PyTokenTypes.LBRACE ? PyTokenTypes.RBRACE : (bracketType == PyTokenTypes.LBRACKET ? PyTokenTypes.RBRACKET : (bracketType == PyTokenTypes.LPAR ? PyTokenTypes.RPAR : null))));
        } else if (PyTokenTypes.CLOSE_BRACES.contains(bracketType) && this.myPendingClosingBraces.contains((Object)bracketType)) {
            while (this.myPendingClosingBraces.peek() != bracketType) {
                this.myPendingClosingBraces.pop();
            }
            IElementType expected = (IElementType)this.myPendingClosingBraces.pop();
            assert (expected == bracketType);
        }
    }

    private static enum CommaSeparation {
        NO_ELEMENTS,
        SINGLE_NO_COMMA,
        EXISTS;

    }
}

