/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.jetbrains.python.lexer;

import fleet.com.intellij.lexer.LexerBase;
import fleet.com.intellij.openapi.diagnostic.Logger;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.StringEscapesTokenTypes;
import fleet.com.intellij.psi.tree.IElementType;
import fleet.com.jetbrains.python.lexer.PyStringLiteralLexer;
import org.jetbrains.annotations.NotNull;

public abstract class PyStringLiteralLexerBase
extends LexerBase {
    protected static final Logger LOG = Logger.getInstance(PyStringLiteralLexer.class);
    protected final IElementType myOriginalLiteralToken;
    protected CharSequence myBuffer;
    protected int myBufferEnd;
    protected int myStart;
    protected int myEnd;
    protected int myBaseLexerState;
    private boolean mySeenEscapedSpacesOnly;

    public PyStringLiteralLexerBase(IElementType originalLiteralToken) {
        this.myOriginalLiteralToken = originalLiteralToken;
    }

    public final void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBuffer = buffer;
        this.myStart = startOffset;
        this.mySeenEscapedSpacesOnly = true;
        this.myBufferEnd = endOffset;
        this.myBaseLexerState = initialState;
        this.handleStart(buffer, initialState);
        this.myEnd = this.locateToken(this.myStart);
    }

    protected void handleStart(@NotNull CharSequence buffer, int initialState) {
    }

    protected abstract boolean isRaw();

    protected abstract boolean isUnicodeMode();

    public IElementType getTokenType() {
        if (this.myStart >= this.myEnd) {
            return null;
        }
        if (!this.isEscape()) {
            this.mySeenEscapedSpacesOnly = false;
            return this.myOriginalLiteralToken;
        }
        return this.getEscapeSequenceType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public IElementType getEscapeSequenceType() {
        IElementType iElementType;
        if (this.myStart + 1 >= this.myEnd) {
            return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        }
        char nextChar = this.myBuffer.charAt(this.myStart + 1);
        this.mySeenEscapedSpacesOnly &= nextChar == ' ';
        if (nextChar == '\n' || nextChar == ' ' && (this.mySeenEscapedSpacesOnly || this.isTrailingSpace(this.myStart + 2))) {
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        if (nextChar == 'u' || nextChar == 'U') {
            if (!this.isUnicodeMode()) return this.myOriginalLiteralToken;
            int width = nextChar == 'u' ? 4 : 8;
            for (int i = this.myStart + 2; i < this.myStart + width + 2; ++i) {
                if (i < this.myEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(i))) continue;
                return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        if (nextChar == 'x') {
            for (int i = this.myStart + 2; i < this.myStart + 4; ++i) {
                if (i < this.myEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(i))) continue;
                return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        if (nextChar == 'N' && this.isUnicodeMode()) {
            int i = this.myStart + 2;
            if (i >= this.myEnd || this.myBuffer.charAt(i) != '{') {
                return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
            }
            ++i;
            while (i < this.myEnd && this.myBuffer.charAt(i) != '}') {
                ++i;
            }
            if (i < this.myEnd) return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
        }
        switch (nextChar) {
            case '\"': 
            case '\'': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '\\': 
            case 'a': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': 
            case 'v': {
                iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                return iElementType;
            }
            default: {
                iElementType = this.myOriginalLiteralToken;
            }
        }
        return iElementType;
    }

    protected boolean isEscape() {
        return this.myBuffer.charAt(this.myStart) == '\\' && (!this.isRaw() || this.isUnicodeMode() && this.nextIsUnicodeEscape());
    }

    private boolean nextIsUnicodeEscape() {
        if (this.myStart + 1 < this.myEnd) {
            char nextChar = this.myBuffer.charAt(this.myStart + 1);
            return nextChar == 'u' || nextChar == 'U';
        }
        return false;
    }

    private boolean isTrailingSpace(int start) {
        for (int i = start; i < this.myBufferEnd; i += 2) {
            char c = this.myBuffer.charAt(i);
            if (c != '\\') {
                return false;
            }
            if (i == this.myBufferEnd - 1) {
                return false;
            }
            if (this.myBuffer.charAt(i + 1) == ' ') continue;
            return false;
        }
        return true;
    }

    public final int getTokenStart() {
        assert (this.myStart < this.myEnd || this.myStart == this.myEnd && this.myEnd == this.myBufferEnd);
        return this.myStart;
    }

    public final int getTokenEnd() {
        if (this.myStart >= this.myEnd && (this.myStart != this.myEnd || this.myEnd != this.myBufferEnd)) {
            LOG.error("myStart=" + this.myStart + " myEnd=" + this.myEnd + " myBufferEnd=" + this.myBufferEnd + " text=" + this.myBuffer.subSequence(this.myStart, this.myBufferEnd));
        }
        return this.myEnd;
    }

    public final int getBufferEnd() {
        return this.myBufferEnd;
    }

    @NotNull
    public final CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    protected abstract int locateToken(int var1);

    protected final int locateEscapeSequence(int start) {
        assert (this.myBuffer.charAt(start) == '\\');
        int i = start;
        ++i;
        if (this.isRaw()) {
            return i;
        }
        if (i == this.myBufferEnd) {
            return i;
        }
        if (this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7') {
            char first = this.myBuffer.charAt(i);
            if (++i < this.myBufferEnd && this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7' && ++i < this.myBufferEnd && first <= '3' && this.myBuffer.charAt(i) >= '0' && this.myBuffer.charAt(i) <= '7') {
                ++i;
            }
            return i;
        }
        if (this.myBuffer.charAt(i) == 'x') {
            ++i;
            while (i < start + 4) {
                if (this.isEscapeEnd(i)) {
                    return i;
                }
                ++i;
            }
            return i;
        }
        if (this.myBuffer.charAt(i) == 'u' || this.myBuffer.charAt(i) == 'U') {
            int width = this.myBuffer.charAt(i) == 'u' ? 4 : 8;
            ++i;
            while (i < start + width + 2) {
                if (this.isEscapeEnd(i)) {
                    return i;
                }
                ++i;
            }
            return i;
        }
        if (this.myBuffer.charAt(i) == 'N' && this.isUnicodeMode()) {
            ++i;
            while (i < this.myBufferEnd && this.myBuffer.charAt(i) != '}' && this.myBuffer.charAt(i) != '\\') {
                ++i;
            }
            if (i < this.myBufferEnd && this.myBuffer.charAt(i) == '}') {
                ++i;
            }
            return i;
        }
        return i + 1;
    }

    protected boolean isEscapeEnd(int offset) {
        return offset == this.myBufferEnd || this.myBuffer.charAt(offset) == '\n' || this.myBuffer.charAt(offset) == '\\';
    }

    public void advance() {
        this.myStart = this.myEnd;
        this.myEnd = this.locateToken(this.myStart);
        if (this.myStart >= this.myEnd && (this.myStart != this.myEnd || this.myEnd != this.myBufferEnd)) {
            LOG.warn("Inconsistent: start " + this.myStart + ", end " + this.myEnd + ", buf end " + this.myBufferEnd);
        }
    }
}

