/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.messages;

import java.util.ArrayList;
import org.freedesktop.dbus.FileDescriptor;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.MessageFormatException;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.types.UInt32;
import org.freedesktop.dbus.utils.Hexdump;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodCall
extends Message {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static long REPLY_WAIT_TIMEOUT = 200000L;
    Message reply = null;

    MethodCall() {
    }

    public MethodCall(String dest, String path, String iface, String member, byte flags, String sig, Object ... args) throws DBusException {
        this(null, dest, path, iface, member, flags, sig, args);
    }

    public MethodCall(String source, String dest, String path, String iface, String member, byte flags, String sig, Object ... args) throws DBusException {
        super(DBusConnection.getEndianness(), (byte)1, flags);
        if (null == member || null == path) {
            throw new MessageFormatException("Must specify destination, path and function name to MethodCalls.");
        }
        this.getHeaders().put((byte)1, path);
        this.getHeaders().put((byte)3, member);
        ArrayList<Object[]> hargs = new ArrayList<Object[]>();
        hargs.add(new Object[]{(byte)1, new Object[]{"o", path}});
        if (null != source) {
            this.getHeaders().put((byte)7, source);
            hargs.add(new Object[]{(byte)7, new Object[]{"s", source}});
        }
        if (null != dest) {
            this.getHeaders().put((byte)6, dest);
            hargs.add(new Object[]{(byte)6, new Object[]{"s", dest}});
        }
        if (null != iface) {
            hargs.add(new Object[]{(byte)2, new Object[]{"s", iface}});
            this.getHeaders().put((byte)2, iface);
        }
        hargs.add(new Object[]{(byte)3, new Object[]{"s", member}});
        if (null != sig) {
            this.logger.debug("Appending arguments with signature: {}", (Object)sig);
            hargs.add(new Object[]{(byte)8, new Object[]{"g", sig}});
            this.getHeaders().put((byte)8, sig);
            this.setArgs(args);
        }
        int totalFileDes = 0;
        if (args != null) {
            for (int x = 0; x < args.length; ++x) {
                if (!(args[x] instanceof FileDescriptor)) continue;
                ++totalFileDes;
            }
        }
        if (totalFileDes > 0) {
            this.getHeaders().put((byte)9, totalFileDes);
            hargs.add(new Object[]{(byte)9, new Object[]{"u", new UInt32(totalFileDes)}});
        }
        byte[] blen = new byte[4];
        this.appendBytes(blen);
        this.append("ua(yv)", this.getSerial(), hargs.toArray());
        this.pad((byte)8);
        long c = this.getByteCounter();
        if (null != sig) {
            this.append(sig, args);
        }
        this.logger.debug("Appended body, type: {} start: {} end: {} size: {}", new Object[]{sig, c, this.getByteCounter(), this.getByteCounter() - c});
        this.marshallint(this.getByteCounter() - c, blen, 0, 4);
        this.logger.debug("marshalled size ({}): {}", (Object)blen, (Object)Hexdump.format(blen));
    }

    public static void setDefaultTimeout(long timeout) {
        REPLY_WAIT_TIMEOUT = timeout;
    }

    public synchronized boolean hasReply() {
        return null != this.reply;
    }

    public synchronized Message getReply(long timeout) {
        this.logger.trace("Blocking on {}", (Object)this);
        if (null != this.reply) {
            return this.reply;
        }
        try {
            this.wait(timeout);
            return this.reply;
        }
        catch (InterruptedException exI) {
            Thread.currentThread().interrupt();
            return this.reply;
        }
    }

    public synchronized Message getReply() {
        this.logger.trace("Blocking on {}", (Object)this);
        if (null != this.reply) {
            return this.reply;
        }
        try {
            this.wait(REPLY_WAIT_TIMEOUT);
            return this.reply;
        }
        catch (InterruptedException exI) {
            Thread.currentThread().interrupt();
            return this.reply;
        }
    }

    public synchronized void setReply(Message _reply) {
        this.logger.trace("Setting reply to {} to {}", (Object)this, (Object)_reply);
        this.reply = _reply;
        this.notifyAll();
    }
}

