/*
 * Decompiled with CFR 0.152.
 */
package fleet.com.goide.highlighting;

import fleet.com.goide.GoTypes;
import fleet.com.intellij.lexer.StringLiteralLexer;
import fleet.com.intellij.openapi.util.TextRange;
import fleet.com.intellij.openapi.util.text.StringUtil;
import fleet.com.intellij.psi.StringEscapesTokenTypes;
import fleet.com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class GoStringLiteralLexer
extends StringLiteralLexer {
    public static final String ADDITIONAL_VALID_ESCAPES = "av";
    public static final int LONG_UNICODE_ESCAPE_SEQUENCE_LENGTH = 10;

    public GoStringLiteralLexer() {
        super('\"', GoTypes.STRING, false, ADDITIONAL_VALID_ESCAPES, true, true);
    }

    protected int locateAdditionalEscapeSequence(int start, int indexOfCharAfterSlash) {
        if (this.myBuffer.charAt(indexOfCharAfterSlash) == 'U') {
            int location;
            for (location = indexOfCharAfterSlash + 1; location < start + 10; ++location) {
                if (location != this.myBufferEnd && this.myBuffer.charAt(location) != '\n' && this.myBuffer.charAt(location) != this.myQuoteChar) continue;
                return location;
            }
            return location;
        }
        return -1;
    }

    public IElementType getTokenType() {
        IElementType tokenType = super.getTokenType();
        if ((tokenType == StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN || tokenType == StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN) && this.isLongUnicodeSequencePrefix()) {
            return this.isLongUnicodeSequence() ? StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN : StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
        }
        return tokenType;
    }

    @NotNull
    public TextRange getTokenRange() {
        return new TextRange(this.getTokenStart(), this.getTokenEnd());
    }

    private boolean isLongUnicodeSequencePrefix() {
        return this.myStart + 1 < this.myEnd && this.myBuffer.charAt(this.myStart) == '\\' && this.myBuffer.charAt(this.myStart + 1) == 'U';
    }

    private boolean isLongUnicodeSequence() {
        if (this.myStart + 10 > this.myEnd) {
            return false;
        }
        if (this.isLongUnicodeSequencePrefix()) {
            for (int i = this.myStart + 2; i < this.myStart + 10; ++i) {
                if (StringUtil.isHexDigit((char)this.myBuffer.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

