/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.support.Native;
import org.clank.support.aliases.type;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.SmallPtrSetImpl;
import org.llvm.adt.aliases.DenseMapInfo;
import org.llvm.ir.Argument;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.CallSite;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.Function;
import org.llvm.ir.GEPOperator;
import org.llvm.ir.GlobalAlias;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.Instruction;
import org.llvm.ir.Module$IR;
import org.llvm.ir.Operator;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.Value;
import org.llvm.ir.ValueSymbolTable;
import org.llvm.ir.impl.PointerStripKind;
import org.llvm.ir.java.IrRTTI;

public final class ValueStatics {
    public static Type checkType(Type Ty) {
        assert (Ty != null) : "Value defined with a null type: Error!";
        return Ty;
    }

    public static boolean getSymTab(Value V, type.ref<ValueSymbolTable> ST) {
        ST.$set(null);
        Instruction I = IrRTTI.dyn_cast_Instruction(V);
        if (I != null) {
            Function PP;
            BasicBlock P2 = I.getParent();
            if (P2 != null && (PP = P2.getParent()) != null) {
                ST.$set((Object)((ValueSymbolTable)Native.$AddrOf((Object)PP.getValueSymbolTable())));
            }
        } else {
            BasicBlock BB = IrRTTI.dyn_cast_BasicBlock(V);
            if (BB != null) {
                Function P3 = BB.getParent();
                if (P3 != null) {
                    ST.$set((Object)((ValueSymbolTable)Native.$AddrOf((Object)P3.getValueSymbolTable())));
                }
            } else {
                GlobalValue GV = IrRTTI.dyn_cast_GlobalValue(V);
                if (GV != null) {
                    Module$IR P4 = GV.getParent();
                    if (P4 != null) {
                        ST.$set((Object)((ValueSymbolTable)Native.$AddrOf((Object)P4.getValueSymbolTable())));
                    }
                } else {
                    Argument A2 = IrRTTI.dyn_cast_Argument(V);
                    if (A2 != null) {
                        Function P5 = A2.getParent();
                        if (P5 != null) {
                            ST.$set((Object)((ValueSymbolTable)Native.$AddrOf((Object)P5.getValueSymbolTable())));
                        }
                    } else {
                        assert (IrRTTI.isa_Constant(V)) : "Unknown value type!";
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean contains(SmallPtrSetImpl<ConstantExpr> Cache, ConstantExpr Expr, Constant C2) {
        if (!Cache.insert((Object)Expr).second) {
            return false;
        }
        for (Use O : Expr.operands()) {
            if (O.$Value$P() == C2) {
                return true;
            }
            ConstantExpr CE = IrRTTI.dyn_cast_ConstantExpr(O);
            if (CE == null || !ValueStatics.contains(Cache, CE, C2)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(Value Expr, Value V) {
        if (Expr == V) {
            return true;
        }
        Constant C2 = IrRTTI.dyn_cast_Constant(V);
        if (C2 == null) {
            return false;
        }
        ConstantExpr CE = IrRTTI.dyn_cast_ConstantExpr(Expr);
        if (CE == null) {
            return false;
        }
        SmallPtrSet Cache = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 4);
        return ValueStatics.contains((SmallPtrSetImpl<ConstantExpr>)Cache, CE, C2);
    }

    public static Value stripPointerCastsAndOffsets(PointerStripKind StripKind, Value V) {
        if (!V.getType().isPointerTy()) {
            return V;
        }
        SmallPtrSet Visited = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 4);
        Visited.insert((Object)V);
        do {
            GEPOperator GEP;
            if ((GEP = IrRTTI.dyn_cast_GEPOperator(V)) != null) {
                switch (StripKind) {
                    case PSK_ZeroIndicesAndAliases: 
                    case PSK_ZeroIndices: {
                        if (GEP.hasAllZeroIndices()) break;
                        return V;
                    }
                    case PSK_InBoundsConstantIndices: {
                        if (!GEP.hasAllConstantIndices()) {
                            return V;
                        }
                    }
                    case PSK_InBounds: {
                        if (GEP.isInBounds()) break;
                        return V;
                    }
                }
                V = GEP.getPointerOperand();
            } else if (Operator.getOpcode(V) == 47 || Operator.getOpcode(V) == 48) {
                V = IrRTTI.cast_User(V).getOperand(0);
            } else {
                GlobalAlias GA = IrRTTI.dyn_cast_GlobalAlias(V);
                if (GA != null) {
                    if (StripKind == PointerStripKind.PSK_ZeroIndices || GA.isInterposable()) {
                        return V;
                    }
                    V = GA.getAliasee();
                } else {
                    Object RV;
                    CallSite CS = new CallSite(V);
                    if (CS.$bool() && (RV = CS.getReturnedArgOperand()) != null) {
                        V = RV;
                        continue;
                    }
                    return V;
                }
            }
            assert (V.getType().isPointerTy()) : "Unexpected operand type!";
        } while (Visited.insert((Object)V).second);
        return V;
    }
}

