/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.support.Unsigned;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.ilist_iterator;
import org.llvm.ir.Argument;
import org.llvm.ir.DataLayout;
import org.llvm.ir.Function;
import org.llvm.ir.Type;
import org.llvm.ir.impl.ManglerPrefixTy;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public final class ManglerStatics {
    public static void getNameWithPrefixImpl(raw_ostream OS, Twine GVName, ManglerPrefixTy PrefixTy, DataLayout DL, byte Prefix) {
        SmallString TmpData = new SmallString(256);
        StringRef Name = GVName.toStringRef(TmpData);
        assert (!Name.empty()) : "getNameWithPrefix requires non-empty name";
        if (Name.$at(0) == 1) {
            OS.$out(Name.substr(1));
            return;
        }
        if (PrefixTy == ManglerPrefixTy.Private) {
            OS.$out(DL.getPrivateGlobalPrefix());
        } else if (PrefixTy == ManglerPrefixTy.LinkerPrivate) {
            OS.$out(DL.getLinkerPrivateGlobalPrefix());
        }
        if (Prefix != 0) {
            OS.$out_char(Prefix);
        }
        OS.$out(Name);
    }

    public static void getNameWithPrefixImpl(raw_ostream OS, Twine GVName, DataLayout DL, ManglerPrefixTy PrefixTy) {
        byte Prefix = DL.getGlobalPrefix();
        ManglerStatics.getNameWithPrefixImpl(OS, GVName, PrefixTy, DL, Prefix);
    }

    public static boolean hasByteCountSuffix(int CC) {
        switch (CC) {
            case 64: 
            case 65: 
            case 80: {
                return true;
            }
        }
        return false;
    }

    public static void addByteCountSuffix(raw_ostream OS, Function F, DataLayout DL) {
        int ArgWords = 0;
        ilist_iterator<Argument> AI = F.arg_begin$Const();
        ilist_iterator<Argument> AE = F.arg_end$Const();
        while (AI.$noteq(AE)) {
            Type Ty = ((Argument)AI.$arrow()).getType();
            if (((Argument)AI.$arrow()).hasByValOrInAllocaAttr()) {
                Ty = IrRTTI.cast_PointerType(Ty).getElementType();
            }
            int PtrSize = DL.getPointerSize();
            ArgWords = (int)((long)ArgWords + llvm.alignTo((long)DL.getTypeAllocSize(Ty), (long)Unsigned.$uint2ulong((int)PtrSize)));
            AI.$preInc();
        }
        OS.$out_char((byte)64).$out_uint(ArgWords);
    }
}

