/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.llvm.adt.StringRef;
import org.llvm.adt.ilist_iterator;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.DILocalScope;
import org.llvm.ir.DISubprogram;
import org.llvm.ir.DebugLoc;
import org.llvm.ir.Function;
import org.llvm.ir.GVMaterializer;
import org.llvm.ir.Instruction;
import org.llvm.ir.MDNode;
import org.llvm.ir.Module$IR;
import org.llvm.ir.NamedMDNode;
import org.llvm.ir.java.IrRTTI;
import org.llvm.ir.mdconst.MdconstGlobals;
import org.llvm.pass.IrLlvmGlobals;

public final class DebugInfoLlvmGlobals {
    public static DISubprogram getDISubprogram(MDNode Scope) {
        DILocalScope LocalScope = IrRTTI.dyn_cast_or_null_DILocalScope(Scope);
        if (LocalScope != null) {
            return LocalScope.getSubprogram();
        }
        return null;
    }

    public static boolean StripDebugInfo(Module$IR M) {
        boolean Changed = false;
        ilist_iterator<NamedMDNode> NMI = M.named_metadata_begin();
        ilist_iterator<NamedMDNode> NME = M.named_metadata_end();
        while (NMI.$noteq(NME)) {
            NamedMDNode NMD = (NamedMDNode)Native.$AddrOf((Object)((NamedMDNode)NMI.$star()));
            NMI.$preInc();
            if (!NMD.getName().startswith("llvm.dbg.")) continue;
            NMD.eraseFromParent();
            Changed = true;
        }
        for (Function F : M) {
            Changed |= IrLlvmGlobals.stripDebugInfo(F);
        }
        GVMaterializer Materializer = M.getMaterializer();
        if (Materializer != null) {
            Materializer.setStripDebugInfo();
        }
        return Changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stripDebugInfo(Function F) {
        boolean Changed = false;
        if (F.getSubprogram() != null) {
            Changed = true;
            F.setSubprogram(null);
        }
        for (BasicBlock BB : F) {
            ilist_iterator<Instruction> II = BB.begin();
            ilist_iterator<Instruction> End = BB.end();
            while (II.$noteq(End)) {
                Instruction I = (Instruction)II.$postInc(0).$star();
                if (IrRTTI.isa_DbgInfoIntrinsic((Instruction)Native.$AddrOf((Object)I))) {
                    I.eraseFromParent();
                    Changed = true;
                    continue;
                }
                if (!I.getDebugLoc().$bool()) continue;
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    Changed = true;
                    I.setDebugLoc((DebugLoc)$c$.track((Object)new DebugLoc()));
                    $c$.clean();
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
        return Changed;
    }

    public static int getDebugMetadataVersionFromModule(Module$IR M) {
        ConstantInt Val = MdconstGlobals.dyn_extract_or_null$ValidReference(ConstantInt.class, M.getModuleFlag(new StringRef("Debug Info Version")));
        if (Val != null) {
            return Unsigned.$ulong2uint((long)Val.getZExtValue());
        }
        return 0;
    }
}

