/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import java.util.Iterator;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.APFloat;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.SmallPtrSetImpl;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUChar;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.ArrayRefULong;
import org.llvm.adt.aliases.ArrayRefUShort;
import org.llvm.adt.aliases.DenseMapInfo;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImplUChar;
import org.llvm.adt.aliases.SmallVectorImplUInt;
import org.llvm.adt.aliases.SmallVectorImplULong;
import org.llvm.adt.aliases.SmallVectorImplUShort;
import org.llvm.adt.aliases.SmallVectorUChar;
import org.llvm.adt.aliases.SmallVectorUInt;
import org.llvm.adt.aliases.SmallVectorULong;
import org.llvm.adt.aliases.SmallVectorUShort;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantDataArray;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.ConstantFP;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.Value;
import org.llvm.ir.impl.ConstantExprKeyType;
import org.llvm.ir.impl.ConstantFoldLlvmStatics;
import org.llvm.ir.impl.LLVMContextImpl;
import org.llvm.ir.java.IrRTTI;
import org.llvm.support.fltSemantics;

public final class ConstantsStatics {
    public static boolean canTrapImpl(Constant C2, SmallPtrSetImpl<ConstantExpr> NonTrappingOps) {
        assert (C2.getType().isFirstClassType()) : "Cannot evaluate aggregate vals!";
        ConstantExpr CE = IrRTTI.dyn_cast_ConstantExpr(C2);
        if (CE == null) {
            return false;
        }
        int e = C2.getNumOperands();
        for (int i = 0; i != e; ++i) {
            ConstantExpr Op = IrRTTI.dyn_cast_ConstantExpr(CE.getOperand_Constant(i));
            if (Op == null || !NonTrappingOps.insert((Object)Op).second || !ConstantsStatics.canTrapImpl(Op, NonTrappingOps)) continue;
            return true;
        }
        switch (CE.getOpcode()) {
            default: {
                return false;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
        }
        return !IrRTTI.isa_ConstantInt(CE.getOperand_Constant(1)) || CE.getOperand_Constant(1).isNullValue();
    }

    public static boolean ConstHasGlobalValuePredicate(Constant C2, NativeCallback.BoolPredicate<GlobalValue> Predicate2) {
        SmallPtrSet Visited = new SmallPtrSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info(), 8);
        SmallVector WorkList = new SmallVector(8, (Object)null);
        WorkList.push_back((Object)C2);
        Visited.insert((Object)C2);
        while (!WorkList.empty()) {
            Constant WorkItem = (Constant)WorkList.pop_back_val();
            GlobalValue GV = IrRTTI.dyn_cast_GlobalValue(WorkItem);
            if (GV != null && Predicate2.$call((Object)GV)) {
                return true;
            }
            for (Use U : WorkItem.operands$Const()) {
                Value Op = U.get();
                Constant ConstOp = IrRTTI.dyn_cast_Constant(Op);
                if (ConstOp == null || !Visited.insert((Object)ConstOp).second) continue;
                WorkList.push_back((Object)ConstOp);
            }
        }
        return false;
    }

    public static boolean removeDeadUsersOfConstant(Constant C2) {
        if (IrRTTI.isa_GlobalValue(C2)) {
            return false;
        }
        while (!C2.use_empty()) {
            Constant User2 = IrRTTI.dyn_cast_Constant(C2.user_back$Value$Const());
            if (User2 == null) {
                return false;
            }
            if (ConstantsStatics.removeDeadUsersOfConstant(User2)) continue;
            return false;
        }
        C2.destroyConstant();
        return true;
    }

    public static fltSemantics TypeToFloatSemantics(Type Ty) {
        if (Ty.isHalfTy()) {
            return (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEhalf);
        }
        if (Ty.isFloatTy()) {
            return (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEsingle);
        }
        if (Ty.isDoubleTy()) {
            return (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEdouble);
        }
        if (Ty.isX86_FP80Ty()) {
            return (fltSemantics)Native.$AddrOf((Object)APFloat.x87DoubleExtended);
        }
        if (Ty.isFP128Ty()) {
            return (fltSemantics)Native.$AddrOf((Object)APFloat.IEEEquad);
        }
        assert (Ty.isPPC_FP128Ty()) : "Unknown FP format";
        return (fltSemantics)Native.$AddrOf((Object)APFloat.PPCDoubleDouble);
    }

    public static boolean rangeOnlyContains(type.ptr<Constant> Start, type.ptr<Constant> End, Constant Elt) {
        Start = (type.ptr)Native.$Clone(Start);
        while (Native.$noteq_ptr((void.ptr)Start, End)) {
            if (Start.$star() != Elt) {
                return false;
            }
            Start.$preInc();
        }
        return true;
    }

    public static Constant getIntSequenceIfElementsMatch$UChar(ArrayRef<Constant> V) {
        assert (!V.empty()) : "Cannot get empty int sequence.";
        SmallVectorUChar Elts = new SmallVectorUChar(16, 0);
        for (Constant C2 : V) {
            ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(C2);
            if (CI != null) {
                Elts.push_back(Unsigned.$ulong2uchar((long)CI.getZExtValue()));
                continue;
            }
            return null;
        }
        return ConstantDataArray.get_LLVMContext_ArrayRefUChar(((Constant)V.$at(0)).getContext(), new ArrayRefUChar((SmallVectorImplUChar)Elts));
    }

    public static Constant getIntSequenceIfElementsMatch$UShort(ArrayRef<Constant> V) {
        assert (!V.empty()) : "Cannot get empty int sequence.";
        SmallVectorUShort Elts = new SmallVectorUShort(16, '\u0000');
        for (Constant C2 : V) {
            ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(C2);
            if (CI != null) {
                Elts.push_back(Unsigned.$ulong2ushort((long)CI.getZExtValue()));
                continue;
            }
            return null;
        }
        return ConstantDataArray.get_LLVMContext_ArrayRefUShort(((Constant)V.$at(0)).getContext(), new ArrayRefUShort((SmallVectorImplUShort)Elts));
    }

    public static Constant getIntSequenceIfElementsMatch$UInt(ArrayRef<Constant> V) {
        assert (!V.empty()) : "Cannot get empty int sequence.";
        SmallVectorUInt Elts = new SmallVectorUInt(16, 0);
        for (Constant C2 : V) {
            ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(C2);
            if (CI != null) {
                Elts.push_back(Unsigned.$ulong2uint((long)CI.getZExtValue()));
                continue;
            }
            return null;
        }
        return ConstantDataArray.get_LLVMContext_ArrayRefUInt(((Constant)V.$at(0)).getContext(), new ArrayRefUInt((SmallVectorImplUInt)Elts));
    }

    public static Constant getIntSequenceIfElementsMatch$ULLong(ArrayRef<Constant> V) {
        assert (!V.empty()) : "Cannot get empty int sequence.";
        SmallVectorULong Elts = new SmallVectorULong(16, 0L);
        for (Constant C2 : V) {
            ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(C2);
            if (CI != null) {
                Elts.push_back(CI.getZExtValue());
                continue;
            }
            return null;
        }
        return ConstantDataArray.get_LLVMContext_ArrayRefULong(((Constant)V.$at(0)).getContext(), new ArrayRefULong((SmallVectorImplULong)Elts));
    }

    public static Constant getFPSequenceIfElementsMatch$UShort(ArrayRef<Constant> V) {
        assert (!V.empty()) : "Cannot get empty FP sequence.";
        SmallVectorUShort Elts = new SmallVectorUShort(16, '\u0000');
        for (Constant C2 : V) {
            ConstantFP CFP = IrRTTI.dyn_cast_ConstantFP(C2);
            if (CFP != null) {
                Elts.push_back(Unsigned.$ulong2ushort((long)CFP.getValueAPF().bitcastToAPInt().getLimitedValue()));
                continue;
            }
            return null;
        }
        return ConstantDataArray.getFP_LLVMContext_ArrayRefUShort(((Constant)V.$at(0)).getContext(), new ArrayRefUShort((SmallVectorImplUShort)Elts));
    }

    public static Constant getFPSequenceIfElementsMatch$UInt(ArrayRef<Constant> V) {
        assert (!V.empty()) : "Cannot get empty FP sequence.";
        SmallVectorUInt Elts = new SmallVectorUInt(16, 0);
        for (Constant C2 : V) {
            ConstantFP CFP = IrRTTI.dyn_cast_ConstantFP(C2);
            if (CFP != null) {
                Elts.push_back(Unsigned.$ulong2uint((long)CFP.getValueAPF().bitcastToAPInt().getLimitedValue()));
                continue;
            }
            return null;
        }
        return ConstantDataArray.getFP_LLVMContext_ArrayRefUInt(((Constant)V.$at(0)).getContext(), new ArrayRefUInt((SmallVectorImplUInt)Elts));
    }

    public static Constant getFPSequenceIfElementsMatch$ULLong(ArrayRef<Constant> V) {
        assert (!V.empty()) : "Cannot get empty FP sequence.";
        SmallVectorULong Elts = new SmallVectorULong(16, 0L);
        for (Constant C2 : V) {
            ConstantFP CFP = IrRTTI.dyn_cast_ConstantFP(C2);
            if (CFP != null) {
                Elts.push_back(CFP.getValueAPF().bitcastToAPInt().getLimitedValue());
                continue;
            }
            return null;
        }
        return ConstantDataArray.getFP_LLVMContext_ArrayRefULong(((Constant)V.$at(0)).getContext(), new ArrayRefULong((SmallVectorImplULong)Elts));
    }

    public static <SequenceTy> Constant getSequenceIfElementsMatch(Constant C2, ArrayRef<Constant> V) {
        ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(C2);
        if (CI != null) {
            if (CI.getType().isIntegerTy(8)) {
                return ConstantsStatics.getIntSequenceIfElementsMatch$UChar(V);
            }
            if (CI.getType().isIntegerTy(16)) {
                return ConstantsStatics.getIntSequenceIfElementsMatch$UShort(V);
            }
            if (CI.getType().isIntegerTy(32)) {
                return ConstantsStatics.getIntSequenceIfElementsMatch$UInt(V);
            }
            if (CI.getType().isIntegerTy(64)) {
                return ConstantsStatics.getIntSequenceIfElementsMatch$ULLong(V);
            }
        } else {
            ConstantFP CFP = IrRTTI.dyn_cast_ConstantFP(C2);
            if (CFP != null) {
                if (CFP.getType().isHalfTy()) {
                    return ConstantsStatics.getFPSequenceIfElementsMatch$UShort(V);
                }
                if (CFP.getType().isFloatTy()) {
                    return ConstantsStatics.getFPSequenceIfElementsMatch$UInt(V);
                }
                if (CFP.getType().isDoubleTy()) {
                    return ConstantsStatics.getFPSequenceIfElementsMatch$ULLong(V);
                }
            }
        }
        return null;
    }

    public static Constant getFoldedCast(int opc, Constant C2, Type Ty) {
        return ConstantsStatics.getFoldedCast(opc, C2, Ty, false);
    }

    public static Constant getFoldedCast(int opc, Constant C2, Type Ty, boolean OnlyIfReduced) {
        assert (Ty.isFirstClassType()) : "Cannot cast to an aggregate type!";
        Constant FC = ConstantFoldLlvmStatics.ConstantFoldCastInstruction(opc, C2, Ty);
        if (FC != null) {
            return FC;
        }
        if (OnlyIfReduced) {
            return null;
        }
        LLVMContextImpl pImpl = Ty.getContext().pImpl;
        ConstantExprKeyType Key = new ConstantExprKeyType(opc, (ArrayRef<Constant>)new ArrayRef((Object)C2, true));
        return pImpl.ExprConstants.getOrCreate(Ty, new ConstantExprKeyType(Key));
    }

    public static boolean isAllZeros(StringRef Arr) {
        Iterator iterator2 = Arr.iterator();
        while (iterator2.hasNext()) {
            byte I = (Byte)iterator2.next();
            if (I == 0) continue;
            return false;
        }
        return true;
    }
}

