/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.APFloat;
import org.llvm.adt.APInt;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.ir.ArrayType;
import org.llvm.ir.BlockAddress;
import org.llvm.ir.CastInst;
import org.llvm.ir.CmpInst;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.ConstantFP;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.ConstantPointerNull;
import org.llvm.ir.ConstantVector;
import org.llvm.ir.FCmpInst;
import org.llvm.ir.GEPOperator;
import org.llvm.ir.GetElementPtrInst;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.GlobalVariable;
import org.llvm.ir.ICmpInst;
import org.llvm.ir.IntegerType;
import org.llvm.ir.PointerType;
import org.llvm.ir.SequentialType;
import org.llvm.ir.StructType;
import org.llvm.ir.Type;
import org.llvm.ir.UndefValue;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.generic_gep_type_iterator;
import org.llvm.ir.java.IRFunctionPointers;
import org.llvm.ir.java.IrRTTI;
import org.llvm.pass.IrLlvmGlobals;

public final class ConstantFoldStatics {
    public static Constant BitCastConstantVector(Constant CV, VectorType DstTy) {
        if (CV.isAllOnesValue()) {
            return Constant.getAllOnesValue(DstTy);
        }
        if (CV.isNullValue()) {
            return Constant.getNullValue(DstTy);
        }
        int NumElts = DstTy.getNumElements();
        if (NumElts != CV.getType().getVectorNumElements()) {
            return null;
        }
        Type DstEltTy = DstTy.getElementType();
        SmallVector Result2 = new SmallVector(16, (Object)null);
        IntegerType Ty = IntegerType.get(CV.getContext(), 32);
        for (int i = 0; i != NumElts; ++i) {
            Constant C2 = ConstantExpr.getExtractElement(CV, ConstantInt.get((Type)Ty, Unsigned.$uint2ulong((int)i)));
            C2 = ConstantExpr.getBitCast(C2, DstEltTy);
            Result2.push_back((Object)C2);
        }
        return ConstantVector.get((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)Result2, true));
    }

    public static int foldConstantCastPair(int opc, ConstantExpr Op, Type DstTy) {
        assert (Op != null && Op.isCast()) : "Can't fold cast of cast without a cast!";
        assert (DstTy != null && DstTy.isFirstClassType()) : "Invalid cast destination type";
        assert (CastInst.isCast(opc)) : "Invalid cast opcode";
        Type SrcTy = Op.getOperand_Constant(0).getType();
        Type MidTy = Op.getType();
        int firstOp = Op.getOpcode();
        int secondOp = opc;
        IntegerType FakeIntPtrTy = Type.getInt64Ty(DstTy.getContext());
        return CastInst.isEliminableCastPair(firstOp, secondOp, SrcTy, MidTy, DstTy, null, FakeIntPtrTy, null);
    }

    public static Constant FoldBitCast(Constant V, Type DestTy) {
        VectorType DestPTy;
        PointerType DPTy;
        Type SrcTy = V.getType();
        if (SrcTy == DestTy) {
            return V;
        }
        PointerType PTy = IrRTTI.dyn_cast_PointerType(V.getType());
        if (PTy != null && (DPTy = IrRTTI.dyn_cast_PointerType(DestTy)) != null && PTy.getAddressSpace() == DPTy.getAddressSpace() && PTy.getElementType().isSized()) {
            SmallVector IdxList = new SmallVector(8, (Object)null);
            Constant Zero = Constant.getNullValue(Type.getInt32Ty(DPTy.getContext()));
            IdxList.push_back((Object)Zero);
            Type ElTy = PTy.getElementType();
            while (ElTy != DPTy.getElementType()) {
                StructType STy = IrRTTI.dyn_cast_StructType(ElTy);
                if (STy != null) {
                    if (STy.getNumElements() == 0) break;
                    ElTy = STy.getElementType(0);
                    IdxList.push_back((Object)Zero);
                    continue;
                }
                SequentialType STy$1 = IrRTTI.dyn_cast_SequentialType(ElTy);
                if (STy$1 == null || ElTy.isPointerTy()) break;
                ElTy = STy$1.getElementType();
                IdxList.push_back((Object)Zero);
            }
            if (ElTy == DPTy.getElementType()) {
                return ConstantExpr.getInBoundsGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P(PTy.getElementType(), V, (ArrayRef<Value>)new ArrayRef((SmallVectorImplCommon)IdxList, true));
            }
        }
        if ((DestPTy = IrRTTI.dyn_cast_VectorType(DestTy)) != null) {
            VectorType SrcTy$1 = IrRTTI.dyn_cast_VectorType(V.getType());
            if (SrcTy$1 != null) {
                assert (DestPTy.getBitWidth() == SrcTy$1.getBitWidth()) : "Not cast between same sized vectors!";
                SrcTy$1 = null;
                if (IrRTTI.isa_ConstantAggregateZero(V)) {
                    return Constant.getNullValue(DestTy);
                }
                return ConstantFoldStatics.BitCastConstantVector(V, DestPTy);
            }
            if (IrRTTI.isa_ConstantInt(V) || IrRTTI.isa_ConstantFP(V)) {
                return ConstantExpr.getBitCast(ConstantVector.get((ArrayRef<Constant>)new ArrayRef((Object)V, true)), DestPTy);
            }
        }
        if (IrRTTI.isa_ConstantPointerNull(V)) {
            return ConstantPointerNull.get(IrRTTI.cast_PointerType(DestTy));
        }
        ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(V);
        if (CI != null) {
            if (DestTy.isIntegerTy()) {
                return V;
            }
            if (DestTy.isFloatingPointTy() && !DestTy.isPPC_FP128Ty()) {
                return ConstantFP.get(DestTy.getContext(), new APFloat(DestTy.getFltSemantics(), CI.getValue()));
            }
            return null;
        }
        ConstantFP FP = IrRTTI.dyn_cast_ConstantFP(V);
        if (FP != null) {
            if (FP.getType().isPPC_FP128Ty()) {
                return null;
            }
            if (!DestTy.isIntegerTy()) {
                return null;
            }
            return ConstantInt.get(FP.getContext(), FP.getValueAPF().bitcastToAPInt());
        }
        return null;
    }

    public static Constant ExtractConstantBytes(Constant C2, int ByteStart, int ByteSize) {
        assert (C2.getType().isIntegerTy() && (IrRTTI.cast_IntegerType(C2.getType()).getBitWidth() & 7) == 0) : "Non-byte sized integer input";
        int CSize = Unsigned.$div_uint((int)IrRTTI.cast_IntegerType(C2.getType()).getBitWidth(), (int)8);
        assert (ByteSize != 0) : "Must be accessing some piece";
        assert (Unsigned.$lesseq_uint((int)(ByteStart + ByteSize), (int)CSize)) : "Extracting invalid piece from input";
        assert (ByteSize != CSize) : "Should not extract everything";
        ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(C2);
        if (CI != null) {
            APInt V = new APInt(CI.getValue());
            if (ByteStart != 0) {
                V.$assignMove(V.lshr(ByteStart * 8));
            }
            V.$assignMove(V.trunc(ByteSize * 8));
            return ConstantInt.get(CI.getContext(), V);
        }
        ConstantExpr CE = IrRTTI.dyn_cast_ConstantExpr(C2);
        if (CE == null) {
            return null;
        }
        switch (CE.getOpcode()) {
            default: {
                return null;
            }
            case 27: {
                Constant RHS = ConstantFoldStatics.ExtractConstantBytes(CE.getOperand_Constant(1), ByteStart, ByteSize);
                if (RHS == null) {
                    return null;
                }
                ConstantInt RHSC = IrRTTI.dyn_cast_ConstantInt(RHS);
                if (RHSC != null && RHSC.isAllOnesValue()) {
                    return RHSC;
                }
                Constant LHS = ConstantFoldStatics.ExtractConstantBytes(CE.getOperand_Constant(0), ByteStart, ByteSize);
                if (LHS == null) {
                    return null;
                }
                return ConstantExpr.getOr(LHS, RHS);
            }
            case 26: {
                Constant RHS = ConstantFoldStatics.ExtractConstantBytes(CE.getOperand_Constant(1), ByteStart, ByteSize);
                if (RHS == null) {
                    return null;
                }
                if (RHS.isNullValue()) {
                    return RHS;
                }
                Constant LHS = ConstantFoldStatics.ExtractConstantBytes(CE.getOperand_Constant(0), ByteStart, ByteSize);
                if (LHS == null) {
                    return null;
                }
                return ConstantExpr.getAnd(LHS, RHS);
            }
            case 24: {
                ConstantInt Amt = IrRTTI.dyn_cast_ConstantInt(CE.getOperand_Constant(1));
                if (Amt == null) {
                    return null;
                }
                int ShAmt = Unsigned.$ulong2uint((long)Amt.getZExtValue());
                if ((ShAmt & 7) != 0) {
                    return null;
                }
                if (Unsigned.$greatereq_uint((int)ByteStart, (int)(CSize - (ShAmt >>>= 3)))) {
                    return Constant.getNullValue(IntegerType.get(CE.getContext(), ByteSize * 8));
                }
                if (Unsigned.$lesseq_uint((int)(ByteStart + ByteSize + ShAmt), (int)CSize)) {
                    return ConstantFoldStatics.ExtractConstantBytes(CE.getOperand_Constant(0), ByteStart + ShAmt, ByteSize);
                }
                return null;
            }
            case 23: {
                ConstantInt Amt = IrRTTI.dyn_cast_ConstantInt(CE.getOperand_Constant(1));
                if (Amt == null) {
                    return null;
                }
                int ShAmt = Unsigned.$ulong2uint((long)Amt.getZExtValue());
                if ((ShAmt & 7) != 0) {
                    return null;
                }
                if (Unsigned.$lesseq_uint((int)(ByteStart + ByteSize), (int)(ShAmt >>>= 3))) {
                    return Constant.getNullValue(IntegerType.get(CE.getContext(), ByteSize * 8));
                }
                if (Unsigned.$greatereq_uint((int)ByteStart, (int)ShAmt)) {
                    return ConstantFoldStatics.ExtractConstantBytes(CE.getOperand_Constant(0), ByteStart - ShAmt, ByteSize);
                }
                return null;
            }
            case 37: 
        }
        int SrcBitSize = IrRTTI.cast_IntegerType(CE.getOperand_Constant(0).getType()).getBitWidth();
        if (Unsigned.$greatereq_uint((int)(ByteStart * 8), (int)SrcBitSize)) {
            return Constant.getNullValue(IntegerType.get(CE.getContext(), ByteSize * 8));
        }
        if (ByteStart == 0 && ByteSize * 8 == SrcBitSize) {
            return CE.getOperand_Constant(0);
        }
        if ((SrcBitSize & 7) == 0 && Unsigned.$lesseq_uint((int)((ByteStart + ByteSize) * 8), (int)SrcBitSize)) {
            return ConstantFoldStatics.ExtractConstantBytes(CE.getOperand_Constant(0), ByteStart, ByteSize);
        }
        if (Unsigned.$less_uint((int)((ByteStart + ByteSize) * 8), (int)SrcBitSize)) {
            assert ((SrcBitSize & 7) != 0) : "Shouldn't get byte sized case here";
            Constant Res = CE.getOperand_Constant(0);
            if (ByteStart != 0) {
                Res = ConstantExpr.getLShr(Res, ConstantInt.get(Res.getType(), Unsigned.$uint2ulong((int)(ByteStart * 8))));
            }
            return ConstantExpr.getTrunc(Res, IntegerType.get(C2.getContext(), ByteSize * 8));
        }
        return null;
    }

    public static Constant getFoldedSizeOf(Type Ty, Type DestTy, boolean Folded) {
        PointerType PTy;
        ArrayType ATy = IrRTTI.dyn_cast_ArrayType(Ty);
        if (ATy != null) {
            Constant N = ConstantInt.get(DestTy, ATy.getNumElements());
            Constant E = ConstantFoldStatics.getFoldedSizeOf(ATy.getElementType(), DestTy, true);
            return ConstantExpr.getNUWMul(E, N);
        }
        StructType STy = IrRTTI.dyn_cast_StructType(Ty);
        if (STy != null && !STy.isPacked()) {
            int NumElems = STy.getNumElements();
            if (NumElems == 0) {
                return ConstantExpr.getNullValue(DestTy);
            }
            Constant MemberSize = ConstantFoldStatics.getFoldedSizeOf(STy.getElementType(0), DestTy, true);
            boolean AllSame = true;
            for (int i = 1; i != NumElems; ++i) {
                if (MemberSize == ConstantFoldStatics.getFoldedSizeOf(STy.getElementType(i), DestTy, true)) continue;
                AllSame = false;
                break;
            }
            if (AllSame) {
                Constant N = ConstantInt.get(DestTy, Unsigned.$uint2ulong((int)NumElems));
                return ConstantExpr.getNUWMul(MemberSize, N);
            }
        }
        if ((PTy = IrRTTI.dyn_cast_PointerType(Ty)) != null && !PTy.getElementType().isIntegerTy(1)) {
            return ConstantFoldStatics.getFoldedSizeOf(PointerType.get(IntegerType.get(PTy.getContext(), 1), PTy.getAddressSpace()), DestTy, true);
        }
        if (!Folded) {
            return null;
        }
        Constant C2 = ConstantExpr.getSizeOf(Ty);
        C2 = ConstantExpr.getCast(CastInst.getCastOpcode(C2, false, DestTy, false), C2, DestTy);
        return C2;
    }

    public static Constant getFoldedAlignOf(Type Ty, Type DestTy, boolean Folded) {
        PointerType PTy;
        ArrayType ATy = IrRTTI.dyn_cast_ArrayType(Ty);
        if (ATy != null) {
            Constant C2 = ConstantExpr.getAlignOf(ATy.getElementType());
            C2 = ConstantExpr.getCast(CastInst.getCastOpcode(C2, false, DestTy, false), C2, DestTy);
            return C2;
        }
        StructType STy = IrRTTI.dyn_cast_StructType(Ty);
        if (STy != null) {
            if (STy.isPacked()) {
                return ConstantInt.get(DestTy, Unsigned.$int2ulong((int)1));
            }
            int NumElems = STy.getNumElements();
            if (NumElems == 0) {
                return ConstantInt.get(DestTy, Unsigned.$int2ulong((int)1));
            }
            Constant MemberAlign = ConstantFoldStatics.getFoldedAlignOf(STy.getElementType(0), DestTy, true);
            boolean AllSame = true;
            for (int i = 1; i != NumElems; ++i) {
                if (MemberAlign == ConstantFoldStatics.getFoldedAlignOf(STy.getElementType(i), DestTy, true)) continue;
                AllSame = false;
                break;
            }
            if (AllSame) {
                return MemberAlign;
            }
        }
        if ((PTy = IrRTTI.dyn_cast_PointerType(Ty)) != null && !PTy.getElementType().isIntegerTy(1)) {
            return ConstantFoldStatics.getFoldedAlignOf(PointerType.get(IntegerType.get(PTy.getContext(), 1), PTy.getAddressSpace()), DestTy, true);
        }
        if (!Folded) {
            return null;
        }
        Constant C3 = ConstantExpr.getAlignOf(Ty);
        C3 = ConstantExpr.getCast(CastInst.getCastOpcode(C3, false, DestTy, false), C3, DestTy);
        return C3;
    }

    public static Constant getFoldedOffsetOf(Type Ty, Constant FieldNo, Type DestTy, boolean Folded) {
        ArrayType ATy = IrRTTI.dyn_cast_ArrayType(Ty);
        if (ATy != null) {
            Constant N = ConstantExpr.getCast(CastInst.getCastOpcode(FieldNo, false, DestTy, false), FieldNo, DestTy);
            Constant E = ConstantFoldStatics.getFoldedSizeOf(ATy.getElementType(), DestTy, true);
            return ConstantExpr.getNUWMul(E, N);
        }
        StructType STy = IrRTTI.dyn_cast_StructType(Ty);
        if (STy != null && !STy.isPacked()) {
            int NumElems = STy.getNumElements();
            if (NumElems == 0) {
                return null;
            }
            Constant MemberSize = ConstantFoldStatics.getFoldedSizeOf(STy.getElementType(0), DestTy, true);
            boolean AllSame = true;
            for (int i = 1; i != NumElems; ++i) {
                if (MemberSize == ConstantFoldStatics.getFoldedSizeOf(STy.getElementType(i), DestTy, true)) continue;
                AllSame = false;
                break;
            }
            if (AllSame) {
                Constant N = ConstantExpr.getCast(CastInst.getCastOpcode(FieldNo, false, DestTy, false), FieldNo, DestTy);
                return ConstantExpr.getNUWMul(MemberSize, N);
            }
        }
        if (!Folded) {
            return null;
        }
        Constant C2 = ConstantExpr.getOffsetOf(Ty, FieldNo);
        C2 = ConstantExpr.getCast(CastInst.getCastOpcode(C2, false, DestTy, false), C2, DestTy);
        return C2;
    }

    public static boolean isMaybeZeroSizedType(Type Ty) {
        StructType STy = IrRTTI.dyn_cast_StructType(Ty);
        if (STy != null) {
            if (STy.isOpaque()) {
                return true;
            }
            int e = STy.getNumElements();
            for (int i = 0; i != e; ++i) {
                if (ConstantFoldStatics.isMaybeZeroSizedType(STy.getElementType(i))) continue;
                return false;
            }
            return true;
        }
        ArrayType ATy = IrRTTI.dyn_cast_ArrayType(Ty);
        if (ATy != null) {
            return ConstantFoldStatics.isMaybeZeroSizedType(ATy.getElementType());
        }
        return false;
    }

    public static int IdxCompare(Constant C1, Constant C2, Type ElTy) {
        long C2Val;
        if (C1 == C2) {
            return 0;
        }
        if (!IrRTTI.isa_ConstantInt(C1) || !IrRTTI.isa_ConstantInt(C2)) {
            return -2;
        }
        if (Unsigned.$greater_uint((int)IrRTTI.cast_ConstantInt(C1).getValue().getActiveBits(), (int)64) || Unsigned.$greater_uint((int)IrRTTI.cast_ConstantInt(C2).getValue().getActiveBits(), (int)64)) {
            return -2;
        }
        long C1Val = IrRTTI.cast_ConstantInt(C1).getSExtValue();
        if (C1Val == (C2Val = IrRTTI.cast_ConstantInt(C2).getSExtValue())) {
            return 0;
        }
        if (ConstantFoldStatics.isMaybeZeroSizedType(ElTy)) {
            return -2;
        }
        if (C1Val < C2Val) {
            return -1;
        }
        return 1;
    }

    public static CmpInst.Predicate evaluateFCmpRelation(Constant V1, Constant V2) {
        assert (V1.getType() == V2.getType()) : "Cannot compare values of different types!";
        if (V1 == V2) {
            return CmpInst.Predicate.FCMP_OEQ;
        }
        if (!IrRTTI.isa_ConstantExpr(V1)) {
            if (!IrRTTI.isa_ConstantExpr(V2)) {
                ConstantInt R = null;
                R = IrRTTI.dyn_cast_ConstantInt(ConstantExpr.getFCmp(CmpInst.Predicate.FCMP_OEQ.getValue(), V1, V2));
                if (R != null && !R.isZero()) {
                    return CmpInst.Predicate.FCMP_OEQ;
                }
                R = IrRTTI.dyn_cast_ConstantInt(ConstantExpr.getFCmp(CmpInst.Predicate.FCMP_OLT.getValue(), V1, V2));
                if (R != null && !R.isZero()) {
                    return CmpInst.Predicate.FCMP_OLT;
                }
                R = IrRTTI.dyn_cast_ConstantInt(ConstantExpr.getFCmp(CmpInst.Predicate.FCMP_OGT.getValue(), V1, V2));
                if (R != null && !R.isZero()) {
                    return CmpInst.Predicate.FCMP_OGT;
                }
                return CmpInst.Predicate.BAD_FCMP_PREDICATE;
            }
            CmpInst.Predicate SwappedRelation = ConstantFoldStatics.evaluateFCmpRelation(V2, V1);
            if (SwappedRelation != CmpInst.Predicate.BAD_FCMP_PREDICATE) {
                return FCmpInst.getSwappedPredicate(SwappedRelation);
            }
        } else {
            ConstantExpr CE1 = IrRTTI.cast_ConstantExpr(V1);
            switch (CE1.getOpcode()) {
                case 41: 
                case 42: 
                case 43: 
                case 44: {
                    break;
                }
            }
        }
        return CmpInst.Predicate.BAD_FCMP_PREDICATE;
    }

    public static CmpInst.Predicate areGlobalsPotentiallyEqual(GlobalValue GV1, GlobalValue GV2) {
        IRFunctionPointers.GlobalValue2Bool isGlobalUnsafeForEquality = GV -> {
            if (GV.hasExternalWeakLinkage() || GV.hasWeakAnyLinkage()) {
                return true;
            }
            GlobalVariable GVar = IrRTTI.dyn_cast_GlobalVariable(GV);
            if (GVar != null) {
                Type Ty = GVar.getValueType();
                if (!Ty.isSized()) {
                    return true;
                }
                if (Ty.isEmptyTy()) {
                    return true;
                }
            }
            return false;
        };
        if (!(IrRTTI.isa_GlobalAlias(GV1) || IrRTTI.isa_GlobalAlias(GV2) || isGlobalUnsafeForEquality.$call(GV1) || isGlobalUnsafeForEquality.$call(GV2))) {
            return CmpInst.Predicate.ICMP_NE;
        }
        return CmpInst.Predicate.BAD_ICMP_PREDICATE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CmpInst.Predicate evaluateICmpRelation(Constant V1, Constant V2, boolean isSigned) {
        assert (V1.getType() == V2.getType()) : "Cannot compare different types of values!";
        if (V1 == V2) {
            return CmpInst.Predicate.ICMP_EQ;
        }
        if (!(IrRTTI.isa_ConstantExpr(V1) || IrRTTI.isa_GlobalValue(V1) || IrRTTI.isa_BlockAddress(V1))) {
            if (!(IrRTTI.isa_GlobalValue(V2) || IrRTTI.isa_ConstantExpr(V2) || IrRTTI.isa_BlockAddress(V2))) {
                ConstantInt R = null;
                CmpInst.Predicate pred = CmpInst.Predicate.ICMP_EQ;
                R = IrRTTI.dyn_cast_ConstantInt(ConstantExpr.getICmp(pred.getValue(), V1, V2));
                if (R != null && !R.isZero()) {
                    return pred;
                }
                pred = isSigned ? CmpInst.Predicate.ICMP_SLT : CmpInst.Predicate.ICMP_ULT;
                R = IrRTTI.dyn_cast_ConstantInt(ConstantExpr.getICmp(pred.getValue(), V1, V2));
                if (R != null && !R.isZero()) {
                    return pred;
                }
                pred = isSigned ? CmpInst.Predicate.ICMP_SGT : CmpInst.Predicate.ICMP_UGT;
                R = IrRTTI.dyn_cast_ConstantInt(ConstantExpr.getICmp(pred.getValue(), V1, V2));
                if (R == null || R.isZero()) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                return pred;
            }
            CmpInst.Predicate SwappedRelation = ConstantFoldStatics.evaluateICmpRelation(V2, V1, isSigned);
            if (SwappedRelation == CmpInst.Predicate.BAD_ICMP_PREDICATE) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
            return ICmpInst.getSwappedPredicate(SwappedRelation);
        }
        GlobalValue GV = IrRTTI.dyn_cast_GlobalValue(V1);
        if (GV != null) {
            if (IrRTTI.isa_ConstantExpr(V2)) {
                CmpInst.Predicate SwappedRelation = ConstantFoldStatics.evaluateICmpRelation(V2, V1, isSigned);
                if (SwappedRelation == CmpInst.Predicate.BAD_ICMP_PREDICATE) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                return ICmpInst.getSwappedPredicate(SwappedRelation);
            }
            GlobalValue GV2 = IrRTTI.dyn_cast_GlobalValue(V2);
            if (GV2 != null) {
                return ConstantFoldStatics.areGlobalsPotentiallyEqual(GV, GV2);
            }
            if (IrRTTI.isa_BlockAddress(V2)) {
                return CmpInst.Predicate.ICMP_NE;
            }
            assert (IrRTTI.isa_ConstantPointerNull(V2)) : "Canonicalization guarantee!";
            if (GV.hasExternalWeakLinkage() || IrRTTI.isa_GlobalAlias(GV)) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
            return CmpInst.Predicate.ICMP_NE;
        }
        BlockAddress BA = IrRTTI.dyn_cast_BlockAddress(V1);
        if (BA != null) {
            if (IrRTTI.isa_ConstantExpr(V2)) {
                CmpInst.Predicate SwappedRelation = ConstantFoldStatics.evaluateICmpRelation(V2, V1, isSigned);
                if (SwappedRelation == CmpInst.Predicate.BAD_ICMP_PREDICATE) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                return ICmpInst.getSwappedPredicate(SwappedRelation);
            }
            BlockAddress BA2 = IrRTTI.dyn_cast_BlockAddress(V2);
            if (BA2 != null) {
                if (BA2.getFunction() == BA.getFunction()) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                return CmpInst.Predicate.ICMP_NE;
            }
            assert (IrRTTI.isa_ConstantPointerNull(V2) || IrRTTI.isa_GlobalValue(V2)) : "Canonicalization guarantee!";
            return CmpInst.Predicate.ICMP_NE;
        }
        ConstantExpr CE1 = IrRTTI.cast_ConstantExpr(V1);
        Constant CE1Op0 = CE1.getOperand_Constant(0);
        switch (CE1.getOpcode()) {
            case 36: 
            case 39: 
            case 40: 
            case 43: 
            case 44: {
                return CmpInst.Predicate.BAD_ICMP_PREDICATE;
            }
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 47: {
                if (CE1Op0.getType().isFloatingPointTy() || !V2.isNullValue() || !CE1.getType().isPointerTy() && !CE1.getType().isIntegerTy()) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                if (CE1.getOpcode() == 37) {
                    isSigned = false;
                }
                if (CE1.getOpcode() != 38) return ConstantFoldStatics.evaluateICmpRelation(CE1Op0, Constant.getNullValue(CE1Op0.getType()), isSigned);
                isSigned = true;
                return ConstantFoldStatics.evaluateICmpRelation(CE1Op0, Constant.getNullValue(CE1Op0.getType()), isSigned);
            }
            case 32: {
                int i;
                GEPOperator CE1GEP = IrRTTI.cast_GEPOperator(CE1);
                if (IrRTTI.isa_ConstantPointerNull(V2)) {
                    GlobalValue GV$1 = IrRTTI.dyn_cast_GlobalValue(CE1Op0);
                    if (GV$1 != null) {
                        if (!GV$1.hasExternalWeakLinkage()) return isSigned ? CmpInst.Predicate.ICMP_SGT : CmpInst.Predicate.ICMP_UGT;
                        return isSigned ? CmpInst.Predicate.ICMP_SGE : CmpInst.Predicate.ICMP_UGE;
                    }
                    if (!IrRTTI.isa_ConstantPointerNull(CE1Op0)) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                    int e = CE1.getNumOperands();
                    for (int i2 = 1; i2 != e; ++i2) {
                        if (CE1.getOperand_Constant(i2).isNullValue()) continue;
                        return isSigned ? CmpInst.Predicate.ICMP_SGT : CmpInst.Predicate.ICMP_UGT;
                    }
                    return CmpInst.Predicate.ICMP_EQ;
                }
                GlobalValue GV2 = IrRTTI.dyn_cast_GlobalValue(V2);
                if (GV2 != null) {
                    if (IrRTTI.isa_ConstantPointerNull(CE1Op0)) {
                        if (!GV2.hasExternalWeakLinkage()) return isSigned ? CmpInst.Predicate.ICMP_SLT : CmpInst.Predicate.ICMP_ULT;
                        return isSigned ? CmpInst.Predicate.ICMP_SLE : CmpInst.Predicate.ICMP_ULE;
                    }
                    GlobalValue GV$1 = IrRTTI.dyn_cast_GlobalValue(CE1Op0);
                    if (GV$1 == null) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                    if (GV$1 == GV2) {
                        assert (CE1.getNumOperands() == 2 && !CE1.getOperand_Constant(1).isNullValue()) : "Surprising getelementptr!";
                        return isSigned ? CmpInst.Predicate.ICMP_SGT : CmpInst.Predicate.ICMP_UGT;
                    }
                    if (!CE1GEP.hasAllZeroIndices()) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                    return ConstantFoldStatics.areGlobalsPotentiallyEqual(GV$1, GV2);
                }
                ConstantExpr CE2 = IrRTTI.cast_ConstantExpr(V2);
                Constant CE2Op0 = CE2.getOperand_Constant(0);
                switch (CE2.getOpcode()) {
                    default: {
                        return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                    }
                    case 32: 
                }
                if (!IrRTTI.isa_GlobalValue(CE1Op0) || !IrRTTI.isa_GlobalValue(CE2Op0)) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                if (CE1Op0 != CE2Op0) {
                    GEPOperator CE2GEP = IrRTTI.cast_GEPOperator(CE2);
                    if (!CE1GEP.hasAllZeroIndices() || !CE2GEP.hasAllZeroIndices()) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                    return ConstantFoldStatics.areGlobalsPotentiallyEqual(IrRTTI.cast_GlobalValue(CE1Op0), IrRTTI.cast_GlobalValue(CE2Op0));
                }
                if (!CE1.isGEPWithNoNotionalOverIndexing()) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                if (!CE2.isGEPWithNoNotionalOverIndexing()) {
                    return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                }
                generic_gep_type_iterator GTI = IrLlvmGlobals.gep_type_begin_User$C$P(CE1);
                for (i = 1; i != CE1.getNumOperands() && i != CE2.getNumOperands(); ++i) {
                    switch (ConstantFoldStatics.IdxCompare(CE1.getOperand_Constant(i), CE2.getOperand_Constant(i), GTI.getIndexedType())) {
                        case -1: {
                            return isSigned ? CmpInst.Predicate.ICMP_SLT : CmpInst.Predicate.ICMP_ULT;
                        }
                        case 1: {
                            return isSigned ? CmpInst.Predicate.ICMP_SGT : CmpInst.Predicate.ICMP_UGT;
                        }
                        case -2: {
                            return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                        }
                    }
                    GTI.$preInc();
                }
                while (Unsigned.$less_uint((int)i, (int)CE1.getNumOperands())) {
                    if (!CE1.getOperand_Constant(i).isNullValue()) {
                        if (!IrRTTI.isa_ConstantInt(CE1.getOperand_Constant(i))) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                        return isSigned ? CmpInst.Predicate.ICMP_SGT : CmpInst.Predicate.ICMP_UGT;
                    }
                    ++i;
                }
                while (Unsigned.$less_uint((int)i, (int)CE2.getNumOperands())) {
                    if (!CE2.getOperand_Constant(i).isNullValue()) {
                        if (!IrRTTI.isa_ConstantInt(CE2.getOperand_Constant(i))) return CmpInst.Predicate.BAD_ICMP_PREDICATE;
                        return isSigned ? CmpInst.Predicate.ICMP_SLT : CmpInst.Predicate.ICMP_ULT;
                    }
                    ++i;
                }
                return CmpInst.Predicate.ICMP_EQ;
            }
        }
        return CmpInst.Predicate.BAD_ICMP_PREDICATE;
    }

    public static <IndexTy extends Value> boolean isInBoundsIndices(ArrayRef<IndexTy> Idxs) {
        if (Idxs.empty()) {
            return true;
        }
        if (IrRTTI.cast_Constant((Value)Idxs.$at(0)).isNullValue()) {
            return true;
        }
        if (Native.$not((boolean)IrRTTI.cast_ConstantInt((Value)Idxs.$at(0)).isOne())) {
            return false;
        }
        int e = Idxs.size();
        for (int i = 1; i != e; ++i) {
            if (!Native.$not((boolean)IrRTTI.cast_Constant((Value)Idxs.$at(i)).isNullValue())) continue;
            return false;
        }
        return true;
    }

    public static boolean isIndexInRangeOfSequentialType(SequentialType STy, ConstantInt CI) {
        if (IrRTTI.isa_PointerType(STy)) {
            return true;
        }
        long NumElements = Unsigned.$int2ulong((int)0);
        ArrayType ATy = IrRTTI.dyn_cast_ArrayType(STy);
        if (ATy != null) {
            NumElements = ATy.getNumElements();
        } else {
            VectorType VTy = IrRTTI.dyn_cast_VectorType(STy);
            if (VTy != null) {
                NumElements = Unsigned.$uint2ulong((int)VTy.getNumElements());
            }
        }
        assert (IrRTTI.isa_ArrayType(STy) || Unsigned.$greater_ulong_ullong((long)NumElements, (long)Unsigned.$int2ullong((int)0))) : "didn't expect non-array type to have zero elements!";
        if (Unsigned.$greater_uint((int)CI.getValue().getActiveBits(), (int)64)) {
            return false;
        }
        long IndexVal = CI.getSExtValue();
        return IndexVal >= 0L && (!Unsigned.$greater_ulong_ullong((long)NumElements, (long)Unsigned.$int2ullong((int)0)) || !Unsigned.$greatereq_ulong((long)IndexVal, (long)NumElements));
    }

    public static <IndexTy extends Value> Constant ConstantFoldGetElementPtrImpl(Type PointeeTy, Constant C2, boolean inBounds, ArrayRef<IndexTy> Idxs) {
        GlobalVariable GV;
        int i;
        ConstantExpr CE;
        if (Idxs.empty()) {
            return C2;
        }
        Constant Idx0 = IrRTTI.cast_Constant((Value)Idxs.$at(0));
        if (Native.$bool((boolean)Native.$eq((int)Idxs.size(), (int)1)) && Idx0.isNullValue()) {
            return C2;
        }
        if (IrRTTI.isa_UndefValue(C2)) {
            PointerType PtrTy = IrRTTI.cast_PointerType(C2.getType().getScalarType());
            Type Ty = GetElementPtrInst.getIndexedType_Type$P_ArrayRef$Value$P(PointeeTy, Idxs);
            assert (Ty != null) : "Invalid indices for GEP!";
            SequentialType GEPTy = PointerType.get(Ty, PtrTy.getAddressSpace());
            VectorType VT = IrRTTI.dyn_cast_VectorType(C2.getType());
            if (VT != null) {
                GEPTy = VectorType.get(GEPTy, VT.getNumElements());
            }
            return UndefValue.get(GEPTy);
        }
        if (C2.isNullValue()) {
            boolean isNull = true;
            int e = Idxs.size();
            for (int i2 = 0; i2 != e; ++i2) {
                if (!Native.$not((boolean)IrRTTI.cast_Constant((Value)Idxs.$at(i2)).isNullValue())) continue;
                isNull = false;
                break;
            }
            if (isNull) {
                PointerType PtrTy = IrRTTI.cast_PointerType(C2.getType().getScalarType());
                Type Ty = GetElementPtrInst.getIndexedType_Type$P_ArrayRef$Value$P(PointeeTy, Idxs);
                assert (Ty != null) : "Invalid indices for GEP!";
                SequentialType GEPTy = PointerType.get(Ty, PtrTy.getAddressSpace());
                VectorType VT = IrRTTI.dyn_cast_VectorType(C2.getType());
                if (VT != null) {
                    GEPTy = VectorType.get(GEPTy, VT.getNumElements());
                }
                return Constant.getNullValue(GEPTy);
            }
        }
        if ((CE = IrRTTI.dyn_cast_ConstantExpr(C2)) != null) {
            if (CE.getOpcode() == 32) {
                Type LastTy = null;
                generic_gep_type_iterator I = IrLlvmGlobals.gep_type_begin_User$C$P(CE);
                generic_gep_type_iterator E = IrLlvmGlobals.gep_type_end_User$C$P(CE);
                while (I.$noteq(E)) {
                    LastTy = I.$star();
                    I.$preInc();
                }
                boolean PerformFold = false;
                if (Idx0.isNullValue()) {
                    PerformFold = true;
                } else {
                    ConstantInt CI;
                    SequentialType STy = IrRTTI.dyn_cast_or_null_SequentialType(LastTy);
                    if (STy != null && (CI = IrRTTI.dyn_cast_ConstantInt(Idx0)) != null) {
                        PerformFold = ConstantFoldStatics.isIndexInRangeOfSequentialType(STy, CI);
                    }
                }
                if (PerformFold) {
                    SmallVector NewIndices = new SmallVector(16, (Object)null);
                    NewIndices.reserve(Native.$add((int)Idxs.size(), (int)CE.getNumOperands()));
                    NewIndices.append_T((type.iterator)CE.op_begin().$add(1), (type.iterator)CE.op_end().$sub(1), from -> from.get());
                    Constant Combined = CE.getOperand_Constant(CE.getNumOperands() - 1);
                    if (!Idx0.isNullValue()) {
                        Type IdxTy = Combined.getType();
                        if (IdxTy != Idx0.getType()) {
                            int CommonExtendedWidth = std.max((int)IdxTy.getIntegerBitWidth(), (int)Idx0.getType().getIntegerBitWidth());
                            CommonExtendedWidth = std.max((int)CommonExtendedWidth, (int)64);
                            IntegerType CommonTy = Type.getIntNTy(IdxTy.getContext(), CommonExtendedWidth);
                            Constant C1 = ConstantExpr.getSExtOrBitCast(Idx0, CommonTy);
                            Constant C22 = ConstantExpr.getSExtOrBitCast(Combined, CommonTy);
                            Combined = ConstantExpr.get(11, C1, C22);
                        } else {
                            Combined = ConstantExpr.get(11, Idx0, Combined);
                        }
                    }
                    NewIndices.push_back((Object)Combined);
                    NewIndices.append_T((type.iterator)Native.$add((type.ptr)Idxs.begin(), (int)1), (type.iterator)Idxs.end());
                    return ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P_bool_Type$P(IrRTTI.cast_GEPOperator(CE).getSourceElementType(), CE.getOperand_Constant(0), (ArrayRef<Value>)new ArrayRef((SmallVectorImplCommon)NewIndices, true), inBounds && IrRTTI.cast_GEPOperator(CE).isInBounds());
                }
            }
            if (Native.$bool((CE.isCast() && Native.$greater((int)Idxs.size(), (int)1) ? 1 : 0) != 0) && Idx0.isNullValue()) {
                PointerType SrcPtrTy = IrRTTI.dyn_cast_PointerType(CE.getOperand_Constant(0).getType());
                PointerType DstPtrTy = IrRTTI.dyn_cast_PointerType(CE.getType());
                if (SrcPtrTy != null && DstPtrTy != null) {
                    ArrayType SrcArrayTy = IrRTTI.dyn_cast_ArrayType(SrcPtrTy.getElementType());
                    ArrayType DstArrayTy = IrRTTI.dyn_cast_ArrayType(DstPtrTy.getElementType());
                    if (SrcArrayTy != null && DstArrayTy != null && SrcArrayTy.getElementType() == DstArrayTy.getElementType() && SrcPtrTy.getAddressSpace() == DstPtrTy.getAddressSpace()) {
                        return ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P_bool_Type$P(SrcArrayTy, CE.getOperand_Constant(0), Idxs, inBounds);
                    }
                }
            }
        }
        SmallVector NewIdxs = new SmallVector(8, (Object)null);
        Type Ty = PointeeTy;
        Type Prev = C2.getType();
        boolean Unknown = Native.$not((boolean)IrRTTI.isa_ConstantInt((Value)Idxs.$at(0)));
        int e = Idxs.size();
        for (i = 1; i != e; ++i) {
            ConstantInt CI = IrRTTI.dyn_cast_ConstantInt((Value)Idxs.$at(i));
            if (Native.$not((Object)CI)) {
                Unknown = true;
            } else if (!IrRTTI.isa_StructType(Ty)) {
                SequentialType STy = IrRTTI.cast_SequentialType(Ty);
                if (IrRTTI.isa_PointerType(STy)) {
                    Unknown = true;
                } else if (IrRTTI.isa_VectorType(STy)) {
                    Unknown = true;
                } else if (!ConstantFoldStatics.isIndexInRangeOfSequentialType(STy, CI)) {
                    if (!IrRTTI.isa_SequentialType(Prev)) {
                        Unknown = true;
                    } else if (Native.$less((long)CI.getSExtValue(), (long)0L)) {
                        Unknown = true;
                    } else {
                        NewIdxs.resize(Idxs.size());
                        long NumElements = STy.getArrayNumElements();
                        ConstantInt Factor = ConstantInt.get(CI.getType(), NumElements);
                        NewIdxs.$set(i, (Object)ConstantExpr.getSRem(CI, Factor));
                        Constant PrevIdx = IrRTTI.cast_Constant((Value)Idxs.$at(i - 1));
                        Constant Div = ConstantExpr.getSDiv(CI, Factor);
                        int CommonExtendedWidth = std.max((int)PrevIdx.getType().getIntegerBitWidth(), (int)Div.getType().getIntegerBitWidth());
                        CommonExtendedWidth = std.max((int)CommonExtendedWidth, (int)64);
                        if (!PrevIdx.getType().isIntegerTy(CommonExtendedWidth)) {
                            PrevIdx = ConstantExpr.getSExt(PrevIdx, Type.getIntNTy(Div.getContext(), CommonExtendedWidth));
                        }
                        if (!Div.getType().isIntegerTy(CommonExtendedWidth)) {
                            Div = ConstantExpr.getSExt(Div, Type.getIntNTy(Div.getContext(), CommonExtendedWidth));
                        }
                        NewIdxs.$set(i - 1, (Object)ConstantExpr.getAdd(PrevIdx, Div));
                    }
                }
            }
            Prev = Ty;
            Ty = IrRTTI.cast_CompositeType(Ty).getTypeAtIndex((Value)Idxs.$at(i));
        }
        if (!NewIdxs.empty()) {
            e = Idxs.size();
            for (i = 0; i != e; ++i) {
                if (NewIdxs.$at(i) != null) continue;
                NewIdxs.$set(i, (Object)IrRTTI.cast_Constant((Value)Idxs.$at(i)));
            }
            return ConstantExpr.getGetElementPtr_Type$P_Constant$P_ArrayRef$Constant$P_bool_Type$P(PointeeTy, C2, (ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)NewIdxs, true), inBounds);
        }
        if (!Unknown && !inBounds && (GV = IrRTTI.dyn_cast_GlobalVariable(C2)) != null && !GV.hasExternalWeakLinkage() && ConstantFoldStatics.isInBoundsIndices(Idxs)) {
            return ConstantExpr.getInBoundsGetElementPtr_Type$P_Constant$P_ArrayRef$Value$P(PointeeTy, C2, Idxs);
        }
        return null;
    }
}

