/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.type;
import org.llvm.adt.APFloat;
import org.llvm.adt.APInt;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.adt.aliases.ArrayRefULong;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.java.SmallVectorImplCommon;
import org.llvm.ir.ArrayType;
import org.llvm.ir.CastInst;
import org.llvm.ir.CmpInst;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantArray;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.ConstantFP;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.ConstantPointerNull;
import org.llvm.ir.ConstantStruct;
import org.llvm.ir.ConstantVector;
import org.llvm.ir.GEPOperator;
import org.llvm.ir.GlobalValue;
import org.llvm.ir.ICmpInst;
import org.llvm.ir.Instruction;
import org.llvm.ir.IntegerType;
import org.llvm.ir.ShuffleVectorInst;
import org.llvm.ir.StructType;
import org.llvm.ir.Type;
import org.llvm.ir.UndefValue;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.impl.ConstantFoldStatics;
import org.llvm.ir.java.IrRTTI;
import org.llvm.ir.patternmatch.PatternMatchGlobals;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;

public final class ConstantFoldLlvmStatics {
    public static Constant ConstantFoldCastInstruction(int opc, Constant V, Type DestTy) {
        if (IrRTTI.isa_UndefValue(V)) {
            if (opc == 37 || opc == 38 || opc == 41 || opc == 42) {
                return Constant.getNullValue(DestTy);
            }
            return UndefValue.get(DestTy);
        }
        if (V.isNullValue() && !DestTy.isX86_MMXTy() && opc != 48) {
            return Constant.getNullValue(DestTy);
        }
        ConstantExpr CE = IrRTTI.dyn_cast_ConstantExpr(V);
        if (CE != null) {
            if (CE.isCast()) {
                int newOpc = ConstantFoldStatics.foldConstantCastPair(opc, CE, DestTy);
                if (newOpc != 0) {
                    return ConstantExpr.getCast(newOpc, CE.getOperand_Constant(0), DestTy);
                }
            } else if (CE.getOpcode() == 32 && opc != 48) {
                boolean isAllNull = true;
                int e = CE.getNumOperands();
                for (int i = 1; i != e; ++i) {
                    if (CE.getOperand_Constant(i).isNullValue()) continue;
                    isAllNull = false;
                    break;
                }
                if (isAllNull) {
                    return ConstantExpr.getPointerCast(CE.getOperand_Constant(0), DestTy);
                }
            }
        }
        if ((IrRTTI.isa_ConstantVector(V) || IrRTTI.isa_ConstantDataVector(V)) && DestTy.isVectorTy() && DestTy.getVectorNumElements() == V.getType().getVectorNumElements()) {
            SmallVector res = new SmallVector(16, (Object)null);
            VectorType DestVecTy = IrRTTI.cast_VectorType(DestTy);
            Type DstEltTy = DestVecTy.getElementType();
            IntegerType Ty = IntegerType.get(V.getContext(), 32);
            int e = V.getType().getVectorNumElements();
            for (int i = 0; i != e; ++i) {
                Constant C2 = ConstantExpr.getExtractElement(V, ConstantInt.get((Type)Ty, Unsigned.$uint2ulong((int)i)));
                res.push_back((Object)ConstantExpr.getCast(opc, C2, DstEltTy));
            }
            return ConstantVector.get((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)res, true));
        }
        switch (opc) {
            default: {
                throw new llvm_unreachable("Failed to cast constant expression");
            }
            case 43: 
            case 44: {
                ConstantFP FPC = IrRTTI.dyn_cast_ConstantFP(V);
                if (FPC != null) {
                    bool.ptr ignored = NativePointer.create_bool$ptr();
                    APFloat Val = new APFloat(FPC.getValueAPF());
                    Val.convert(DestTy.isHalfTy() ? APFloat.IEEEhalf : (DestTy.isFloatTy() ? APFloat.IEEEsingle : (DestTy.isDoubleTy() ? APFloat.IEEEdouble : (DestTy.isX86_FP80Ty() ? APFloat.x87DoubleExtended : (DestTy.isFP128Ty() ? APFloat.IEEEquad : (DestTy.isPPC_FP128Ty() ? APFloat.PPCDoubleDouble : APFloat.Bogus))))), APFloat.roundingMode.rmNearestTiesToEven, (bool.ptr)Native.$AddrOf((Object)ignored));
                    return ConstantFP.get(V.getContext(), Val);
                }
                return null;
            }
            case 39: 
            case 40: {
                ConstantFP FPC = IrRTTI.dyn_cast_ConstantFP(V);
                if (FPC != null) {
                    APFloat V$1 = FPC.getValueAPF();
                    bool.ptr ignored = NativePointer.create_bool$ptr();
                    long[] x = NativePointer.new$ulong((int)2);
                    int DestBitWidth = IrRTTI.cast_IntegerType(DestTy).getBitWidth();
                    if (1 == V$1.convertToInteger(NativePointer.create_ulong$ptr((long[])x), DestBitWidth, opc == 40, APFloat.roundingMode.rmTowardZero, (bool.ptr)Native.$AddrOf((Object)ignored))) {
                        return UndefValue.get(DestTy);
                    }
                    APInt Val = new APInt(DestBitWidth, new ArrayRefULong(x));
                    return ConstantInt.get(FPC.getContext(), Val);
                }
                return null;
            }
            case 46: {
                if (V.isNullValue()) {
                    return ConstantPointerNull.get(IrRTTI.cast_PointerType(DestTy));
                }
                return null;
            }
            case 45: {
                if (V.isNullValue()) {
                    return ConstantInt.get(DestTy, Unsigned.$int2ulong((int)0));
                }
                CE = IrRTTI.dyn_cast_ConstantExpr(V);
                if (CE != null && CE.getOpcode() == 32 && CE.getOperand_Constant(0).isNullValue()) {
                    GEPOperator GEPO = IrRTTI.cast_GEPOperator(CE);
                    Type Ty = GEPO.getSourceElementType();
                    if (CE.getNumOperands() == 2) {
                        Constant Idx = CE.getOperand_Constant(1);
                        boolean isOne = IrRTTI.isa_ConstantInt(Idx) && IrRTTI.cast_ConstantInt(Idx).isOne();
                        Constant C3 = ConstantFoldStatics.getFoldedSizeOf(Ty, DestTy, !isOne);
                        if (C3 != null) {
                            Idx = ConstantExpr.getCast(CastInst.getCastOpcode(Idx, true, DestTy, false), Idx, DestTy);
                            return ConstantExpr.getMul(C3, Idx);
                        }
                    } else if (CE.getNumOperands() == 3 && CE.getOperand_Constant(1).isNullValue()) {
                        Constant C4;
                        ConstantInt CI;
                        StructType STy = IrRTTI.dyn_cast_StructType(Ty);
                        if (STy != null && !STy.isPacked() && (CI = IrRTTI.cast_ConstantInt(CE.getOperand_Constant(2))).isOne() && STy.getNumElements() == 2 && STy.getElementType(0).isIntegerTy(1)) {
                            return ConstantFoldStatics.getFoldedAlignOf(STy.getElementType(1), DestTy, false);
                        }
                        if ((Ty.isStructTy() || Ty.isArrayTy()) && (C4 = ConstantFoldStatics.getFoldedOffsetOf(Ty, CE.getOperand_Constant(2), DestTy, false)) != null) {
                            return C4;
                        }
                    }
                }
                return null;
            }
            case 41: 
            case 42: {
                ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(V);
                if (CI != null) {
                    APInt api = CI.getValue();
                    APFloat apf = new APFloat(DestTy.getFltSemantics(), APInt.getNullValue((int)DestTy.getPrimitiveSizeInBits()));
                    if ((4 & apf.convertFromAPInt(api, opc == 42, APFloat.roundingMode.rmNearestTiesToEven)) != 0) {
                        return UndefValue.get(DestTy);
                    }
                    return ConstantFP.get(V.getContext(), apf);
                }
                return null;
            }
            case 37: {
                int BitWidth;
                ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(V);
                if (CI != null) {
                    BitWidth = IrRTTI.cast_IntegerType(DestTy).getBitWidth();
                    return ConstantInt.get(V.getContext(), CI.getValue().zext(BitWidth));
                }
                return null;
            }
            case 38: {
                int BitWidth;
                ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(V);
                if (CI != null) {
                    BitWidth = IrRTTI.cast_IntegerType(DestTy).getBitWidth();
                    return ConstantInt.get(V.getContext(), CI.getValue().sext(BitWidth));
                }
                return null;
            }
            case 36: {
                Constant Res;
                if (V.getType().isVectorTy()) {
                    return null;
                }
                int DestBitWidth = IrRTTI.cast_IntegerType(DestTy).getBitWidth();
                ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(V);
                if (CI != null) {
                    return ConstantInt.get(V.getContext(), CI.getValue().trunc(DestBitWidth));
                }
                if ((DestBitWidth & 7) == 0 && (IrRTTI.cast_IntegerType(V.getType()).getBitWidth() & 7) == 0 && (Res = ConstantFoldStatics.ExtractConstantBytes(V, 0, Unsigned.$div_uint((int)DestBitWidth, (int)8))) != null) {
                    return Res;
                }
                return null;
            }
            case 47: {
                return ConstantFoldStatics.FoldBitCast(V, DestTy);
            }
            case 48: 
        }
        return null;
    }

    public static Constant ConstantFoldSelectInstruction(Constant Cond, Constant V1, Constant V2) {
        if (Cond.isNullValue()) {
            return V2;
        }
        if (Cond.isAllOnesValue()) {
            return V1;
        }
        ConstantVector CondV = IrRTTI.dyn_cast_ConstantVector(Cond);
        if (CondV != null) {
            SmallVector Result2 = new SmallVector(16, (Object)null);
            IntegerType Ty = IntegerType.get(CondV.getContext(), 32);
            int e = V1.getType().getVectorNumElements();
            for (int i = 0; i != e; ++i) {
                Constant V;
                Constant V1Element = ConstantExpr.getExtractElement(V1, ConstantInt.get((Type)Ty, Unsigned.$uint2ulong((int)i)));
                Constant V2Element = ConstantExpr.getExtractElement(V2, ConstantInt.get((Type)Ty, Unsigned.$uint2ulong((int)i)));
                Constant Cond$1 = IrRTTI.dyn_cast_Constant(CondV.getOperand(i));
                if (V1Element == V2Element) {
                    V = V1Element;
                } else if (IrRTTI.isa_UndefValue(Cond$1)) {
                    V = IrRTTI.isa_UndefValue(V1Element) ? V1Element : V2Element;
                } else {
                    if (!IrRTTI.isa_ConstantInt(Cond$1)) break;
                    V = Cond$1.isNullValue() ? V2Element : V1Element;
                }
                Result2.push_back((Object)V);
            }
            if (Result2.size() == V1.getType().getVectorNumElements()) {
                return ConstantVector.get((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)Result2, true));
            }
        }
        if (IrRTTI.isa_UndefValue(Cond)) {
            if (IrRTTI.isa_UndefValue(V1)) {
                return V1;
            }
            return V2;
        }
        if (IrRTTI.isa_UndefValue(V1)) {
            return V2;
        }
        if (IrRTTI.isa_UndefValue(V2)) {
            return V1;
        }
        if (V1 == V2) {
            return V1;
        }
        ConstantExpr TrueVal = IrRTTI.dyn_cast_ConstantExpr(V1);
        if (TrueVal != null && TrueVal.getOpcode() == 55 && TrueVal.getOperand_Constant(0) == Cond) {
            return ConstantExpr.getSelect(Cond, TrueVal.getOperand_Constant(1), V2);
        }
        ConstantExpr FalseVal = IrRTTI.dyn_cast_ConstantExpr(V2);
        if (FalseVal != null && FalseVal.getOpcode() == 55 && FalseVal.getOperand_Constant(0) == Cond) {
            return ConstantExpr.getSelect(Cond, V1, FalseVal.getOperand_Constant(2));
        }
        return null;
    }

    public static Constant ConstantFoldExtractElementInstruction(Constant Val, Constant Idx) {
        if (IrRTTI.isa_UndefValue(Val)) {
            return UndefValue.get(Val.getType().getVectorElementType());
        }
        if (Val.isNullValue()) {
            return Constant.getNullValue(Val.getType().getVectorElementType());
        }
        if (IrRTTI.isa_UndefValue(Idx)) {
            return UndefValue.get(Val.getType().getVectorElementType());
        }
        ConstantInt CIdx = IrRTTI.dyn_cast_ConstantInt(Idx);
        if (CIdx != null) {
            if (CIdx.uge(Unsigned.$uint2ulong((int)Val.getType().getVectorNumElements()))) {
                return UndefValue.get(Val.getType().getVectorElementType());
            }
            return Val.getAggregateElement(Unsigned.$ulong2uint((long)CIdx.getZExtValue()));
        }
        return null;
    }

    public static Constant ConstantFoldInsertElementInstruction(Constant Val, Constant Elt, Constant Idx) {
        if (IrRTTI.isa_UndefValue(Idx)) {
            return UndefValue.get(Val.getType());
        }
        ConstantInt CIdx = IrRTTI.dyn_cast_ConstantInt(Idx);
        if (CIdx == null) {
            return null;
        }
        int NumElts = Val.getType().getVectorNumElements();
        if (CIdx.uge(Unsigned.$uint2ulong((int)NumElts))) {
            return UndefValue.get(Val.getType());
        }
        SmallVector Result2 = new SmallVector(16, (Object)null);
        Result2.reserve(NumElts);
        IntegerType Ty = Type.getInt32Ty(Val.getContext());
        long IdxVal = CIdx.getZExtValue();
        for (int i = 0; i != NumElts; ++i) {
            if (Unsigned.$uint2ullong((int)i) == IdxVal) {
                Result2.push_back((Object)Elt);
                continue;
            }
            Constant C2 = ConstantExpr.getExtractElement(Val, ConstantInt.get(Ty, Unsigned.$uint2ulong((int)i)));
            Result2.push_back((Object)C2);
        }
        return ConstantVector.get((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)Result2, true));
    }

    public static Constant ConstantFoldShuffleVectorInstruction(Constant V1, Constant V2, Constant Mask) {
        int MaskNumElts = Mask.getType().getVectorNumElements();
        Type EltTy = V1.getType().getVectorElementType();
        if (IrRTTI.isa_UndefValue(Mask)) {
            return UndefValue.get(VectorType.get(EltTy, MaskNumElts));
        }
        if (IrRTTI.isa_ConstantExpr(Mask)) {
            return null;
        }
        int SrcNumElts = V1.getType().getVectorNumElements();
        SmallVector Result2 = new SmallVector(32, (Object)null);
        for (int i = 0; i != MaskNumElts; ++i) {
            IntegerType Ty;
            Constant InElt;
            int Elt = ShuffleVectorInst.getMaskValue(Mask, i);
            if (Elt == -1) {
                Result2.push_back((Object)UndefValue.get(EltTy));
                continue;
            }
            if (Unsigned.$greatereq_uint((int)Elt, (int)(SrcNumElts * 2))) {
                InElt = UndefValue.get(EltTy);
            } else if (Unsigned.$greatereq_uint((int)Elt, (int)SrcNumElts)) {
                Ty = IntegerType.get(V2.getContext(), 32);
                InElt = ConstantExpr.getExtractElement(V2, ConstantInt.get((Type)Ty, Unsigned.$uint2ulong((int)(Elt - SrcNumElts))));
            } else {
                Ty = IntegerType.get(V1.getContext(), 32);
                InElt = ConstantExpr.getExtractElement(V1, ConstantInt.get((Type)Ty, Unsigned.$int2ulong((int)Elt)));
            }
            Result2.push_back((Object)InElt);
        }
        return ConstantVector.get((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)Result2, true));
    }

    public static Constant ConstantFoldExtractValueInstruction(Constant Agg, ArrayRefUInt Idxs) {
        if (Idxs.empty()) {
            return Agg;
        }
        Constant C2 = Agg.getAggregateElement(Idxs.$at(0));
        if (C2 != null) {
            return ConstantFoldLlvmStatics.ConstantFoldExtractValueInstruction(C2, Idxs.slice(1));
        }
        return null;
    }

    public static Constant ConstantFoldInsertValueInstruction(Constant Agg, Constant Val, ArrayRefUInt Idxs) {
        ArrayType AT;
        if (Idxs.empty()) {
            return Val;
        }
        StructType ST = IrRTTI.dyn_cast_StructType(Agg.getType());
        int NumElts = ST != null ? ST.getNumElements() : ((AT = IrRTTI.dyn_cast_ArrayType(Agg.getType())) != null ? Unsigned.$ulong2uint((long)AT.getNumElements()) : Agg.getType().getVectorNumElements());
        SmallVector Result2 = new SmallVector(32, (Object)null);
        for (int i = 0; i != NumElts; ++i) {
            Constant C2 = Agg.getAggregateElement(i);
            if (C2 == null) {
                return null;
            }
            if (Idxs.$at(0) == i) {
                C2 = ConstantFoldLlvmStatics.ConstantFoldInsertValueInstruction(C2, Val, Idxs.slice(1));
            }
            Result2.push_back((Object)C2);
        }
        StructType ST2 = IrRTTI.dyn_cast_StructType(Agg.getType());
        if (ST2 != null) {
            return ConstantStruct.get(ST2, (ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)Result2, true));
        }
        AT = IrRTTI.dyn_cast_ArrayType(Agg.getType());
        if (AT != null) {
            return ConstantArray.get(AT, (ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)Result2, true));
        }
        return ConstantVector.get((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)Result2, true));
    }

    public static Constant ConstantFoldBinaryInstruction(int Opcode, Constant C1, Constant C2) {
        block118: {
            block117: {
                block116: {
                    block115: {
                        assert (Instruction.isBinaryOp(Opcode)) : "Non-binary instruction detected";
                        if (IrRTTI.isa_UndefValue(C1) || IrRTTI.isa_UndefValue(C2)) {
                            switch (Opcode) {
                                case 28: {
                                    if (IrRTTI.isa_UndefValue(C1) && IrRTTI.isa_UndefValue(C2)) {
                                        return Constant.getNullValue(C1.getType());
                                    }
                                }
                                case 11: 
                                case 13: {
                                    return UndefValue.get(C1.getType());
                                }
                                case 26: {
                                    if (IrRTTI.isa_UndefValue(C1) && IrRTTI.isa_UndefValue(C2)) {
                                        return C1;
                                    }
                                    return Constant.getNullValue(C1.getType());
                                }
                                case 15: {
                                    if (IrRTTI.isa_UndefValue(C1) && IrRTTI.isa_UndefValue(C2)) {
                                        return C1;
                                    }
                                    type.ref CV = NativePointer.create_type$ref();
                                    if ((PatternMatchGlobals.match(C1, PatternMatchGlobals.m_APInt((type.ref<APInt>)CV)) || PatternMatchGlobals.match(C2, PatternMatchGlobals.m_APInt((type.ref<APInt>)CV))) && ((APInt)Native.$Deref((Object)((APInt)CV.$deref()))).$at(0)) {
                                        return UndefValue.get(C1.getType());
                                    }
                                    return Constant.getNullValue(C1.getType());
                                }
                                case 17: 
                                case 18: {
                                    if (IrRTTI.isa_UndefValue(C2)) {
                                        return C2;
                                    }
                                    if (PatternMatchGlobals.match(C2, PatternMatchGlobals.m_Zero()) || PatternMatchGlobals.match(C2, PatternMatchGlobals.m_One())) {
                                        return C1;
                                    }
                                    return Constant.getNullValue(C1.getType());
                                }
                                case 20: 
                                case 21: {
                                    if (PatternMatchGlobals.match(C2, PatternMatchGlobals.m_Undef())) {
                                        return C2;
                                    }
                                    if (PatternMatchGlobals.match(C2, PatternMatchGlobals.m_Zero())) {
                                        return C1;
                                    }
                                    return Constant.getNullValue(C1.getType());
                                }
                                case 27: {
                                    if (IrRTTI.isa_UndefValue(C1) && IrRTTI.isa_UndefValue(C2)) {
                                        return C1;
                                    }
                                    return Constant.getAllOnesValue(C1.getType());
                                }
                                case 24: {
                                    if (IrRTTI.isa_UndefValue(C2)) {
                                        return C2;
                                    }
                                    if (PatternMatchGlobals.match(C2, PatternMatchGlobals.m_Zero())) {
                                        return C1;
                                    }
                                    return Constant.getNullValue(C1.getType());
                                }
                                case 25: {
                                    if (IrRTTI.isa_UndefValue(C2)) {
                                        return C2;
                                    }
                                    if (PatternMatchGlobals.match(C2, PatternMatchGlobals.m_Zero())) {
                                        return C1;
                                    }
                                    return Constant.getNullValue(C1.getType());
                                }
                                case 23: {
                                    if (IrRTTI.isa_UndefValue(C2)) {
                                        return C2;
                                    }
                                    if (PatternMatchGlobals.match(C2, PatternMatchGlobals.m_Zero())) {
                                        return C1;
                                    }
                                    return Constant.getNullValue(C1.getType());
                                }
                                case 12: 
                                case 14: 
                                case 16: 
                                case 19: 
                                case 22: {
                                    return null;
                                }
                                case 29: {
                                    throw new llvm_unreachable("Invalid BinaryOp");
                                }
                            }
                        }
                        assert (!IrRTTI.isa_UndefValue(C1) && !IrRTTI.isa_UndefValue(C2)) : "Unexpected UndefValue";
                        ConstantInt CI2 = IrRTTI.dyn_cast_ConstantInt(C2);
                        if (CI2 == null) break block115;
                        block14 : switch (Opcode) {
                            case 11: {
                                if (!CI2.equalsInt(Unsigned.$int2ulong((int)0))) break;
                                return C1;
                            }
                            case 13: {
                                if (!CI2.equalsInt(Unsigned.$int2ulong((int)0))) break;
                                return C1;
                            }
                            case 15: {
                                if (CI2.equalsInt(Unsigned.$int2ulong((int)0))) {
                                    return C2;
                                }
                                if (!CI2.equalsInt(Unsigned.$int2ulong((int)1))) break;
                                return C1;
                            }
                            case 17: 
                            case 18: {
                                if (CI2.equalsInt(Unsigned.$int2ulong((int)1))) {
                                    return C1;
                                }
                                if (!CI2.equalsInt(Unsigned.$int2ulong((int)0))) break;
                                return UndefValue.get(CI2.getType());
                            }
                            case 20: 
                            case 21: {
                                if (CI2.equalsInt(Unsigned.$int2ulong((int)1))) {
                                    return Constant.getNullValue(CI2.getType());
                                }
                                if (!CI2.equalsInt(Unsigned.$int2ulong((int)0))) break;
                                return UndefValue.get(CI2.getType());
                            }
                            case 26: {
                                if (CI2.isZero()) {
                                    return C2;
                                }
                                if (CI2.isAllOnesValue()) {
                                    return C1;
                                }
                                ConstantExpr CE1 = IrRTTI.dyn_cast_ConstantExpr(C1);
                                if (CE1 != null) {
                                    int SrcWidth;
                                    int DstWidth;
                                    APInt PossiblySetBits;
                                    if (CE1.getOpcode() == 37 && (PossiblySetBits = APInt.getLowBitsSet((int)(DstWidth = CI2.getType().getBitWidth()), (int)(SrcWidth = CE1.getOperand_Constant(0).getType().getPrimitiveSizeInBits()))).$bitand(CI2.getValue()).$eq(PossiblySetBits)) {
                                        return C1;
                                    }
                                    if (CE1.getOpcode() == 45 && IrRTTI.isa_GlobalValue(CE1.getOperand_Constant(0))) {
                                        GlobalValue GV = IrRTTI.cast_GlobalValue(CE1.getOperand_Constant(0));
                                        int GVAlign = GV.getAlignment();
                                        if (IrRTTI.isa_Function(GV)) {
                                            GVAlign = std.max((int)GVAlign, (int)4);
                                        }
                                        if (Unsigned.$greater_uint((int)GVAlign, (int)1)) {
                                            int DstWidth2 = CI2.getType().getBitWidth();
                                            int SrcWidth2 = std.min_uint((int)DstWidth2, (int)llvm.Log2_32((int)GVAlign));
                                            APInt BitsNotSet = APInt.getLowBitsSet((int)DstWidth2, (int)SrcWidth2);
                                            if (CI2.getValue().$bitand(BitsNotSet).$eq(CI2.getValue())) {
                                                return Constant.getNullValue(CI2.getType());
                                            }
                                        }
                                    }
                                }
                                break block116;
                            }
                            case 27: {
                                if (CI2.equalsInt(Unsigned.$int2ulong((int)0))) {
                                    return C1;
                                }
                                if (!CI2.isAllOnesValue()) break;
                                return C2;
                            }
                            case 28: {
                                if (CI2.equalsInt(Unsigned.$int2ulong((int)0))) {
                                    return C1;
                                }
                                ConstantExpr CE1 = IrRTTI.dyn_cast_ConstantExpr(C1);
                                if (CE1 != null) {
                                    switch (CE1.getOpcode()) {
                                        default: {
                                            break block14;
                                        }
                                        case 51: 
                                        case 52: 
                                    }
                                    assert (CI2.equalsInt(Unsigned.$int2ulong((int)1)));
                                    CmpInst.Predicate pred = CmpInst.Predicate.valueOf(CE1.getPredicate());
                                    pred = CmpInst.getInversePredicate(pred);
                                    return ConstantExpr.getCompare(pred.getValue(), CE1.getOperand_Constant(0), CE1.getOperand_Constant(1));
                                }
                                break block116;
                            }
                            case 25: {
                                ConstantExpr CE1 = IrRTTI.dyn_cast_ConstantExpr(C1);
                                if (CE1 == null || CE1.getOpcode() != 37) break;
                                return ConstantExpr.getLShr(C1, C2);
                            }
                        }
                        break block116;
                    }
                    if (IrRTTI.isa_ConstantInt(C1) && Instruction.isCommutative(Opcode)) {
                        return ConstantExpr.get(Opcode, C2, C1);
                    }
                }
                ConstantInt CI1 = IrRTTI.dyn_cast_ConstantInt(C1);
                if (CI1 == null) break block117;
                ConstantInt CI2 = IrRTTI.dyn_cast_ConstantInt(C2);
                if (CI2 != null) {
                    APInt C1V = CI1.getValue();
                    APInt C2V = CI2.getValue();
                    switch (Opcode) {
                        default: {
                            break;
                        }
                        case 11: {
                            return ConstantInt.get(CI1.getContext(), C1V.$add(C2V));
                        }
                        case 13: {
                            return ConstantInt.get(CI1.getContext(), C1V.$sub(C2V));
                        }
                        case 15: {
                            return ConstantInt.get(CI1.getContext(), C1V.$star(C2V));
                        }
                        case 17: {
                            assert (!CI2.isNullValue()) : "Div by zero handled above";
                            return ConstantInt.get(CI1.getContext(), C1V.udiv(C2V));
                        }
                        case 18: {
                            assert (!CI2.isNullValue()) : "Div by zero handled above";
                            if (C2V.isAllOnesValue() && C1V.isMinSignedValue()) {
                                return UndefValue.get(CI1.getType());
                            }
                            return ConstantInt.get(CI1.getContext(), C1V.sdiv(C2V));
                        }
                        case 20: {
                            assert (!CI2.isNullValue()) : "Div by zero handled above";
                            return ConstantInt.get(CI1.getContext(), C1V.urem(C2V));
                        }
                        case 21: {
                            assert (!CI2.isNullValue()) : "Div by zero handled above";
                            if (C2V.isAllOnesValue() && C1V.isMinSignedValue()) {
                                return UndefValue.get(CI1.getType());
                            }
                            return ConstantInt.get(CI1.getContext(), C1V.srem(C2V));
                        }
                        case 26: {
                            return ConstantInt.get(CI1.getContext(), C1V.$bitand(C2V));
                        }
                        case 27: {
                            return ConstantInt.get(CI1.getContext(), C1V.$bitor(C2V));
                        }
                        case 28: {
                            return ConstantInt.get(CI1.getContext(), C1V.$bitxor(C2V));
                        }
                        case 23: {
                            if (C2V.ult(Unsigned.$uint2ulong((int)C1V.getBitWidth()))) {
                                return ConstantInt.get(CI1.getContext(), C1V.shl(C2V));
                            }
                            return UndefValue.get(C1.getType());
                        }
                        case 24: {
                            if (C2V.ult(Unsigned.$uint2ulong((int)C1V.getBitWidth()))) {
                                return ConstantInt.get(CI1.getContext(), C1V.lshr(C2V));
                            }
                            return UndefValue.get(C1.getType());
                        }
                        case 25: {
                            if (C2V.ult(Unsigned.$uint2ulong((int)C1V.getBitWidth()))) {
                                return ConstantInt.get(CI1.getContext(), C1V.ashr(C2V));
                            }
                            return UndefValue.get(C1.getType());
                        }
                    }
                }
                switch (Opcode) {
                    case 17: 
                    case 18: 
                    case 20: 
                    case 21: 
                    case 23: 
                    case 24: 
                    case 25: {
                        if (CI1.equalsInt(Unsigned.$int2ulong((int)0))) {
                            return C1;
                        } else {
                            break;
                        }
                    }
                }
                break block118;
            }
            ConstantFP CFP1 = IrRTTI.dyn_cast_ConstantFP(C1);
            if (CFP1 != null) {
                ConstantFP CFP2 = IrRTTI.dyn_cast_ConstantFP(C2);
                if (CFP2 != null) {
                    APFloat C1V = CFP1.getValueAPF();
                    APFloat C2V = CFP2.getValueAPF();
                    APFloat C3V = new APFloat(C1V);
                    switch (Opcode) {
                        default: {
                            break;
                        }
                        case 12: {
                            C3V.add(C2V, APFloat.roundingMode.rmNearestTiesToEven);
                            return ConstantFP.get(C1.getContext(), C3V);
                        }
                        case 14: {
                            C3V.subtract(C2V, APFloat.roundingMode.rmNearestTiesToEven);
                            return ConstantFP.get(C1.getContext(), C3V);
                        }
                        case 16: {
                            C3V.multiply(C2V, APFloat.roundingMode.rmNearestTiesToEven);
                            return ConstantFP.get(C1.getContext(), C3V);
                        }
                        case 19: {
                            C3V.divide(C2V, APFloat.roundingMode.rmNearestTiesToEven);
                            return ConstantFP.get(C1.getContext(), C3V);
                        }
                        case 22: {
                            C3V.mod(C2V);
                            return ConstantFP.get(C1.getContext(), C3V);
                        }
                    }
                }
            } else {
                VectorType VTy = IrRTTI.dyn_cast_VectorType(C1.getType());
                if (VTy != null) {
                    SmallVector Result2 = new SmallVector(16, (Object)null);
                    IntegerType Ty = IntegerType.get(VTy.getContext(), 32);
                    int e = VTy.getNumElements();
                    for (int i = 0; i != e; ++i) {
                        Constant LHS = ConstantExpr.getExtractElement(C1, ConstantInt.get((Type)Ty, Unsigned.$uint2ulong((int)i)));
                        Constant RHS = ConstantExpr.getExtractElement(C2, ConstantInt.get((Type)Ty, Unsigned.$uint2ulong((int)i)));
                        Result2.push_back((Object)ConstantExpr.get(Opcode, LHS, RHS));
                    }
                    return ConstantVector.get((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)Result2, true));
                }
            }
        }
        ConstantExpr CE1 = IrRTTI.dyn_cast_ConstantExpr(C1);
        if (CE1 != null) {
            Constant T2;
            if (Instruction.isAssociative(Opcode) && CE1.getOpcode() == Opcode && (!IrRTTI.isa_ConstantExpr(T2 = ConstantExpr.get(Opcode, CE1.getOperand_Constant(1), C2)) || IrRTTI.cast_ConstantExpr(T2).getOpcode() != Opcode)) {
                return ConstantExpr.get(Opcode, CE1.getOperand_Constant(0), T2);
            }
        } else if (IrRTTI.isa_ConstantExpr(C2) && Instruction.isCommutative(Opcode)) {
            return ConstantFoldLlvmStatics.ConstantFoldBinaryInstruction(Opcode, C2, C1);
        }
        if (C1.getType().isIntegerTy(1)) {
            switch (Opcode) {
                case 11: 
                case 13: {
                    return ConstantExpr.getXor(C1, C2);
                }
                case 15: {
                    return ConstantExpr.getAnd(C1, C2);
                }
                case 23: 
                case 24: 
                case 25: {
                    return C1;
                }
                case 17: 
                case 18: {
                    return C1;
                }
                case 20: 
                case 21: {
                    return ConstantInt.getFalse(C1.getContext());
                }
            }
        }
        return null;
    }

    public static Constant ConstantFoldCompareInstruction(char pred, Constant C1, Constant C2) {
        GlobalValue GV;
        VectorType VT = IrRTTI.dyn_cast_VectorType(C1.getType());
        Type ResultTy = VT != null ? VectorType.get(Type.getInt1Ty(C1.getContext()), VT.getNumElements()) : Type.getInt1Ty(C1.getContext());
        if (Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_FALSE.getValue()) {
            return Constant.getNullValue(ResultTy);
        }
        if (Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_TRUE.getValue()) {
            return Constant.getAllOnesValue(ResultTy);
        }
        if (IrRTTI.isa_UndefValue(C1) || IrRTTI.isa_UndefValue(C2)) {
            CmpInst.Predicate Predicate2 = CmpInst.Predicate.valueOf(pred);
            boolean isIntegerPredicate = ICmpInst.isIntPredicate(Predicate2);
            if (ICmpInst.isEquality(Predicate2) || isIntegerPredicate && C1 == C2) {
                return UndefValue.get(ResultTy);
            }
            if (isIntegerPredicate) {
                return ConstantInt.get(ResultTy, (long)(CmpInst.isTrueWhenEqual(Predicate2) ? 1 : 0));
            }
            return ConstantInt.get(ResultTy, (long)(CmpInst.isUnordered(Predicate2) ? 1 : 0));
        }
        if (C1.isNullValue()) {
            GV = IrRTTI.dyn_cast_GlobalValue(C2);
            if (GV != null && !IrRTTI.isa_GlobalAlias(GV) && !GV.hasExternalWeakLinkage()) {
                if (Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.ICMP_EQ.getValue()) {
                    return ConstantInt.getFalse(C1.getContext());
                }
                if (Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.ICMP_NE.getValue()) {
                    return ConstantInt.getTrue(C1.getContext());
                }
            }
        } else if (C2.isNullValue() && (GV = IrRTTI.dyn_cast_GlobalValue(C1)) != null && !IrRTTI.isa_GlobalAlias(GV) && !GV.hasExternalWeakLinkage()) {
            if (Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.ICMP_EQ.getValue()) {
                return ConstantInt.getFalse(C1.getContext());
            }
            if (Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.ICMP_NE.getValue()) {
                return ConstantInt.getTrue(C1.getContext());
            }
        }
        if (C1.getType().isIntegerTy(1)) {
            switch (CmpInst.Predicate.valueOf(Unsigned.$ushort2int((char)pred))) {
                case ICMP_EQ: {
                    if (IrRTTI.isa_ConstantInt(C2)) {
                        return ConstantExpr.getXor(C1, ConstantExpr.getNot(C2));
                    }
                    return ConstantExpr.getXor(ConstantExpr.getNot(C1), C2);
                }
                case ICMP_NE: {
                    return ConstantExpr.getXor(C1, C2);
                }
            }
        }
        if (IrRTTI.isa_ConstantInt(C1) && IrRTTI.isa_ConstantInt(C2)) {
            APInt V1 = IrRTTI.cast_ConstantInt(C1).getValue();
            APInt V2 = IrRTTI.cast_ConstantInt(C2).getValue();
            switch (CmpInst.Predicate.valueOf(Unsigned.$ushort2int((char)pred))) {
                default: {
                    throw new llvm_unreachable("Invalid ICmp Predicate");
                }
                case ICMP_EQ: {
                    return ConstantInt.get(ResultTy, (long)(V1.$eq(V2) ? 1 : 0));
                }
                case ICMP_NE: {
                    return ConstantInt.get(ResultTy, (long)(V1.$noteq(V2) ? 1 : 0));
                }
                case ICMP_SLT: {
                    return ConstantInt.get(ResultTy, (long)(V1.slt(V2) ? 1 : 0));
                }
                case ICMP_SGT: {
                    return ConstantInt.get(ResultTy, (long)(V1.sgt(V2) ? 1 : 0));
                }
                case ICMP_SLE: {
                    return ConstantInt.get(ResultTy, (long)(V1.sle(V2) ? 1 : 0));
                }
                case ICMP_SGE: {
                    return ConstantInt.get(ResultTy, (long)(V1.sge(V2) ? 1 : 0));
                }
                case ICMP_ULT: {
                    return ConstantInt.get(ResultTy, (long)(V1.ult(V2) ? 1 : 0));
                }
                case ICMP_UGT: {
                    return ConstantInt.get(ResultTy, (long)(V1.ugt(V2) ? 1 : 0));
                }
                case ICMP_ULE: {
                    return ConstantInt.get(ResultTy, (long)(V1.ule(V2) ? 1 : 0));
                }
                case ICMP_UGE: 
            }
            return ConstantInt.get(ResultTy, (long)(V1.uge(V2) ? 1 : 0));
        }
        if (IrRTTI.isa_ConstantFP(C1) && IrRTTI.isa_ConstantFP(C2)) {
            APFloat C1V = IrRTTI.cast_ConstantFP(C1).getValueAPF();
            APFloat C2V = IrRTTI.cast_ConstantFP(C2).getValueAPF();
            APFloat.cmpResult R = C1V.compare(C2V);
            switch (CmpInst.Predicate.valueOf(Unsigned.$ushort2int((char)pred))) {
                default: {
                    throw new llvm_unreachable("Invalid FCmp Predicate");
                }
                case FCMP_FALSE: {
                    return Constant.getNullValue(ResultTy);
                }
                case FCMP_TRUE: {
                    return Constant.getAllOnesValue(ResultTy);
                }
                case FCMP_UNO: {
                    return ConstantInt.get(ResultTy, (long)(R == APFloat.cmpResult.cmpUnordered ? 1 : 0));
                }
                case FCMP_ORD: {
                    return ConstantInt.get(ResultTy, (long)(R != APFloat.cmpResult.cmpUnordered ? 1 : 0));
                }
                case FCMP_UEQ: {
                    return ConstantInt.get(ResultTy, (long)(R == APFloat.cmpResult.cmpUnordered || R == APFloat.cmpResult.cmpEqual ? 1 : 0));
                }
                case FCMP_OEQ: {
                    return ConstantInt.get(ResultTy, (long)(R == APFloat.cmpResult.cmpEqual ? 1 : 0));
                }
                case FCMP_UNE: {
                    return ConstantInt.get(ResultTy, (long)(R != APFloat.cmpResult.cmpEqual ? 1 : 0));
                }
                case FCMP_ONE: {
                    return ConstantInt.get(ResultTy, (long)(R == APFloat.cmpResult.cmpLessThan || R == APFloat.cmpResult.cmpGreaterThan ? 1 : 0));
                }
                case FCMP_ULT: {
                    return ConstantInt.get(ResultTy, (long)(R == APFloat.cmpResult.cmpUnordered || R == APFloat.cmpResult.cmpLessThan ? 1 : 0));
                }
                case FCMP_OLT: {
                    return ConstantInt.get(ResultTy, (long)(R == APFloat.cmpResult.cmpLessThan ? 1 : 0));
                }
                case FCMP_UGT: {
                    return ConstantInt.get(ResultTy, (long)(R == APFloat.cmpResult.cmpUnordered || R == APFloat.cmpResult.cmpGreaterThan ? 1 : 0));
                }
                case FCMP_OGT: {
                    return ConstantInt.get(ResultTy, (long)(R == APFloat.cmpResult.cmpGreaterThan ? 1 : 0));
                }
                case FCMP_ULE: {
                    return ConstantInt.get(ResultTy, (long)(R != APFloat.cmpResult.cmpGreaterThan ? 1 : 0));
                }
                case FCMP_OLE: {
                    return ConstantInt.get(ResultTy, (long)(R == APFloat.cmpResult.cmpLessThan || R == APFloat.cmpResult.cmpEqual ? 1 : 0));
                }
                case FCMP_UGE: {
                    return ConstantInt.get(ResultTy, (long)(R != APFloat.cmpResult.cmpLessThan ? 1 : 0));
                }
                case FCMP_OGE: 
            }
            return ConstantInt.get(ResultTy, (long)(R == APFloat.cmpResult.cmpGreaterThan || R == APFloat.cmpResult.cmpEqual ? 1 : 0));
        }
        if (C1.getType().isVectorTy()) {
            SmallVector ResElts = new SmallVector(4, (Object)null);
            IntegerType Ty = IntegerType.get(C1.getContext(), 32);
            int e = C1.getType().getVectorNumElements();
            for (int i = 0; i != e; ++i) {
                Constant C1E = ConstantExpr.getExtractElement(C1, ConstantInt.get((Type)Ty, Unsigned.$uint2ulong((int)i)));
                Constant C2E = ConstantExpr.getExtractElement(C2, ConstantInt.get((Type)Ty, Unsigned.$uint2ulong((int)i)));
                ResElts.push_back((Object)ConstantExpr.getCompare(pred, C1E, C2E));
            }
            return ConstantVector.get((ArrayRef<Constant>)new ArrayRef((SmallVectorImplCommon)ResElts, true));
        }
        if (C1.getType().isFloatingPointTy() && (IrRTTI.isa_ConstantExpr(C1) || IrRTTI.isa_ConstantExpr(C2))) {
            int Result2 = -1;
            switch (ConstantFoldStatics.evaluateFCmpRelation(C1, C2)) {
                default: {
                    throw new llvm_unreachable("Unknown relation!");
                }
                case FCMP_FALSE: 
                case FCMP_TRUE: 
                case FCMP_UNO: 
                case FCMP_ORD: 
                case FCMP_UEQ: 
                case FCMP_UNE: 
                case FCMP_ULT: 
                case FCMP_UGT: 
                case FCMP_ULE: 
                case FCMP_UGE: 
                case BAD_FCMP_PREDICATE: {
                    break;
                }
                case FCMP_OEQ: {
                    Result2 = Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_UEQ.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_OEQ.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_ULE.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_OLE.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_UGE.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_OGE.getValue() ? 1 : 0;
                    break;
                }
                case FCMP_OLT: {
                    Result2 = Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_UNE.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_ONE.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_ULT.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_OLT.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_ULE.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_OLE.getValue() ? 1 : 0;
                    break;
                }
                case FCMP_OGT: {
                    Result2 = Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_UNE.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_ONE.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_UGT.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_OGT.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_UGE.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_OGE.getValue() ? 1 : 0;
                    break;
                }
                case FCMP_OLE: {
                    if (Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_UGT.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_OGT.getValue()) {
                        Result2 = 0;
                        break;
                    }
                    if (Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.FCMP_ULT.getValue() && Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.FCMP_OLT.getValue()) break;
                    Result2 = 1;
                    break;
                }
                case FCMP_OGE: {
                    if (Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_ULT.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_OLT.getValue()) {
                        Result2 = 0;
                        break;
                    }
                    if (Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.FCMP_UGT.getValue() && Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.FCMP_OGT.getValue()) break;
                    Result2 = 1;
                    break;
                }
                case FCMP_ONE: {
                    if (Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_OEQ.getValue() || Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.FCMP_UEQ.getValue()) {
                        Result2 = 0;
                        break;
                    }
                    if (Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.FCMP_ONE.getValue() && Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.FCMP_UNE.getValue()) break;
                    Result2 = 1;
                }
            }
            if (Result2 != -1) {
                return ConstantInt.get(ResultTy, Unsigned.$int2ulong((int)Result2));
            }
        } else {
            Constant CE1Op0;
            Constant CE1Inverse;
            ConstantExpr CE1;
            int Result3 = -1;
            switch (ConstantFoldStatics.evaluateICmpRelation(C1, C2, CmpInst.isSigned(CmpInst.Predicate.valueOf(pred)))) {
                default: {
                    throw new llvm_unreachable("Unknown relational!");
                }
                case BAD_ICMP_PREDICATE: {
                    break;
                }
                case ICMP_EQ: {
                    Result3 = ICmpInst.isTrueWhenEqual(CmpInst.Predicate.valueOf(pred)) ? 1 : 0;
                    break;
                }
                case ICMP_ULT: {
                    switch (CmpInst.Predicate.valueOf(Unsigned.$ushort2int((char)pred))) {
                        case ICMP_NE: 
                        case ICMP_ULT: 
                        case ICMP_ULE: {
                            Result3 = 1;
                            break;
                        }
                        case ICMP_EQ: 
                        case ICMP_UGT: 
                        case ICMP_UGE: {
                            Result3 = 0;
                        }
                    }
                    break;
                }
                case ICMP_SLT: {
                    switch (CmpInst.Predicate.valueOf(Unsigned.$ushort2int((char)pred))) {
                        case ICMP_NE: 
                        case ICMP_SLT: 
                        case ICMP_SLE: {
                            Result3 = 1;
                            break;
                        }
                        case ICMP_EQ: 
                        case ICMP_SGT: 
                        case ICMP_SGE: {
                            Result3 = 0;
                        }
                    }
                    break;
                }
                case ICMP_UGT: {
                    switch (CmpInst.Predicate.valueOf(Unsigned.$ushort2int((char)pred))) {
                        case ICMP_NE: 
                        case ICMP_UGT: 
                        case ICMP_UGE: {
                            Result3 = 1;
                            break;
                        }
                        case ICMP_EQ: 
                        case ICMP_ULT: 
                        case ICMP_ULE: {
                            Result3 = 0;
                        }
                    }
                    break;
                }
                case ICMP_SGT: {
                    switch (CmpInst.Predicate.valueOf(Unsigned.$ushort2int((char)pred))) {
                        case ICMP_NE: 
                        case ICMP_SGT: 
                        case ICMP_SGE: {
                            Result3 = 1;
                            break;
                        }
                        case ICMP_EQ: 
                        case ICMP_SLT: 
                        case ICMP_SLE: {
                            Result3 = 0;
                        }
                    }
                    break;
                }
                case ICMP_ULE: {
                    if (Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.ICMP_UGT.getValue()) {
                        Result3 = 0;
                    }
                    if (Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.ICMP_ULT.getValue() && Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.ICMP_ULE.getValue()) break;
                    Result3 = 1;
                    break;
                }
                case ICMP_SLE: {
                    if (Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.ICMP_SGT.getValue()) {
                        Result3 = 0;
                    }
                    if (Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.ICMP_SLT.getValue() && Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.ICMP_SLE.getValue()) break;
                    Result3 = 1;
                    break;
                }
                case ICMP_UGE: {
                    if (Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.ICMP_ULT.getValue()) {
                        Result3 = 0;
                    }
                    if (Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.ICMP_UGT.getValue() && Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.ICMP_UGE.getValue()) break;
                    Result3 = 1;
                    break;
                }
                case ICMP_SGE: {
                    if (Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.ICMP_SLT.getValue()) {
                        Result3 = 0;
                    }
                    if (Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.ICMP_SGT.getValue() && Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.ICMP_SGE.getValue()) break;
                    Result3 = 1;
                    break;
                }
                case ICMP_NE: {
                    if (Unsigned.$ushort2int((char)pred) == CmpInst.Predicate.ICMP_EQ.getValue()) {
                        Result3 = 0;
                    }
                    if (Unsigned.$ushort2int((char)pred) != CmpInst.Predicate.ICMP_NE.getValue()) break;
                    Result3 = 1;
                }
            }
            if (Result3 != -1) {
                return ConstantInt.get(ResultTy, Unsigned.$int2ulong((int)Result3));
            }
            ConstantExpr CE2 = IrRTTI.dyn_cast_ConstantExpr(C2);
            if (CE2 != null) {
                Constant CE2Op0 = CE2.getOperand_Constant(0);
                if (CE2.getOpcode() == 47 && CE2.getType().isVectorTy() == CE2Op0.getType().isVectorTy()) {
                    Constant Inverse2 = ConstantExpr.getBitCast(C1, CE2Op0.getType());
                    return ConstantExpr.getICmp(pred, Inverse2, CE2Op0);
                }
            }
            if ((CE1 = IrRTTI.dyn_cast_ConstantExpr(C1)) != null && (CE1.getOpcode() == 38 && ICmpInst.isSigned(CmpInst.Predicate.valueOf(pred)) || CE1.getOpcode() == 37 && !ICmpInst.isSigned(CmpInst.Predicate.valueOf(pred))) && (CE1Inverse = ConstantExpr.getTrunc(CE1, (CE1Op0 = CE1.getOperand_Constant(0)).getType())) == CE1Op0) {
                Constant C2Inverse = ConstantExpr.getTrunc(C2, CE1Op0.getType());
                if (ConstantExpr.getCast(CE1.getOpcode(), C2Inverse, C2.getType()) == C2) {
                    return ConstantExpr.getICmp(pred, CE1Inverse, C2Inverse);
                }
            }
            if (!IrRTTI.isa_ConstantExpr(C1) && IrRTTI.isa_ConstantExpr(C2) || C1.isNullValue() && !C2.isNullValue()) {
                pred = ICmpInst.getSwappedPredicate(CmpInst.Predicate.valueOf(pred)).getValue();
                return ConstantExpr.getICmp(pred, C2, C1);
            }
        }
        return null;
    }

    public static Constant ConstantFoldGetElementPtr_Type$P_Constant$P_bool_ArrayRef$Constant$P(Type Ty, Constant C2, boolean inBounds, ArrayRef<Constant> Idxs) {
        return ConstantFoldStatics.ConstantFoldGetElementPtrImpl(Ty, C2, inBounds, new ArrayRef(Idxs));
    }

    public static Constant ConstantFoldGetElementPtr_Type$P_Constant$P_bool_ArrayRef$Value$P(Type Ty, Constant C2, boolean inBounds, ArrayRef<Value> Idxs) {
        return ConstantFoldStatics.ConstantFoldGetElementPtrImpl(Ty, C2, inBounds, new ArrayRef(Idxs));
    }
}

