/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.StringRef;
import org.llvm.ir.AttrBuilder;
import org.llvm.ir.Attribute;
import org.llvm.ir.AttributeSet;
import org.llvm.ir.Function;
import org.llvm.ir.impl.gen.EnumAttr;
import org.llvm.ir.impl.gen.StrBoolAttr;

public final class AttributesStatics {
    public static int AllocSizeNumElemsNotPresent = -1;

    public static long packAllocSizeArgs(int ElemSizeArg, ADTAliases.OptionalUInt NumElemsArg) {
        assert (!NumElemsArg.hasValue() || NumElemsArg.$star() != AllocSizeNumElemsNotPresent) : "Attempting to pack a reserved value";
        return Unsigned.$uint2ulong((int)ElemSizeArg) << 32 | Unsigned.$uint2ullong((int)NumElemsArg.getValueOr_T$RR(AllocSizeNumElemsNotPresent));
    }

    public static std_pair.pairUIntType<ADTAliases.OptionalUInt> unpackAllocSizeArgs(long Num) {
        int NumElems = Unsigned.$ullong2uint((long)(Num & Unsigned.$uint2ullong((int)std.numeric_limitsUInt.max())));
        int ElemSizeArg = Unsigned.$ulong2uint((long)(Num >>> 32));
        ADTAliases.OptionalUInt NumElemsArg = new ADTAliases.OptionalUInt();
        if (NumElems != AllocSizeNumElemsNotPresent) {
            NumElemsArg.$assign_T$C$R(NumElems);
        }
        return std.make_pair_uint_T((int)ElemSizeArg, (Object)NumElemsArg);
    }

    public static <AttrClass> boolean isEqual(Attribute.AttrKind attrKind, Function Caller, Function Callee) {
        return Native.$eq((Object)Caller.getFnAttribute(attrKind), (Object)Callee.getFnAttribute(attrKind));
    }

    public static <AttrClass extends StrBoolAttr> void setAND(char.ptr attrKind, Function Caller, Function Callee) {
        if (Native.$bool((boolean)StrBoolAttr.isSet(Caller, new StringRef(attrKind))) && Native.$not((boolean)StrBoolAttr.isSet(Callee, new StringRef(attrKind)))) {
            StrBoolAttr.set(Caller, new StringRef(attrKind), false);
        }
    }

    public static <AttrClass extends StrBoolAttr> void setOR(char.ptr attrKind, Function Caller, Function Callee) {
        if (Native.$not((boolean)StrBoolAttr.isSet(Caller, new StringRef(attrKind))) && Native.$bool((boolean)StrBoolAttr.isSet(Callee, new StringRef(attrKind)))) {
            StrBoolAttr.set(Caller, new StringRef(attrKind), true);
        }
    }

    public static <AttrClass extends EnumAttr> void setOR(Attribute.AttrKind attrKind, Function Caller, Function Callee) {
        if (Native.$not((boolean)EnumAttr.isSet(Caller, attrKind)) && Native.$bool((boolean)EnumAttr.isSet(Callee, attrKind))) {
            EnumAttr.set(Caller, attrKind, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adjustCallerSSPLevel(Function Caller, Function Callee) {
        AttrBuilder B2 = null;
        try {
            B2 = new AttrBuilder();
            B2.addAttribute(Attribute.AttrKind.StackProtect).addAttribute(Attribute.AttrKind.StackProtectStrong).addAttribute(Attribute.AttrKind.StackProtectReq);
            AttributeSet OldSSPAttr = AttributeSet.get(Caller.getContext(), AttributeSet.AttrIndex.FunctionIndex.getValue(), B2);
            if (Callee.hasFnAttribute(Attribute.AttrKind.StackProtectReq)) {
                Caller.removeAttributes(AttributeSet.AttrIndex.FunctionIndex.getValue(), new AttributeSet(OldSSPAttr));
                Caller.addFnAttr(Attribute.AttrKind.StackProtectReq);
            } else if (Callee.hasFnAttribute(Attribute.AttrKind.StackProtectStrong) && !Caller.hasFnAttribute(Attribute.AttrKind.StackProtectReq)) {
                Caller.removeAttributes(AttributeSet.AttrIndex.FunctionIndex.getValue(), new AttributeSet(OldSSPAttr));
                Caller.addFnAttr(Attribute.AttrKind.StackProtectStrong);
            } else if (Callee.hasFnAttribute(Attribute.AttrKind.StackProtect) && !Caller.hasFnAttribute(Attribute.AttrKind.StackProtectReq) && !Caller.hasFnAttribute(Attribute.AttrKind.StackProtectStrong)) {
                Caller.addFnAttr(Attribute.AttrKind.StackProtect);
            }
        }
        finally {
            if (B2 != null) {
                B2.$destroy();
            }
        }
    }
}

