/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir.impl;

import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.clank.support.void;
import org.llvm.adt.SetVector;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.DenseMapIteratorTypeUInt;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.ir.AllocaInst;
import org.llvm.ir.Argument;
import org.llvm.ir.AssemblyAnnotationWriter;
import org.llvm.ir.AtomicCmpXchgInst;
import org.llvm.ir.AtomicRMWInst;
import org.llvm.ir.Attribute;
import org.llvm.ir.AttributeSet;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.BranchInst;
import org.llvm.ir.CallInst;
import org.llvm.ir.CatchReturnInst;
import org.llvm.ir.CatchSwitchInst;
import org.llvm.ir.CleanupReturnInst;
import org.llvm.ir.CmpInst;
import org.llvm.ir.Comdat;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.ExtractValueInst;
import org.llvm.ir.FenceInst;
import org.llvm.ir.FuncletPadInst;
import org.llvm.ir.Function;
import org.llvm.ir.FunctionType;
import org.llvm.ir.GCRelocateInst;
import org.llvm.ir.GetElementPtrInst;
import org.llvm.ir.GlobalAlias;
import org.llvm.ir.GlobalIFunc;
import org.llvm.ir.GlobalIndirectSymbol;
import org.llvm.ir.GlobalObject;
import org.llvm.ir.GlobalVariable;
import org.llvm.ir.ImmutableCallSite;
import org.llvm.ir.InsertValueInst;
import org.llvm.ir.Instruction;
import org.llvm.ir.InvokeInst;
import org.llvm.ir.LandingPadInst;
import org.llvm.ir.LoadInst;
import org.llvm.ir.MDNode;
import org.llvm.ir.Metadata;
import org.llvm.ir.Module$IR;
import org.llvm.ir.NamedMDNode;
import org.llvm.ir.OperandBundleUse;
import org.llvm.ir.PHINode;
import org.llvm.ir.PredIterator;
import org.llvm.ir.StoreInst;
import org.llvm.ir.StructType;
import org.llvm.ir.SwitchInst;
import org.llvm.ir.SynchronizationScope;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.UseListOrder;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.impl.AsmWriterStatics;
import org.llvm.ir.impl.PrefixType;
import org.llvm.ir.impl.SlotTracker;
import org.llvm.ir.impl.TypePrinting;
import org.llvm.ir.java.IrRTTI;
import org.llvm.pass.IrLlvmGlobals;
import org.llvm.support.AdtsupportLlvmGlobals;
import org.llvm.support.AtomicOrdering;
import org.llvm.support.formatted_raw_ostream;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;

public class AssemblyWriter
implements Destructors.ClassWithDestructor {
    private final formatted_raw_ostream Out;
    private Module$IR TheModule;
    private std_ptr.unique_ptr<SlotTracker> SlotTrackerStorage;
    private final SlotTracker Machine;
    private TypePrinting TypePrinter;
    private AssemblyAnnotationWriter AnnotationWriter;
    private SetVector<Comdat> Comdats;
    private boolean IsForDebug;
    private boolean ShouldPreserveUseListOrder;
    private std.vector<UseListOrder> UseListOrders;
    private SmallVector<StringRef> MDNames;

    public AssemblyWriter(formatted_raw_ostream o, SlotTracker Mac, Module$IR M, AssemblyAnnotationWriter AAW, boolean IsForDebug) {
        this(o, Mac, M, AAW, IsForDebug, false);
    }

    public AssemblyWriter(formatted_raw_ostream o, SlotTracker Mac, Module$IR M, AssemblyAnnotationWriter AAW, boolean IsForDebug, boolean ShouldPreserveUseListOrder) {
        this.Out = o;
        this.TheModule = M;
        this.SlotTrackerStorage = new std_ptr.unique_ptr();
        this.Machine = Mac;
        this.TypePrinter = new TypePrinting();
        this.AnnotationWriter = AAW;
        this.Comdats = new SetVector((Object)null);
        this.IsForDebug = IsForDebug;
        this.ShouldPreserveUseListOrder = ShouldPreserveUseListOrder;
        this.UseListOrders = new std.vector(() -> new UseListOrder());
        this.MDNames = new SmallVector(8, (Object)new StringRef());
        if (this.TheModule == null) {
            return;
        }
        this.TypePrinter.incorporateTypes((Module$IR)Native.$Deref((Object)this.TheModule));
        for (GlobalObject GO : this.TheModule.global_objects$Const()) {
            Comdat C2 = GO.getComdat$Const();
            if (C2 == null) continue;
            this.Comdats.insert((Object)C2);
        }
    }

    public void printMDNodeBody(MDNode Node2) {
        AsmWriterStatics.WriteMDNodeBodyInternal((raw_ostream)this.Out, Node2, (TypePrinting)Native.$AddrOf((Object)this.TypePrinter), (SlotTracker)Native.$AddrOf((Object)this.Machine), this.TheModule);
    }

    public void printNamedMDNode(NamedMDNode NMD) {
        this.Out.$out_char((byte)33);
        AsmWriterStatics.printMetadataIdentifier(NMD.getName(), this.Out);
        this.Out.$out(" = !{");
        int e = NMD.getNumOperands();
        for (int i = 0; i != e; ++i) {
            int Slot;
            if (i != 0) {
                this.Out.$out(NativePointer.$COMMA_SPACE);
            }
            if ((Slot = this.Machine.getMetadataSlot(NMD.getOperand(i))) == -1) {
                this.Out.$out("<badref>");
                continue;
            }
            this.Out.$out_char((byte)33).$out_int(Slot);
        }
        this.Out.$out("}\n");
    }

    public void printModule(Module$IR M) {
        std.string DL;
        this.Machine.initialize();
        if (this.ShouldPreserveUseListOrder) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)this.UseListOrders.$assignMove((std.vector)$c$.track(AsmWriterStatics.predictUseListOrder(M))));
            }
            finally {
                $c$.$destroy();
            }
        }
        if (!M.getModuleIdentifier().empty() && M.getModuleIdentifier().find_T_size_type$_CharT((byte)10) == std.string.npos) {
            this.Out.$out("; ModuleID = '").$out(M.getModuleIdentifier()).$out("'\n");
        }
        if (!M.getSourceFileName().empty()) {
            this.Out.$out("source_filename = \"");
            AsmWriterStatics.PrintEscapedString(new StringRef(M.getSourceFileName()), (raw_ostream)this.Out);
            this.Out.$out(NativePointer.$QUOTE_LF);
        }
        if (!(DL = M.getDataLayoutStr()).empty()) {
            this.Out.$out("target datalayout = \"").$out(DL).$out(NativePointer.$QUOTE_LF);
        }
        if (!M.getTargetTriple().empty()) {
            this.Out.$out("target triple = \"").$out(M.getTargetTriple()).$out(NativePointer.$QUOTE_LF);
        }
        if (!M.getModuleInlineAsm().empty()) {
            this.Out.$out_char((byte)10);
            StringRef Asm = new StringRef(M.getModuleInlineAsm());
            do {
                StringRef Front = new StringRef();
                std.tie((Object)Front, (Object)Asm).$assign((std_pair.pair)Asm.split((byte)10));
                this.Out.$out("module asm \"");
                AsmWriterStatics.PrintEscapedString(new StringRef(Front), (raw_ostream)this.Out);
                this.Out.$out(NativePointer.$QUOTE_LF);
            } while (!Asm.empty());
        }
        this.printTypeIdentities();
        if (!this.Comdats.empty()) {
            this.Out.$out_char((byte)10);
        }
        for (Comdat C2 : this.Comdats) {
            this.printComdat(C2);
            if (C2 == this.Comdats.back()) continue;
            this.Out.$out_char((byte)10);
        }
        if (!M.global_empty()) {
            this.Out.$out_char((byte)10);
        }
        for (GlobalVariable GV : M.globals$Const()) {
            this.printGlobal((GlobalVariable)Native.$AddrOf((Object)GV));
            this.Out.$out_char((byte)10);
        }
        if (!M.alias_empty()) {
            this.Out.$out(NativePointer.$LF);
        }
        for (GlobalAlias GA : M.aliases$Const()) {
            this.printIndirectSymbol((GlobalIndirectSymbol)Native.$AddrOf((Object)GA));
        }
        if (!M.ifunc_empty()) {
            this.Out.$out(NativePointer.$LF);
        }
        for (GlobalIFunc GI : M.ifuncs$Const()) {
            this.printIndirectSymbol((GlobalIndirectSymbol)Native.$AddrOf((Object)GI));
        }
        this.printUseLists(null);
        for (Function F : (Module$IR)Native.$Deref((Object)M)) {
            this.printFunction((Function)Native.$AddrOf((Object)F));
        }
        assert (this.UseListOrders.empty()) : "All use-lists should have been consumed";
        if (!this.Machine.as_empty()) {
            this.Out.$out_char((byte)10);
            this.writeAllAttributeGroups();
        }
        if (!M.named_metadata_empty()) {
            this.Out.$out_char((byte)10);
        }
        for (NamedMDNode Node2 : M.named_metadata$Const()) {
            this.printNamedMDNode((NamedMDNode)Native.$AddrOf((Object)Node2));
        }
        if (!this.Machine.mdn_empty()) {
            this.Out.$out_char((byte)10);
            this.writeAllMDNodes();
        }
    }

    public void writeOperand(Value Operand, boolean PrintType) {
        if (Operand == null) {
            this.Out.$out("<null operand!>");
            return;
        }
        if (PrintType) {
            this.TypePrinter.print(Operand.getType(), (raw_ostream)this.Out);
            this.Out.$out_char((byte)32);
        }
        AsmWriterStatics.WriteAsOperandInternal((raw_ostream)this.Out, Operand, (TypePrinting)Native.$AddrOf((Object)this.TypePrinter), (SlotTracker)Native.$AddrOf((Object)this.Machine), this.TheModule);
    }

    public void writeParamOperand(Value Operand, AttributeSet Attrs, int Idx) {
        if (Operand == null) {
            this.Out.$out("<null operand!>");
            return;
        }
        this.TypePrinter.print(Operand.getType(), (raw_ostream)this.Out);
        if (Attrs.hasAttributes(Idx)) {
            this.Out.$out_char((byte)32).$out(Attrs.getAsString(Idx));
        }
        this.Out.$out_char((byte)32);
        AsmWriterStatics.WriteAsOperandInternal((raw_ostream)this.Out, Operand, (TypePrinting)Native.$AddrOf((Object)this.TypePrinter), (SlotTracker)Native.$AddrOf((Object)this.Machine), this.TheModule);
    }

    public void writeOperandBundles(ImmutableCallSite CS) {
        if (!CS.hasOperandBundles()) {
            return;
        }
        this.Out.$out(" [ ");
        boolean FirstBundle = true;
        int e = CS.getNumOperandBundles();
        for (int i = 0; i != e; ++i) {
            OperandBundleUse BU = CS.getOperandBundleAt(i);
            if (!FirstBundle) {
                this.Out.$out(NativePointer.$COMMA_SPACE);
            }
            FirstBundle = false;
            this.Out.$out_char((byte)34);
            AsmWriterStatics.PrintEscapedString(BU.getTagName(), (raw_ostream)this.Out);
            this.Out.$out_char((byte)34);
            this.Out.$out_char((byte)40);
            boolean FirstInput = true;
            for (Use Input : BU.Inputs) {
                if (!FirstInput) {
                    this.Out.$out(NativePointer.$COMMA_SPACE);
                }
                FirstInput = false;
                this.TypePrinter.print(Input.$arrow$Const().getType(), (raw_ostream)this.Out);
                this.Out.$out(NativePointer.$SPACE);
                AsmWriterStatics.WriteAsOperandInternal((raw_ostream)this.Out, Input.$Value$P(), (TypePrinting)Native.$AddrOf((Object)this.TypePrinter), (SlotTracker)Native.$AddrOf((Object)this.Machine), this.TheModule);
            }
            this.Out.$out_char((byte)41);
        }
        this.Out.$out(" ]");
    }

    public void writeAtomic(AtomicOrdering Ordering, SynchronizationScope SynchScope) {
        if (Ordering == AtomicOrdering.NotAtomic) {
            return;
        }
        switch (SynchScope) {
            case SingleThread: {
                this.Out.$out(" singlethread");
                break;
            }
        }
        this.Out.$out(NativePointer.$SPACE).$out(AdtsupportLlvmGlobals.toIRString((AtomicOrdering)Ordering));
    }

    public void writeAtomicCmpXchg(AtomicOrdering SuccessOrdering, AtomicOrdering FailureOrdering, SynchronizationScope SynchScope) {
        assert (SuccessOrdering != AtomicOrdering.NotAtomic && FailureOrdering != AtomicOrdering.NotAtomic);
        switch (SynchScope) {
            case SingleThread: {
                this.Out.$out(" singlethread");
                break;
            }
        }
        this.Out.$out(NativePointer.$SPACE).$out(AdtsupportLlvmGlobals.toIRString((AtomicOrdering)SuccessOrdering));
        this.Out.$out(NativePointer.$SPACE).$out(AdtsupportLlvmGlobals.toIRString((AtomicOrdering)FailureOrdering));
    }

    public void writeAllMDNodes() {
        SmallVector Nodes = new SmallVector(16, (Object)null);
        Nodes.resize(this.Machine.mdn_size());
        DenseMapIteratorTypeUInt<MDNode> I = this.Machine.mdn_begin();
        DenseMapIteratorTypeUInt<MDNode> E = this.Machine.mdn_end();
        while (I.$noteq(E)) {
            Nodes.$set(I.$arrow().second, (Object)IrRTTI.cast_MDNode((Metadata)I.$arrow().first));
            I.$preInc();
        }
        int e = Nodes.size();
        for (int i = 0; i != e; ++i) {
            this.writeMDNode(i, (MDNode)Nodes.$at(i));
        }
    }

    public void writeMDNode(int Slot, MDNode Node2) {
        this.Out.$out_char((byte)33).$out_uint(Slot).$out(" = ");
        this.printMDNodeBody(Node2);
        this.Out.$out(NativePointer.$LF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAllAttributeGroups() {
        std.vector asVec = null;
        try {
            asVec = new std.vector((Object)new std_pair.pairTypeUInt());
            asVec.resize(this.Machine.as_size());
            DenseMapIteratorTypeUInt<AttributeSet> I = this.Machine.as_begin();
            DenseMapIteratorTypeUInt<AttributeSet> E = this.Machine.as_end();
            while (I.$noteq(E)) {
                ((std_pair.pairTypeUInt)asVec.$at(I.$arrow().second)).$assign(I.$star());
                I.$preInc();
            }
            for (std_pair.pairTypeUInt I2 : asVec) {
                this.Out.$out("attributes #").$out_uint(I2.second).$out(" = { ").$out(((AttributeSet)I2.first).getAsString(AttributeSet.AttrIndex.FunctionIndex.getValue(), true)).$out(" }\n");
            }
        }
        finally {
            if (asVec != null) {
                asVec.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printTypeIdentities() {
        std.vector NumberedTypes = null;
        try {
            int i;
            if (this.TypePrinter.NumberedTypes.empty() && this.TypePrinter.NamedTypes.empty()) {
                return;
            }
            this.Out.$out_char((byte)10);
            NumberedTypes = new std.vector(this.TypePrinter.NumberedTypes.size(), (Object)null);
            DenseMapIteratorTypeUInt I = this.TypePrinter.NumberedTypes.begin();
            DenseMapIteratorTypeUInt E = this.TypePrinter.NumberedTypes.end();
            while (I.$noteq(E)) {
                assert (Unsigned.$less_uint((int)I.$arrow().second, (int)NumberedTypes.size())) : "Didn't get a dense numbering?";
                NumberedTypes.$set(I.$arrow().second, (Object)((StructType)I.$arrow().first));
                I.$preInc();
            }
            int e = NumberedTypes.size();
            for (i = 0; i != e; ++i) {
                this.Out.$out_char((byte)37).$out_uint(i).$out(" = type ");
                this.TypePrinter.printStructBody((StructType)NumberedTypes.$at(i), (raw_ostream)this.Out);
                this.Out.$out_char((byte)10);
            }
            e = this.TypePrinter.NamedTypes.size();
            for (i = 0; i != e; ++i) {
                AsmWriterStatics.PrintLLVMName((raw_ostream)this.Out, this.TypePrinter.NamedTypes.$at(i).getName(), PrefixType.LocalPrefix);
                this.Out.$out(" = type ");
                this.TypePrinter.printStructBody(this.TypePrinter.NamedTypes.$at(i), (raw_ostream)this.Out);
                this.Out.$out_char((byte)10);
            }
        }
        finally {
            if (NumberedTypes != null) {
                NumberedTypes.$destroy();
            }
        }
    }

    public void printGlobal(GlobalVariable GV) {
        int AddressSpace;
        if (GV.isMaterializable()) {
            this.Out.$out("; Materializable\n");
        }
        AsmWriterStatics.WriteAsOperandInternal((raw_ostream)this.Out, GV, (TypePrinting)Native.$AddrOf((Object)this.TypePrinter), (SlotTracker)Native.$AddrOf((Object)this.Machine), GV.getParent$Const());
        this.Out.$out(" = ");
        if (!GV.hasInitializer() && GV.hasExternalLinkage()) {
            this.Out.$out("external ");
        }
        this.Out.$out(AsmWriterStatics.getLinkagePrintName(GV.getLinkage()));
        AsmWriterStatics.PrintVisibility(GV.getVisibility(), this.Out);
        AsmWriterStatics.PrintDLLStorageClass(GV.getDLLStorageClass(), this.Out);
        AsmWriterStatics.PrintThreadLocalModel(GV.getThreadLocalMode(), this.Out);
        StringRef UA = AsmWriterStatics.getUnnamedAddrEncoding(GV.getUnnamedAddr());
        if (!UA.empty()) {
            this.Out.$out(UA).$out_char((byte)32);
        }
        if ((AddressSpace = GV.getType().getAddressSpace()) != 0) {
            this.Out.$out("addrspace(").$out_uint(AddressSpace).$out(") ");
        }
        if (GV.isExternallyInitialized()) {
            this.Out.$out("externally_initialized ");
        }
        this.Out.$out(GV.isConstant() ? NativePointer.$((String)"constant ") : NativePointer.$((String)"global "));
        this.TypePrinter.print(GV.getValueType(), (raw_ostream)this.Out);
        if (GV.hasInitializer()) {
            this.Out.$out_char((byte)32);
            this.writeOperand(GV.getInitializer$Const(), false);
        }
        if (GV.hasSection()) {
            this.Out.$out(", section \"");
            AsmWriterStatics.PrintEscapedString(GV.getSection(), (raw_ostream)this.Out);
            this.Out.$out_char((byte)34);
        }
        AsmWriterStatics.maybePrintComdat(this.Out, (GlobalObject)Native.$Deref((Object)GV));
        if (GV.getAlignment() != 0) {
            this.Out.$out(", align ").$out_uint(GV.getAlignment());
        }
        SmallVector MDs = new SmallVector(4, (Object)new std_pair.pairUIntPtr());
        GV.getAllMetadata((SmallVectorImpl<std_pair.pairUIntPtr<MDNode>>)MDs);
        this.printMetadataAttachments((SmallVectorImpl<std_pair.pairUIntPtr<MDNode>>)MDs, new StringRef(NativePointer.$COMMA_SPACE));
        this.printInfoComment((Value)Native.$Deref((Object)GV));
    }

    public void printIndirectSymbol(GlobalIndirectSymbol GIS) {
        if (GIS.isMaterializable()) {
            this.Out.$out("; Materializable\n");
        }
        AsmWriterStatics.WriteAsOperandInternal((raw_ostream)this.Out, GIS, (TypePrinting)Native.$AddrOf((Object)this.TypePrinter), (SlotTracker)Native.$AddrOf((Object)this.Machine), GIS.getParent$Const());
        this.Out.$out(" = ");
        this.Out.$out(AsmWriterStatics.getLinkagePrintName(GIS.getLinkage()));
        AsmWriterStatics.PrintVisibility(GIS.getVisibility(), this.Out);
        AsmWriterStatics.PrintDLLStorageClass(GIS.getDLLStorageClass(), this.Out);
        AsmWriterStatics.PrintThreadLocalModel(GIS.getThreadLocalMode(), this.Out);
        StringRef UA = AsmWriterStatics.getUnnamedAddrEncoding(GIS.getUnnamedAddr());
        if (!UA.empty()) {
            this.Out.$out(UA).$out_char((byte)32);
        }
        if (IrRTTI.isa_GlobalAlias(GIS)) {
            this.Out.$out("alias ");
        } else if (IrRTTI.isa_GlobalIFunc(GIS)) {
            this.Out.$out("ifunc ");
        } else {
            throw new llvm_unreachable("Not an alias or ifunc!");
        }
        this.TypePrinter.print(GIS.getValueType(), (raw_ostream)this.Out);
        this.Out.$out(NativePointer.$COMMA_SPACE);
        Constant IS = GIS.getIndirectSymbol$Const();
        if (IS == null) {
            this.TypePrinter.print(GIS.getType(), (raw_ostream)this.Out);
            this.Out.$out(" <<NULL ALIASEE>>");
        } else {
            this.writeOperand(IS, !IrRTTI.isa_ConstantExpr(IS));
        }
        this.printInfoComment((Value)Native.$Deref((Object)GIS));
        this.Out.$out_char((byte)10);
    }

    public void printComdat(Comdat C2) {
        C2.print((raw_ostream)this.Out);
    }

    public void printFunction(Function F) {
        AttributeSet Attrs;
        this.Out.$out_char((byte)10);
        if (this.AnnotationWriter != null) {
            this.AnnotationWriter.emitFunctionAnnot(F, this.Out);
        }
        if (F.isMaterializable()) {
            this.Out.$out("; Materializable\n");
        }
        if ((Attrs = F.getAttributes()).hasAttributes(AttributeSet.AttrIndex.FunctionIndex.getValue())) {
            int Idx;
            AttributeSet AS = Attrs.getFnAttributes();
            std.string AttrStr = new std.string();
            int E = AS.getNumSlots();
            for (Idx = 0; Idx != E && AS.getSlotIndex(Idx) != AttributeSet.AttrIndex.FunctionIndex.getValue(); ++Idx) {
            }
            type.ptr I = (type.ptr)Native.$tryClone(AS.begin(Idx));
            type.ptr E2 = (type.ptr)Native.$tryClone(AS.end(Idx));
            while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E2)) {
                Attribute Attr = new Attribute((Attribute)I.$star());
                if (!Attr.isStringAttribute()) {
                    if (!AttrStr.empty()) {
                        AttrStr.$addassign_T((byte)32);
                    }
                    AttrStr.$addassign(Attr.getAsString());
                }
                I.$preInc();
            }
            if (!AttrStr.empty()) {
                this.Out.$out("; Function Attrs: ").$out(AttrStr).$out_char((byte)10);
            }
        }
        this.Machine.incorporateFunction(F);
        if (F.isDeclaration()) {
            this.Out.$out("declare");
            SmallVector MDs = new SmallVector(4, (Object)new std_pair.pairUIntPtr());
            F.getAllMetadata((SmallVectorImpl<std_pair.pairUIntPtr<MDNode>>)MDs);
            this.printMetadataAttachments((SmallVectorImpl<std_pair.pairUIntPtr<MDNode>>)MDs, new StringRef(NativePointer.$SPACE));
            this.Out.$out_char((byte)32);
        } else {
            this.Out.$out("define ");
        }
        this.Out.$out(AsmWriterStatics.getLinkagePrintName(F.getLinkage()));
        AsmWriterStatics.PrintVisibility(F.getVisibility(), this.Out);
        AsmWriterStatics.PrintDLLStorageClass(F.getDLLStorageClass(), this.Out);
        if (F.getCallingConv() != 0) {
            AsmWriterStatics.PrintCallingConv(F.getCallingConv(), (raw_ostream)this.Out);
            this.Out.$out(NativePointer.$SPACE);
        }
        FunctionType FT = F.getFunctionType();
        if (Attrs.hasAttributes(AttributeSet.AttrIndex.ReturnIndex.getValue())) {
            this.Out.$out(Attrs.getAsString(AttributeSet.AttrIndex.ReturnIndex.getValue())).$out_char((byte)32);
        }
        this.TypePrinter.print(F.getReturnType(), (raw_ostream)this.Out);
        this.Out.$out_char((byte)32);
        AsmWriterStatics.WriteAsOperandInternal((raw_ostream)this.Out, F, (TypePrinting)Native.$AddrOf((Object)this.TypePrinter), (SlotTracker)Native.$AddrOf((Object)this.Machine), F.getParent$Const());
        this.Out.$out_char((byte)40);
        if (F.isDeclaration() && !this.IsForDebug) {
            int E = FT.getNumParams();
            for (int I = 0; I != E; ++I) {
                if (I != 0) {
                    this.Out.$out(NativePointer.$COMMA_SPACE);
                }
                this.TypePrinter.print(FT.getParamType(I), (raw_ostream)this.Out);
                if (!Attrs.hasAttributes(I + 1)) continue;
                this.Out.$out_char((byte)32).$out(Attrs.getAsString(I + 1));
            }
        } else {
            int Idx = 1;
            for (Argument Arg : F.args$Const()) {
                if (Idx != 1) {
                    this.Out.$out(NativePointer.$COMMA_SPACE);
                }
                this.printArgument((Argument)Native.$AddrOf((Object)Arg), new AttributeSet(Attrs), Idx++);
            }
        }
        if (FT.isVarArg()) {
            if (FT.getNumParams() != 0) {
                this.Out.$out(NativePointer.$COMMA_SPACE);
            }
            this.Out.$out(NativePointer.$ELLIPSIS);
        }
        this.Out.$out_char((byte)41);
        StringRef UA = AsmWriterStatics.getUnnamedAddrEncoding(F.getUnnamedAddr());
        if (!UA.empty()) {
            this.Out.$out_char((byte)32).$out(UA);
        }
        if (Attrs.hasAttributes(AttributeSet.AttrIndex.FunctionIndex.getValue())) {
            this.Out.$out(" #").$out_int(this.Machine.getAttributeGroupSlot(Attrs.getFnAttributes()));
        }
        if (F.hasSection()) {
            this.Out.$out(" section \"");
            AsmWriterStatics.PrintEscapedString(F.getSection(), (raw_ostream)this.Out);
            this.Out.$out_char((byte)34);
        }
        AsmWriterStatics.maybePrintComdat(this.Out, (GlobalObject)Native.$Deref((Object)F));
        if (F.getAlignment() != 0) {
            this.Out.$out(" align ").$out_uint(F.getAlignment());
        }
        if (F.hasGC()) {
            this.Out.$out(" gc \"").$out(F.getGC()).$out_char((byte)34);
        }
        if (F.hasPrefixData()) {
            this.Out.$out(" prefix ");
            this.writeOperand(F.getPrefixData(), true);
        }
        if (F.hasPrologueData()) {
            this.Out.$out(" prologue ");
            this.writeOperand(F.getPrologueData(), true);
        }
        if (F.hasPersonalityFn()) {
            this.Out.$out(" personality ");
            this.writeOperand(F.getPersonalityFn(), true);
        }
        if (F.isDeclaration()) {
            this.Out.$out_char((byte)10);
        } else {
            SmallVector MDs = new SmallVector(4, (Object)new std_pair.pairUIntPtr());
            F.getAllMetadata((SmallVectorImpl<std_pair.pairUIntPtr<MDNode>>)MDs);
            this.printMetadataAttachments((SmallVectorImpl<std_pair.pairUIntPtr<MDNode>>)MDs, new StringRef(NativePointer.$SPACE));
            this.Out.$out(" {");
            for (BasicBlock BB : (Function)Native.$Deref((Object)F)) {
                this.printBasicBlock((BasicBlock)Native.$AddrOf((Object)BB));
            }
            this.printUseLists(F);
            this.Out.$out("}\n");
        }
        this.Machine.purgeFunction();
    }

    public void printArgument(Argument Arg, AttributeSet Attrs, int Idx) {
        this.TypePrinter.print(Arg.getType(), (raw_ostream)this.Out);
        if (Attrs.hasAttributes(Idx)) {
            this.Out.$out_char((byte)32).$out(Attrs.getAsString(Idx));
        }
        if (Arg.hasName()) {
            this.Out.$out_char((byte)32);
            AsmWriterStatics.PrintLLVMName((raw_ostream)this.Out, Arg);
        }
    }

    public void printBasicBlock(BasicBlock BB) {
        if (BB.hasName()) {
            this.Out.$out(NativePointer.$LF);
            AsmWriterStatics.PrintLLVMName((raw_ostream)this.Out, BB.getName(), PrefixType.LabelPrefix);
            this.Out.$out_char((byte)58);
        } else if (!BB.use_empty()) {
            this.Out.$out("\n; <label>:");
            int Slot = this.Machine.getLocalSlot(BB);
            if (Slot != -1) {
                this.Out.$out_int(Slot).$out(NativePointer.$COLON);
            } else {
                this.Out.$out("<badref>");
            }
        }
        if (BB.getParent$Const() == null) {
            this.Out.PadToColumn(50);
            this.Out.$out("; Error: Block without parent!");
        } else if (BB != Native.$AddrOf((Object)BB.getParent$Const().getEntryBlock$Const())) {
            this.Out.PadToColumn(50);
            this.Out.$out(NativePointer.$SEMI);
            PredIterator<BasicBlock, Value.user_iterator_impl<User>> PI = IrLlvmGlobals.pred_begin_BasicBlock$C$P(BB);
            PredIterator<BasicBlock, Value.user_iterator_impl<User>> PE = IrLlvmGlobals.pred_end_BasicBlock$C$P(BB);
            if (PI.$eq(PE)) {
                this.Out.$out(" No predecessors!");
            } else {
                this.Out.$out(" preds = ");
                this.writeOperand((Value)PI.$star(), false);
                PI.$preInc();
                while (PI.$noteq(PE)) {
                    this.Out.$out(NativePointer.$COMMA_SPACE);
                    this.writeOperand((Value)PI.$star(), false);
                    PI.$preInc();
                }
            }
        }
        this.Out.$out(NativePointer.$LF);
        if (this.AnnotationWriter != null) {
            this.AnnotationWriter.emitBasicBlockStartAnnot(BB, this.Out);
        }
        for (Instruction I : (BasicBlock)Native.$Deref((Object)BB)) {
            this.printInstructionLine(I);
        }
        if (this.AnnotationWriter != null) {
            this.AnnotationWriter.emitBasicBlockEndAnnot(BB, this.Out);
        }
    }

    public void printInstructionLine(Instruction I) {
        this.printInstruction(I);
        this.Out.$out_char((byte)10);
    }

    public void printInstruction(Instruction I) {
        Value Operand;
        AtomicRMWInst RMWI;
        if (this.AnnotationWriter != null) {
            this.AnnotationWriter.emitInstructionAnnot((Instruction)Native.$AddrOf((Object)I), this.Out);
        }
        this.Out.$out("  ");
        if (I.hasName()) {
            AsmWriterStatics.PrintLLVMName((raw_ostream)this.Out, (Value)Native.$AddrOf((Object)I));
            this.Out.$out(" = ");
        } else if (!I.getType().isVoidTy()) {
            int SlotNum = this.Machine.getLocalSlot((Value)Native.$AddrOf((Object)I));
            if (SlotNum == -1) {
                this.Out.$out("<badref> = ");
            } else {
                this.Out.$out_char((byte)37).$out_int(SlotNum).$out(" = ");
            }
        }
        Instruction CI = IrRTTI.dyn_cast_CallInst((Instruction)Native.$AddrOf((Object)I));
        if (CI != null) {
            if (((CallInst)CI).isMustTailCall()) {
                this.Out.$out("musttail ");
            } else if (((CallInst)CI).isTailCall()) {
                this.Out.$out("tail ");
            } else if (((CallInst)CI).isNoTailCall()) {
                this.Out.$out("notail ");
            }
        }
        this.Out.$out(I.getOpcodeName());
        if (IrRTTI.isa_LoadInst(I) && IrRTTI.cast_LoadInst(I).isAtomic() || IrRTTI.isa_StoreInst(I) && IrRTTI.cast_StoreInst(I).isAtomic()) {
            this.Out.$out(" atomic");
        }
        if (IrRTTI.isa_AtomicCmpXchgInst(I) && IrRTTI.cast_AtomicCmpXchgInst(I).isWeak()) {
            this.Out.$out(" weak");
        }
        if (IrRTTI.isa_LoadInst(I) && IrRTTI.cast_LoadInst(I).isVolatile() || IrRTTI.isa_StoreInst(I) && IrRTTI.cast_StoreInst(I).isVolatile() || IrRTTI.isa_AtomicCmpXchgInst(I) && IrRTTI.cast_AtomicCmpXchgInst(I).isVolatile() || IrRTTI.isa_AtomicRMWInst(I) && IrRTTI.cast_AtomicRMWInst(I).isVolatile()) {
            this.Out.$out(" volatile");
        }
        AsmWriterStatics.WriteOptimizationInfo((raw_ostream)this.Out, (User)Native.$AddrOf((Object)I));
        CI = IrRTTI.dyn_cast_CmpInst((Instruction)Native.$AddrOf((Object)I));
        if (CI != null) {
            this.Out.$out_char((byte)32).$out(AsmWriterStatics.getPredicateText(((CmpInst)CI).getPredicate().getValue()));
        }
        if ((RMWI = IrRTTI.dyn_cast_AtomicRMWInst((Instruction)Native.$AddrOf((Object)I))) != null) {
            AsmWriterStatics.writeAtomicRMWOperation((raw_ostream)this.Out, RMWI.getOperation());
        }
        Value value = Operand = I.getNumOperands() != 0 ? I.getOperand(0) : null;
        if (IrRTTI.isa_BranchInst(I) && IrRTTI.cast_BranchInst(I).isConditional()) {
            BranchInst BI = IrRTTI.cast_BranchInst(I);
            this.Out.$out_char((byte)32);
            this.writeOperand(BI.getCondition(), true);
            this.Out.$out(NativePointer.$COMMA_SPACE);
            this.writeOperand(BI.getSuccessor(0), true);
            this.Out.$out(NativePointer.$COMMA_SPACE);
            this.writeOperand(BI.getSuccessor(1), true);
        } else if (IrRTTI.isa_SwitchInst(I)) {
            SwitchInst SI = IrRTTI.cast_SwitchInst(I);
            this.Out.$out_char((byte)32);
            this.writeOperand(SI.getCondition(), true);
            this.Out.$out(NativePointer.$COMMA_SPACE);
            this.writeOperand(SI.getDefaultDest(), true);
            this.Out.$out(" [");
            SwitchInst.CaseIteratorT<SwitchInst, ConstantInt, BasicBlock> i = SI.case_begin$Const();
            SwitchInst.CaseIteratorT<SwitchInst, ConstantInt, BasicBlock> e = SI.case_end$Const();
            while (i.$noteq(e)) {
                this.Out.$out("\n    ");
                this.writeOperand(i.getCaseValue(), true);
                this.Out.$out(NativePointer.$COMMA_SPACE);
                this.writeOperand(i.getCaseSuccessor(), true);
                i.$preInc();
            }
            this.Out.$out("\n  ]");
        } else if (IrRTTI.isa_IndirectBrInst(I)) {
            this.Out.$out_char((byte)32);
            this.writeOperand(Operand, true);
            this.Out.$out(", [");
            int e = I.getNumOperands();
            for (int i = 1; i != e; ++i) {
                if (i != 1) {
                    this.Out.$out(NativePointer.$COMMA_SPACE);
                }
                this.writeOperand(I.getOperand(i), true);
            }
            this.Out.$out_char((byte)93);
        } else {
            PHINode PN = IrRTTI.dyn_cast_PHINode((Instruction)Native.$AddrOf((Object)I));
            if (PN != null) {
                this.Out.$out_char((byte)32);
                this.TypePrinter.print(I.getType(), (raw_ostream)this.Out);
                this.Out.$out_char((byte)32);
                int op = 0;
                int Eop = PN.getNumIncomingValues();
                while (Unsigned.$less_uint((int)op, (int)Eop)) {
                    if (op != 0) {
                        this.Out.$out(NativePointer.$COMMA_SPACE);
                    }
                    this.Out.$out("[ ");
                    this.writeOperand(PN.getIncomingValue(op), false);
                    this.Out.$out(NativePointer.$COMMA_SPACE);
                    this.writeOperand(PN.getIncomingBlock(op), false);
                    this.Out.$out(" ]");
                    ++op;
                }
            } else {
                ExtractValueInst EVI = IrRTTI.dyn_cast_ExtractValueInst((Instruction)Native.$AddrOf((Object)I));
                if (EVI != null) {
                    this.Out.$out_char((byte)32);
                    this.writeOperand(I.getOperand(0), true);
                    uint.ptr i = (uint.ptr)Native.$tryClone((NativeCloneable)EVI.idx_begin());
                    uint.ptr e = (uint.ptr)Native.$tryClone((NativeCloneable)EVI.idx_end());
                    while (Native.$noteq_ptr((void.ptr)i, (void.ptr)e)) {
                        this.Out.$out(NativePointer.$COMMA_SPACE).$out_uint(i.$star());
                        i.$preInc();
                    }
                } else {
                    InsertValueInst IVI = IrRTTI.dyn_cast_InsertValueInst((Instruction)Native.$AddrOf((Object)I));
                    if (IVI != null) {
                        this.Out.$out_char((byte)32);
                        this.writeOperand(I.getOperand(0), true);
                        this.Out.$out(NativePointer.$COMMA_SPACE);
                        this.writeOperand(I.getOperand(1), true);
                        uint.ptr i = (uint.ptr)Native.$tryClone((NativeCloneable)IVI.idx_begin());
                        uint.ptr e = (uint.ptr)Native.$tryClone((NativeCloneable)IVI.idx_end());
                        while (Native.$noteq_ptr((void.ptr)i, (void.ptr)e)) {
                            this.Out.$out(NativePointer.$COMMA_SPACE).$out_uint(i.$star());
                            i.$preInc();
                        }
                    } else {
                        LandingPadInst LPI = IrRTTI.dyn_cast_LandingPadInst((Instruction)Native.$AddrOf((Object)I));
                        if (LPI != null) {
                            this.Out.$out_char((byte)32);
                            this.TypePrinter.print(I.getType(), (raw_ostream)this.Out);
                            if (LPI.isCleanup() || LPI.getNumClauses() != 0) {
                                this.Out.$out_char((byte)10);
                            }
                            if (LPI.isCleanup()) {
                                this.Out.$out("          cleanup");
                            }
                            int e = LPI.getNumClauses();
                            for (int i = 0; i != e; ++i) {
                                if (i != 0 || LPI.isCleanup()) {
                                    this.Out.$out(NativePointer.$LF);
                                }
                                if (LPI.isCatch(i)) {
                                    this.Out.$out("          catch ");
                                } else {
                                    this.Out.$out("          filter ");
                                }
                                this.writeOperand(LPI.getClause(i), true);
                            }
                        } else {
                            CatchSwitchInst CatchSwitch = IrRTTI.dyn_cast_CatchSwitchInst((Instruction)Native.$AddrOf((Object)I));
                            if (CatchSwitch != null) {
                                this.Out.$out(" within ");
                                this.writeOperand(CatchSwitch.getParentPad(), false);
                                this.Out.$out(" [");
                                int Op = 0;
                                for (BasicBlock PadBB : CatchSwitch.handlers$Const()) {
                                    if (Unsigned.$greater_uint((int)Op, (int)0)) {
                                        this.Out.$out(NativePointer.$COMMA_SPACE);
                                    }
                                    this.writeOperand(PadBB, true);
                                    ++Op;
                                }
                                this.Out.$out("] unwind ");
                                BasicBlock UnwindDest = CatchSwitch.getUnwindDest();
                                if (UnwindDest != null) {
                                    this.writeOperand(UnwindDest, true);
                                } else {
                                    this.Out.$out("to caller");
                                }
                            } else {
                                FuncletPadInst FPI = IrRTTI.dyn_cast_FuncletPadInst((Instruction)Native.$AddrOf((Object)I));
                                if (FPI != null) {
                                    this.Out.$out(" within ");
                                    this.writeOperand(FPI.getParentPad(), false);
                                    this.Out.$out(" [");
                                    int Op = 0;
                                    int NumOps = FPI.getNumArgOperands();
                                    while (Unsigned.$less_uint((int)Op, (int)NumOps)) {
                                        if (Unsigned.$greater_uint((int)Op, (int)0)) {
                                            this.Out.$out(NativePointer.$COMMA_SPACE);
                                        }
                                        this.writeOperand(FPI.getArgOperand(Op), true);
                                        ++Op;
                                    }
                                    this.Out.$out_char((byte)93);
                                } else if (IrRTTI.isa_ReturnInst(I) && Operand == null) {
                                    this.Out.$out(" void");
                                } else {
                                    CatchReturnInst CRI = IrRTTI.dyn_cast_CatchReturnInst((Instruction)Native.$AddrOf((Object)I));
                                    if (CRI != null) {
                                        this.Out.$out(" from ");
                                        this.writeOperand(CRI.getOperand(0), false);
                                        this.Out.$out(" to ");
                                        this.writeOperand(CRI.getOperand(1), true);
                                    } else {
                                        CleanupReturnInst CRI$1 = IrRTTI.dyn_cast_CleanupReturnInst((Instruction)Native.$AddrOf((Object)I));
                                        if (CRI$1 != null) {
                                            this.Out.$out(" from ");
                                            this.writeOperand(CRI$1.getOperand(0), false);
                                            this.Out.$out(" unwind ");
                                            if (CRI$1.hasUnwindDest()) {
                                                this.writeOperand(CRI$1.getOperand(1), true);
                                            } else {
                                                this.Out.$out("to caller");
                                            }
                                        } else {
                                            CallInst CI2 = IrRTTI.dyn_cast_CallInst((Instruction)Native.$AddrOf((Object)I));
                                            if (CI2 != null) {
                                                if (CI2.getCallingConv() != 0) {
                                                    this.Out.$out(NativePointer.$SPACE);
                                                    AsmWriterStatics.PrintCallingConv(CI2.getCallingConv(), (raw_ostream)this.Out);
                                                }
                                                Operand = CI2.getCalledValue$Const();
                                                FunctionType FTy = IrRTTI.cast_FunctionType(CI2.getFunctionType());
                                                Type RetTy = FTy.getReturnType();
                                                AttributeSet PAL = CI2.getAttributes();
                                                if (PAL.hasAttributes(AttributeSet.AttrIndex.ReturnIndex.getValue())) {
                                                    this.Out.$out_char((byte)32).$out(PAL.getAsString(AttributeSet.AttrIndex.ReturnIndex.getValue()));
                                                }
                                                this.Out.$out_char((byte)32);
                                                this.TypePrinter.print(FTy.isVarArg() ? FTy : RetTy, (raw_ostream)this.Out);
                                                this.Out.$out_char((byte)32);
                                                this.writeOperand(Operand, false);
                                                this.Out.$out_char((byte)40);
                                                int op = 0;
                                                int Eop = CI2.getNumArgOperands();
                                                while (Unsigned.$less_uint((int)op, (int)Eop)) {
                                                    if (Unsigned.$greater_uint((int)op, (int)0)) {
                                                        this.Out.$out(NativePointer.$COMMA_SPACE);
                                                    }
                                                    this.writeParamOperand(CI2.getArgOperand(op), new AttributeSet(PAL), op + 1);
                                                    ++op;
                                                }
                                                if (CI2.isMustTailCall() && CI2.getParent$Const() != null && CI2.getParent$Const().getParent$Const() != null && CI2.getParent$Const().getParent$Const().isVarArg()) {
                                                    this.Out.$out(", ...");
                                                }
                                                this.Out.$out_char((byte)41);
                                                if (PAL.hasAttributes(AttributeSet.AttrIndex.FunctionIndex.getValue())) {
                                                    this.Out.$out(" #").$out_int(this.Machine.getAttributeGroupSlot(PAL.getFnAttributes()));
                                                }
                                                this.writeOperandBundles(new ImmutableCallSite(CI2));
                                            } else {
                                                InvokeInst II = IrRTTI.dyn_cast_InvokeInst((Instruction)Native.$AddrOf((Object)I));
                                                if (II != null) {
                                                    Operand = II.getCalledValue$Const();
                                                    FunctionType FTy = IrRTTI.cast_FunctionType(II.getFunctionType());
                                                    Type RetTy = FTy.getReturnType();
                                                    AttributeSet PAL = II.getAttributes();
                                                    if (II.getCallingConv() != 0) {
                                                        this.Out.$out(NativePointer.$SPACE);
                                                        AsmWriterStatics.PrintCallingConv(II.getCallingConv(), (raw_ostream)this.Out);
                                                    }
                                                    if (PAL.hasAttributes(AttributeSet.AttrIndex.ReturnIndex.getValue())) {
                                                        this.Out.$out_char((byte)32).$out(PAL.getAsString(AttributeSet.AttrIndex.ReturnIndex.getValue()));
                                                    }
                                                    this.Out.$out_char((byte)32);
                                                    this.TypePrinter.print(FTy.isVarArg() ? FTy : RetTy, (raw_ostream)this.Out);
                                                    this.Out.$out_char((byte)32);
                                                    this.writeOperand(Operand, false);
                                                    this.Out.$out_char((byte)40);
                                                    int op = 0;
                                                    int Eop = II.getNumArgOperands();
                                                    while (Unsigned.$less_uint((int)op, (int)Eop)) {
                                                        if (op != 0) {
                                                            this.Out.$out(NativePointer.$COMMA_SPACE);
                                                        }
                                                        this.writeParamOperand(II.getArgOperand(op), new AttributeSet(PAL), op + 1);
                                                        ++op;
                                                    }
                                                    this.Out.$out_char((byte)41);
                                                    if (PAL.hasAttributes(AttributeSet.AttrIndex.FunctionIndex.getValue())) {
                                                        this.Out.$out(" #").$out_int(this.Machine.getAttributeGroupSlot(PAL.getFnAttributes()));
                                                    }
                                                    this.writeOperandBundles(new ImmutableCallSite(II));
                                                    this.Out.$out("\n          to ");
                                                    this.writeOperand(II.getNormalDest(), true);
                                                    this.Out.$out(" unwind ");
                                                    this.writeOperand(II.getUnwindDest(), true);
                                                } else {
                                                    AllocaInst AI = IrRTTI.dyn_cast_AllocaInst((Instruction)Native.$AddrOf((Object)I));
                                                    if (AI != null) {
                                                        this.Out.$out_char((byte)32);
                                                        if (AI.isUsedWithInAlloca()) {
                                                            this.Out.$out("inalloca ");
                                                        }
                                                        if (AI.isSwiftError()) {
                                                            this.Out.$out("swifterror ");
                                                        }
                                                        this.TypePrinter.print(AI.getAllocatedType(), (raw_ostream)this.Out);
                                                        if (AI.getArraySize$Const() == null || AI.isArrayAllocation() || !AI.getArraySize$Const().getType().isIntegerTy(32)) {
                                                            this.Out.$out(NativePointer.$COMMA_SPACE);
                                                            this.writeOperand(AI.getArraySize$Const(), true);
                                                        }
                                                        if (AI.getAlignment() != 0) {
                                                            this.Out.$out(", align ").$out_uint(AI.getAlignment());
                                                        }
                                                    } else if (IrRTTI.isa_CastInst(I)) {
                                                        if (Operand != null) {
                                                            this.Out.$out_char((byte)32);
                                                            this.writeOperand(Operand, true);
                                                        }
                                                        this.Out.$out(" to ");
                                                        this.TypePrinter.print(I.getType(), (raw_ostream)this.Out);
                                                    } else if (IrRTTI.isa_VAArgInst(I)) {
                                                        if (Operand != null) {
                                                            this.Out.$out_char((byte)32);
                                                            this.writeOperand(Operand, true);
                                                        }
                                                        this.Out.$out(NativePointer.$COMMA_SPACE);
                                                        this.TypePrinter.print(I.getType(), (raw_ostream)this.Out);
                                                    } else if (Operand != null) {
                                                        int i;
                                                        int E;
                                                        GetElementPtrInst GEP = IrRTTI.dyn_cast_GetElementPtrInst((Instruction)Native.$AddrOf((Object)I));
                                                        if (GEP != null) {
                                                            this.Out.$out_char((byte)32);
                                                            this.TypePrinter.print(GEP.getSourceElementType(), (raw_ostream)this.Out);
                                                            this.Out.$out_char((byte)44);
                                                        } else {
                                                            LoadInst LI = IrRTTI.dyn_cast_LoadInst((Instruction)Native.$AddrOf((Object)I));
                                                            if (LI != null) {
                                                                this.Out.$out_char((byte)32);
                                                                this.TypePrinter.print(LI.getType(), (raw_ostream)this.Out);
                                                                this.Out.$out_char((byte)44);
                                                            }
                                                        }
                                                        boolean PrintAllTypes = false;
                                                        Type TheType = Operand.getType();
                                                        if (IrRTTI.isa_SelectInst(I) || IrRTTI.isa_StoreInst(I) || IrRTTI.isa_ShuffleVectorInst(I) || IrRTTI.isa_ReturnInst(I)) {
                                                            PrintAllTypes = true;
                                                        } else {
                                                            E = I.getNumOperands();
                                                            for (i = 1; i != E; ++i) {
                                                                Operand = I.getOperand(i);
                                                                if (Operand == null || Operand.getType() == TheType) continue;
                                                                PrintAllTypes = true;
                                                                break;
                                                            }
                                                        }
                                                        if (!PrintAllTypes) {
                                                            this.Out.$out_char((byte)32);
                                                            this.TypePrinter.print(TheType, (raw_ostream)this.Out);
                                                        }
                                                        this.Out.$out_char((byte)32);
                                                        E = I.getNumOperands();
                                                        for (i = 0; i != E; ++i) {
                                                            if (i != 0) {
                                                                this.Out.$out(NativePointer.$COMMA_SPACE);
                                                            }
                                                            this.writeOperand(I.getOperand(i), PrintAllTypes);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        LoadInst LI = IrRTTI.dyn_cast_LoadInst((Instruction)Native.$AddrOf((Object)I));
        if (LI != null) {
            if (LI.isAtomic()) {
                this.writeAtomic(LI.getOrdering(), LI.getSynchScope());
            }
            if (LI.getAlignment() != 0) {
                this.Out.$out(", align ").$out_uint(LI.getAlignment());
            }
        } else {
            StoreInst SI = IrRTTI.dyn_cast_StoreInst((Instruction)Native.$AddrOf((Object)I));
            if (SI != null) {
                if (SI.isAtomic()) {
                    this.writeAtomic(SI.getOrdering(), SI.getSynchScope());
                }
                if (SI.getAlignment() != 0) {
                    this.Out.$out(", align ").$out_uint(SI.getAlignment());
                }
            } else {
                AtomicCmpXchgInst CXI = IrRTTI.dyn_cast_AtomicCmpXchgInst((Instruction)Native.$AddrOf((Object)I));
                if (CXI != null) {
                    this.writeAtomicCmpXchg(CXI.getSuccessOrdering(), CXI.getFailureOrdering(), CXI.getSynchScope());
                } else {
                    AtomicRMWInst RMWI2 = IrRTTI.dyn_cast_AtomicRMWInst((Instruction)Native.$AddrOf((Object)I));
                    if (RMWI2 != null) {
                        this.writeAtomic(RMWI2.getOrdering(), RMWI2.getSynchScope());
                    } else {
                        FenceInst FI = IrRTTI.dyn_cast_FenceInst((Instruction)Native.$AddrOf((Object)I));
                        if (FI != null) {
                            this.writeAtomic(FI.getOrdering(), FI.getSynchScope());
                        }
                    }
                }
            }
        }
        SmallVector InstMD = new SmallVector(4, (Object)new std_pair.pairUIntPtr());
        I.getAllMetadata((SmallVectorImpl<std_pair.pairUIntPtr<MDNode>>)InstMD);
        this.printMetadataAttachments((SmallVectorImpl<std_pair.pairUIntPtr<MDNode>>)InstMD, new StringRef(NativePointer.$COMMA_SPACE));
        this.printInfoComment(I);
    }

    public void printUseListOrder(UseListOrder Order) {
        BasicBlock BB;
        boolean IsInFunction;
        boolean bl = IsInFunction = this.Machine.getFunction() != null;
        if (IsInFunction) {
            this.Out.$out("  ");
        }
        this.Out.$out("uselistorder");
        BasicBlock basicBlock = BB = IsInFunction ? null : IrRTTI.dyn_cast_BasicBlock(Order.V);
        if (BB != null) {
            this.Out.$out("_bb ");
            this.writeOperand(BB.getParent$Const(), false);
            this.Out.$out(NativePointer.$COMMA_SPACE);
            this.writeOperand(BB, false);
        } else {
            this.Out.$out(NativePointer.$SPACE);
            this.writeOperand(Order.V, true);
        }
        this.Out.$out(", { ");
        assert (Unsigned.$greatereq_uint((int)Order.Shuffle.size(), (int)2)) : "Shuffle too small";
        this.Out.$out_uint(Order.Shuffle.$at$Const(0));
        int E = Order.Shuffle.size();
        for (int I = 1; I != E; ++I) {
            this.Out.$out(NativePointer.$COMMA_SPACE).$out_uint(Order.Shuffle.$at$Const(I));
        }
        this.Out.$out(" }\n");
    }

    public void printUseLists(Function F) {
        NativeCallback.VoidBoolPredicate hasMore = () -> !this.UseListOrders.empty() && ((UseListOrder)this.UseListOrders.back()).F == F;
        if (!hasMore.$call()) {
            return;
        }
        this.Out.$out("\n; uselistorder directives\n");
        while (hasMore.$call()) {
            this.printUseListOrder((UseListOrder)this.UseListOrders.back());
            this.UseListOrders.pop_back();
        }
    }

    private void printMetadataAttachments(SmallVectorImpl<std_pair.pairUIntPtr<MDNode>> MDs, StringRef Separator) {
        if (MDs.empty()) {
            return;
        }
        if (this.MDNames.empty()) {
            ((MDNode)((std_pair.pairUIntPtr)MDs.$at$Const((int)0)).second).getContext().getMDKindNames((SmallVectorImpl<StringRef>)this.MDNames);
        }
        for (std_pair.pairUIntPtr I : MDs) {
            int Kind2 = I.first;
            this.Out.$out(Separator);
            if (Unsigned.$less_uint((int)Kind2, (int)this.MDNames.size())) {
                this.Out.$out(NativePointer.$EXCLAIM);
                AsmWriterStatics.printMetadataIdentifier(new StringRef((StringRef)this.MDNames.$at(Kind2)), this.Out);
            } else {
                this.Out.$out("!<unknown kind #").$out_uint(Kind2).$out(NativePointer.$GT);
            }
            this.Out.$out_char((byte)32);
            AsmWriterStatics.WriteAsOperandInternal((raw_ostream)this.Out, (Metadata)I.second, (TypePrinting)Native.$AddrOf((Object)this.TypePrinter), (SlotTracker)Native.$AddrOf((Object)this.Machine), this.TheModule);
        }
    }

    private void printInfoComment(Value V) {
        GCRelocateInst Relocate = IrRTTI.dyn_cast_GCRelocateInst((Value)Native.$AddrOf((Object)V));
        if (Relocate != null) {
            this.printGCRelocateComment((GCRelocateInst)Native.$Deref((Object)Relocate));
        }
        if (this.AnnotationWriter != null) {
            this.AnnotationWriter.printInfoComment(V, this.Out);
        }
    }

    private void printGCRelocateComment(GCRelocateInst Relocate) {
        this.Out.$out(" ; (");
        this.writeOperand(Relocate.getBasePtr(), false);
        this.Out.$out(NativePointer.$COMMA_SPACE);
        this.writeOperand(Relocate.getDerivedPtr(), false);
        this.Out.$out(NativePointer.$RPAREN);
    }

    public void $destroy() {
        this.MDNames.$destroy();
        this.UseListOrders.$destroy();
        this.Comdats.$destroy();
        this.TypePrinter.$destroy();
        this.SlotTrackerStorage.$destroy();
    }

    public String toString() {
        return "Out=" + this.Out + ", TheModule=" + this.TheModule + ", SlotTrackerStorage=" + this.SlotTrackerStorage + ", Machine=" + this.Machine + ", TypePrinter=" + this.TypePrinter + ", AnnotationWriter=" + this.AnnotationWriter + ", Comdats=" + this.Comdats + ", IsForDebug=" + this.IsForDebug + ", ShouldPreserveUseListOrder=" + this.ShouldPreserveUseListOrder + ", UseListOrders=" + this.UseListOrders + ", MDNames=" + this.MDNames;
    }
}

