/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.aliases.JavaIterator;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.DenseMapInfo;
import org.llvm.adt.aliases.DenseMapInfo;
import org.llvm.adt.aliases.DenseSet;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.ilist_iterator;
import org.llvm.ir.Argument;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantAsMetadata;
import org.llvm.ir.Function;
import org.llvm.ir.GlobalAlias;
import org.llvm.ir.GlobalVariable;
import org.llvm.ir.Instruction;
import org.llvm.ir.MDNode;
import org.llvm.ir.Metadata;
import org.llvm.ir.MetadataAsValue;
import org.llvm.ir.Module$IR;
import org.llvm.ir.NamedMDNode;
import org.llvm.ir.StructType;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.ValueAsMetadata;
import org.llvm.ir.java.IrRTTI;

public class TypeFinder
implements Iterable<StructType>,
Destructors.ClassWithDestructor {
    private DenseSet<Value> VisitedConstants = new DenseSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info());
    private DenseSet<MDNode> VisitedMetadata = new DenseSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info());
    private DenseSet<Type> VisitedTypes = new DenseSet((DenseMapInfo)DenseMapInfo.LikePtr.$Info());
    private std.vector<StructType> StructTypes = new std.vector((Object)null);
    private boolean OnlyNamed = false;

    public void run(Module$IR M, boolean onlyNamed) {
        this.OnlyNamed = onlyNamed;
        Object I = M.global_begin$Const();
        Object E = M.global_end$Const();
        while (I.$noteq(E)) {
            this.incorporateType(((GlobalVariable)I.$arrow()).getType());
            if (((GlobalVariable)I.$arrow()).hasInitializer()) {
                this.incorporateValue(((GlobalVariable)I.$arrow()).getInitializer$Const());
            }
            I.$preInc();
        }
        I = M.alias_begin$Const();
        E = M.alias_end$Const();
        while (I.$noteq(E)) {
            this.incorporateType(((GlobalAlias)I.$arrow()).getType());
            Constant Aliasee = ((GlobalAlias)I.$arrow()).getAliasee$Const();
            if (Aliasee != null) {
                this.incorporateValue(Aliasee);
            }
            I.$preInc();
        }
        SmallVector MDForInst = new SmallVector(4, (Object)new std_pair.pairUIntPtr());
        for (Function FI : M) {
            this.incorporateType(FI.getType());
            for (Use U : FI.operands$Const()) {
                this.incorporateValue(U.get());
            }
            ilist_iterator<Argument> AI = FI.arg_begin$Const();
            ilist_iterator<Argument> AE = FI.arg_end$Const();
            while (AI.$noteq(AE)) {
                this.incorporateValue((Value)Native.$AddrOf((Object)((Argument)AI.$star())));
                AI.$preInc();
            }
            for (BasicBlock BB : FI) {
                for (Instruction I2 : BB) {
                    this.incorporateType(I2.getType());
                    type.ptr OI = (type.ptr)Native.$tryClone(I2.op_begin$Const());
                    type.ptr OE = (type.ptr)Native.$tryClone(I2.op_end$Const());
                    while (Native.$noteq_ptr((void.ptr)OI, (void.ptr)OE)) {
                        if (((Use)OI.$star()).$Value$P() != null && !IrRTTI.isa_Instruction(OI)) {
                            this.incorporateValue(((Use)OI.$star()).$Value$P());
                        }
                        OI.$preInc();
                    }
                    I2.getAllMetadataOtherThanDebugLoc((SmallVectorImpl<std_pair.pairUIntPtr<MDNode>>)MDForInst);
                    int e = MDForInst.size();
                    for (int i = 0; i != e; ++i) {
                        this.incorporateMDNode((MDNode)((std_pair.pairUIntPtr)MDForInst.$at((int)i)).second);
                    }
                    MDForInst.clear();
                }
            }
        }
        ilist_iterator<NamedMDNode> I3 = M.named_metadata_begin$Const();
        ilist_iterator<NamedMDNode> E2 = M.named_metadata_end$Const();
        while (I3.$noteq(E2)) {
            NamedMDNode NMD = (NamedMDNode)Native.$AddrOf((Object)((NamedMDNode)I3.$star()));
            int e = NMD.getNumOperands();
            for (int i = 0; i != e; ++i) {
                this.incorporateMDNode(NMD.getOperand(i));
            }
            I3.$preInc();
        }
    }

    public void clear() {
        this.VisitedConstants.clear();
        this.VisitedTypes.clear();
        this.StructTypes.clear();
    }

    public StdVector.iterator<StructType> begin() {
        return this.StructTypes.begin();
    }

    public StdVector.iterator<StructType> end() {
        return this.StructTypes.end();
    }

    public StdVector.iterator<StructType> begin$Const() {
        return this.StructTypes.begin$Const();
    }

    public StdVector.iterator<StructType> end$Const() {
        return this.StructTypes.end$Const();
    }

    public boolean empty() {
        return this.StructTypes.empty();
    }

    public int size() {
        return this.StructTypes.size();
    }

    public StdVector.iterator<StructType> erase(StdVector.iterator<StructType> I, StdVector.iterator<StructType> E) {
        return this.StructTypes.erase(new StdVector.iterator(I), new StdVector.iterator(E));
    }

    public StructType $at(int Idx) {
        return (StructType)this.StructTypes.$at(Idx);
    }

    private void incorporateType(Type Ty) {
        if (!this.VisitedTypes.insert((Object)Ty).second) {
            return;
        }
        SmallVector TypeWorklist = new SmallVector(4, (Object)null);
        TypeWorklist.push_back((Object)Ty);
        do {
            StructType STy;
            if ((STy = IrRTTI.dyn_cast_StructType(Ty = (Type)TypeWorklist.pop_back_val())) != null && (!this.OnlyNamed || STy.hasName())) {
                this.StructTypes.push_back_T$C$R((Object)STy);
            }
            std.reverse_iterator<Type> I = Ty.subtype_rbegin();
            std.reverse_iterator<Type> E = Ty.subtype_rend();
            while (ADTAliases.$noteq_reverse_iterator$C(I, E)) {
                if (this.VisitedTypes.insert((Object)((Type)I.$star())).second) {
                    TypeWorklist.push_back((Object)((Type)I.$star()));
                }
                I.$preInc();
            }
        } while (!TypeWorklist.empty());
    }

    private void incorporateValue(Value V) {
        MetadataAsValue M = IrRTTI.dyn_cast_MetadataAsValue(V);
        if (M != null) {
            MDNode N = IrRTTI.dyn_cast_MDNode(M.getMetadata());
            if (N != null) {
                this.incorporateMDNode(N);
                return;
            }
            ValueAsMetadata MDV = IrRTTI.dyn_cast_ValueAsMetadata(M.getMetadata());
            if (MDV != null) {
                this.incorporateValue(MDV.getValue());
                return;
            }
            return;
        }
        if (!IrRTTI.isa_Constant(V) || IrRTTI.isa_GlobalValue(V)) {
            return;
        }
        if (!this.VisitedConstants.insert((Object)V).second) {
            return;
        }
        this.incorporateType(V.getType());
        if (IrRTTI.isa_Instruction(V)) {
            return;
        }
        User U = IrRTTI.cast_User(V);
        type.ptr I = (type.ptr)Native.$tryClone(U.op_begin$Const());
        type.ptr E = (type.ptr)Native.$tryClone(U.op_end$Const());
        while (Native.$noteq_ptr((void.ptr)I, (void.ptr)E)) {
            this.incorporateValue(((Use)I.$star()).$Value$P());
            I.$preInc();
        }
    }

    private void incorporateMDNode(MDNode V) {
        if (!this.VisitedMetadata.insert((Object)V).second) {
            return;
        }
        int e = V.getNumOperands();
        for (int i = 0; i != e; ++i) {
            Metadata Op = V.getOperand(i).$Metadata$P();
            if (Op == null) continue;
            MDNode N = IrRTTI.dyn_cast_MDNode(Op);
            if (N != null) {
                this.incorporateMDNode(N);
                continue;
            }
            ConstantAsMetadata C2 = IrRTTI.dyn_cast_ConstantAsMetadata(Op);
            if (C2 == null) continue;
            this.incorporateValue(C2.getValue());
        }
    }

    public void $destroy() {
        this.StructTypes.$destroy();
        this.VisitedTypes.$destroy();
        this.VisitedMetadata.$destroy();
        this.VisitedConstants.$destroy();
    }

    @Override
    public Iterator<StructType> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public type.ref<StructType> re$at(int Idx) {
        return this.StructTypes.ref$at(Idx);
    }

    public String toString() {
        return "VisitedConstants=" + this.VisitedConstants + ", VisitedMetadata=" + this.VisitedMetadata + ", VisitedTypes=" + this.VisitedTypes + ", StructTypes=" + this.StructTypes + ", OnlyNamed=" + this.OnlyNamed;
    }
}

