/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.java.std;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.type;
import org.clank.support.aliases.ulong;
import org.llvm.ir.DataLayout;
import org.llvm.ir.StructType;
import org.llvm.ir.Type;
import org.llvm.support.llvm;

public class StructLayout {
    private long StructSize;
    private int StructAlignment;
    private boolean IsPadded;
    private int NumElements;
    private long[] MemberOffsets = NativePointer.new$ulong((int)1);
    private final type.ptr $this;

    public long getSizeInBytes() {
        return this.StructSize;
    }

    public long getSizeInBits() {
        return Unsigned.$int2ullong((int)8) * this.StructSize;
    }

    public int getAlignment() {
        return this.StructAlignment;
    }

    public boolean hasPadding() {
        return this.IsPadded;
    }

    public int getElementContainingOffset(long Offset) {
        ulong.ptr tmp = NativePointer.create_ulong$ptr((long[])this.MemberOffsets);
        ulong.ptr SI = (ulong.ptr)Native.$tryClone((NativeCloneable)std.upper_bound_ulong((ulong.ptr)tmp, (ulong.ptr)((ulong.ptr)tmp.$add(this.NumElements)), (long)Offset));
        assert (Native.$noteq_ptr((Object)SI, (Object)Native.$AddrOf((long)this.MemberOffsets[0]))) : "Offset not in structure type!";
        SI.$preDec();
        assert (Unsigned.$lesseq_ulong((long)SI.$star(), (long)Offset)) : "upper_bound didn't work";
        assert ((Native.$eq_ptr((Object)SI, (Object)Native.$AddrOf((long)this.MemberOffsets[0])) || Unsigned.$lesseq_ulong((long)((ulong.ptr)SI.$sub(1)).$star(), (long)Offset)) && (Native.$eq_ptr((Object)SI.$add(1), (Object)Native.$AddrOf((long)this.MemberOffsets[this.NumElements])) || Unsigned.$greater_ulong((long)((ulong.ptr)SI.$add(1)).$star(), (long)Offset))) : "Upper bound didn't work!";
        return SI.$sub((abstract_iterator)tmp);
    }

    public long getElementOffset(int Idx) {
        assert (Unsigned.$less_uint((int)Idx, (int)this.NumElements)) : "Invalid element idx!";
        return this.MemberOffsets[Idx];
    }

    public long getElementOffsetInBits(int Idx) {
        return this.getElementOffset(Idx) * Unsigned.$int2ullong((int)8);
    }

    StructLayout(type.ref Java$SL, type.ptr Java$This, StructType ST, DataLayout DL) {
        this.$this = Native.$toConst((type.ptr)Java$This);
        this.$this.$set((Object)this);
        Java$SL.$set((Object)this);
        assert (!ST.isOpaque()) : "Cannot get layout of opaque structs";
        this.StructAlignment = 0;
        this.StructSize = Unsigned.$int2ulong((int)0);
        this.IsPadded = false;
        this.NumElements = ST.getNumElements();
        this.MemberOffsets = NativePointer.new$ulong((int)this.NumElements);
        int e = this.NumElements;
        for (int i = 0; i != e; ++i) {
            int TyAlign;
            Type Ty = ST.getElementType(i);
            int n = TyAlign = ST.isPacked() ? 1 : DL.getABITypeAlignment(Ty);
            if ((this.StructSize & Unsigned.$uint2ullong((int)(TyAlign - 1))) != Unsigned.$int2ullong((int)0)) {
                this.IsPadded = true;
                this.StructSize = llvm.alignTo((long)this.StructSize, (long)Unsigned.$uint2ulong((int)TyAlign));
            }
            this.StructAlignment = std.max((int)TyAlign, (int)this.StructAlignment);
            this.MemberOffsets[i] = this.StructSize;
            this.StructSize += DL.getTypeAllocSize(Ty);
        }
        if (this.StructAlignment == 0) {
            this.StructAlignment = 1;
        }
        if ((this.StructSize & Unsigned.$uint2ullong((int)(this.StructAlignment - 1))) != Unsigned.$int2ullong((int)0)) {
            this.IsPadded = true;
            this.StructSize = llvm.alignTo((long)this.StructSize, (long)Unsigned.$uint2ulong((int)this.StructAlignment));
        }
    }

    public String toString() {
        return "StructSize=" + this.StructSize + ", StructAlignment=" + this.StructAlignment + ", IsPadded=" + this.IsPadded + ", NumElements=" + this.NumElements + ", MemberOffsets=" + this.MemberOffsets;
    }
}

