/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.ir;

import org.clank.support.Destructors;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVectorImplInt;
import org.llvm.adt.aliases.SmallVectorInt;
import org.llvm.ir.BasicBlock;
import org.llvm.ir.Constant;
import org.llvm.ir.ConstantDataSequential;
import org.llvm.ir.ConstantExpr;
import org.llvm.ir.ConstantInt;
import org.llvm.ir.ConstantVector;
import org.llvm.ir.Instruction;
import org.llvm.ir.OperandTraitsShuffleVectorInst;
import org.llvm.ir.Type;
import org.llvm.ir.Use;
import org.llvm.ir.User;
import org.llvm.ir.Value;
import org.llvm.ir.VectorType;
import org.llvm.ir.java.IrRTTI;

public class ShuffleVectorInst
extends Instruction
implements Destructors.ClassWithDestructor {
    protected ShuffleVectorInst cloneImpl() {
        return ShuffleVectorInst.$new_ShuffleVectorInst(New$Mem -> new ShuffleVectorInst(this.getOperand(0), this.getOperand(1), this.getOperand(2)));
    }

    public static <T extends ShuffleVectorInst> T $new_ShuffleVectorInst(NativeCallback.New.ConstructorCallback<T> $Ctor) {
        return (T)((ShuffleVectorInst)User.$new_FixedUses(3, $Ctor));
    }

    public ShuffleVectorInst(Value V1, Value V2, Value Mask) {
        this(V1, V2, Mask, new Twine(NativePointer.$EMPTY), (Instruction)null);
    }

    public ShuffleVectorInst(Value V1, Value V2, Value Mask, Twine Name) {
        this(V1, V2, Mask, Name, (Instruction)null);
    }

    public ShuffleVectorInst(Value V1, Value V2, Value Mask, Twine Name, Instruction InsertBefore) {
        super((Type)VectorType.get(IrRTTI.cast_VectorType(V1.getType()).getElementType(), IrRTTI.cast_VectorType(Mask.getType()).getNumElements()), 61, OperandTraitsShuffleVectorInst.op_begin(User.$BEING_CREATED()), OperandTraitsShuffleVectorInst.operands$FixedNumOperandTraits(User.$BEING_CREATED()), InsertBefore);
        assert (ShuffleVectorInst.isValidOperands(V1, V2, Mask)) : "Invalid shuffle vector instruction operands!";
        this.Op(0).$assign(V1);
        this.Op(1).$assign(V2);
        this.Op(2).$assign(Mask);
        this.setName(Name);
    }

    public ShuffleVectorInst(Value V1, Value V2, Value Mask, Twine Name, BasicBlock InsertAtEnd) {
        super((Type)VectorType.get(IrRTTI.cast_VectorType(V1.getType()).getElementType(), IrRTTI.cast_VectorType(Mask.getType()).getNumElements()), 61, OperandTraitsShuffleVectorInst.op_begin(User.$BEING_CREATED()), OperandTraitsShuffleVectorInst.operands$FixedNumOperandTraits(User.$BEING_CREATED()), InsertAtEnd);
        assert (ShuffleVectorInst.isValidOperands(V1, V2, Mask)) : "Invalid shuffle vector instruction operands!";
        this.Op(0).$assign(V1);
        this.Op(1).$assign(V2);
        this.Op(2).$assign(Mask);
        this.setName(Name);
    }

    public static boolean isValidOperands(Value V1, Value V2, Value Mask) {
        if (!V1.getType().isVectorTy() || V1.getType() != V2.getType()) {
            return false;
        }
        VectorType MaskTy = IrRTTI.dyn_cast_VectorType(Mask.getType());
        if (MaskTy == null || !MaskTy.getElementType().isIntegerTy(32)) {
            return false;
        }
        if (IrRTTI.isa_UndefValue(Mask) || IrRTTI.isa_ConstantAggregateZero(Mask)) {
            return true;
        }
        ConstantVector MV = IrRTTI.dyn_cast_ConstantVector(Mask);
        if (MV != null) {
            int V1Size = IrRTTI.cast_VectorType(V1.getType()).getNumElements();
            for (Use U : MV.operands$Const()) {
                Value Op = U.$Value$P();
                ConstantInt CI = IrRTTI.dyn_cast_ConstantInt(Op);
                if (!(CI != null ? CI.uge(Unsigned.$uint2ulong((int)(V1Size * 2))) : !IrRTTI.isa_UndefValue(Op))) continue;
                return false;
            }
            return true;
        }
        ConstantDataSequential CDS = IrRTTI.dyn_cast_ConstantDataSequential(Mask);
        if (CDS != null) {
            int V1Size = IrRTTI.cast_VectorType(V1.getType()).getNumElements();
            int e = MaskTy.getNumElements();
            for (int i = 0; i != e; ++i) {
                if (!Unsigned.$greatereq_ulong_uint((long)CDS.getElementAsInteger(i), (int)(V1Size * 2))) continue;
                return false;
            }
            return true;
        }
        ConstantExpr CE = IrRTTI.dyn_cast_ConstantExpr(Mask);
        return CE != null && CE.getOpcode() == 56;
    }

    @Override
    public VectorType getType() {
        return IrRTTI.cast_VectorType(super.getType());
    }

    @Override
    public Value getOperand(int i_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsShuffleVectorInst.operands$FixedNumOperandTraits(this))) : "getOperand() out of range!";
        return IrRTTI.cast_or_null_Value(((Use)OperandTraitsShuffleVectorInst.op_begin(this).$at(i_nocapture)).get());
    }

    @Override
    public void setOperand(int i_nocapture, Value Val_nocapture) {
        assert (Unsigned.$less_uint((int)i_nocapture, (int)OperandTraitsShuffleVectorInst.operands$FixedNumOperandTraits(this))) : "setOperand() out of range!";
        ((Use)OperandTraitsShuffleVectorInst.op_begin(this).$at(i_nocapture)).$assign(Val_nocapture);
    }

    @Override
    public type.ptr<Use> op_begin() {
        return OperandTraitsShuffleVectorInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_begin$Const() {
        return OperandTraitsShuffleVectorInst.op_begin(this);
    }

    @Override
    public type.ptr<Use> op_end() {
        return OperandTraitsShuffleVectorInst.op_end(this);
    }

    @Override
    public type.ptr<Use> op_end$Const() {
        return OperandTraitsShuffleVectorInst.op_end(this);
    }

    @Override
    protected Use Op(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    protected Use Op$Const(int Idx_nocapture) {
        return this.OpFrom(Idx_nocapture, this);
    }

    @Override
    public int getNumOperands() {
        return OperandTraitsShuffleVectorInst.operands$FixedNumOperandTraits(this);
    }

    public Constant getMask() {
        return IrRTTI.cast_Constant(this.getOperand(2));
    }

    public static int getMaskValue(Constant Mask, int i) {
        assert (Unsigned.$less_uint((int)i, (int)Mask.getType().getVectorNumElements())) : "Index out of range";
        ConstantDataSequential CDS = IrRTTI.dyn_cast_ConstantDataSequential(Mask);
        if (CDS != null) {
            return Unsigned.$ulong2int((long)CDS.getElementAsInteger(i));
        }
        Constant C2 = Mask.getAggregateElement(i);
        if (IrRTTI.isa_UndefValue(C2)) {
            return -1;
        }
        return Unsigned.$ulong2int((long)IrRTTI.cast_ConstantInt(C2).getZExtValue());
    }

    public int getMaskValue(int i) {
        return ShuffleVectorInst.getMaskValue(this.getMask(), i);
    }

    public static void getShuffleMask(Constant Mask, SmallVectorImplInt Result2) {
        int NumElts = Mask.getType().getVectorNumElements();
        ConstantDataSequential CDS = IrRTTI.dyn_cast_ConstantDataSequential(Mask);
        if (CDS != null) {
            for (int i = 0; i != NumElts; ++i) {
                Result2.push_back(Unsigned.$ulong2int((long)CDS.getElementAsInteger(i)));
            }
            return;
        }
        for (int i = 0; i != NumElts; ++i) {
            Constant C2 = Mask.getAggregateElement(i);
            Result2.push_back(Unsigned.$ullong2int((long)(IrRTTI.isa_UndefValue(C2) ? Unsigned.$int2ullong((int)-1) : IrRTTI.cast_ConstantInt(C2).getZExtValue())));
        }
    }

    public void getShuffleMask(SmallVectorImplInt Result2) {
        ShuffleVectorInst.getShuffleMask(this.getMask(), Result2);
    }

    public SmallVectorInt getShuffleMask() {
        SmallVectorInt Mask = new SmallVectorInt(16);
        this.getShuffleMask((SmallVectorImplInt)Mask);
        return Mask;
    }

    public static boolean classof(Instruction I) {
        return I.getOpcode() == 61;
    }

    public static boolean classof(Value V) {
        return IrRTTI.isa_Instruction(V) && ShuffleVectorInst.classof(IrRTTI.cast_Instruction(V));
    }

    @Override
    public void $destroy() {
        super.$destroy();
    }

    @Override
    public String toString() {
        return "" + super.toString();
    }
}

